/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.compiere.plaf.CompiereColor;

public class CompiereUtils {
    private static Logger log = Logger.getLogger(CompiereUtils.class.getName());
    public static final Color COL_1TOP = new Color(255, 255, 255, 128);
    public static final Color COL_1END = new Color(255, 255, 255, 0);
    public static final Color COL_2TOP = new Color(0, 0, 0, 0);
    public static final Color COL_2END = new Color(0, 0, 0, 64);
    protected static final Component s_component = new Component(){
        private static final long serialVersionUID = 2185807624882290223L;
    };
    protected static final MediaTracker s_tracker = new MediaTracker(s_component);
    private static int s_no = 0;

    public static void fillRectange(Graphics2D g2D, JComponent c, boolean round) {
        CompiereColor cc = null;
        boolean stdCC = c.getClientProperty("CompiereBackgroundFill") != null;
        try {
            cc = (CompiereColor)c.getClientProperty("CompiereBackground");
        }
        catch (Exception e) {
            stdCC = true;
        }
        if (stdCC) {
            cc = CompiereColor.getDefaultBackground();
        }
        if (cc != null) {
            cc.paint(g2D, c);
        } else {
            Color paint = c.getBackground();
            g2D.setPaint(paint);
            RectangularShape rec = null;
            rec = round ? new RoundRectangle2D.Float(0.0f, 0.0f, c.getWidth(), c.getHeight(), 15.0f, 15.0f) : new Rectangle(0, 0, c.getWidth(), c.getHeight());
            g2D.fill(rec);
        }
    }

    public static void paint3Deffect(Graphics2D g2D, Rectangle r, boolean round, boolean out) {
        GradientPaint topPaint = null;
        topPaint = out ? new GradientPaint(r.x, r.y, COL_1TOP, r.x, r.y + r.height / 2, COL_1END) : new GradientPaint(r.x, r.y, COL_2END, r.x, r.y + r.height / 2, COL_2TOP);
        g2D.setPaint(topPaint);
        RectangularShape topRec = null;
        topRec = round ? new RoundRectangle2D.Float(r.x, r.y, r.width, r.height / 2, 15.0f, 15.0f) : new Rectangle(r.x, r.y, r.width, r.height / 2);
        g2D.fill(topRec);
        GradientPaint endPaint = null;
        endPaint = out ? new GradientPaint(r.x, r.y + r.height / 2, COL_2TOP, r.x, r.y + r.height, COL_2END) : new GradientPaint(r.x, r.y + r.height / 2, COL_1END, r.x, r.y + r.height, COL_1TOP);
        g2D.setPaint(endPaint);
        RectangularShape endRec = null;
        endRec = round ? new RoundRectangle2D.Float(r.x, r.y + r.height / 2, r.width, r.height / 2, 15.0f, 15.0f) : new Rectangle(r.x, r.y + r.height / 2, r.width, r.height / 2);
        g2D.fill(endRec);
    }

    public static void paint3Deffect(Graphics2D g2D, JComponent c, boolean round, boolean out) {
        GradientPaint topPaint = null;
        topPaint = out ? new GradientPaint(0.0f, 0.0f, COL_1TOP, 0.0f, c.getHeight() / 2, COL_1END) : new GradientPaint(0.0f, 0.0f, COL_2END, 0.0f, c.getHeight() / 2, COL_2TOP);
        g2D.setPaint(topPaint);
        RectangularShape topRec = null;
        topRec = round ? new RoundRectangle2D.Float(0.0f, 0.0f, c.getWidth(), c.getHeight() / 2, 15.0f, 15.0f) : new Rectangle(0, 0, c.getWidth(), c.getHeight() / 2);
        g2D.fill(topRec);
        GradientPaint endPaint = null;
        endPaint = out ? new GradientPaint(0.0f, c.getHeight() / 2, COL_2TOP, 0.0f, c.getHeight(), COL_2END) : new GradientPaint(0.0f, c.getHeight() / 2, COL_1END, 0.0f, c.getHeight(), COL_1TOP);
        g2D.setPaint(endPaint);
        RectangularShape endRec = null;
        endRec = round ? new RoundRectangle2D.Float(0.0f, c.getHeight() / 2, c.getWidth(), c.getHeight() / 2, 15.0f, 15.0f) : new Rectangle(0, c.getHeight() / 2, c.getWidth(), c.getHeight() / 2);
        g2D.fill(endRec);
    }

    public static Color getTranslucentColor(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static void setNotBuffered(Component c) {
        if (c instanceof JComponent) {
            ((JComponent)c).setDoubleBuffered(false);
        }
        if (c instanceof Container) {
            Component[] cc = ((Container)c).getComponents();
            for (int i2 = 0; i2 < cc.length; ++i2) {
                CompiereUtils.setNotBuffered(cc[i2]);
            }
        }
    }

    public static synchronized Image loadImage(String path) {
        Image image = null;
        if (path != null) {
            try {
                File file = new File(path);
                URL url = file.toURI().toURL();
                image = CompiereUtils.loadImage(url);
            }
            catch (MalformedURLException e) {
                log.severe("Path= " + path + " - " + e.getMessage());
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Image loadImage(URL url) {
        Image image = null;
        image = Toolkit.getDefaultToolkit().getImage(url);
        if (image != null) {
            s_tracker.addImage(image, 0);
            try {
                s_tracker.waitForAll();
            }
            catch (InterruptedException e) {
                log.severe("Url= " + url + " - " + e.getMessage());
                s_tracker.removeImage(image);
                image = null;
            }
            finally {
                if (image != null) {
                    s_tracker.removeImage(image);
                }
                if (s_tracker.isErrorAny()) {
                    log.severe("Tracker: " + s_tracker.getErrorsAny()[0]);
                    image = null;
                }
                if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                    log.severe("Image=0");
                    image = null;
                }
            }
        }
        return image;
    }

    public static synchronized BufferedImage loadBufferedImage(File file, int imageType) {
        BufferedImage image = null;
        try {
            URL url = file.toURI().toURL();
            image = CompiereUtils.loadBufferedImage(url, imageType);
        }
        catch (MalformedURLException e) {
            log.severe("File: " + file + " - " + e.getMessage());
        }
        return image;
    }

    public static synchronized BufferedImage loadBufferedImage(String path, int imageType) {
        File file = new File(path);
        BufferedImage image = null;
        try {
            URL url = file.toURI().toURL();
            image = CompiereUtils.loadBufferedImage(url, imageType);
        }
        catch (MalformedURLException e) {
            log.severe("Path: " + path + " - " + e.getMessage());
        }
        return image;
    }

    public static synchronized BufferedImage loadBufferedImage(URL url, int imageType) {
        BufferedImage image = null;
        if (url == null || !url.toString().toLowerCase().endsWith(".jpg")) {
            Image tmpImage = CompiereUtils.loadImage(url);
            if (tmpImage != null) {
                image = new BufferedImage(tmpImage.getWidth(null), tmpImage.getHeight(null), imageType);
                Graphics2D g = image.createGraphics();
                g.drawImage(tmpImage, 0, 0, null);
                g.dispose();
            }
        } else {
            BufferedImage tmpImage = CompiereUtils.loadBufferedJPEGImage(url);
            if (tmpImage != null) {
                if (tmpImage.getType() != imageType) {
                    log.config("Incompatible JPEG image type: creating new buffer image");
                    image = new BufferedImage(tmpImage.getWidth(null), tmpImage.getHeight(null), imageType);
                    Graphics2D g = image.createGraphics();
                    g.drawImage((Image)tmpImage, 0, 0, null);
                    g.dispose();
                } else {
                    image = tmpImage;
                }
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized BufferedImage loadBufferedJPEGImage(URL url) {
        BufferedImage image = null;
        if (url != null) {
            try {
                image = ImageIO.read(url);
            }
            catch (Exception e) {
                log.severe("URL: " + url + " - " + e.getMessage());
                image = null;
            }
            if (image != null) {
                log.config("Image type : " + image.getType());
                if (image.getWidth() <= 0 || image.getHeight() <= 0) {
                    log.severe("URL: " + url + " =0");
                    image = null;
                }
            }
        }
        return image;
    }

    public static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    static void printParents(JComponent c) {
        if (c.getName() == null) {
            c.setName("C" + String.valueOf(s_no++));
        }
        System.out.print(c.getName());
        System.out.print(" - " + c.getClass().getName());
        System.out.println(" ** " + c.isOpaque() + " bg=" + (c.getClientProperty("CompiereBackground") != null));
        for (Container container = c.getParent(); container != null; container = container.getParent()) {
            System.out.print(" - " + container.getName() + " " + container.getClass().getName() + " ** " + container.isOpaque());
            if (container instanceof JComponent) {
                System.out.print(" bg=" + (((JComponent)container).getClientProperty("CompiereBackground") != null));
            }
            System.out.println();
        }
    }
}

