/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MTree_Node;
import org.compiere.model.MTree_NodeBP;
import org.compiere.model.MTree_NodeMM;
import org.compiere.model.MTree_NodePR;
import org.compiere.model.X_AD_Tree;
import org.compiere.util.CCache;

public class MTree_Base
extends X_AD_Tree {
    private static final long serialVersionUID = -7657958239525901547L;
    private static CCache<Integer, MTree_Base> s_cache = new CCache("AD_Tree", 10);

    public static boolean addNode(Properties ctx, String treeType, int Record_ID, String trxName) {
        int AD_Tree_ID = 0;
        MClient client = MClient.get(ctx);
        MClientInfo ci = client.getInfo();
        if ("AY".equals(treeType)) {
            AD_Tree_ID = ci.getAD_Tree_Activity_ID();
        } else {
            if ("BB".equals(treeType)) {
                throw new IllegalArgumentException("BoM Trees not supported");
            }
            if ("BP".equals(treeType)) {
                AD_Tree_ID = ci.getAD_Tree_BPartner_ID();
            } else if ("MC".equals(treeType)) {
                AD_Tree_ID = ci.getAD_Tree_Campaign_ID();
            } else {
                if ("EV".equals(treeType)) {
                    throw new IllegalArgumentException("ElementValue cannot use this API");
                }
                if ("MM".equals(treeType)) {
                    AD_Tree_ID = ci.getAD_Tree_Menu_ID();
                } else if ("OO".equals(treeType)) {
                    AD_Tree_ID = ci.getAD_Tree_Org_ID();
                } else if ("PR".equals(treeType)) {
                    AD_Tree_ID = ci.getAD_Tree_Product_ID();
                } else {
                    if ("PC".equals(treeType)) {
                        throw new IllegalArgumentException("Product Category Trees not supported");
                    }
                    if ("PJ".equals(treeType)) {
                        AD_Tree_ID = ci.getAD_Tree_Project_ID();
                    } else if ("SR".equals(treeType)) {
                        AD_Tree_ID = ci.getAD_Tree_SalesRegion_ID();
                    }
                }
            }
        }
        if (AD_Tree_ID == 0) {
            throw new IllegalArgumentException("No Tree found");
        }
        MTree_Base tree = MTree_Base.get(ctx, AD_Tree_ID, trxName);
        if (tree.get_ID() != AD_Tree_ID) {
            throw new IllegalArgumentException("Tree found AD_Tree_ID=" + AD_Tree_ID);
        }
        boolean saved = false;
        if ("MM".equals(treeType)) {
            MTree_NodeMM node = new MTree_NodeMM(tree, Record_ID);
            saved = node.save();
        } else if ("BP".equals(treeType)) {
            MTree_NodeBP node = new MTree_NodeBP(tree, Record_ID);
            saved = node.save();
        } else if ("PR".equals(treeType)) {
            MTree_NodePR node = new MTree_NodePR(tree, Record_ID);
            saved = node.save();
        } else {
            MTree_Node node = new MTree_Node(tree, Record_ID);
            saved = node.save();
        }
        return saved;
    }

    public static String getNodeTableName(String treeType) {
        String nodeTableName = "AD_TreeNode";
        if ("MM".equals(treeType)) {
            nodeTableName = String.valueOf(nodeTableName) + "MM";
        } else if ("BP".equals(treeType)) {
            nodeTableName = String.valueOf(nodeTableName) + "BP";
        } else if ("PR".equals(treeType)) {
            nodeTableName = String.valueOf(nodeTableName) + "PR";
        } else if ("CC".equals(treeType)) {
            nodeTableName = String.valueOf(nodeTableName) + "CMC";
        } else if ("CS".equals(treeType)) {
            nodeTableName = String.valueOf(nodeTableName) + "CMS";
        } else if ("CM".equals(treeType)) {
            nodeTableName = String.valueOf(nodeTableName) + "CMM";
        } else if ("CT".equals(treeType)) {
            nodeTableName = String.valueOf(nodeTableName) + "CMT";
        } else if ("U1".equals(treeType)) {
            nodeTableName = String.valueOf(nodeTableName) + "U1";
        } else if ("U2".equals(treeType)) {
            nodeTableName = String.valueOf(nodeTableName) + "U2";
        } else if ("U3".equals(treeType)) {
            nodeTableName = String.valueOf(nodeTableName) + "U3";
        } else if ("U4".equals(treeType)) {
            nodeTableName = String.valueOf(nodeTableName) + "U4";
        }
        return nodeTableName;
    }

    public static String getSourceTableName(String treeType) {
        if (treeType == null) {
            return null;
        }
        String sourceTable = null;
        if (treeType.equals("MM")) {
            sourceTable = "AD_Menu";
        } else if (treeType.equals("OO")) {
            sourceTable = "AD_Org";
        } else if (treeType.equals("PR")) {
            sourceTable = "M_Product";
        } else if (treeType.equals("PC")) {
            sourceTable = "M_Product_Category";
        } else if (treeType.equals("BB")) {
            sourceTable = "M_BOM";
        } else if (treeType.equals("EV")) {
            sourceTable = "C_ElementValue";
        } else if (treeType.equals("BP")) {
            sourceTable = "C_BPartner";
        } else if (treeType.equals("MC")) {
            sourceTable = "C_Campaign";
        } else if (treeType.equals("PJ")) {
            sourceTable = "C_Project";
        } else if (treeType.equals("AY")) {
            sourceTable = "C_Activity";
        } else if (treeType.equals("SR")) {
            sourceTable = "C_SalesRegion";
        } else if (treeType.equals("CC")) {
            sourceTable = "CM_Container";
        } else if (treeType.equals("CS")) {
            sourceTable = "CM_CStage";
        } else if (treeType.equals("CM")) {
            sourceTable = "CM_Media";
        } else if (treeType.equals("CT")) {
            sourceTable = "CM_Template";
        } else if (treeType.equals("U1") || treeType.equals("U2") || treeType.equals("U3") || treeType.equals("U4")) {
            sourceTable = "C_ElementValue";
        } else if (treeType.equals("DO")) {
            sourceTable = "CC_SelectBPLine";
        }
        return sourceTable;
    }

    public static MTree_Base get(Properties ctx, int AD_Tree_ID, String trxName) {
        Integer key = new Integer(AD_Tree_ID);
        MTree_Base retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTree_Base(ctx, AD_Tree_ID, trxName);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MTree_Base(Properties ctx, int AD_Tree_ID, String trxName) {
        super(ctx, AD_Tree_ID, trxName);
        if (AD_Tree_ID == 0) {
            this.setIsAllNodes(true);
            this.setIsDefault(false);
        }
    }

    public MTree_Base(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTree_Base(MClient client, String name, String treeType) {
        this(client.getCtx(), 0, client.get_TrxName());
        this.setClientOrg(client);
        this.setName(name);
        this.setTreeType(treeType);
    }

    public MTree_Base(Properties ctx, String Name2, String TreeType, String trxName) {
        super(ctx, 0, trxName);
        this.setName(Name2);
        this.setTreeType(TreeType);
        this.setIsAllNodes(true);
        this.setIsDefault(false);
    }

    public String getNodeTableName() {
        return MTree_Base.getNodeTableName(this.getTreeType());
    }

    public String getSourceTableName(boolean tableNameOnly) {
        String tableName = MTree_Base.getSourceTableName(this.getTreeType());
        if (tableNameOnly) {
            return tableName;
        }
        if ("M_Product".equals(tableName)) {
            return "M_Product t INNER JOIN M_Product_Category x ON (t.M_Product_Category_ID=x.M_Product_Category_ID)";
        }
        if ("C_BPartner".equals(tableName)) {
            return "C_BPartner t INNER JOIN C_BP_Group x ON (t.C_BP_Group_ID=x.C_BP_Group_ID)";
        }
        if ("AD_Org".equals(tableName)) {
            return "AD_Org t INNER JOIN AD_OrgInfo i ON (t.AD_Org_ID=i.AD_Org_ID) LEFT OUTER JOIN AD_OrgType x ON (i.AD_OrgType_ID=x.AD_OrgType_ID)";
        }
        if ("C_Campaign".equals(tableName)) {
            return "C_Campaign t LEFT OUTER JOIN C_Channel x ON (t.C_Channel_ID=x.C_Channel_ID)";
        }
        if (tableName != null) {
            tableName = String.valueOf(tableName) + " t";
        }
        return tableName;
    }

    public String getActionColorName() {
        String tableName = MTree_Base.getSourceTableName(this.getTreeType());
        if ("AD_Menu".equals(tableName)) {
            return "t.Action";
        }
        if ("M_Product".equals(tableName) || "C_BPartner".equals(tableName) || "AD_Org".equals(tableName) || "C_Campaign".equals(tableName)) {
            return "x.AD_PrintColor_ID";
        }
        return "NULL";
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!this.isActive() || !this.isAllNodes()) {
            this.setIsDefault(false);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord) {
            if ("BP".equals(this.getTreeType())) {
                MTree_NodeBP ndBP = new MTree_NodeBP(this, 0);
                ndBP.saveEx();
            } else if ("MM".equals(this.getTreeType())) {
                MTree_NodeMM ndMM = new MTree_NodeMM(this, 0);
                ndMM.saveEx();
            } else if ("PR".equals(this.getTreeType())) {
                MTree_NodePR ndPR = new MTree_NodePR(this, 0);
                ndPR.saveEx();
            } else {
                MTree_Node nd = new MTree_Node(this, 0);
                nd.saveEx();
            }
        }
        return success;
    }
}

