/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.GridTab;
import org.compiere.model.MDocType;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Sequence;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Trx;

public class MSequence
extends X_AD_Sequence {
    private static final long serialVersionUID = -6827013120475678483L;
    private static boolean USE_PROCEDURE = false;
    private static final Level LOGLEVEL = Level.ALL;
    private static final int QUERY_TIME_OUT = 10;
    private static final String PREFIX_DOCSEQ = "DocumentNo_";
    public static final int INIT_NO = 1000000;
    public static final int INIT_SYS_NO = 50000;
    private static CLogger s_log = CLogger.getCLogger(MSequence.class);
    private static Vector<Integer> s_list = null;

    public static int getNextID(int AD_Client_ID, String TableName) {
        return MSequence.getNextID(AD_Client_ID, TableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int getNextID(int AD_Client_ID, String TableName, String trxName) {
        if (TableName == null || TableName.length() == 0) {
            throw new IllegalArgumentException("TableName missing");
        }
        int retValue = -1;
        boolean adempiereSys = Ini.isPropertyBool("AdempiereSys");
        if (adempiereSys && AD_Client_ID > 11) {
            adempiereSys = false;
        }
        if (CLogMgt.isLevel(LOGLEVEL)) {
            s_log.log(LOGLEVEL, TableName + " - AdempiereSys=" + adempiereSys + " [" + trxName + "]");
        }
        String selectSQL = null;
        if (DB.isPostgreSQL()) {
            selectSQL = "SELECT CurrentNext, CurrentNextSys, IncrementNo, AD_Sequence_ID FROM AD_Sequence WHERE Name=? AND IsActive='Y' AND IsTableID='Y' AND IsAutoSequence='Y'  FOR UPDATE OF AD_Sequence ";
            USE_PROCEDURE = false;
        } else if (DB.isOracle()) {
            selectSQL = "SELECT CurrentNext, CurrentNextSys, IncrementNo, AD_Sequence_ID FROM AD_Sequence WHERE Name=? AND IsActive='Y' AND IsTableID='Y' AND IsAutoSequence='Y' FOR UPDATE";
            USE_PROCEDURE = true;
        } else {
            selectSQL = "SELECT CurrentNext, CurrentNextSys, IncrementNo, AD_Sequence_ID FROM AD_Sequence WHERE Name=? AND IsActive='Y' AND IsTableID='Y' AND IsAutoSequence='Y' ";
            USE_PROCEDURE = false;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        for (int i2 = 0; i2 < 3; ++i2) {
            block54: {
                block53: {
                    block49: {
                        conn = DB.getConnectionID();
                        if (conn != null) break block49;
                        int n = -1;
                        DB.close(rs, pstmt);
                        pstmt = null;
                        rs = null;
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            conn = null;
                        }
                        return n;
                    }
                    pstmt = conn.prepareStatement(selectSQL, 1003, 1008);
                    pstmt.setString(1, TableName);
                    if (!USE_PROCEDURE && DB.getDatabase().isQueryTimeoutSupported()) {
                        pstmt.setQueryTimeout(10);
                    }
                    rs = pstmt.executeQuery();
                    if (CLogMgt.isLevelFinest()) {
                        s_log.finest("AC=" + conn.getAutoCommit() + ", RO=" + conn.isReadOnly() + " - Isolation=" + conn.getTransactionIsolation() + "(" + 2 + ") - RSType=" + pstmt.getResultSetType() + "(" + 1005 + "), RSConcur=" + pstmt.getResultSetConcurrency() + "(" + 1008 + ")");
                    }
                    if (rs.next()) {
                        String isUseProjectCentralizedID;
                        PreparedStatement updateSQL;
                        String isUseCentralizedID;
                        MTable table2 = MTable.get(Env.getCtx(), TableName);
                        int AD_Sequence_ID = rs.getInt(4);
                        boolean gotFromHTTP = false;
                        if (adempiereSys && !(isUseCentralizedID = MSysConfig.getValue("DICTIONARY_ID_USE_CENTRALIZED_ID", "Y")).equals("N") && !MSequence.isExceptionCentralized(TableName)) {
                            retValue = MSequence.getNextOfficialID_HTTP(TableName);
                            if (retValue > 0) {
                                updateSQL = conn.prepareStatement("UPDATE AD_Sequence SET CurrentNextSys = ? + 1 WHERE AD_Sequence_ID = ?");
                                try {
                                    updateSQL.setInt(1, retValue);
                                    updateSQL.setInt(2, AD_Sequence_ID);
                                    updateSQL.executeUpdate();
                                }
                                finally {
                                    updateSQL.close();
                                }
                            }
                            gotFromHTTP = true;
                        }
                        boolean queryProjectServer = false;
                        if (table2.getColumn("EntityType") != null) {
                            queryProjectServer = true;
                        }
                        if (!queryProjectServer && "AD_Sequence".equalsIgnoreCase(TableName)) {
                            queryProjectServer = true;
                        }
                        if (queryProjectServer && !adempiereSys && !MSequence.isExceptionCentralized(TableName) && (isUseProjectCentralizedID = MSysConfig.getValue("PROJECT_ID_USE_CENTRALIZED_ID", "N")).equals("Y")) {
                            retValue = MSequence.getNextProjectID_HTTP(TableName);
                            if (retValue > 0) {
                                try (PreparedStatement updateSQL2 = conn.prepareStatement("UPDATE AD_Sequence SET CurrentNext = GREATEST(CurrentNext, ? + 1) WHERE AD_Sequence_ID = ?");){
                                    updateSQL2.setInt(1, retValue);
                                    updateSQL2.setInt(2, AD_Sequence_ID);
                                    updateSQL2.executeUpdate();
                                }
                            }
                            gotFromHTTP = true;
                        }
                        if (!gotFromHTTP) {
                            if (USE_PROCEDURE) {
                                retValue = MSequence.nextID(conn, AD_Sequence_ID, adempiereSys);
                            } else {
                                int incrementNo = rs.getInt(3);
                                if (adempiereSys) {
                                    updateSQL = conn.prepareStatement("UPDATE AD_Sequence SET CurrentNextSys = CurrentNextSys + ? WHERE AD_Sequence_ID = ?");
                                    retValue = rs.getInt(2);
                                } else {
                                    updateSQL = conn.prepareStatement("UPDATE AD_Sequence SET CurrentNext = CurrentNext + ? WHERE AD_Sequence_ID = ?");
                                    retValue = rs.getInt(1);
                                }
                                try {
                                    updateSQL.setInt(1, incrementNo);
                                    updateSQL.setInt(2, AD_Sequence_ID);
                                    updateSQL.executeUpdate();
                                }
                                finally {
                                    updateSQL.close();
                                }
                            }
                        }
                        conn.commit();
                        break block53;
                    }
                    s_log.severe("No record found - " + TableName);
                }
                DB.close(rs, pstmt);
                pstmt = null;
                rs = null;
                if (conn == null) break;
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                conn = null;
                break;
                catch (Exception e) {
                    try {
                        s_log.log(Level.SEVERE, TableName + " - " + e.getMessage(), e);
                        try {
                            if (conn != null) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException e1) {
                            // empty catch block
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        pstmt = null;
                        rs = null;
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException e2) {
                                // empty catch block
                            }
                            conn = null;
                        }
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    pstmt = null;
                    rs = null;
                    if (conn == null) break block54;
                    try {
                        conn.close();
                    }
                    catch (SQLException e3) {
                        // empty catch block
                    }
                    conn = null;
                }
            }
            Thread.yield();
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextID(Connection conn, int AD_Sequence_ID, boolean adempiereSys) {
        if (conn == null || AD_Sequence_ID == 0) {
            return -3;
        }
        int retValue = -1;
        String sqlUpdate = "{call nextID(?,?,?)}";
        CallableStatement cstmt = null;
        try {
            cstmt = conn.prepareCall(sqlUpdate, 1003, 1007);
            cstmt.setInt(1, AD_Sequence_ID);
            cstmt.setString(2, adempiereSys ? "Y" : "N");
            cstmt.registerOutParameter(3, 4);
            if (DB.getDatabase().isQueryTimeoutSupported()) {
                cstmt.setQueryTimeout(10);
            }
            cstmt.execute();
            retValue = cstmt.getInt(3);
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, e.toString());
            }
            catch (Throwable throwable) {
                DB.close(cstmt);
                throw throwable;
            }
            DB.close(cstmt);
        }
        DB.close(cstmt);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextIDByYear(Connection conn, int AD_Sequence_ID, int incrementNo, String calendarYear) {
        if (conn == null || AD_Sequence_ID == 0) {
            return -3;
        }
        int retValue = -1;
        String sqlUpdate = "{call nextIDByYear(?,?,?,?)}";
        CallableStatement cstmt = null;
        try {
            cstmt = conn.prepareCall(sqlUpdate, 1003, 1007);
            cstmt.setInt(1, AD_Sequence_ID);
            cstmt.setInt(2, incrementNo);
            cstmt.setString(3, calendarYear);
            cstmt.registerOutParameter(4, 4);
            if (DB.getDatabase().isQueryTimeoutSupported()) {
                cstmt.setQueryTimeout(10);
            }
            cstmt.execute();
            retValue = cstmt.getInt(4);
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, e.toString());
            }
            catch (Throwable throwable) {
                DB.close(cstmt);
                throw throwable;
            }
            DB.close(cstmt);
        }
        DB.close(cstmt);
        return retValue;
    }

    public static String getDocumentNo(int AD_Client_ID, String TableName, String trxName) {
        return MSequence.getDocumentNo(AD_Client_ID, TableName, trxName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDocumentNo(int AD_Client_ID, String TableName, String trxName, PO po) {
        if (TableName == null) throw new IllegalArgumentException("TableName missing");
        if (TableName.length() == 0) {
            throw new IllegalArgumentException("TableName missing");
        }
        boolean adempiereSys = Ini.isPropertyBool("AdempiereSys");
        if (adempiereSys && AD_Client_ID > 11) {
            adempiereSys = false;
        }
        if (CLogMgt.isLevel(LOGLEVEL)) {
            s_log.log(LOGLEVEL, TableName + " - AdempiereSys=" + adempiereSys + " [" + trxName + "]");
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean isStartNewYear = false;
        String dateColumn = null;
        if (!adempiereSys) {
            String startNewYearSQL = "SELECT StartNewYear, DateColumn FROM AD_Sequence WHERE Name = ? AND IsActive = 'Y' AND IsTableID = 'N' AND IsAutoSequence='Y' AND AD_Client_ID = ?";
            try {
                pstmt = DB.prepareStatement(startNewYearSQL, trxName);
                pstmt.setString(1, PREFIX_DOCSEQ + TableName);
                pstmt.setInt(2, AD_Client_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    isStartNewYear = "Y".equals(rs.getString(1));
                    dateColumn = rs.getString(2);
                }
                DB.close(rs, pstmt);
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, "(Table) [" + trxName + "]", e);
            }
            finally {
                DB.close(rs, pstmt);
            }
        }
        String selectSQL = null;
        if (!DB.isOracle()) {
            selectSQL = isStartNewYear ? "SELECT y.CurrentNext, s.CurrentNextSys, s.IncrementNo, s.Prefix, s.Suffix, s.DecimalPattern, s.AD_Sequence_ID FROM AD_Sequence_No y, AD_Sequence s WHERE y.AD_Sequence_ID = s.AD_Sequence_ID AND s.Name = ? AND s.AD_Client_ID = ? AND y.CalendarYear = ? AND s.IsActive='Y' AND s.IsTableID='N' AND s.IsAutoSequence='Y' ORDER BY s.AD_Client_ID DESC FOR UPDATE " : "SELECT CurrentNext, CurrentNextSys, IncrementNo, Prefix, Suffix, DecimalPattern, AD_Sequence_ID FROM AD_Sequence WHERE Name = ? AND AD_Client_ID = ? AND IsActive='Y' AND IsTableID='N' AND IsAutoSequence='Y' ORDER BY AD_Client_ID DESC FOR UPDATE ";
            USE_PROCEDURE = false;
        } else {
            selectSQL = isStartNewYear ? "SELECT y.CurrentNext, s.CurrentNextSys, s.IncrementNo, Prefix, Suffix, DecimalPattern, s.AD_Sequence_ID FROM AD_Sequence_No y, AD_Sequence s WHERE y.AD_Sequence_ID = s.AD_Sequence_ID AND s.Name = ? AND s.AD_Client_ID = ? AND y.CalendarYear = ? AND s.IsActive='Y' AND s.IsTableID='N' AND s.IsAutoSequence='Y' ORDER BY s.AD_Client_ID DESC" : "SELECT CurrentNext, CurrentNextSys, IncrementNo, Prefix, Suffix, DecimalPattern, AD_Sequence_ID FROM AD_Sequence WHERE Name = ? AND AD_Client_ID = ? AND IsActive='Y' AND IsTableID='N' AND IsAutoSequence='Y' ORDER BY AD_Client_ID DESC";
            USE_PROCEDURE = true;
        }
        Connection conn = null;
        Trx trx = trxName == null ? null : Trx.get(trxName, true);
        int AD_Sequence_ID = 0;
        int incrementNo = 0;
        int next = -1;
        String prefix = "";
        String suffix = "";
        String decimalPattern = "";
        String calendarYear = "";
        try {
            block47: {
                block46: {
                    conn = trx != null ? trx.getConnection() : DB.getConnectionID();
                    if (conn == null) {
                        String string = null;
                        return string;
                    }
                    if (isStartNewYear) {
                        if (po != null && dateColumn != null && dateColumn.length() > 0) {
                            Date docDate = (Date)po.get_Value(dateColumn);
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                            calendarYear = sdf.format(docDate);
                        } else {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                            calendarYear = sdf.format(new Date());
                        }
                    }
                    pstmt = conn.prepareStatement(selectSQL, 1003, 1008);
                    pstmt.setString(1, PREFIX_DOCSEQ + TableName);
                    pstmt.setInt(2, AD_Client_ID);
                    if (isStartNewYear) {
                        pstmt.setString(3, calendarYear);
                    }
                    if (!USE_PROCEDURE && DB.getDatabase().isQueryTimeoutSupported()) {
                        pstmt.setQueryTimeout(10);
                    }
                    if (!(rs = pstmt.executeQuery()).next()) break block46;
                    AD_Sequence_ID = rs.getInt(7);
                    prefix = rs.getString(4);
                    suffix = rs.getString(5);
                    decimalPattern = rs.getString(6);
                    incrementNo = rs.getInt(3);
                    if (USE_PROCEDURE) {
                        next = isStartNewYear ? MSequence.nextIDByYear(conn, AD_Sequence_ID, incrementNo, calendarYear) : MSequence.nextID(conn, AD_Sequence_ID, adempiereSys);
                        break block47;
                    } else {
                        PreparedStatement updateSQL = null;
                        try {
                            if (adempiereSys) {
                                updateSQL = conn.prepareStatement("UPDATE AD_Sequence SET CurrentNextSys = CurrentNextSys + ? WHERE AD_Sequence_ID = ?");
                                next = rs.getInt(2);
                            } else {
                                String sql = isStartNewYear ? "UPDATE AD_Sequence_No SET CurrentNext = CurrentNext + ? WHERE AD_Sequence_ID = ? AND CalendarYear = ?" : "UPDATE AD_Sequence SET CurrentNext = CurrentNext + ? WHERE AD_Sequence_ID = ?";
                                updateSQL = conn.prepareStatement(sql);
                                next = rs.getInt(1);
                            }
                            updateSQL.setInt(1, incrementNo);
                            updateSQL.setInt(2, AD_Sequence_ID);
                            if (isStartNewYear) {
                                updateSQL.setString(3, calendarYear);
                            }
                            updateSQL.executeUpdate();
                        }
                        catch (Throwable throwable) {
                            DB.close(updateSQL);
                            throw throwable;
                        }
                        DB.close(updateSQL);
                    }
                    break block47;
                }
                s_log.warning("(Table) - no record found - " + TableName);
                MSequence seq = new MSequence(Env.getCtx(), AD_Client_ID, TableName, null);
                next = seq.getNextID();
                seq.saveEx();
            }
            if (trx == null) {
                conn.commit();
            }
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "(Table) [" + trxName + "]", e);
            if (!DBException.isTimeout(e)) throw new AdempiereException("GenerateDocumentNoError", e);
            throw new AdempiereException("GenerateDocumentNoTimeOut", e);
        }
        finally {
            DB.close(rs, pstmt);
            try {
                if (trx == null && conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, "(Table) - finish", e);
            }
        }
        if (next < 0) {
            return null;
        }
        StringBuffer doc = new StringBuffer();
        if (prefix != null && prefix.length() > 0) {
            doc.append(Env.parseVariable(prefix, po, trxName, false));
        }
        if (decimalPattern != null && decimalPattern.length() > 0) {
            doc.append(new DecimalFormat(decimalPattern).format(next));
        } else {
            doc.append(next);
        }
        if (suffix != null && suffix.length() > 0) {
            doc.append(Env.parseVariable(suffix, po, trxName, false));
        }
        String documentNo = doc.toString();
        s_log.finer(documentNo + " (" + incrementNo + ")" + " - Table=" + TableName + " [" + trx + "]");
        return documentNo;
    }

    public static String getDocumentNo(int C_DocType_ID, String trxName) {
        return MSequence.getDocumentNo(C_DocType_ID, trxName, false);
    }

    public static String getDocumentNo(int C_DocType_ID, String trxName, boolean definite) {
        return MSequence.getDocumentNo(C_DocType_ID, trxName, definite, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getDocumentNo(int C_DocType_ID, String trxName, boolean definite, PO po) {
        if (C_DocType_ID == 0) {
            s_log.severe("C_DocType_ID=0");
            return null;
        }
        MDocType dt = MDocType.get(Env.getCtx(), C_DocType_ID);
        if (dt != null && !dt.isDocNoControlled()) {
            s_log.finer("DocType_ID=" + C_DocType_ID + " Not DocNo controlled");
            return null;
        }
        if (definite && !dt.isOverwriteSeqOnComplete()) {
            s_log.finer("DocType_ID=" + C_DocType_ID + " Not Sequence Overwrite on Complete");
            return null;
        }
        if (dt == null || dt.getDocNoSequence_ID() == 0) {
            s_log.warning("No Sequence for DocType - " + dt);
            return null;
        }
        if (definite && dt.getDefiniteSequence_ID() == 0) {
            s_log.warning("No Definite Sequence for DocType - " + dt);
            return null;
        }
        boolean adempiereSys = Ini.isPropertyBool("AdempiereSys");
        if (CLogMgt.isLevel(LOGLEVEL)) {
            s_log.log(LOGLEVEL, "DocType_ID=" + C_DocType_ID + " [" + trxName + "]");
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean isStartNewYear = false;
        String dateColumn = null;
        if (!adempiereSys) {
            block49: {
                String startNewYearSQL = "SELECT StartNewYear, DateColumn FROM AD_Sequence WHERE AD_Sequence_ID = ? AND IsActive = 'Y' AND IsTableID = 'N' AND IsAutoSequence='Y'";
                try {
                    pstmt = DB.prepareStatement(startNewYearSQL, trxName);
                    pstmt.setInt(1, definite ? dt.getDefiniteSequence_ID() : dt.getDocNoSequence_ID());
                    rs = pstmt.executeQuery();
                    if (!rs.next()) break block49;
                    isStartNewYear = "Y".equals(rs.getString(1));
                    dateColumn = rs.getString(2);
                }
                catch (Exception e) {
                    try {
                        s_log.log(Level.SEVERE, "(Table) [" + trxName + "]", e);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                }
            }
            DB.close(rs, pstmt);
        }
        String selectSQL = null;
        if (!DB.isOracle()) {
            selectSQL = isStartNewYear ? "SELECT y.CurrentNext, s.CurrentNextSys, s.IncrementNo, s.Prefix, s.Suffix, s.DecimalPattern, s.AD_Client_ID, s.AD_Sequence_ID FROM AD_Sequence_No y, AD_Sequence s WHERE y.AD_Sequence_ID = s.AD_Sequence_ID AND s.AD_Sequence_ID = ? AND y.CalendarYear = ? AND s.IsActive='Y' AND s.IsTableID='N' AND s.IsAutoSequence='Y' FOR UPDATE " : "SELECT CurrentNext, CurrentNextSys, IncrementNo, Prefix, Suffix, DecimalPattern, AD_Client_ID, AD_Sequence_ID FROM AD_Sequence WHERE AD_Sequence_ID = ? AND IsActive='Y' AND IsTableID='N' AND IsAutoSequence='Y' FOR UPDATE ";
            USE_PROCEDURE = false;
        } else {
            selectSQL = isStartNewYear ? "SELECT y.CurrentNext, s.CurrentNextSys, s.IncrementNo, s.Prefix, s.Suffix, s.DecimalPattern, s.AD_Client_ID, s.AD_Sequence_ID FROM AD_Sequence_No y, AD_Sequence s WHERE y.AD_Sequence_ID = s.AD_Sequence_ID AND s.AD_Sequence_ID = ? AND y.CalendarYear = ? AND s.IsActive='Y' AND s.IsTableID='N' AND s.IsAutoSequence='Y' " : "SELECT CurrentNext, CurrentNextSys, IncrementNo, Prefix, Suffix, DecimalPattern, AD_Client_ID, AD_Sequence_ID FROM AD_Sequence WHERE AD_Sequence_ID = ? AND IsActive='Y' AND IsTableID='N' AND IsAutoSequence='Y' ";
            USE_PROCEDURE = true;
        }
        Connection conn = null;
        Trx trx = trxName == null ? null : Trx.get(trxName, true);
        int AD_Sequence_ID = 0;
        int incrementNo = 0;
        int next = -1;
        String prefix = "";
        String suffix = "";
        String decimalPattern = "";
        String calendarYear = "";
        try {
            block53: {
                block52: {
                    PreparedStatement updateSQL;
                    conn = trx != null ? trx.getConnection() : DB.getConnectionID();
                    if (conn == null) {
                        String string = null;
                        return string;
                    }
                    if (isStartNewYear) {
                        if (po != null && dateColumn != null && dateColumn.length() > 0) {
                            Date docDate = (Date)po.get_Value(dateColumn);
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                            calendarYear = sdf.format(docDate);
                        } else {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
                            calendarYear = sdf.format(new Date());
                        }
                    }
                    pstmt = conn.prepareStatement(selectSQL, 1003, 1008);
                    if (definite) {
                        pstmt.setInt(1, dt.getDefiniteSequence_ID());
                    } else {
                        pstmt.setInt(1, dt.getDocNoSequence_ID());
                    }
                    if (isStartNewYear) {
                        pstmt.setString(2, calendarYear);
                    }
                    if (!USE_PROCEDURE && DB.getDatabase().isQueryTimeoutSupported()) {
                        pstmt.setQueryTimeout(10);
                    }
                    if (!(rs = pstmt.executeQuery()).next()) break block52;
                    incrementNo = rs.getInt(3);
                    prefix = rs.getString(4);
                    suffix = rs.getString(5);
                    decimalPattern = rs.getString(6);
                    int AD_Client_ID = rs.getInt(7);
                    if (adempiereSys && AD_Client_ID > 11) {
                        adempiereSys = false;
                    }
                    AD_Sequence_ID = rs.getInt(8);
                    if (USE_PROCEDURE) {
                        next = isStartNewYear ? MSequence.nextIDByYear(conn, AD_Sequence_ID, incrementNo, calendarYear) : MSequence.nextID(conn, AD_Sequence_ID, adempiereSys);
                    } else {
                        updateSQL = null;
                        if (adempiereSys) {
                            updateSQL = conn.prepareStatement("UPDATE AD_Sequence SET CurrentNextSys = CurrentNextSys + ? WHERE AD_Sequence_ID = ?");
                            next = rs.getInt(2);
                        } else {
                            String sql = isStartNewYear ? "UPDATE AD_Sequence_No SET CurrentNext = CurrentNext + ? WHERE AD_Sequence_ID = ? AND CalendarYear = ?" : "UPDATE AD_Sequence SET CurrentNext = CurrentNext + ? WHERE AD_Sequence_ID = ?";
                            updateSQL = conn.prepareStatement(sql);
                            next = rs.getInt(1);
                        }
                        updateSQL.setInt(1, incrementNo);
                        updateSQL.setInt(2, AD_Sequence_ID);
                        if (isStartNewYear) {
                            updateSQL.setString(3, calendarYear);
                        }
                        updateSQL.executeUpdate();
                        DB.close(updateSQL);
                    }
                    break block53;
                    catch (Throwable throwable) {
                        DB.close(updateSQL);
                        throw throwable;
                    }
                }
                s_log.warning("(DocType)- no record found - " + dt);
                next = -2;
            }
            if (trx == null) {
                conn.commit();
            }
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "(DocType) [" + trxName + "]", e);
            if (DBException.isTimeout(e)) {
                throw new AdempiereException("GenerateDocumentNoTimeOut", e);
            }
            throw new AdempiereException("GenerateDocumentNoError", e);
        }
        finally {
            try {
                DB.close(rs, pstmt);
                if (trx == null && conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, "(DocType) - finish", e);
            }
        }
        if (next < 0) {
            return null;
        }
        StringBuffer doc = new StringBuffer();
        if (prefix != null && prefix.length() > 0) {
            doc.append(Env.parseVariable(prefix, po, trxName, false));
        }
        if (decimalPattern != null && decimalPattern.length() > 0) {
            doc.append(new DecimalFormat(decimalPattern).format(next));
        } else {
            doc.append(next);
        }
        if (suffix != null && suffix.length() > 0) {
            doc.append(Env.parseVariable(suffix, po, trxName, false));
        }
        String documentNo = doc.toString();
        s_log.finer(documentNo + " (" + incrementNo + ")" + " - C_DocType_ID=" + C_DocType_ID + " [" + trx + "]");
        return documentNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkClientSequences(Properties ctx, int AD_Client_ID, String trxName) {
        String sql = "SELECT TableName FROM AD_Table t WHERE IsActive='Y' AND IsView='N' AND AD_Table_ID IN (SELECT AD_Table_ID FROM AD_Column WHERE ColumnName = 'DocumentNo' OR ColumnName = 'Value') AND 'DocumentNo_' || TableName NOT IN (SELECT Name FROM AD_Sequence s WHERE s.AD_Client_ID=?)";
        int counter = 0;
        boolean success = true;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, AD_Client_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(1);
                s_log.fine("Add: " + tableName);
                MSequence seq = new MSequence(ctx, AD_Client_ID, tableName, trxName);
                if (seq.save()) {
                    ++counter;
                    continue;
                }
                s_log.severe("Not created - AD_Client_ID=" + AD_Client_ID + " - " + tableName);
                success = false;
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        s_log.info("AD_Client_ID=" + AD_Client_ID + " - created #" + counter + " - success=" + success);
        return success;
    }

    public static boolean createTableSequence(Properties ctx, String TableName, String trxName) {
        boolean SYSTEM_NATIVE_SEQUENCE = MSysConfig.getBooleanValue("SYSTEM_NATIVE_SEQUENCE", false);
        if (SYSTEM_NATIVE_SEQUENCE) {
            int next_id = MSequence.getNextID(Env.getAD_Client_ID(ctx), TableName, trxName);
            if (next_id == -1) {
                MSequence seq = new MSequence(ctx, 0, trxName);
                seq.setClientOrg(0, 0);
                seq.setName(TableName);
                seq.setDescription("Table " + TableName);
                seq.setIsTableID(true);
                seq.saveEx();
                next_id = 1000000;
            }
            return CConnection.get().getDatabase().createSequence(TableName + "_SEQ", 1, 0, 99999999, next_id, trxName);
        }
        MSequence seq = new MSequence(ctx, 0, trxName);
        seq.setClientOrg(0, 0);
        seq.setName(TableName);
        seq.setDescription("Table " + TableName);
        seq.setIsTableID(true);
        return seq.save();
    }

    public static MSequence get(Properties ctx, String tableName) {
        return MSequence.get(ctx, tableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MSequence get(Properties ctx, String tableName, String trxName) {
        String sql = "SELECT * FROM AD_Sequence WHERE UPPER(Name)=? AND IsTableID='Y'";
        MSequence retValue = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setString(1, tableName.toUpperCase());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MSequence(ctx, rs, trxName);
            }
            if (rs.next()) {
                s_log.log(Level.SEVERE, "More then one sequence for " + tableName);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "get", e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public MSequence(Properties ctx, int AD_Sequence_ID, String trxName) {
        super(ctx, AD_Sequence_ID, trxName);
        if (AD_Sequence_ID == 0) {
            this.setIsTableID(false);
            this.setStartNo(1000000);
            this.setCurrentNext(1000000);
            this.setCurrentNextSys(50000);
            this.setIncrementNo(1);
            this.setIsAutoSequence(true);
            this.setIsAudited(false);
            this.setStartNewYear(false);
        }
    }

    public MSequence(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MSequence(Properties ctx, int AD_Client_ID, String tableName, String trxName) {
        this(ctx, 0, trxName);
        this.setClientOrg(AD_Client_ID, 0);
        this.setName(PREFIX_DOCSEQ + tableName);
        this.setDescription("DocumentNo/Value for Table " + tableName);
    }

    public MSequence(Properties ctx, int AD_Client_ID, String sequenceName, int StartNo, String trxName) {
        this(ctx, 0, trxName);
        this.setClientOrg(AD_Client_ID, 0);
        this.setName(sequenceName);
        this.setDescription(sequenceName);
        this.setStartNo(StartNo);
        this.setCurrentNext(StartNo);
        this.setCurrentNextSys(StartNo / 10);
    }

    public int getNextID() {
        int retValue = this.getCurrentNext();
        this.setCurrentNext(retValue + this.getIncrementNo());
        return retValue;
    }

    public boolean validateTableIDValue() {
        int maxTableSysID;
        int maxTableID;
        if (!this.isTableID()) {
            return false;
        }
        String tableName = this.getName();
        int AD_Column_ID = DB.getSQLValue(null, "SELECT MAX(c.AD_Column_ID) FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE t.TableName='" + tableName + "'" + " AND c.ColumnName='" + tableName + "_ID'");
        if (AD_Column_ID <= 0) {
            return false;
        }
        MSystem system = MSystem.get(this.getCtx());
        int IDRangeEnd = 0;
        if (system.getIDRangeEnd() != null) {
            IDRangeEnd = system.getIDRangeEnd().intValue();
        }
        boolean change = false;
        String info = null;
        String sql = "SELECT MAX(" + tableName + "_ID) FROM " + tableName;
        if (IDRangeEnd > 0) {
            sql = sql + " WHERE " + tableName + "_ID < " + IDRangeEnd;
        }
        if ((maxTableID = DB.getSQLValue(null, sql)) < 1000000) {
            maxTableID = 999999;
        }
        if (this.getCurrentNext() < ++maxTableID) {
            this.setCurrentNext(maxTableID);
            info = "CurrentNext=" + maxTableID;
            change = true;
        }
        if ((maxTableSysID = DB.getSQLValue(null, sql = "SELECT MAX(" + tableName + "_ID) FROM " + tableName + " WHERE " + tableName + "_ID < " + 1000000)) <= 0) {
            maxTableSysID = 49999;
        }
        if (this.getCurrentNextSys() < ++maxTableSysID) {
            this.setCurrentNextSys(maxTableSysID);
            info = info == null ? "CurrentNextSys=" + maxTableSysID : info + " - CurrentNextSys=" + maxTableSysID;
            change = true;
        }
        if (info != null) {
            this.log.fine(this.getName() + " - " + info);
        }
        return change;
    }

    public static void main(String[] args) {
        int i2;
        Adempiere.startup(true);
        CLogMgt.setLevel(Level.SEVERE);
        CLogMgt.setLoggerLevel(Level.SEVERE, null);
        s_list = new Vector(1000);
        long time = System.currentTimeMillis();
        Thread[] threads = new Thread[10];
        for (i2 = 0; i2 < 10; ++i2) {
            GetIDs r = new GetIDs(i2);
            threads[i2] = new Thread(r);
            threads[i2].start();
        }
        for (i2 = 0; i2 < 10; ++i2) {
            try {
                threads[i2].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        time = System.currentTimeMillis() - time;
        System.out.println("-------------------------------------------");
        System.out.println("Size=" + s_list.size() + " (should be 1000)");
        Object[] ia = new Integer[s_list.size()];
        s_list.toArray(ia);
        Arrays.sort(ia);
        Object last = null;
        int duplicates = 0;
        for (int i3 = 0; i3 < ia.length; ++i3) {
            if (last != null && ((Integer)last).compareTo((Integer)ia[i3]) == 0) {
                ++duplicates;
            }
            last = ia[i3];
        }
        System.out.println("-------------------------------------------");
        System.out.println("Size=" + s_list.size() + " (should be 1000)");
        System.out.println("Duplicates=" + duplicates);
        System.out.println("Time (ms)=" + time + " - " + (float)time / (float)s_list.size() + " each");
        System.out.println("-------------------------------------------");
    }

    public static synchronized int getNextOfficialID_HTTP(String TableName) {
        String website = MSysConfig.getValue("DICTIONARY_ID_WEBSITE");
        String prm_USER = MSysConfig.getValue("DICTIONARY_ID_USER");
        String prm_PASSWORD = MSysConfig.getValue("DICTIONARY_ID_PASSWORD");
        String prm_TABLE = TableName;
        String prm_ALTKEY = "";
        String prm_COMMENT = MSysConfig.getValue("DICTIONARY_ID_COMMENTS");
        String prm_PROJECT = new String("Adempiere");
        return MSequence.getNextID_HTTP(TableName, website, prm_USER, prm_PASSWORD, prm_TABLE, prm_ALTKEY, prm_COMMENT, prm_PROJECT);
    }

    public static synchronized int getNextProjectID_HTTP(String TableName) {
        String website = MSysConfig.getValue("PROJECT_ID_WEBSITE");
        String prm_USER = MSysConfig.getValue("PROJECT_ID_USER");
        String prm_PASSWORD = MSysConfig.getValue("PROJECT_ID_PASSWORD");
        String prm_TABLE = TableName;
        String prm_ALTKEY = "";
        String prm_COMMENT = MSysConfig.getValue("PROJECT_ID_COMMENTS");
        String prm_PROJECT = MSysConfig.getValue("PROJECT_ID_PROJECT");
        return MSequence.getNextID_HTTP(TableName, website, prm_USER, prm_PASSWORD, prm_TABLE, prm_ALTKEY, prm_COMMENT, prm_PROJECT);
    }

    private static int getNextID_HTTP(String TableName, String website, String prm_USER, String prm_PASSWORD, String prm_TABLE, String prm_ALTKEY, String prm_COMMENT, String prm_PROJECT) {
        StringBuffer read = new StringBuffer();
        int retValue = -1;
        try {
            int bytes_read;
            String completeUrl = website + "?" + "USER=" + URLEncoder.encode(prm_USER, "UTF-8") + "&PASSWORD=" + URLEncoder.encode(prm_PASSWORD, "UTF-8") + "&PROJECT=" + URLEncoder.encode(prm_PROJECT, "UTF-8") + "&TABLE=" + URLEncoder.encode(prm_TABLE, "UTF-8") + "&ALTKEY=" + URLEncoder.encode(prm_ALTKEY, "UTF-8") + "&COMMENT=" + URLEncoder.encode(prm_COMMENT, "UTF-8");
            URL url = new URL(completeUrl);
            String protocol = url.getProtocol();
            if (!protocol.equals("http")) {
                throw new IllegalArgumentException("URL must use 'http:' protocol");
            }
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setAllowUserInteraction(false);
            InputStream is = conn.getInputStream();
            byte[] buffer = new byte[4096];
            while ((bytes_read = is.read(buffer)) != -1) {
                for (int i2 = 0; i2 < bytes_read; ++i2) {
                    if (buffer[i2] == 10) continue;
                    read.append((char)buffer[i2]);
                }
            }
            conn.disconnect();
            retValue = Integer.parseInt(read.toString());
            if (retValue <= 0) {
                retValue = -1;
            }
        }
        catch (Exception e) {
            System.err.println(e);
            retValue = -1;
        }
        s_log.log(Level.INFO, "getNextID_HTTP - " + TableName + "=" + read + "(" + retValue + ")");
        return retValue;
    }

    private static boolean isExceptionCentralized(String tableName) {
        String[] exceptionTables = new String[]{"AD_ACCESSLOG", "AD_ALERTPROCESSORLOG", "AD_CHANGELOG", "AD_ISSUE", "AD_LDAPPROCESSORLOG", "AD_MIGRATION", "AD_MIGRATIONSTEP", "AD_MIGRATIONDATA", "AD_PACKAGE_IMP", "AD_PACKAGE_IMP_BACKUP", "AD_PACKAGE_IMP_DETAIL", "AD_PACKAGE_IMP_INST", "AD_PACKAGE_IMP_PROC", "AD_PINSTANCE", "AD_PINSTANCE_LOG", "AD_PINSTANCE_PARA", "AD_REPLICATION_LOG", "AD_SCHEDULERLOG", "AD_SESSION", "AD_WORKFLOWPROCESSORLOG", "CM_WEBACCESSLOG", "C_ACCTPROCESSORLOG", "K_INDEXLOG", "R_REQUESTPROCESSORLOG", "T_AGING", "T_ALTER_COLUMN", "T_DISTRIBUTIONRUNDETAIL", "T_INVENTORYVALUE", "T_INVOICEGL", "T_REPLENISH", "T_REPORT", "T_REPORTSTATEMENT", "T_SELECTION", "T_SELECTION2", "T_SPOOL", "T_TRANSACTION", "T_TRIALBALANCE"};
        for (int i2 = 0; i2 < exceptionTables.length; ++i2) {
            if (!tableName.equalsIgnoreCase(exceptionTables[i2])) continue;
            return true;
        }
        return false;
    }

    public static String getPreliminaryNoByYear(GridTab tab, int AD_Sequence_ID, String dateColumn, String trxName) {
        Date d = (Date)tab.getValue(dateColumn);
        if (d == null) {
            d = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        String calendarYear = sdf.format(d);
        String sql = "select CurrentNext From AD_Sequence_No Where AD_Sequence_ID = ? and CalendarYear = ?";
        return DB.getSQLValueString(trxName, sql, AD_Sequence_ID, calendarYear);
    }

    public static class GetIDs
    implements Runnable {
        private int m_i;

        public GetIDs(int i2) {
            this.m_i = i2;
        }

        @Override
        public void run() {
            for (int i2 = 0; i2 < 100; ++i2) {
                try {
                    int no = DB.getNextID(0, "Test", null);
                    s_list.add(new Integer(no));
                    continue;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        }
    }
}

