/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.MRfQResponse;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.model.X_C_RfQResponseLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class MRfQResponseLine
extends X_C_RfQResponseLine {
    private static final long serialVersionUID = 3388579962604552288L;
    private MRfQLine m_rfqLine = null;
    private MRfQResponseLineQty[] m_qtys = null;

    public MRfQResponseLine(Properties ctx, int C_RfQResponseLine_ID, String trxName) {
        super(ctx, C_RfQResponseLine_ID, trxName);
    }

    public MRfQResponseLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRfQResponseLine(MRfQResponse response, MRfQLine line) {
        super(response.getCtx(), 0, response.get_TrxName());
        this.setClientOrg(response);
        this.setC_RfQResponse_ID(response.getC_RfQResponse_ID());
        this.setC_RfQLine_ID(line.getC_RfQLine_ID());
        this.setDeliveryDays(line.getDeliveryDays());
        this.setDescription(line.getDescription());
        this.setHelp(line.getHelp());
        this.setIsSelectedWinner(false);
        this.setIsSelfService(false);
        MRfQLineQty[] qtys = line.getQtys();
        for (int i2 = 0; i2 < qtys.length; ++i2) {
            if (!qtys[i2].isActive() || !qtys[i2].isRfQQty()) continue;
            if (this.get_ID() == 0) {
                this.save();
            }
            MRfQResponseLineQty qty = new MRfQResponseLineQty(this, qtys[i2]);
            qty.saveEx();
        }
    }

    public MRfQResponseLineQty[] getQtys() {
        return this.getQtys(false);
    }

    public MRfQResponseLineQty[] getQtys(boolean requery) {
        if (this.m_qtys != null && !requery) {
            return this.m_qtys;
        }
        ArrayList<MRfQResponseLineQty> list = new ArrayList<MRfQResponseLineQty>();
        String sql = "SELECT * FROM C_RfQResponseLineQty WHERE C_RfQResponseLine_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_RfQResponseLine_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRfQResponseLineQty(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_qtys = new MRfQResponseLineQty[list.size()];
        list.toArray(this.m_qtys);
        return this.m_qtys;
    }

    public MRfQLine getRfQLine() {
        if (this.m_rfqLine == null) {
            this.m_rfqLine = MRfQLine.get(this.getCtx(), this.getC_RfQLine_ID(), this.get_TrxName());
        }
        return this.m_rfqLine;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MRfQResponseLine[");
        sb.append(this.get_ID()).append(",Winner=").append(this.isSelectedWinner()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateWorkStart() != null && this.getDeliveryDays() != 0) {
            this.setDateWorkComplete(TimeUtil.addDays(this.getDateWorkStart(), this.getDeliveryDays()));
        } else if (this.getDateWorkStart() != null && this.getDeliveryDays() == 0 && this.getDateWorkComplete() != null) {
            this.setDeliveryDays(TimeUtil.getDaysBetween(this.getDateWorkStart(), this.getDateWorkComplete()));
        } else if (this.getDateWorkStart() == null && this.getDeliveryDays() != 0 && this.getDateWorkComplete() != null) {
            this.setDateWorkStart(TimeUtil.addDays(this.getDateWorkComplete(), this.getDeliveryDays() * -1));
        }
        if (!this.isActive()) {
            this.setIsSelectedWinner(false);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!this.isActive()) {
            this.getQtys(false);
            for (int i2 = 0; i2 < this.m_qtys.length; ++i2) {
                MRfQResponseLineQty qty = this.m_qtys[i2];
                if (!qty.isActive()) continue;
                qty.setIsActive(false);
                qty.saveEx();
            }
        }
        return success;
    }
}

