/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Requisition;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MRequisition
extends X_M_Requisition
implements DocAction {
    private static final long serialVersionUID = 898606565778668659L;
    private MRequisitionLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MRequisition(Properties ctx, int M_Requisition_ID, String trxName) {
        super(ctx, M_Requisition_ID, trxName);
        if (M_Requisition_ID == 0) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
            this.setDateRequired(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setPriorityRule("5");
            this.setTotalLines(Env.ZERO);
            this.setIsApproved(false);
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MRequisition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRequisitionLine[] getLines() {
        if (this.m_lines != null) {
            MRequisition.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String whereClause = "M_Requisition_ID=?";
        List<MRequisitionLine> list = new Query(this.getCtx(), "M_RequisitionLine", "M_Requisition_ID=?", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("Line").list();
        this.m_lines = new MRequisitionLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MRequisition[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",Status=").append(this.getDocStatus()).append(",Action=").append(this.getDocAction()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        return String.valueOf(Msg.getElement(this.getCtx(), "M_Requisition_ID")) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public void setM_PriceList_ID() {
        MPriceList defaultPL = MPriceList.getDefault(this.getCtx(), false);
        if (defaultPL == null) {
            defaultPL = MPriceList.getDefault(this.getCtx(), true);
        }
        if (defaultPL != null) {
            this.setM_PriceList_ID(defaultPL.getM_PriceList_ID());
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getM_PriceList_ID() == 0) {
            this.setM_PriceList_ID();
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        MRequisitionLine[] mRequisitionLineArray = this.getLines();
        int n = mRequisitionLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MRequisitionLine line = mRequisitionLineArray[n2];
            line.deleteEx(true);
            ++n2;
        }
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MRequisitionLine[] lines = this.getLines();
        if (this.getAD_User_ID() == 0 || this.getM_PriceList_ID() == 0 || this.getM_Warehouse_ID() == 0) {
            return "IN";
        }
        if (lines.length == 0) {
            throw new AdempiereException("@NoLines@");
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateDoc(), "POR", this.getAD_Org_ID());
        int precision = MPriceList.getStandardPrecision(this.getCtx(), this.getM_PriceList_ID());
        BigDecimal totalLines = Env.ZERO;
        int i = 0;
        while (i < lines.length) {
            MRequisitionLine line = lines[i];
            BigDecimal lineNet = line.getQty().multiply(line.getPriceActual());
            if ((lineNet = lineNet.setScale(precision, 4)).compareTo(line.getLineNetAmt()) != 0) {
                line.setLineNetAmt(lineNet);
                line.saveEx();
            }
            totalLines = totalLines.add(line.getLineNetAmt());
            ++i;
        }
        if (totalLines.compareTo(this.getTotalLines()) != 0) {
            this.setTotalLines(totalLines);
            this.saveEx();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        String accion = this.completeOFB();
        if (accion.length() > 1) {
            return accion;
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.closeIt()) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        return this.m_processMsg == null;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        MRequisitionLine[] lines = this.getLines();
        BigDecimal totalLines = Env.ZERO;
        int i = 0;
        while (i < lines.length) {
            MRequisitionLine line = lines[i];
            BigDecimal finalQty = line.getQty();
            if (line.getC_OrderLine_ID() == 0) {
                finalQty = Env.ZERO;
            } else {
                MOrderLine ol = new MOrderLine(this.getCtx(), line.getC_OrderLine_ID(), this.get_TrxName());
                finalQty = ol.getQtyOrdered();
            }
            if (finalQty.compareTo(line.getQty()) != 0) {
                String description = line.getDescription();
                if (description == null) {
                    description = "";
                }
                description = String.valueOf(description) + " [" + line.getQty() + "]";
                line.setDescription(description);
                line.setQty(finalQty);
                line.setLineNetAmt();
                line.saveEx();
            }
            totalLines = totalLines.add(line.getLineNetAmt());
            ++i;
        }
        if (totalLines.compareTo(this.getTotalLines()) != 0) {
            this.setTotalLines(totalLines);
            this.saveEx();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.reverseCorrectIt()) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(" - ").append(this.getUserName());
        sb.append(": ").append(Msg.translate(this.getCtx(), "TotalLines")).append("=").append(this.getTotalLines()).append(" (#").append(this.getLines().length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getAD_User_ID();
    }

    @Override
    public int getC_Currency_ID() {
        MPriceList pl = MPriceList.get(this.getCtx(), this.getM_PriceList_ID(), this.get_TrxName());
        return pl.getC_Currency_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getTotalLines();
    }

    public String getUserName() {
        return MUser.get(this.getCtx(), this.getAD_User_ID()).getName();
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public String completeOFB() {
        DB.executeUpdate("update M_REQUISITIONLINE set Processed='Y' where M_REQUISITION_ID=" + this.getM_Requisition_ID(), this.get_TrxName());
        return "";
    }

    public String getDocBase() {
        String base = DB.getSQLValueString(this.get_TrxName(), "Select docbasetype from C_DocType where C_DocType_ID=" + this.getC_DocType_ID(), new Object[0]);
        return base;
    }

    public boolean isSOTrx() {
        boolean issotrx = "Y".equals(DB.getSQLValueString(this.get_TrxName(), "Select IsSoTrx from C_DocType where C_DocType_ID=" + this.getC_DocType_ID(), new Object[0]));
        return issotrx;
    }
}

