/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductionLine;
import org.compiere.model.MStorage;
import org.compiere.model.X_M_Production;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProduction
extends X_M_Production {
    private static CLogger m_log = CLogger.getCLogger(MProduction.class);
    private static final long serialVersionUID = 1L;
    private int lineno;
    private int count;

    public MProduction(Properties ctx, int M_Production_ID, String trxName) {
        super(ctx, M_Production_ID, trxName);
    }

    public MProduction(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProduction(MOrderLine line) {
        super(line.getCtx(), 0, line.get_TrxName());
        this.setAD_Client_ID(line.getAD_Client_ID());
        this.setAD_Org_ID(line.getAD_Org_ID());
        this.setMovementDate(line.getDatePromised());
    }

    public MProductionLine[] getLines() {
        ArrayList<MProductionLine> list = new ArrayList<MProductionLine>();
        String sql = "SELECT pl.M_ProductionLine_ID FROM M_ProductionLine pl WHERE pl.M_Production_ID = ?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.get_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProductionLine(this.getCtx(), rs.getInt(1), this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            try {
                throw new AdempiereException("Unable to load production lines", ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        MProductionLine[] retValue = new MProductionLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void deleteLines(String trxName) {
        for (MProductionLine line : this.getLines()) {
            line.deleteEx(true);
        }
    }

    public int createLines(boolean mustBeStocked) {
        this.lineno = 100;
        this.count = 0;
        MProduct finishedProduct = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        MProductionLine line = new MProductionLine(this);
        line.setLine(this.lineno);
        line.setM_Product_ID(finishedProduct.get_ID());
        line.setM_Locator_ID(this.getM_Locator_ID());
        line.setMovementQty(this.getProductionQty());
        line.setPlannedQty(this.getProductionQty());
        line.save();
        ++this.count;
        this.createLines(mustBeStocked, finishedProduct, this.getProductionQty());
        return this.count;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int createLines(boolean mustBeStocked, MProduct finishedProduct, BigDecimal requiredQty) {
        block19: {
            block18: {
                defaultLocator = 0;
                finishedLocator = MLocator.get(this.getCtx(), this.getM_Locator_ID());
                M_Warehouse_ID = finishedLocator.getM_Warehouse_ID();
                asi = 0;
                sql = " SELECT bl.M_Product_ID, bl.QtyBOM FROM PP_Product_BOMLine bl JOIN PP_Product_BOM b ON b.PP_Product_BOM_ID = bl.PP_Product_BOM_ID  WHERE b.M_Product_ID=" + finishedProduct.getM_Product_ID() + " ORDER BY bl.Line";
                pstmt = null;
                rs = null;
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    rs = pstmt.executeQuery();
lbl11:
                    // 7 sources

                    while (rs.next()) {
                        this.lineno += 10;
                        BOMProduct_ID = rs.getInt(1);
                        BOMQty = rs.getBigDecimal(2);
                        BOMMovementQty = BOMQty.multiply(requiredQty);
                        bomproduct = new MProduct(Env.getCtx(), BOMProduct_ID, this.get_TrxName());
                        if (bomproduct.isBOM() && bomproduct.isPhantom()) {
                            this.createLines(mustBeStocked, bomproduct, BOMMovementQty);
                            continue;
                        }
                        defaultLocator = bomproduct.getM_Locator_ID();
                        if (defaultLocator == 0) {
                            defaultLocator = this.getM_Locator_ID();
                        }
                        if (!bomproduct.isStocked()) {
                            BOMLine = null;
                            BOMLine = new MProductionLine(this);
                            BOMLine.setLine(this.lineno);
                            BOMLine.setM_Product_ID(BOMProduct_ID);
                            BOMLine.setM_Locator_ID(defaultLocator);
                            BOMLine.setQtyUsed(BOMMovementQty);
                            BOMLine.setPlannedQty(BOMMovementQty);
                            BOMLine.save(this.get_TrxName());
                            this.lineno += 10;
                            ++this.count;
                            continue;
                        }
                        if (BOMMovementQty.signum() == 0) {
                            BOMLine = null;
                            BOMLine = new MProductionLine(this);
                            BOMLine.setLine(this.lineno);
                            BOMLine.setM_Product_ID(BOMProduct_ID);
                            BOMLine.setM_Locator_ID(defaultLocator);
                            BOMLine.setQtyUsed(BOMMovementQty);
                            BOMLine.setPlannedQty(BOMMovementQty);
                            BOMLine.save(this.get_TrxName());
                            this.lineno += 10;
                            ++this.count;
                            continue;
                        }
                        storages = null;
                        usedProduct = MProduct.get(this.getCtx(), BOMProduct_ID);
                        defaultLocator = usedProduct.getM_Locator_ID();
                        if (defaultLocator == 0) {
                            defaultLocator = this.getM_Locator_ID();
                        }
                        if (usedProduct == null || usedProduct.get_ID() == 0) {
                            var17_19 = 0;
                            break block18;
                        }
                        ** GOTO lbl-1000
                    }
                    break block19;
                }
                catch (Exception e) {
                    try {
                        throw new AdempiereException("Failed to create production lines", e);
                    }
                    catch (Throwable var28_30) {
                        DB.close(rs, pstmt);
                        throw var28_30;
                    }
                }
            }
            DB.close(rs, pstmt);
            return var17_19;
lbl-1000:
            // 1 sources

            {
                block20: {
                    client = MClient.get(this.getCtx());
                    pc = MProductCategory.get(this.getCtx(), usedProduct.getM_Product_Category_ID());
                    MMPolicy = pc.getMMPolicy();
                    if (MMPolicy == null || MMPolicy.length() == 0) {
                        MMPolicy = client.getMMPolicy();
                    }
                    storages = MStorage.getWarehouse(this.getCtx(), M_Warehouse_ID, BOMProduct_ID, 0, null, "F".equals(MMPolicy), true, 0, this.get_TrxName());
                    BOMLine = null;
                    prevLoc = -1;
                    previousAttribSet = -1;
                    for (sl = 0; sl < storages.length; ++sl) {
                        lineQty = storages[sl].getQtyOnHand();
                        if (lineQty.signum() == 0) continue;
                        if (lineQty.compareTo(BOMMovementQty) > 0) {
                            lineQty = BOMMovementQty;
                        }
                        loc = storages[sl].getM_Locator_ID();
                        slASI = storages[sl].getM_AttributeSetInstance_ID();
                        locAttribSet = new MAttributeSetInstance(this.getCtx(), asi, this.get_TrxName()).getM_AttributeSet_ID();
                        if (locAttribSet == 0 && previousAttribSet == 0 && prevLoc == loc) {
                            BOMLine.setQtyUsed(BOMLine.getQtyUsed().add(lineQty));
                            BOMLine.setPlannedQty(BOMLine.getQtyUsed());
                            BOMLine.save(this.get_TrxName());
                        } else {
                            BOMLine = new MProductionLine(this);
                            BOMLine.setLine(this.lineno);
                            BOMLine.setM_Product_ID(BOMProduct_ID);
                            BOMLine.setM_Locator_ID(loc);
                            BOMLine.setQtyUsed(lineQty);
                            BOMLine.setPlannedQty(lineQty);
                            if (slASI != 0 && locAttribSet != 0) {
                                BOMLine.setM_AttributeSetInstance_ID(slASI);
                            }
                            BOMLine.save(this.get_TrxName());
                            this.lineno += 10;
                            ++this.count;
                        }
                        prevLoc = loc;
                        previousAttribSet = locAttribSet;
                        BOMMovementQty = BOMMovementQty.subtract(lineQty);
                        if (BOMMovementQty.signum() == 0) break;
                    }
                    if (BOMMovementQty.signum() == 0) ** GOTO lbl11
                    if (mustBeStocked != false) throw new AdempiereUserError("Not enough stock of " + BOMProduct_ID);
                    if (previousAttribSet != 0 || prevLoc != defaultLocator) break block20;
                    BOMLine.setQtyUsed(BOMLine.getQtyUsed().add(BOMMovementQty));
                    BOMLine.setPlannedQty(BOMLine.getQtyUsed());
                    BOMLine.save(this.get_TrxName());
                    ** GOTO lbl11
                }
                BOMLine = new MProductionLine(this);
                BOMLine.setLine(this.lineno);
                BOMLine.setM_Product_ID(BOMProduct_ID);
                BOMLine.setM_Locator_ID(defaultLocator);
                BOMLine.setQtyUsed(BOMMovementQty);
                BOMLine.setPlannedQty(BOMMovementQty);
                BOMLine.save(this.get_TrxName());
                this.lineno += 10;
                ++this.count;
                ** GOTO lbl11
            }
        }
        DB.close(rs, pstmt);
        return this.count;
    }

    @Override
    protected boolean beforeDelete() {
        this.deleteLines(this.get_TrxName());
        return true;
    }
}

