/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MMigrationStep;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Migration;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MMigration
extends X_AD_Migration {
    private static final long serialVersionUID = -5145941967716336078L;
    private CLogger log = CLogger.getCLogger(MMigration.class);
    private boolean isFailOnError = true;
    public static boolean updated = false;

    public boolean isFailOnError() {
        return this.isFailOnError;
    }

    public void setFailOnError(boolean isFailOnError) {
        this.isFailOnError = isFailOnError;
    }

    public MMigration(Properties ctx, int AD_Migration_ID, String trxName) {
        super(ctx, AD_Migration_ID, trxName);
    }

    public MMigration(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void apply() throws AdempiereException {
        for (MMigrationStep step : this.getSteps(false)) {
            step.load(this.get_TrxName());
            if (!step.isActive()) continue;
            try {
                Trx.run(new StepRunner(step, false));
            }
            catch (Exception e) {
                if (!this.isFailOnError) continue;
                throw new AdempiereException(e);
            }
        }
        Trx trx = Trx.get("Migration", true);
        this.set_TrxName(trx.getTrxName());
        this.updateStatus(this.get_TrxName());
        trx.commit();
        trx.close();
    }

    public void rollback() throws SQLException {
        for (MMigrationStep step : this.getSteps(true)) {
            step.load(this.get_TrxName());
            if (!step.isActive()) continue;
            try {
                Trx.run(new StepRunner(step, true));
            }
            catch (Exception e) {
                if (!this.isFailOnError) continue;
                throw new AdempiereException(e);
            }
        }
        Trx trx = Trx.get("Migration", true);
        this.set_TrxName(trx.getTrxName());
        this.updateStatus(this.get_TrxName());
        trx.commit();
        trx.close();
    }

    public void updateStatus(String trxName) {
        String base = "SELECT count(1)  FROM AD_MigrationStep  WHERE AD_Migration_ID = " + this.getAD_Migration_ID() + " AND IsActive = 'Y'";
        int total = DB.getSQLValue(trxName, base);
        String sql = base + " AND StatusCode = '" + "A" + "'";
        int applied = DB.getSQLValue(trxName, sql);
        sql = base + " AND StatusCode IN ('" + "F" + "','" + "U" + "')";
        int unapplied = DB.getSQLValue(trxName, sql);
        String status = "";
        if (applied == total && applied > 0) {
            this.setStatusCode("A");
            this.setApply("R");
            status = "Applied";
        } else if (unapplied == total && unapplied > 0) {
            this.setStatusCode("U");
            this.setApply("A");
            status = "Unapplied";
        } else if (total > applied && applied > 0) {
            this.setStatusCode("P");
            this.setApply("R");
            status = "Partially Applied";
        }
        this.saveEx();
        this.log.log(Level.CONFIG, this.toString() + " ---> " + status + " (" + this.getStatusCode() + ")");
    }

    private List<MMigrationStep> getSteps(boolean rollback) {
        String where = "AD_Migration_ID = " + this.getAD_Migration_ID();
        String order = rollback ? "SeqNo DESC" : "SeqNo ASC";
        return MTable.get(this.getCtx(), MMigrationStep.Table_ID).createQuery(where, null).setOnlyActiveRecords(true).setOrderBy(order).list();
    }

    public static List<MMigration> getMigrations(Properties ctx, Boolean processed, String trxName) {
        String where = "Processed = " + (processed != false ? "'Y'" : "'N'");
        return MTable.get(ctx, Table_ID).createQuery(where, trxName).setOnlyActiveRecords(true).list();
    }

    public static MMigration fromXmlNode(Properties ctx, Element element, String trxName) throws SQLException {
        if (!updated) {
            MMigration.update();
        }
        if (!"Migration".equals(element.getLocalName())) {
            return null;
        }
        MColumn col = MColumn.get(ctx, MColumn.getColumn_ID("AD_Migration", "Name"));
        int length = col.getFieldLength();
        String name = element.getAttribute("Name");
        if (name.length() > length) {
            name = name.substring(0, length);
        }
        String seqNo = element.getAttribute("SeqNo");
        String entityType = element.getAttribute("EntityType");
        String releaseNo = element.getAttribute("ReleaseNo");
        String where = "Name = ? AND SeqNo = ? AND EntityType = ? AND ReleaseNo = ?";
        Object[] params = new Object[]{name, Integer.parseInt(seqNo), entityType, releaseNo};
        MMigration mmigration = (MMigration)new Query(ctx, "AD_Migration", where, trxName).setParameters(params).firstOnly();
        if (mmigration != null) {
            return mmigration;
        }
        mmigration = new MMigration(ctx, 0, trxName);
        mmigration.setName(name);
        mmigration.setSeqNo(Integer.parseInt(seqNo));
        mmigration.setEntityType(entityType);
        mmigration.setReleaseNo(releaseNo);
        mmigration.saveEx();
        Element comment = (Element)element.getElementsByTagName("Comments").item(0);
        if (comment != null) {
            mmigration.setComments(comment.getTextContent());
        }
        NodeList children = element.getElementsByTagName("Step");
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Element step = (Element)children.item(i2);
            if ("Step".equals(step.getTagName())) {
                MMigrationStep.fromXmlNode(mmigration, step);
            }
            Trx.get(trxName, false).commit(true);
        }
        mmigration.saveEx();
        return mmigration;
    }

    private static void update() {
        String sql = "UPDATE AD_Column SET FieldLength = 999999999 WHERE AD_Column_ID IN (57874, 57873) AND FieldLength = 2000";
        int count = DB.executeUpdateEx(sql, null);
        if (count > 0) {
            MColumn col = new MColumn(Env.getCtx(), 57874, null);
            col.syncDatabase();
            col = new MColumn(Env.getCtx(), 57873, null);
            col.syncDatabase();
        }
        updated = true;
    }

    public Node toXmlNode(Document document) throws ParserConfigurationException, SAXException {
        Element migration = document.createElement("Migration");
        migration.setAttribute("SeqNo", Integer.toString(this.getSeqNo()));
        migration.setAttribute("Name", this.getName());
        migration.setAttribute("EntityType", this.getEntityType());
        migration.setAttribute("ReleaseNo", this.getReleaseNo());
        if (this.getComments() != null) {
            Element comment = document.createElement("Comments");
            migration.appendChild(comment);
            comment.appendChild(document.createTextNode(this.getComments()));
        }
        for (MMigrationStep step : this.getSteps(false)) {
            this.log.log(Level.FINE, "Exporting step: " + step);
            migration.appendChild(step.toXmlNode(document));
        }
        return migration;
    }

    public void mergeMigration(MMigration from) {
        int lastSeq = DB.getSQLValue(this.get_TrxName(), "SELECT COALESCE(MAX(SeqNo),0) FROM AD_MigrationStep WHERE AD_Migration_ID = " + this.getAD_Migration_ID());
        String updateSql = "UPDATE AD_MigrationStep SET AD_Migration_ID = ?, SeqNo = SeqNo + ? WHERE AD_Migration_ID = ? ";
        Object[] params = new Object[]{this.getAD_Migration_ID(), lastSeq, from.getAD_Migration_ID()};
        DB.executeUpdateEx(updateSql, params, this.get_TrxName());
        try {
            DB.commit(false, this.get_TrxName());
            from.deleteEx(false, this.get_TrxName());
        }
        catch (IllegalStateException | SQLException e) {
            this.log.log(Level.SEVERE, "[" + this.get_TrxName() + "]", e);
        }
    }

    @Override
    protected boolean beforeDelete() {
        for (MMigrationStep step : this.getSteps(false)) {
            step.deleteEx(true);
        }
        return true;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Client_ID() > 0) {
            this.setAD_Client_ID(0);
        }
        if (this.getAD_Org_ID() > 0) {
            this.setAD_Org_ID(0);
        }
        return true;
    }

    @Override
    public String toString() {
        return "Migration " + this.getSeqNo() + " - " + this.getName() + " - " + this.getReleaseNo() + " (" + this.getEntityType() + ")";
    }

    public void clean() {
        if (this.getEntityType().equals("D") && this.getStatusCode().equals("A")) {
            this.log.log(Level.CONFIG, "Cleaning migration: " + this.toString());
            this.setProcessed(true);
            for (MMigrationStep step : this.getSteps(false)) {
                this.log.log(Level.CONFIG, "   Deleting step: " + step.toString());
                step.deleteEx(true);
            }
            this.saveEx();
        }
    }

    class StepRunner
    implements TrxRunnable {
        MMigrationStep step;
        boolean rollback;

        public StepRunner(MMigrationStep step, boolean rollback) {
            this.step = step;
            this.rollback = rollback;
        }

        @Override
        public void run(String trxName) {
            this.step.set_TrxName(trxName);
            if (this.rollback) {
                this.step.rollback();
            } else {
                this.step.apply();
            }
        }
    }
}

