/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.engine.CostingMethodFactory;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchPO;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.model.Query;
import org.compiere.model.X_M_MatchInv;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MMatchInv
extends X_M_MatchInv
implements IDocumentLine {
    private static final long serialVersionUID = 3668871839074170205L;
    private static CLogger s_log = CLogger.getCLogger(MMatchInv.class);

    public static List<MMatchInv> getInOutLine(MInOutLine inOutLine) {
        return new Query(inOutLine.getCtx(), "M_MatchInv", "M_InOutLine_ID=?", inOutLine.get_TrxName()).setParameters(inOutLine.getM_InOutLine_ID()).list();
    }

    public static MMatchInv[] get(Properties ctx, int M_InOutLine_ID, int C_InvoiceLine_ID, String trxName) {
        if (M_InOutLine_ID <= 0 || C_InvoiceLine_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "M_InOutLine_ID=? AND C_InvoiceLine_ID=?";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", "M_InOutLine_ID=? AND C_InvoiceLine_ID=?", trxName).setParameters(M_InOutLine_ID, C_InvoiceLine_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public static MMatchInv[] getInvoiceLine(Properties ctx, int C_InvoiceLine_ID, String trxName) {
        if (C_InvoiceLine_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "C_InvoiceLine_ID=?";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", whereClause, trxName).setParameters(C_InvoiceLine_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public static MMatchInv[] getInOut(Properties ctx, int M_InOut_ID, String trxName) {
        if (M_InOut_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "EXISTS (SELECT 1 FROM M_InOutLine l WHERE M_MatchInv.M_InOutLine_ID=l.M_InOutLine_ID AND l.M_InOut_ID=?)";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", "EXISTS (SELECT 1 FROM M_InOutLine l WHERE M_MatchInv.M_InOutLine_ID=l.M_InOutLine_ID AND l.M_InOut_ID=?)", trxName).setParameters(M_InOut_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public static MMatchInv[] getInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        if (C_Invoice_ID == 0) {
            return new MMatchInv[0];
        }
        String whereClause = " EXISTS (SELECT 1 FROM C_InvoiceLine il WHERE M_MatchInv.C_InvoiceLine_ID=il.C_InvoiceLine_ID AND il.C_Invoice_ID=?)";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", " EXISTS (SELECT 1 FROM C_InvoiceLine il WHERE M_MatchInv.C_InvoiceLine_ID=il.C_InvoiceLine_ID AND il.C_Invoice_ID=?)", trxName).setParameters(C_Invoice_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public MMatchInv(Properties ctx, int M_MatchInv_ID, String trxName) {
        super(ctx, M_MatchInv_ID, trxName);
        if (M_MatchInv_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setPosted(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MMatchInv(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMatchInv(MInvoiceLine iLine, Timestamp dateTrx, BigDecimal qty) {
        this(iLine.getCtx(), 0, iLine.get_TrxName());
        this.setClientOrg(iLine);
        this.setC_InvoiceLine_ID(iLine.getC_InvoiceLine_ID());
        this.setM_InOutLine_ID(iLine.getM_InOutLine_ID());
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
        }
        this.setM_Product_ID(iLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getDateAcct() == null) {
            Timestamp ts = this.getNewerDateAcct();
            if (ts == null) {
                ts = this.getDateTrx();
            }
            this.setDateAcct(ts);
        }
        if (this.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0) {
            MInOutLine iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            MInOutLine inout_line = (MInOutLine)this.getM_InOutLine();
            for (MTransaction mTransaction : MTransaction.getByInOutLine(inout_line)) {
            }
        }
        return success;
    }

    public Timestamp getNewerDateAcct() {
        String sql = "SELECT io.DateAcct FROM M_InOutLine iol INNER JOIN M_InOut io ON (io.M_InOut_ID=iol.M_InOut_ID) WHERE iol.M_InOutLine_ID=?";
        Timestamp shipDate = DB.getSQLValueTS(this.get_TrxName(), sql, this.getM_InOutLine_ID());
        return shipDate;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isPosted()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateTrx(), "MXI", this.getAD_Org_ID());
            this.setPosted(false);
            MFactAcct.deleteEx(Table_ID, this.get_ID(), this.get_TrxName());
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.deleteMatchInvCostDetail();
            MInvoiceLine iLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
            int C_OrderLine_ID = iLine.getC_OrderLine_ID();
            if (C_OrderLine_ID == 0) {
                MInOutLine ioLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
                C_OrderLine_ID = ioLine.getC_OrderLine_ID();
            }
            if (C_OrderLine_ID == 0) {
                return success;
            }
            MMatchPO[] mPO = MMatchPO.get(this.getCtx(), C_OrderLine_ID, this.getC_InvoiceLine_ID(), this.get_TrxName());
            int i = 0;
            while (i < mPO.length) {
                if (mPO[i].getM_InOutLine_ID() == 0) {
                    mPO[i].delete(true);
                } else {
                    mPO[i].setC_InvoiceLine_ID(null);
                    mPO[i].saveEx();
                }
                ++i;
            }
        }
        return success;
    }

    private String deleteMatchInvCostDetail() {
        MAcctSchema[] acctschemas = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
        int asn = 0;
        while (asn < acctschemas.length) {
            MAcctSchema as = acctschemas[asn];
            if (!as.isSkipOrg(this.getAD_Org_ID())) {
                MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
                String CostingLevel = product.getCostingLevel(as);
                int Org_ID = this.getAD_Org_ID();
                int M_ASI_ID = this.getM_AttributeSetInstance_ID();
                if ("C".equals(CostingLevel)) {
                    Org_ID = 0;
                    M_ASI_ID = 0;
                } else if ("O".equals(CostingLevel)) {
                    M_ASI_ID = 0;
                } else if ("B".equals(CostingLevel)) {
                    Org_ID = 0;
                }
                List<MCostElement> ces = MCostElement.getCostElement(this.getCtx(), this.get_TrxName());
                List<MCostType> cts = MCostType.get(this.getCtx(), this.get_TrxName());
                for (MCostType ct : cts) {
                    if (!ct.isActive()) continue;
                    for (MCostElement ce : ces) {
                        String whereClause = "c_invoiceline_id =? and m_costtype_id=? and m_costelement_ID=?";
                        List cds = new Query(this.getCtx(), "M_CostDetail", whereClause, this.get_TrxName()).setParameters(this.getC_InvoiceLine_ID(), ct.getM_CostType_ID(), ce.getM_CostElement_ID()).list();
                        for (MCostDetail cd : cds) {
                            cd.setCostAdjustment(Env.ZERO);
                            cd.setCostAdjustmentLL(Env.ZERO);
                            cd.saveEx();
                            MInOutLine inout_line = (MInOutLine)this.getM_InOutLine();
                            MCost dimension = new MCost(product, M_ASI_ID, as.getC_AcctSchema_ID(), Org_ID, inout_line.getM_Warehouse_ID(), cd.getM_CostType_ID(), cd.getM_CostElement_ID(), this.get_TrxName());
                            for (MTransaction trx : MTransaction.getByInOutLine(inout_line)) {
                                ICostingMethod method = CostingMethodFactory.get().getCostingMethod(ct.getCostingMethod());
                                method.setCostingMethod(as, trx, this, dimension, Env.ZERO, Env.ZERO, false);
                                method.processCostDetail(cd);
                            }
                        }
                    }
                }
            }
            ++asn;
        }
        return "";
    }

    @Override
    public int getM_Locator_ID() {
        return -1;
    }

    @Override
    public BigDecimal getMovementQty() {
        return this.getQty();
    }

    @Override
    public BigDecimal getPriceActual() {
        MInvoiceLine il = (MInvoiceLine)this.getC_InvoiceLine();
        BigDecimal priceActual = MConversionRate.convertBase(this.getCtx(), il.getPriceActual(), il.getParent().getC_Currency_ID(), il.getParent().getDateAcct(), il.getParent().getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
        if ("APC".equals(il.getParent().getC_DocType().getDocBaseType())) {
            return priceActual.multiply(new BigDecimal(-1));
        }
        return priceActual;
    }

    @Override
    public int getReversalLine_ID() {
        return -1;
    }

    @Override
    public boolean isSOTrx() {
        return false;
    }

    @Override
    public void setM_Locator_ID(int M_Locator_ID) {
    }

    @Override
    public IDocumentLine getReversalDocumentLine() {
        return null;
    }

    @Override
    public int getM_AttributeSetInstanceTo_ID() {
        return -1;
    }

    @Override
    public int getM_LocatorTo_ID() {
        return -1;
    }

    @Override
    public int getC_DocType_ID() {
        return -1;
    }
}

