/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import org.compiere.model.Lookup;
import org.compiere.model.MLookupCache;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MQuery;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;

public final class MLookup
extends Lookup
implements Serializable {
    private static final long serialVersionUID = 5784044288965615466L;
    public static final String INACTIVE_S = "~";
    public static final String INACTIVE_E = "~";
    private static final int MAX_ROWS = 10000;
    private static Integer MINUS_ONE = new Integer(-1);
    private MLookupInfo m_info = null;
    private volatile LinkedHashMap<Object, Object> m_lookup = new LinkedHashMap();
    private MLoader m_loader;
    private boolean m_allLoaded = false;
    private boolean m_hasInactive = false;
    private boolean m_refreshing = false;
    private long m_nextRead = 0L;
    private HashMap<Object, Object> m_lookupDirect = null;
    private Object m_directNullKey = null;

    public MLookup(MLookupInfo info, int TabNo) {
        super(info.DisplayType, info.WindowNo);
        this.m_info = info;
        this.log.fine(this.m_info.KeyColumn);
        if (MLookupCache.loadFromCache(this.m_info, this.m_lookup)) {
            return;
        }
        if (this.m_info.DisplayType == 30 || this.m_info.IsCreadedUpdatedBy) {
            return;
        }
        if (this.m_info.IsParent || this.m_info.IsKey) {
            this.m_hasInactive = true;
            return;
        }
    }

    @Override
    public void dispose() {
        if (this.m_info != null) {
            this.log.fine(this.m_info.KeyColumn + ": dispose");
        }
        if (this.m_loader != null && this.m_loader.isAlive()) {
            this.m_loader.interrupt();
        }
        this.m_loader = null;
        if (this.m_lookup != null) {
            this.m_lookup.clear();
        }
        this.m_lookup = null;
        if (this.m_lookupDirect != null) {
            this.m_lookupDirect.clear();
        }
        this.m_lookupDirect = null;
        this.m_info = null;
        super.dispose();
    }

    @Override
    public void loadComplete() {
        if (this.m_loader != null && this.m_loader.isAlive()) {
            try {
                this.m_loader.join();
                this.m_loader = null;
            }
            catch (InterruptedException ie) {
                this.log.log(Level.SEVERE, this.m_info.KeyColumn + ": Interrupted", ie);
            }
        }
    }

    @Override
    public NamePair get(Object key) {
        NamePair retValue;
        if (key == null || MINUS_ONE.equals(key)) {
            return null;
        }
        if (this.m_info.IsParent) {
            if (this.m_nextRead > 0L && this.m_nextRead < System.currentTimeMillis()) {
                this.m_lookup.clear();
                if (this.m_lookupDirect != null) {
                    this.m_lookupDirect.clear();
                }
            }
            this.m_nextRead = System.currentTimeMillis() + 5000L;
        }
        if ((retValue = (NamePair)this.m_lookup.get(key)) != null) {
            return retValue;
        }
        if (this.m_loader != null && this.m_loader.isAlive()) {
            this.log.finer((this.m_info.KeyColumn == null ? "ID=" + this.m_info.Column_ID : this.m_info.KeyColumn) + ": waiting for Loader");
            this.loadComplete();
            retValue = (NamePair)this.m_lookup.get(key);
            if (retValue != null) {
                return retValue;
            }
        }
        if (!this.m_info.IsParent && this.m_info.IsValidated && this.m_allLoaded) {
            this.log.finer(this.m_info.KeyColumn + ": <NULL> - " + key + "; Size=" + this.m_lookup.size());
            return this.getDirect(key, false, true);
        }
        this.log.finest(this.m_info.KeyColumn + ": " + key + "; Size=" + this.m_lookup.size() + "; Validated=" + this.m_info.IsValidated + "; All Loaded=" + this.m_allLoaded + "; HasInactive=" + this.m_hasInactive);
        if (!(this.m_allLoaded || this.m_lookup.size() != 0 || this.m_info.IsCreadedUpdatedBy || this.m_info.IsParent || this.getDisplayType() == 30)) {
            this.m_loader = new MLoader();
            this.m_loader.run();
            retValue = (NamePair)this.m_lookup.get(key);
            if (retValue != null) {
                return retValue;
            }
        }
        boolean cacheLocal = this.m_info.IsValidated;
        return this.getDirect(key, false, cacheLocal);
    }

    @Override
    public String getDisplay(Object key) {
        if (key == null) {
            return "";
        }
        NamePair display = this.get(key);
        if (display == null) {
            return "<" + key.toString() + ">";
        }
        return ((Object)display).toString();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.m_lookup.containsKey(key)) {
            return true;
        }
        if (this.m_lookup.size() > 0) {
            return false;
        }
        return this.get(key) != null;
    }

    public MLookupInfo getLookupInfo() {
        return this.m_info;
    }

    public String toString() {
        return "MLookup[" + this.m_info.KeyColumn + ",Column_ID=" + this.m_info.Column_ID + ",Size=" + this.m_lookup.size() + ",Validated=" + this.isValidated() + "-" + this.getValidation() + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof MLookup) {
            MLookup ll = (MLookup)obj;
            if (ll.m_info.Column_ID == this.m_info.Column_ID) {
                return true;
            }
        }
        return false;
    }

    public int size() {
        return this.m_lookup.size();
    }

    public boolean isAllLoaded() {
        return this.m_allLoaded;
    }

    @Override
    public boolean isValidated() {
        if (this.m_info == null) {
            return false;
        }
        return this.isValidated(this.m_info);
    }

    @Override
    public String getValidation() {
        return this.m_info.ValidationCode;
    }

    public int getAD_Reference_Value_ID() {
        return this.m_info.AD_Reference_Value_ID;
    }

    @Override
    public boolean hasInactive() {
        return this.m_hasInactive;
    }

    private ArrayList<Object> getData(boolean onlyValidated, boolean loadParent) {
        boolean validated;
        if (this.m_loader != null && this.m_loader.isAlive()) {
            this.log.fine((this.m_info.KeyColumn == null ? "ID=" + this.m_info.Column_ID : this.m_info.KeyColumn) + ": waiting for Loader");
            this.loadComplete();
        }
        if (!this.m_allLoaded || this.m_lookup.size() == 0) {
            this.loadData(loadParent);
        }
        if (validated = this.isValidated(this.m_info)) {
            return new ArrayList<Object>(this.m_lookup.values());
        }
        if (!validated && onlyValidated) {
            this.loadData(loadParent);
            this.log.fine(this.m_info.KeyColumn + ": Validated - #" + this.m_lookup.size());
        }
        return new ArrayList<Object>(this.m_lookup.values());
    }

    @Override
    public ArrayList<Object> getData(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary) {
        ArrayList<Object> list = this.getData(onlyValidated, true);
        if (onlyActive && this.m_hasInactive) {
            for (int i2 = list.size(); i2 > 0; --i2) {
                String s;
                Object o = list.get(i2 - 1);
                if (o == null || !(s = o.toString()).startsWith("~") || !s.endsWith("~")) continue;
                list.remove(i2 - 1);
            }
        }
        if (!mandatory) {
            NamePair p2 = null;
            p2 = this.m_info.KeyColumn != null && this.m_info.KeyColumn.endsWith("_ID") ? new KeyNamePair(-1, "") : new ValueNamePair("", "");
            list.add(0, p2);
        }
        return list;
    }

    @Override
    public NamePair getDirect(Object key, boolean saveInCache, boolean cacheLocal) {
        if (key == null || this.m_info.QueryDirect == null || this.m_info.QueryDirect.length() == 0) {
            return null;
        }
        if (key.equals(this.m_directNullKey)) {
            return null;
        }
        NamePair directValue = null;
        if (this.m_lookupDirect != null && (directValue = (NamePair)this.m_lookupDirect.get(key)) != null) {
            return directValue;
        }
        this.log.finer(this.m_info.KeyColumn + ": " + key + ", SaveInCache=" + saveInCache + ",Local=" + cacheLocal);
        boolean isNumber = this.m_info.KeyColumn.endsWith("_ID");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(this.m_info.QueryDirect, null);
            if (isNumber) {
                pstmt.setInt(1, Integer.parseInt(key.toString()));
            } else {
                pstmt.setString(1, key.toString());
            }
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                String name = rs.getString(3);
                if (isNumber) {
                    int keyValue = rs.getInt(1);
                    KeyNamePair p2 = new KeyNamePair(keyValue, name);
                    if (saveInCache) {
                        this.m_lookup.put(new Integer(keyValue), p2);
                    }
                    directValue = p2;
                } else {
                    String value = rs.getString(2);
                    ValueNamePair p3 = new ValueNamePair(value, name);
                    if (saveInCache) {
                        this.m_lookup.put(value, p3);
                    }
                    directValue = p3;
                }
                if (rs.next()) {
                    this.log.log(Level.SEVERE, this.m_info.KeyColumn + ": Not unique (first returned) for " + key + " SQL=" + this.m_info.QueryDirect);
                }
            } else {
                this.m_directNullKey = key;
                directValue = null;
            }
            rs.close();
            pstmt.close();
            if (CLogMgt.isLevelFinest()) {
                this.log.finest(this.m_info.KeyColumn + ": " + directValue + " - " + this.m_info);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, this.m_info.KeyColumn + ": SQL=" + this.m_info.QueryDirect + "; Key=" + key, e);
            directValue = null;
        }
        if (cacheLocal && !saveInCache && directValue != null) {
            if (this.m_lookupDirect == null) {
                this.m_lookupDirect = new HashMap();
            }
            this.m_lookupDirect.put(key, directValue);
        }
        this.m_hasInactive = true;
        return directValue;
    }

    @Override
    public int getZoom() {
        return this.m_info.ZoomWindow;
    }

    @Override
    public int getZoom(MQuery query) {
        if (this.m_info.ZoomWindowPO == 0 || query == null) {
            return this.m_info.ZoomWindow;
        }
        boolean isSOTrx = DB.isSOTrx(this.m_info.TableName, query.getWhereClause(false));
        if (!isSOTrx) {
            return this.m_info.ZoomWindowPO;
        }
        return this.m_info.ZoomWindow;
    }

    @Override
    public MQuery getZoomQuery() {
        return this.m_info.ZoomQuery;
    }

    @Override
    public String getColumnName() {
        return this.m_info.KeyColumn;
    }

    @Override
    public int refresh() {
        if (this.m_refreshing) {
            return 0;
        }
        return this.refresh(true);
    }

    public int refresh(boolean loadParent) {
        if (this.m_refreshing) {
            return 0;
        }
        if (!loadParent && this.m_info.IsParent) {
            return 0;
        }
        if (this.m_info.DisplayType == 30 || this.m_info.IsCreadedUpdatedBy) {
            this.removeAllElements();
            return 0;
        }
        this.m_refreshing = true;
        this.m_lookup.clear();
        this.fillComboBox(this.isMandatory(), true, true, false);
        this.m_refreshing = false;
        return this.m_lookup.size();
    }

    private int loadData(boolean loadParent) {
        if (!loadParent && this.m_info.IsParent) {
            return 0;
        }
        if (this.m_info.DisplayType == 30 || this.m_info.IsCreadedUpdatedBy) {
            return 0;
        }
        this.log.fine(this.m_info.KeyColumn + ": start");
        this.m_loader = new MLoader();
        this.m_loader.start();
        this.loadComplete();
        this.log.fine(this.m_info.KeyColumn + ": #" + this.m_lookup.size());
        return this.m_lookup.size();
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.m_lookup.clear();
        if (this.m_lookupDirect != null) {
            this.m_lookupDirect.clear();
        }
    }

    private boolean isValidated(MLookupInfo info) {
        if (info.IsValidated) {
            return true;
        }
        if (info.ValidationCode.length() == 0) {
            return true;
        }
        String validation = Env.parseContext(this.m_info.ctx, this.m_info.WindowNo, this.m_info.ValidationCode, false);
        return validation.equals(info.parsedValidationCode);
    }

    @Override
    public String getInfoFactoryClass() {
        return this.m_info.InfoFactoryClass != null ? this.m_info.InfoFactoryClass : "";
    }

    public String getTableName() {
        return this.m_info.TableName;
    }

    public boolean isAlert() {
        return this.m_info.IsAlert;
    }

    class MLoader
    extends Thread
    implements Serializable {
        private static final long serialVersionUID = -7868426685745727939L;
        private long m_startTime;

        public MLoader() {
            super("MLoader-" + ((MLookup)MLookup.this).m_info.KeyColumn);
            this.m_startTime = System.currentTimeMillis();
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            MLookupCache.loadStart(MLookup.this.m_info);
            String sql = ((MLookup)MLookup.this).m_info.Query;
            if (!((MLookup)MLookup.this).m_info.IsValidated) {
                String validation;
                ((MLookup)MLookup.this).m_info.parsedValidationCode = validation = Env.parseContext(((MLookup)MLookup.this).m_info.ctx, ((MLookup)MLookup.this).m_info.WindowNo, ((MLookup)MLookup.this).m_info.ValidationCode, false);
                if (validation.length() == 0 && ((MLookup)MLookup.this).m_info.ValidationCode.length() > 0) {
                    MLookup.this.log.fine(((MLookup)MLookup.this).m_info.KeyColumn + ": Loader NOT Validated: " + ((MLookup)MLookup.this).m_info.ValidationCode);
                    boolean isReportViewer = Env.getContext(((MLookup)MLookup.this).m_info.ctx, ((MLookup)MLookup.this).m_info.WindowNo, "_WinInfo_IsReportViewer").equals("Y");
                    if (!isReportViewer) {
                        MLookup.this.m_lookup.clear();
                        return;
                    }
                } else {
                    MLookup.this.log.fine(((MLookup)MLookup.this).m_info.KeyColumn + ": Loader Validated: " + validation);
                    int posFrom = sql.lastIndexOf(" FROM ");
                    boolean hasWhere = sql.indexOf(" WHERE ", posFrom) != -1;
                    int posOrder = sql.lastIndexOf(" ORDER BY ");
                    sql = posOrder != -1 ? sql.substring(0, posOrder) + (hasWhere ? " AND " : " WHERE ") + validation + sql.substring(posOrder) : sql + (hasWhere ? " AND " : " WHERE ") + validation;
                    if (CLogMgt.isLevelFinest()) {
                        MLookup.this.log.fine(((MLookup)MLookup.this).m_info.KeyColumn + ": Validation=" + validation);
                    }
                }
            }
            if (this.isInterrupted()) {
                MLookup.this.log.log(Level.WARNING, ((MLookup)MLookup.this).m_info.KeyColumn + ": Loader interrupted");
                return;
            }
            if (CLogMgt.isLevelFiner()) {
                Env.setContext(((MLookup)MLookup.this).m_info.ctx, 1111, ((MLookup)MLookup.this).m_info.Column_ID, ((MLookup)MLookup.this).m_info.KeyColumn, sql);
            }
            if (CLogMgt.isLevelFinest()) {
                MLookup.this.log.fine(((MLookup)MLookup.this).m_info.KeyColumn + ": " + sql);
            }
            MLookup.this.m_lookup.clear();
            boolean isNumber = ((MLookup)MLookup.this).m_info.KeyColumn.endsWith("_ID");
            MLookup.this.m_hasInactive = false;
            int rows = 0;
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                ResultSet rs = pstmt.executeQuery();
                MLookup.this.m_allLoaded = true;
                while (rs.next()) {
                    NamePair p2;
                    if (rows++ > 10000) {
                        MLookup.this.log.warning(((MLookup)MLookup.this).m_info.KeyColumn + ": Loader - Too many records");
                        MLookup.this.m_allLoaded = false;
                        break;
                    }
                    if (rows % 20 == 0 && this.isInterrupted()) break;
                    String name = rs.getString(3);
                    boolean isActive = rs.getString(4).equals("Y");
                    if (!isActive) {
                        name = "~" + name + "~";
                        MLookup.this.m_hasInactive = true;
                    }
                    if (isNumber) {
                        int key = rs.getInt(1);
                        p2 = new KeyNamePair(key, name);
                        MLookup.this.m_lookup.put(new Integer(key), p2);
                        continue;
                    }
                    String value = rs.getString(2);
                    p2 = new ValueNamePair(value, name);
                    MLookup.this.m_lookup.put(value, p2);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                MLookup.this.log.log(Level.SEVERE, ((MLookup)MLookup.this).m_info.KeyColumn + ", " + ((MLookup)MLookup.this).m_info.Column_ID + " : Loader - " + sql, e);
            }
            int size = MLookup.this.m_lookup.size();
            MLookup.this.log.finer(((MLookup)MLookup.this).m_info.KeyColumn + " (" + ((MLookup)MLookup.this).m_info.Column_ID + "):" + " - Loader complete #" + size + " - all=" + MLookup.this.m_allLoaded + " - ms=" + String.valueOf(System.currentTimeMillis() - this.m_startTime) + " (" + String.valueOf(System.currentTimeMillis() - startTime) + ")");
            MLookupCache.loadEnd(MLookup.this.m_info, MLookup.this.m_lookup);
        }
    }
}

