/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MCurrency;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.Query;
import org.compiere.model.X_C_LandedCostAllocation;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MLandedCostAllocation
extends X_C_LandedCostAllocation
implements IDocumentLine {
    private static final long serialVersionUID = -8645283018475474574L;
    private static CLogger s_log = CLogger.getCLogger(MLandedCostAllocation.class);

    public static MLandedCostAllocation[] getOfInvoiceLine(Properties ctx, int C_InvoiceLine_ID, String trxName) {
        ArrayList<MLandedCostAllocation> list = new ArrayList<MLandedCostAllocation>();
        String sql = "SELECT * FROM C_LandedCostAllocation WHERE C_InvoiceLine_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, C_InvoiceLine_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MLandedCostAllocation(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MLandedCostAllocation[] retValue = new MLandedCostAllocation[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static List<MLandedCostAllocation> getOfInOuline(MInOutLine ioLine, int M_CostElement_ID) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_InOutLine_ID").append("=? AND ");
        whereClause.append("M_CostElement_ID").append("=? ");
        return new Query(ioLine.getCtx(), "C_LandedCostAllocation", whereClause.toString(), ioLine.get_TrxName()).setClient_ID().setParameters(ioLine.getM_InOutLine_ID(), M_CostElement_ID).list();
    }

    public MLandedCostAllocation(Properties ctx, int C_LandedCostAllocation_ID, String trxName) {
        super(ctx, C_LandedCostAllocation_ID, trxName);
        if (C_LandedCostAllocation_ID == 0) {
            this.setAmt(Env.ZERO);
            this.setQty(Env.ZERO);
            this.setBase(Env.ZERO);
        }
    }

    public MLandedCostAllocation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MLandedCostAllocation(MInvoiceLine parent, int M_CostElement_ID) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setC_InvoiceLine_ID(parent.getC_InvoiceLine_ID());
        this.setM_CostElement_ID(M_CostElement_ID);
    }

    public void setAmt(double Amt, int precision) {
        BigDecimal bd = new BigDecimal(Amt);
        if (bd.scale() > precision) {
            bd = bd.setScale(precision, 4);
        }
        super.setAmt(bd);
    }

    @Override
    public void setQty(BigDecimal Qty) {
        super.setQty(Qty);
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public int getM_Locator_ID() {
        return 0;
    }

    @Override
    public BigDecimal getMovementQty() {
        return this.getQty();
    }

    @Override
    public BigDecimal getPriceActual() {
        String where = "EXISTS (SELECT 1 FROM C_Invoice i INNER JOIN C_InvoiceLine il ON (i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_Currency.C_Currency_ID=i.C_Currency_ID AND il.C_InvoiceLine_ID=?)";
        MCurrency currency = (MCurrency)new Query(this.getCtx(), "C_Currency", "EXISTS (SELECT 1 FROM C_Invoice i INNER JOIN C_InvoiceLine il ON (i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_Currency.C_Currency_ID=i.C_Currency_ID AND il.C_InvoiceLine_ID=?)", this.get_TrxName()).setParameters(this.getC_InvoiceLine_ID()).firstOnly();
        BigDecimal price = this.getAmt().divide(this.getQty(), currency.getCostingPrecision(), RoundingMode.HALF_UP);
        return price;
    }

    @Override
    public int getReversalLine_ID() {
        return 0;
    }

    @Override
    public boolean isSOTrx() {
        return false;
    }

    @Override
    public void setM_Locator_ID(int M_Locator_ID) {
    }

    @Override
    public Timestamp getDateAcct() {
        return this.getM_InOutLine().getM_InOut().getDateAcct();
    }

    @Override
    public IDocumentLine getReversalDocumentLine() {
        return null;
    }

    @Override
    public int getM_AttributeSetInstanceTo_ID() {
        return -1;
    }

    @Override
    public int getM_LocatorTo_ID() {
        return -1;
    }

    @Override
    public int getC_DocType_ID() {
        return -1;
    }
}

