/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MCurrency;
import org.compiere.model.MElementValue;
import org.compiere.model.MJournal;
import org.compiere.model.X_GL_JournalLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MJournalLine
extends X_GL_JournalLine {
    private static final long serialVersionUID = -7008806797777773843L;
    private MJournal m_parent = null;
    private int m_precision = 2;
    private MAccount m_account = null;
    private MElementValue m_accountElement = null;

    public MJournalLine(Properties ctx, int GL_JournalLine_ID, String trxName) {
        super(ctx, GL_JournalLine_ID, trxName);
        if (GL_JournalLine_ID == 0) {
            this.setLine(0);
            this.setAmtAcctCr(Env.ZERO);
            this.setAmtAcctDr(Env.ZERO);
            this.setAmtSourceCr(Env.ZERO);
            this.setAmtSourceDr(Env.ZERO);
            this.setCurrencyRate(Env.ONE);
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setIsGenerated(true);
        }
    }

    public MJournalLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MJournalLine(MJournal parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setGL_Journal_ID(parent.getGL_Journal_ID());
        this.setC_Currency_ID(parent.getC_Currency_ID());
        this.setC_ConversionType_ID(parent.getC_ConversionType_ID());
        this.setDateAcct(parent.getDateAcct());
    }

    public MJournal getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MJournal(this.getCtx(), this.getGL_Journal_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setCurrency(int C_Currency_ID, int C_ConversionType_ID, BigDecimal CurrencyRate) {
        this.setC_Currency_ID(C_Currency_ID);
        if (C_ConversionType_ID != 0) {
            this.setC_ConversionType_ID(C_ConversionType_ID);
        }
        if (CurrencyRate != null && CurrencyRate.signum() == 0) {
            this.setCurrencyRate(CurrencyRate);
        }
    }

    @Override
    public void setC_Currency_ID(int C_Currency_ID) {
        if (C_Currency_ID == 0) {
            return;
        }
        super.setC_Currency_ID(C_Currency_ID);
        this.m_precision = MCurrency.getStdPrecision(this.getCtx(), C_Currency_ID);
    }

    public int getPrecision() {
        return this.m_precision;
    }

    @Override
    public void setCurrencyRate(BigDecimal CurrencyRate) {
        if (CurrencyRate == null) {
            this.log.warning("was NULL - set to 1");
            super.setCurrencyRate(Env.ONE);
        } else if (CurrencyRate.signum() < 0) {
            this.log.warning("negative - " + CurrencyRate + " - set to 1");
            super.setCurrencyRate(Env.ONE);
        } else {
            super.setCurrencyRate(CurrencyRate);
        }
    }

    public void setAmtAcct(BigDecimal AmtAcctDr, BigDecimal AmtAcctCr) {
        double rateDR = 0.0;
        if (AmtAcctDr != null && AmtAcctDr.signum() != 0) {
            rateDR = AmtAcctDr.doubleValue() / this.getAmtSourceDr().doubleValue();
            super.setAmtAcctDr(AmtAcctDr);
        }
        double rateCR = 0.0;
        if (AmtAcctCr != null && AmtAcctCr.signum() != 0) {
            rateCR = AmtAcctCr.doubleValue() / this.getAmtSourceCr().doubleValue();
            super.setAmtAcctCr(AmtAcctCr);
        }
        if (rateDR != 0.0 && rateCR != 0.0 && rateDR != rateCR) {
            this.log.warning("Rates Different DR=" + rateDR + "(used) <> CR=" + rateCR + "(ignored)");
            rateCR = 0.0;
        }
        if (rateDR < 0.0 || Double.isInfinite(rateDR) || Double.isNaN(rateDR)) {
            this.log.warning("DR Rate ignored - " + rateDR);
            return;
        }
        if (rateCR < 0.0 || Double.isInfinite(rateCR) || Double.isNaN(rateCR)) {
            this.log.warning("CR Rate ignored - " + rateCR);
            return;
        }
        if (rateDR != 0.0) {
            this.setCurrencyRate(new BigDecimal(rateDR));
        }
        if (rateCR != 0.0) {
            this.setCurrencyRate(new BigDecimal(rateCR));
        }
    }

    @Override
    public void setC_ValidCombination_ID(int C_ValidCombination_ID) {
        super.setC_ValidCombination_ID(C_ValidCombination_ID);
        this.m_account = null;
        this.m_accountElement = null;
    }

    public void setC_ValidCombination_ID(MAccount acct) {
        if (acct == null) {
            throw new IllegalArgumentException("Account is null");
        }
        super.setC_ValidCombination_ID(acct.getC_ValidCombination_ID());
        this.m_account = acct;
        this.m_accountElement = null;
    }

    public MAccount getAccount_Combi() {
        if (this.m_account == null && this.getC_ValidCombination_ID() != 0) {
            this.m_account = new MAccount(this.getCtx(), this.getC_ValidCombination_ID(), this.get_TrxName());
        }
        return this.m_account;
    }

    public MElementValue getAccountElementValue() {
        MAccount vc;
        if (this.m_accountElement == null && (vc = this.getAccount_Combi()) != null && vc.getAccount_ID() != 0) {
            this.m_accountElement = new MElementValue(this.getCtx(), vc.getAccount_ID(), this.get_TrxName());
        }
        return this.m_accountElement;
    }

    public boolean isDocControlled() {
        MElementValue acct = this.getAccountElementValue();
        if (acct == null) {
            this.log.warning("Account not found for C_ValidCombination_ID=" + this.getC_ValidCombination_ID());
            return false;
        }
        return acct.isDocControlled();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "GL_JournalLine"));
            return false;
        }
        if (this.getC_ValidCombination_ID() <= 0) {
            this.log.saveError("SaveError", Msg.parseTranslation(this.getCtx(), "@FillMandatory@@C_ValidCombination_ID@"));
            return false;
        }
        BigDecimal rate = this.getCurrencyRate();
        BigDecimal amt = rate.multiply(this.getAmtSourceDr());
        if (amt.scale() > this.getPrecision()) {
            amt = amt.setScale(this.getPrecision(), 4);
        }
        this.setAmtAcctDr(amt);
        amt = rate.multiply(this.getAmtSourceCr());
        if (amt.scale() > this.getPrecision()) {
            amt = amt.setScale(this.getPrecision(), 4);
        }
        this.setAmtAcctCr(amt);
        if (this.getAD_Org_ID() <= 0) {
            this.setAD_Org_ID(this.getParent().getAD_Org_ID());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateJournalTotal();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateJournalTotal();
    }

    private boolean updateJournalTotal() {
        String sql = "UPDATE GL_Journal j SET (TotalDr, TotalCr) = (SELECT COALESCE(SUM(AmtAcctDr),0), COALESCE(SUM(AmtAcctCr),0) FROM GL_JournalLine jl WHERE jl.IsActive='Y' AND j.GL_Journal_ID=jl.GL_Journal_ID) WHERE GL_Journal_ID=" + this.getGL_Journal_ID();
        int no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 1) {
            this.log.warning("afterSave - Update Journal #" + no);
        }
        return no == 1;
    }

    private boolean getOrCreateCombination() {
        if (this.getC_ValidCombination_ID() == 0 || !this.is_new() && (this.is_ValueChanged("Account_ID") || this.is_ValueChanged("C_SubAcct_ID") || this.is_ValueChanged("M_Product_ID") || this.is_ValueChanged("C_BPartner_ID") || this.is_ValueChanged("AD_OrgTrx_ID") || this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("C_LocFrom_ID") || this.is_ValueChanged("C_LocTo_ID") || this.is_ValueChanged("C_SalesRegion_ID") || this.is_ValueChanged("C_Project_ID") || this.is_ValueChanged("C_Campaign_ID") || this.is_ValueChanged("C_Activity_ID") || this.is_ValueChanged("User1_ID") || this.is_ValueChanged("User2_ID"))) {
            MJournal gl = new MJournal(this.getCtx(), this.getGL_Journal_ID(), this.get_TrxName());
            MAcctSchema as = (MAcctSchema)this.getParent().getC_AcctSchema();
            String errorFields = "";
            MAcctSchemaElement[] mAcctSchemaElementArray = MAcctSchemaElement.getAcctSchemaElements(as);
            int n = mAcctSchemaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                MAcctSchemaElement elem = mAcctSchemaElementArray[n2];
                if (elem.isMandatory()) {
                    String et = elem.getElementType();
                    if ("AC".equals(et) && this.get_ValueAsInt("Account_ID") == 0) {
                        errorFields = String.valueOf(errorFields) + "@Account_ID@, ";
                    }
                    if ("AY".equals(et) && this.get_ValueAsInt("C_Activity_ID") == 0) {
                        errorFields = String.valueOf(errorFields) + "@C_Account_ID@, ";
                    }
                    if ("BP".equals(et) && this.get_ValueAsInt("C_BPartner_ID") == 0) {
                        errorFields = String.valueOf(errorFields) + "@C_BPartner_ID@, ";
                    }
                    if ("MC".equals(et) && this.get_ValueAsInt("C_Campaign_ID") == 0) {
                        errorFields = String.valueOf(errorFields) + "@C_Campaign_ID@, ";
                    }
                    if ("OO".equals(et) && this.getAD_Org_ID() == 0) {
                        errorFields = String.valueOf(errorFields) + "@AD_Org_ID@, ";
                    }
                    if ("OT".equals(et) && this.get_ValueAsInt("AD_OrgTrx_ID") == 0) {
                        errorFields = String.valueOf(errorFields) + "@AD_OrgTrx_ID@, ";
                    }
                    if ("PR".equals(et) && this.get_ValueAsInt("M_Product_ID") == 0) {
                        errorFields = String.valueOf(errorFields) + "@M_Product_ID@, ";
                    }
                    if ("PJ".equals(et) && this.get_ValueAsInt("C_Project_ID") == 0) {
                        errorFields = String.valueOf(errorFields) + "@C_Project_ID@, ";
                    }
                    if ("SR".equals(et) && this.get_ValueAsInt("C_SalesRegion_ID") == 0) {
                        errorFields = String.valueOf(errorFields) + "@C_SalesRegion_ID@, ";
                    }
                    if ("U1".equals(et) && this.get_ValueAsInt("User1_ID") == 0) {
                        errorFields = String.valueOf(errorFields) + "@User1_ID@, ";
                    }
                    if ("U2".equals(et) && this.get_ValueAsInt("User2_ID") == 0) {
                        errorFields = String.valueOf(errorFields) + "@User2_ID@, ";
                    }
                }
                ++n2;
            }
            if (errorFields.length() > 0) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@IsMandatory@: " + errorFields.substring(0, errorFields.length() - 2)));
                return false;
            }
            MAccount acct = MAccount.get(this.getCtx(), this.getAD_Client_ID(), this.getAD_Org_ID(), gl.getC_AcctSchema_ID(), this.get_ValueAsInt("Account_ID"), this.get_ValueAsInt("C_SubAcct_ID"), this.get_ValueAsInt("M_Product_ID"), this.get_ValueAsInt("C_BPartner_ID"), this.get_ValueAsInt("AD_OrgTrx_ID"), this.get_ValueAsInt("C_LocFrom_ID"), this.get_ValueAsInt("C_LocTo_ID"), this.get_ValueAsInt("C_SalesRegion_ID"), this.get_ValueAsInt("C_Project_ID"), this.get_ValueAsInt("C_Campaign_ID"), this.get_ValueAsInt("C_Activity_ID"), this.get_ValueAsInt("User1_ID"), this.get_ValueAsInt("User2_ID"), 0, 0);
            if (acct != null) {
                acct.saveEx(this.get_TrxName());
                this.setC_ValidCombination_ID(acct.get_ID());
                if (acct.getAlias() != null && acct.getAlias().length() > 0) {
                    this.set_Value("Alias_ValidCombination_ID", (Object)acct.get_ID());
                } else {
                    this.set_Value("Alias_ValidCombination_ID", null);
                }
            }
        }
        return true;
    }

    private void fillDimensionsFromCombination() {
        if (this.getC_ValidCombination_ID() > 0) {
            MAccount combi = new MAccount(this.getCtx(), this.getC_ValidCombination_ID(), this.get_TrxName());
            this.set_Value("Account_ID", combi.getAccount_ID() > 0 ? Integer.valueOf(combi.getAccount_ID()) : null);
            this.set_Value("C_SubAcct_ID", combi.getC_SubAcct_ID() > 0 ? Integer.valueOf(combi.getC_SubAcct_ID()) : null);
            this.set_Value("M_Product_ID", combi.getM_Product_ID() > 0 ? Integer.valueOf(combi.getM_Product_ID()) : null);
            this.set_Value("C_BPartner_ID", combi.getC_BPartner_ID() > 0 ? Integer.valueOf(combi.getC_BPartner_ID()) : null);
            this.set_Value("AD_OrgTrx_ID", combi.getAD_OrgTrx_ID() > 0 ? Integer.valueOf(combi.getAD_OrgTrx_ID()) : null);
            this.setAD_Org_ID(combi.getAD_Org_ID() > 0 ? combi.getAD_Org_ID() : 0);
            this.set_Value("C_LocFrom_ID", combi.getC_LocFrom_ID() > 0 ? Integer.valueOf(combi.getC_LocFrom_ID()) : null);
            this.set_Value("C_LocTo_ID", combi.getC_LocTo_ID() > 0 ? Integer.valueOf(combi.getC_LocTo_ID()) : null);
            this.set_Value("C_SalesRegion_ID", combi.getC_SalesRegion_ID() > 0 ? Integer.valueOf(combi.getC_SalesRegion_ID()) : null);
            this.set_Value("C_Project_ID", combi.getC_Project_ID() > 0 ? Integer.valueOf(combi.getC_Project_ID()) : null);
            this.set_Value("C_Campaign_ID", combi.getC_Campaign_ID() > 0 ? Integer.valueOf(combi.getC_Campaign_ID()) : null);
            this.set_Value("C_Activity_ID", combi.getC_Activity_ID() > 0 ? Integer.valueOf(combi.getC_Activity_ID()) : null);
            this.set_Value("User1_ID", combi.getUser1_ID() > 0 ? Integer.valueOf(combi.getUser1_ID()) : null);
            this.set_Value("User2_ID", combi.getUser2_ID() > 0 ? Integer.valueOf(combi.getUser2_ID()) : null);
        }
    }

    public MAccount getAccount() {
        if (this.m_account == null && this.getC_ValidCombination_ID() != 0) {
            this.m_account = new MAccount(this.getCtx(), this.getC_ValidCombination_ID(), this.get_TrxName());
        }
        return this.m_account;
    }
}

