/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MCostDetail;
import org.compiere.model.MDocType;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInventoryLineMA;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_AttributeSetInstance;
import org.compiere.model.X_M_Inventory;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MInventory
extends X_M_Inventory
implements DocAction {
    private static final long serialVersionUID = -7137974064086172763L;
    private static CCache<Integer, MInventory> s_cache = new CCache("M_Inventory", 5, 5);
    private MInventoryLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private boolean m_reversal = false;

    public static MInventory get(Properties ctx, int M_Inventory_ID) {
        Integer key = new Integer(M_Inventory_ID);
        MInventory retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MInventory(ctx, M_Inventory_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MInventory(Properties ctx, int M_Inventory_ID, String trxName) {
        super(ctx, M_Inventory_ID, trxName);
        if (M_Inventory_ID == 0) {
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MInventory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInventory(MWarehouse wh) {
        this(wh, wh.get_TrxName());
    }

    public MInventory(MWarehouse wh, String trxName) {
        this(wh.getCtx(), 0, trxName);
        this.setClientOrg(wh);
        this.setM_Warehouse_ID(wh.getM_Warehouse_ID());
    }

    public MInventoryLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MInventory.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        List<MInventoryLine> list = new Query(this.getCtx(), "M_InventoryLine", "M_Inventory_ID=?", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("Line").list();
        this.m_lines = list.toArray(new MInventoryLine[list.size()]);
        return this.m_lines;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInventory[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",M_Warehouse_ID=").append(this.getM_Warehouse_ID()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_DocType_ID() == 0) {
            MDocType[] types = MDocType.getOfDocBaseType(this.getCtx(), "MMI");
            if (types.length > 0) {
                this.setC_DocType_ID(types[0].getC_DocType_ID());
            } else {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@ @C_DocType_ID@"));
                return false;
            }
        }
        return true;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE M_InventoryLine SET Processed=? WHERE M_Inventory_ID=?";
        int noLine = DB.executeUpdateEx("UPDATE M_InventoryLine SET Processed=? WHERE M_Inventory_ID=?", new Object[]{processed, this.getM_Inventory_ID()}, this.get_TrxName());
        this.m_lines = null;
        this.log.fine("Processed=" + processed + " - Lines=" + noLine);
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), "MMI", this.getAD_Org_ID());
        MInventoryLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        MInventoryLine[] lines;
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        for (MInventoryLine line : lines = this.getLines(false)) {
            if (!line.isActive()) continue;
            MProduct product = line.getProduct();
            BigDecimal qtyDiff = line.getQtyInternalUse().negate();
            if (qtyDiff.signum() == 0 && (qtyDiff = line.getQtyCount().subtract(line.getQtyBook())).signum() == 0) continue;
            if (!this.isReversal()) {
                this.checkMaterialPolicy(line, qtyDiff);
            }
            if (product == null || !product.isStocked()) continue;
            this.log.fine("Material Transaction");
            MTransaction mtrx = null;
            if (line.getM_AttributeSetInstance_ID() == 0 || qtyDiff.compareTo(Env.ZERO) == 0) {
                MInventoryLineMA[] mas = MInventoryLineMA.get(this.getCtx(), line.getM_InventoryLine_ID(), this.get_TrxName());
                for (int j = 0; j < mas.length; ++j) {
                    MInventoryLineMA ma = mas[j];
                    BigDecimal QtyMA = ma.getMovementQty();
                    BigDecimal QtyNew = QtyMA.add(qtyDiff);
                    this.log.fine("Diff=" + qtyDiff + " - Instance OnHand=" + QtyMA + "->" + QtyNew);
                    if (!MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), 0, QtyMA.negate(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                        this.m_processMsg = "Cannot correct Inventory (MA)";
                        return "IN";
                    }
                    if (line.getQtyInternalUse().compareTo(Env.ZERO) == 0) {
                        MStorage storage = MStorage.get(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), this.get_TrxName());
                        storage.setDateLastInventory(this.getMovementDate());
                        if (!storage.save(this.get_TrxName())) {
                            this.m_processMsg = "Storage not updated(2)";
                            return "IN";
                        }
                    }
                    String m_MovementType = null;
                    m_MovementType = QtyMA.negate().compareTo(Env.ZERO) > 0 ? "I+" : "I-";
                    mtrx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), m_MovementType, line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA.negate(), this.getMovementDate(), this.get_TrxName());
                    mtrx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                    if (!mtrx.save()) {
                        this.m_processMsg = "Transaction not inserted(2)";
                        return "IN";
                    }
                    qtyDiff = QtyNew;
                }
            }
            if (mtrx != null) continue;
            if (!MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), 0, qtyDiff, Env.ZERO, Env.ZERO, this.get_TrxName())) {
                this.m_processMsg = "Cannot correct Inventory (MA)";
                return "IN";
            }
            if (line.getQtyInternalUse().compareTo(Env.ZERO) == 0) {
                MStorage storage = MStorage.get(this.getCtx(), line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), this.get_TrxName());
                storage.setDateLastInventory(this.getMovementDate());
                if (!storage.save(this.get_TrxName())) {
                    this.m_processMsg = "Storage not updated(2)";
                    return "IN";
                }
            }
            String m_MovementType = null;
            m_MovementType = qtyDiff.compareTo(Env.ZERO) > 0 ? "I+" : "I-";
            mtrx = new MTransaction(this.getCtx(), line.getAD_Org_ID(), m_MovementType, line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), qtyDiff, this.getMovementDate(), this.get_TrxName());
            mtrx.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
            if (mtrx.save()) continue;
            this.m_processMsg = "Transaction not inserted(2)";
            return "IN";
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    private void checkMaterialPolicy(MInventoryLine line, BigDecimal qtyDiff) {
        int no = MInventoryLineMA.deleteInventoryLineMA(line.getM_InventoryLine_ID(), this.get_TrxName());
        if (no > 0) {
            this.log.config("Delete old #" + no);
        }
        boolean needSave = false;
        if (line.getM_AttributeSetInstance_ID() == 0) {
            MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
            if (qtyDiff.signum() > 0) {
                MStorage[] storages;
                X_M_AttributeSetInstance asi = null;
                for (MStorage storage : storages = MStorage.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), 0, null, "F".equals(product.getMMPolicy()), false, line.getM_Locator_ID(), this.get_TrxName())) {
                    if (storage.getQtyOnHand().signum() >= 0) continue;
                    asi = new MAttributeSetInstance(this.getCtx(), storage.getM_AttributeSetInstance_ID(), this.get_TrxName());
                    break;
                }
                if (asi == null) {
                    asi = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
                }
                line.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
                needSave = true;
            } else {
                String MMPolicy = product.getMMPolicy();
                MStorage[] storages = MStorage.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), 0, null, "F".equals(MMPolicy), true, line.getM_Locator_ID(), this.get_TrxName());
                BigDecimal qtyToDeliver = qtyDiff.negate();
                for (MStorage storage : storages) {
                    MInventoryLineMA ma;
                    if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                        ma = new MInventoryLineMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver);
                        ma.saveEx();
                        qtyToDeliver = Env.ZERO;
                        this.log.fine(ma + ", QtyToDeliver=" + qtyToDeliver);
                    } else {
                        ma = new MInventoryLineMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
                        ma.saveEx();
                        qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                        this.log.fine(ma + ", QtyToDeliver=" + qtyToDeliver);
                    }
                    if (qtyToDeliver.signum() == 0) break;
                }
                if (qtyToDeliver.signum() != 0) {
                    MAttributeSetInstance asi = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
                    int M_AttributeSetInstance_ID = asi.getM_AttributeSetInstance_ID();
                    MInventoryLineMA ma = new MInventoryLineMA(line, M_AttributeSetInstance_ID, qtyToDeliver);
                    ma.saveEx();
                    this.log.fine("##: " + ma);
                }
            }
            if (needSave) {
                line.saveEx();
            }
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            MInventoryLine[] lines = this.getLines(false);
            for (int i2 = 0; i2 < lines.length; ++i2) {
                MInventoryLine line = lines[i2];
                BigDecimal oldCount = line.getQtyCount();
                BigDecimal oldInternal = line.getQtyInternalUse();
                if (oldCount.compareTo(line.getQtyBook()) == 0 && oldInternal.signum() == 0) continue;
                line.setQtyInternalUse(Env.ZERO);
                line.setQtyCount(line.getQtyBook());
                line.addDescription("Void (" + oldCount + "/" + oldInternal + ")");
                line.save(this.get_TrxName());
            }
        } else {
            return this.reverseCorrectIt();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), dt.getDocBaseType(), this.getAD_Org_ID());
        MInventory reversal = new MInventory(this.getCtx(), 0, this.get_TrxName());
        MInventory.copyValues(this, reversal, this.getAD_Client_ID(), this.getAD_Org_ID());
        reversal.setDocStatus("DR");
        reversal.setDocAction("CO");
        reversal.setIsApproved(false);
        reversal.setPosted(false);
        reversal.setProcessed(false);
        reversal.addDescription("{->" + this.getDocumentNo() + ")");
        reversal.setReversal_ID(this.getM_Inventory_ID());
        reversal.saveEx();
        reversal.setReversal(true);
        MInventoryLine[] oLines = this.getLines(true);
        for (int i2 = 0; i2 < oLines.length; ++i2) {
            MInventoryLine oLine = oLines[i2];
            MInventoryLine rLine = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
            MInventory.copyValues(oLine, rLine, oLine.getAD_Client_ID(), oLine.getAD_Org_ID());
            rLine.setM_Inventory_ID(reversal.getM_Inventory_ID());
            rLine.setParent(reversal);
            rLine.setReversalLine_ID(oLine.getM_InventoryLine_ID());
            rLine.setQtyBook(oLine.getQtyCount());
            rLine.setQtyCount(oLine.getQtyBook());
            rLine.setQtyInternalUse(oLine.getQtyInternalUse().negate());
            rLine.saveEx();
            if (rLine.getM_AttributeSetInstance_ID() != 0) continue;
            MInventoryLineMA[] mas = MInventoryLineMA.get(this.getCtx(), oLines[i2].getM_InventoryLine_ID(), this.get_TrxName());
            for (int j = 0; j < mas.length; ++j) {
                MInventoryLineMA ma = new MInventoryLineMA(rLine, mas[j].getM_AttributeSetInstance_ID(), mas[j].getMovementQty().negate());
                ma.saveEx();
            }
        }
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return false;
        }
        reversal.closeIt();
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx();
        this.m_processMsg = reversal.getDocumentNo();
        this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setReversal_ID(reversal.getM_Inventory_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    private void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    private boolean isReversal() {
        return this.m_reversal;
    }

    private void createCostDetail(MTransaction trx, int reversalLine_ID) {
        String whereClause = "M_InventoryLine_ID=? AND M_AttributeSetInstance_ID=?";
        List list = new Query(trx.getCtx(), "M_CostDetail", whereClause, trx.get_TrxName()).setParameters(reversalLine_ID, trx.getM_AttributeSetInstance_ID()).list();
        MCostDetail cdnew = null;
        for (MCostDetail cd : list) {
            cdnew = new MCostDetail(trx.getCtx(), 0, trx.get_TrxName());
            MInventory.copyValues(cd, cdnew);
            cdnew.setProcessed(false);
            cdnew.setM_AttributeSetInstance_ID(cd.getM_AttributeSetInstance_ID());
            cdnew.setM_InventoryLine_ID(trx.getM_InventoryLine_ID());
            cdnew.setM_Product_ID(cd.getM_Product_ID());
            cdnew.setAmt(cd.getAmt().negate());
            cdnew.setQty(cd.getQty().negate());
            cdnew.saveEx();
            cdnew.process();
        }
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

