/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_Order;
import org.compiere.model.I_M_InOutLine;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MInOutConfirm;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MRefList;
import org.compiere.model.MStorage;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTransaction;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_C_OrderLine;
import org.compiere.model.X_M_AttributeSetInstance;
import org.compiere.model.X_M_InOut;
import org.compiere.model.X_M_RMA;
import org.compiere.model.X_M_RMALine;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.ofb.model.OFBForward;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MInOut
extends X_M_InOut
implements DocAction {
    private static final long serialVersionUID = -239302197968535277L;
    private MInOutLine[] m_lines = null;
    private MInOutConfirm[] m_confirms = null;
    private MBPartner m_partner = null;
    private boolean m_reversal = false;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    ArrayList<PO> docsPostProcess = new ArrayList();

    public static MInOut createFrom(MOrder order, Timestamp movementDate, boolean forceDelivery, boolean allAttributeInstances, Timestamp minGuaranteeDate, boolean complete, String trxName) {
        if (order == null) {
            throw new IllegalArgumentException("No Order");
        }
        if (!forceDelivery && "L".equals(order.getDeliveryRule())) {
            return null;
        }
        MInOut retValue = new MInOut(order, 0, movementDate);
        retValue.setDocAction(complete ? "CO" : "PR");
        MOrderLine[] oLines = order.getLines(true, "M_Product_ID");
        int i = 0;
        while (i < oLines.length) {
            block14: {
                MStorage[] storages;
                BigDecimal qty;
                block15: {
                    BigDecimal maxQty;
                    block16: {
                        qty = oLines[i].getQtyOrdered().subtract(oLines[i].getQtyDelivered());
                        if (qty.signum() == 0) break block14;
                        storages = null;
                        MProduct product = oLines[i].getProduct();
                        if (product == null || product.get_ID() == 0 || !product.isStocked()) break block14;
                        String MMPolicy = product.getMMPolicy();
                        storages = MStorage.getWarehouse(order.getCtx(), order.getM_Warehouse_ID(), oLines[i].getM_Product_ID(), oLines[i].getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy), true, 0, trxName);
                        if (forceDelivery) break block15;
                        maxQty = Env.ZERO;
                        int ll = 0;
                        while (ll < storages.length) {
                            maxQty = maxQty.add(storages[ll].getQtyOnHand());
                            ++ll;
                        }
                        if (!"A".equals(order.getDeliveryRule())) break block16;
                        if (maxQty.compareTo(qty) < 0) {
                            qty = maxQty;
                        }
                        break block15;
                    }
                    if ("L".equals(order.getDeliveryRule()) && maxQty.compareTo(qty) < 0) break block14;
                }
                if (retValue.get_ID() == 0) {
                    retValue.save(trxName);
                }
                int ll = 0;
                while (ll < storages.length) {
                    BigDecimal lineQty = storages[ll].getQtyOnHand();
                    if (lineQty.compareTo(qty) > 0) {
                        lineQty = qty;
                    }
                    MInOutLine line = new MInOutLine(retValue);
                    line.setOrderLine(oLines[i], storages[ll].getM_Locator_ID(), order.isSOTrx() ? lineQty : Env.ZERO);
                    line.setQty(lineQty);
                    if (oLines[i].getQtyEntered().compareTo(oLines[i].getQtyOrdered()) != 0) {
                        line.setQtyEntered(lineQty.multiply(oLines[i].getQtyEntered()).divide(oLines[i].getQtyOrdered(), 12, 4));
                    }
                    line.setC_Project_ID(oLines[i].getC_Project_ID());
                    line.save(trxName);
                    qty = qty.subtract(lineQty);
                    if (qty.signum() == 0) break;
                    ++ll;
                }
            }
            ++i;
        }
        if (retValue.get_ID() == 0) {
            return null;
        }
        return retValue;
    }

    public static MInOut copyFrom(MInOut from, Timestamp dateDoc, Timestamp dateAcct, int C_DocType_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder) {
        MInOut to = new MInOut(from.getCtx(), 0, null);
        to.set_TrxName(trxName);
        MInOut.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("M_InOut_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(C_DocType_ID);
        to.setIsSOTrx(isSOTrx);
        if (counter) {
            MDocType docType = MDocType.get(from.getCtx(), C_DocType_ID);
            if ("MMS".equals(docType.getDocBaseType())) {
                to.setMovementType(isSOTrx ? "C-" : "V-");
            } else if ("MMR".equals(docType.getDocBaseType())) {
                to.setMovementType(isSOTrx ? "C+" : "V+");
            }
        }
        to.setDateOrdered(dateDoc);
        to.setDateAcct(dateAcct);
        to.setMovementDate(dateDoc);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setDateReceived(null);
        to.setNoPackages(0);
        to.setShipDate(null);
        to.setPickDate(null);
        to.setIsInTransit(false);
        to.setIsApproved(false);
        to.setC_Invoice_ID(0);
        to.setTrackingNo(null);
        to.setIsInDispute(false);
        to.setPosted(false);
        to.setProcessed(false);
        to.setProcessing(false);
        to.setC_Order_ID(0);
        to.setM_RMA_ID(0);
        if (counter) {
            PO peer;
            to.setC_Order_ID(0);
            to.setRef_InOut_ID(from.getM_InOut_ID());
            if (from.getC_Order_ID() != 0 && ((X_C_Order)(peer = new MOrder(from.getCtx(), from.getC_Order_ID(), from.get_TrxName()))).getRef_Order_ID() != 0) {
                to.setC_Order_ID(((X_C_Order)peer).getRef_Order_ID());
            }
            if (from.getC_Invoice_ID() != 0 && ((X_C_Invoice)(peer = new MInvoice(from.getCtx(), from.getC_Invoice_ID(), from.get_TrxName()))).getRef_Invoice_ID() != 0) {
                to.setC_Invoice_ID(((X_C_Invoice)peer).getRef_Invoice_ID());
            }
            if (from.getM_RMA_ID() != 0 && ((X_M_RMA)(peer = new MRMA(from.getCtx(), from.getM_RMA_ID(), from.get_TrxName()))).getRef_RMA_ID() > 0) {
                to.setM_RMA_ID(((X_M_RMA)peer).getRef_RMA_ID());
            }
        } else {
            to.setRef_InOut_ID(0);
            if (setOrder) {
                to.setC_Order_ID(from.getC_Order_ID());
                to.setM_RMA_ID(from.getM_RMA_ID());
            }
        }
        if (!to.save(trxName)) {
            throw new IllegalStateException("Could not create Shipment");
        }
        if (counter) {
            from.setRef_InOut_ID(to.getM_InOut_ID());
        }
        if (to.copyLinesFrom(from, counter, setOrder) <= 0) {
            throw new IllegalStateException("Could not create Shipment Lines");
        }
        return to;
    }

    public static MInOut copyFrom(MInOut from, Timestamp dateDoc, int C_DocType_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder) {
        MInOut to = MInOut.copyFrom(from, dateDoc, dateDoc, C_DocType_ID, isSOTrx, counter, trxName, setOrder);
        return to;
    }

    public MInOut(Properties ctx, int M_InOut_ID, String trxName) {
        super(ctx, M_InOut_ID, trxName);
        if (M_InOut_ID == 0) {
            this.setIsSOTrx(false);
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(this.getMovementDate());
            this.setDeliveryRule("A");
            this.setDeliveryViaRule("P");
            this.setFreightCostRule("I");
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setPriorityRule("5");
            this.setNoPackages(0);
            this.setIsInTransit(false);
            this.setIsPrinted(false);
            this.setSendEMail(false);
            this.setIsInDispute(false);
            this.setIsApproved(false);
            super.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
        }
    }

    public MInOut(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOut(MOrder order, int C_DocTypeShipment_ID, Timestamp movementDate) {
        this(order.getCtx(), 0, order.get_TrxName());
        this.setClientOrg(order);
        this.setC_BPartner_ID(order.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
        this.setAD_User_ID(order.getAD_User_ID());
        this.setM_Warehouse_ID(order.getM_Warehouse_ID());
        this.setIsSOTrx(order.isSOTrx());
        if (C_DocTypeShipment_ID == 0) {
            C_DocTypeShipment_ID = DB.getSQLValue(null, "SELECT C_DocTypeShipment_ID FROM C_DocType WHERE C_DocType_ID=?", order.getC_DocType_ID());
        }
        this.setC_DocType_ID(C_DocTypeShipment_ID);
        String movementTypeShipment = null;
        MDocType dtShipment = new MDocType(order.getCtx(), C_DocTypeShipment_ID, order.get_TrxName());
        if (dtShipment.getDocBaseType().equals("MMS")) {
            movementTypeShipment = dtShipment.isSOTrx() ? "C-" : "V-";
        } else if (dtShipment.getDocBaseType().equals("MMR")) {
            movementTypeShipment = dtShipment.isSOTrx() ? "C+" : "V+";
        }
        this.setMovementType(movementTypeShipment);
        if (movementDate != null) {
            this.setMovementDate(movementDate);
        }
        this.setDateAcct(this.getMovementDate());
        this.setC_Order_ID(order.getC_Order_ID());
        this.setDeliveryRule(order.getDeliveryRule());
        this.setDeliveryViaRule(order.getDeliveryViaRule());
        this.setM_Shipper_ID(order.getM_Shipper_ID());
        this.setFreightCostRule(order.getFreightCostRule());
        this.setFreightAmt(order.getFreightAmt());
        this.setSalesRep_ID(order.getSalesRep_ID());
        this.setC_Activity_ID(order.getC_Activity_ID());
        this.setC_Campaign_ID(order.getC_Campaign_ID());
        this.setC_Charge_ID(order.getC_Charge_ID());
        this.setChargeAmt(order.getChargeAmt());
        this.setC_Project_ID(order.getC_Project_ID());
        this.setDateOrdered(order.getDateOrdered());
        this.setDescription(order.getDescription());
        this.setPOReference(order.getPOReference());
        this.setSalesRep_ID(order.getSalesRep_ID());
        this.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        this.setUser1_ID(order.getUser1_ID());
        this.setUser2_ID(order.getUser2_ID());
        this.setPriorityRule(order.getPriorityRule());
        this.setIsDropShip(order.isDropShip());
        this.setDropShip_BPartner_ID(order.getDropShip_BPartner_ID());
        this.setDropShip_Location_ID(order.getDropShip_Location_ID());
        this.setDropShip_User_ID(order.getDropShip_User_ID());
    }

    public MInOut(MInvoice invoice, int C_DocTypeShipment_ID, Timestamp movementDate, int M_Warehouse_ID) {
        this(invoice.getCtx(), 0, invoice.get_TrxName());
        this.setClientOrg(invoice);
        this.setC_BPartner_ID(invoice.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(invoice.getC_BPartner_Location_ID());
        this.setAD_User_ID(invoice.getAD_User_ID());
        this.setM_Warehouse_ID(M_Warehouse_ID);
        this.setIsSOTrx(invoice.isSOTrx());
        this.setMovementType(invoice.isSOTrx() ? "C-" : "V+");
        X_C_Order order = null;
        if (invoice.getC_Order_ID() != 0) {
            order = new MOrder(invoice.getCtx(), invoice.getC_Order_ID(), invoice.get_TrxName());
        }
        if (C_DocTypeShipment_ID == 0 && order != null) {
            C_DocTypeShipment_ID = DB.getSQLValue(null, "SELECT C_DocTypeShipment_ID FROM C_DocType WHERE C_DocType_ID=?", order.getC_DocType_ID());
        }
        if (C_DocTypeShipment_ID != 0) {
            this.setC_DocType_ID(C_DocTypeShipment_ID);
        } else {
            this.setC_DocType_ID();
        }
        if (movementDate != null) {
            this.setMovementDate(movementDate);
        }
        this.setDateAcct(this.getMovementDate());
        this.setC_Order_ID(invoice.getC_Order_ID());
        this.setSalesRep_ID(invoice.getSalesRep_ID());
        this.setC_Activity_ID(invoice.getC_Activity_ID());
        this.setC_Campaign_ID(invoice.getC_Campaign_ID());
        this.setC_Charge_ID(invoice.getC_Charge_ID());
        this.setChargeAmt(invoice.getChargeAmt());
        this.setC_Project_ID(invoice.getC_Project_ID());
        this.setDateOrdered(invoice.getDateOrdered());
        this.setDescription(invoice.getDescription());
        this.setPOReference(invoice.getPOReference());
        this.setAD_OrgTrx_ID(invoice.getAD_OrgTrx_ID());
        this.setUser1_ID(invoice.getUser1_ID());
        this.setUser2_ID(invoice.getUser2_ID());
        if (order != null) {
            this.setDeliveryRule(order.getDeliveryRule());
            this.setDeliveryViaRule(order.getDeliveryViaRule());
            this.setM_Shipper_ID(order.getM_Shipper_ID());
            this.setFreightCostRule(order.getFreightCostRule());
            this.setFreightAmt(order.getFreightAmt());
            this.setIsDropShip(order.isDropShip());
            this.setDropShip_BPartner_ID(order.getDropShip_BPartner_ID());
            this.setDropShip_Location_ID(order.getDropShip_Location_ID());
            this.setDropShip_User_ID(order.getDropShip_User_ID());
        }
    }

    public MInOut(MInOut original, int C_DocTypeShipment_ID, Timestamp movementDate) {
        this(original.getCtx(), 0, original.get_TrxName());
        this.setClientOrg(original);
        this.setC_BPartner_ID(original.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(original.getC_BPartner_Location_ID());
        this.setAD_User_ID(original.getAD_User_ID());
        this.setM_Warehouse_ID(original.getM_Warehouse_ID());
        this.setIsSOTrx(original.isSOTrx());
        this.setMovementType(original.getMovementType());
        if (C_DocTypeShipment_ID == 0) {
            this.setC_DocType_ID(original.getC_DocType_ID());
        } else {
            this.setC_DocType_ID(C_DocTypeShipment_ID);
        }
        if (movementDate != null) {
            this.setMovementDate(movementDate);
        }
        this.setDateAcct(this.getMovementDate());
        this.setC_Order_ID(original.getC_Order_ID());
        this.setDeliveryRule(original.getDeliveryRule());
        this.setDeliveryViaRule(original.getDeliveryViaRule());
        this.setM_Shipper_ID(original.getM_Shipper_ID());
        this.setFreightCostRule(original.getFreightCostRule());
        this.setFreightAmt(original.getFreightAmt());
        this.setSalesRep_ID(original.getSalesRep_ID());
        this.setC_Activity_ID(original.getC_Activity_ID());
        this.setC_Campaign_ID(original.getC_Campaign_ID());
        this.setC_Charge_ID(original.getC_Charge_ID());
        this.setChargeAmt(original.getChargeAmt());
        this.setC_Project_ID(original.getC_Project_ID());
        this.setDateOrdered(original.getDateOrdered());
        this.setDescription(original.getDescription());
        this.setPOReference(original.getPOReference());
        this.setSalesRep_ID(original.getSalesRep_ID());
        this.setAD_OrgTrx_ID(original.getAD_OrgTrx_ID());
        this.setUser1_ID(original.getUser1_ID());
        this.setUser2_ID(original.getUser2_ID());
        this.setIsDropShip(original.isDropShip());
        this.setDropShip_BPartner_ID(original.getDropShip_BPartner_ID());
        this.setDropShip_Location_ID(original.getDropShip_Location_ID());
        this.setDropShip_User_ID(original.getDropShip_User_ID());
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInOut[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",DocStatus=").append(this.getDocStatus()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return String.valueOf(dt.getName()) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get(this.getCtx(), 1, this.getM_InOut_ID(), this.get_TrxName());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public MInOutLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MInOut.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        List<MInOutLine> list = new Query(this.getCtx(), "M_InOutLine", "M_InOut_ID=?", this.get_TrxName()).setParameters(this.getM_InOut_ID()).setOrderBy("Line").list();
        this.m_lines = new MInOutLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public MInOutLine[] getLines() {
        return this.getLines(false);
    }

    public MInOutConfirm[] getConfirmations(boolean requery) {
        if (this.m_confirms != null && !requery) {
            MInOut.set_TrxName(this.m_confirms, this.get_TrxName());
            return this.m_confirms;
        }
        List<MInOutConfirm> list = new Query(this.getCtx(), "M_InOutConfirm", "M_InOut_ID=?", this.get_TrxName()).setParameters(this.getM_InOut_ID()).list();
        this.m_confirms = new MInOutConfirm[list.size()];
        list.toArray(this.m_confirms);
        return this.m_confirms;
    }

    public int copyLinesFrom(MInOut otherShipment, boolean counter, boolean setOrder) {
        if (this.isProcessed() || this.isPosted() || otherShipment == null) {
            return 0;
        }
        MInOutLine[] fromLines = otherShipment.getLines(true);
        int count = 0;
        int i = 0;
        while (i < fromLines.length) {
            MInOutLine line = new MInOutLine(this);
            MInOutLine fromLine = fromLines[i];
            line.set_TrxName(this.get_TrxName());
            if (counter) {
                PO.copyValues(fromLine, line, this.getAD_Client_ID(), this.getAD_Org_ID());
            } else {
                PO.copyValues(fromLine, line, fromLine.getAD_Client_ID(), fromLine.getAD_Org_ID());
            }
            line.setM_InOut_ID(this.getM_InOut_ID());
            line.set_ValueNoCheck("M_InOutLine_ID", I_ZERO);
            if (!setOrder) {
                line.setC_OrderLine_ID(0);
                line.setM_RMALine_ID(0);
            }
            line.setM_AttributeSetInstance_ID(fromLine.getM_AttributeSetInstance_ID());
            line.setRef_InOutLine_ID(0);
            line.setIsInvoiced(false);
            line.setConfirmedQty(Env.ZERO);
            line.setPickedQty(Env.ZERO);
            line.setScrappedQty(Env.ZERO);
            line.setTargetQty(Env.ZERO);
            if (this.getM_Warehouse_ID() != otherShipment.getM_Warehouse_ID()) {
                line.setM_Locator_ID(0);
                line.setM_Locator_ID(Env.ZERO);
            }
            if (counter) {
                PO peer;
                line.setRef_InOutLine_ID(fromLine.getM_InOutLine_ID());
                if (fromLine.getC_OrderLine_ID() != 0 && ((X_C_OrderLine)(peer = new MOrderLine(this.getCtx(), fromLine.getC_OrderLine_ID(), this.get_TrxName()))).getRef_OrderLine_ID() != 0) {
                    line.setC_OrderLine_ID(((X_C_OrderLine)peer).getRef_OrderLine_ID());
                }
                if (fromLine.getM_RMALine_ID() != 0 && ((X_M_RMALine)(peer = new MRMALine(this.getCtx(), fromLine.getM_RMALine_ID(), this.get_TrxName()))).getRef_RMALine_ID() > 0) {
                    line.setM_RMALine_ID(((X_M_RMALine)peer).getRef_RMALine_ID());
                }
            }
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            if (counter) {
                fromLine.setRef_InOutLine_ID(line.getM_InOutLine_ID());
                fromLine.save(this.get_TrxName());
            }
            ++i;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
            this.log.info("Line difference - From=" + fromLines.length + " <> Saved=" + count);
            count = -1;
        }
        return count;
    }

    private void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    public boolean isReversal() {
        return this.m_reversal;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE M_InOutLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE M_InOut_ID=" + this.getM_InOut_ID();
        int noLine = DB.executeUpdate(sql, this.get_TrxName());
        this.m_lines = null;
        this.log.fine(String.valueOf(processed) + " - Lines=" + noLine);
    }

    public MBPartner getBPartner() {
        if (this.m_partner == null) {
            this.m_partner = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        }
        return this.m_partner;
    }

    public void setC_DocType_ID(String DocBaseType) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND DocBaseType=? AND IsActive='Y' AND IsSOTrx='" + (this.isSOTrx() ? "Y" : "N") + "' " + "ORDER BY IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, sql, this.getAD_Client_ID(), DocBaseType);
        if (C_DocType_ID <= 0) {
            this.log.log(Level.SEVERE, "Not found for AC_Client_ID=" + this.getAD_Client_ID() + " - " + DocBaseType);
        } else {
            this.log.fine("DocBaseType=" + DocBaseType + " - C_DocType_ID=" + C_DocType_ID);
            this.setC_DocType_ID(C_DocType_ID);
            boolean isSOTrx = "MMS".equals(DocBaseType);
            this.setIsSOTrx(isSOTrx);
        }
    }

    public void setC_DocType_ID() {
        if (this.isSOTrx()) {
            this.setC_DocType_ID("MMS");
        } else {
            this.setC_DocType_ID("MMR");
        }
    }

    public void setBPartner(MBPartner bp) {
        MUser[] contacts;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        MBPartnerLocation[] locs = bp.getLocations(false);
        if (locs != null) {
            int i = 0;
            while (i < locs.length) {
                if (locs[i].isShipTo()) {
                    this.setC_BPartner_Location_ID(locs[i].getC_BPartner_Location_ID());
                }
                ++i;
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                this.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, "Has no To Address: " + bp);
        }
        if ((contacts = bp.getContacts(false)) != null && contacts.length > 0) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public void createConfirmation() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        boolean pick = dt.isPickQAConfirm();
        boolean ship = dt.isShipConfirm();
        if (!pick && !ship) {
            this.log.fine("No need");
            return;
        }
        if (pick && ship) {
            boolean havePick = false;
            boolean haveShip = false;
            MInOutConfirm[] confirmations = this.getConfirmations(false);
            int i = 0;
            while (i < confirmations.length) {
                MInOutConfirm confirm = confirmations[i];
                if ("PC".equals(confirm.getConfirmType())) {
                    if (!confirm.isProcessed()) {
                        this.log.fine("Unprocessed: " + confirm);
                        return;
                    }
                    havePick = true;
                } else if ("SC".equals(confirm.getConfirmType())) {
                    haveShip = true;
                }
                ++i;
            }
            if (!havePick) {
                MInOutConfirm.create(this, "PC", false);
                return;
            }
            if (!haveShip) {
                MInOutConfirm.create(this, "SC", false);
                return;
            }
            return;
        }
        if (pick) {
            MInOutConfirm.create(this, "PC", true);
        } else if (ship) {
            MInOutConfirm.create(this, "SC", true);
        }
    }

    private void voidConfirmations() {
        MInOutConfirm[] mInOutConfirmArray = this.getConfirmations(true);
        int n = mInOutConfirmArray.length;
        int n2 = 0;
        while (n2 < n) {
            MInOutConfirm confirm = mInOutConfirmArray[n2];
            if (!confirm.isProcessed()) {
                if (!confirm.processIt("VO")) {
                    throw new AdempiereException(confirm.getProcessMsg());
                }
                confirm.saveEx();
            }
            ++n2;
        }
    }

    @Override
    public void setM_Warehouse_ID(int M_Warehouse_ID) {
        if (M_Warehouse_ID == 0) {
            this.log.severe("Ignored - Cannot set AD_Warehouse_ID to 0");
            return;
        }
        super.setM_Warehouse_ID(M_Warehouse_ID);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_Order_ID() != 0 && this.getM_RMA_ID() != 0) {
            this.log.saveError("OrderOrRMA", "");
            return false;
        }
        if (!OFBForward.NoValidateOrderShipment() && !this.getMovementType().contentEquals("C+") && this.isSOTrx() && this.getC_Order_ID() == 0 && this.getM_RMA_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.translate(this.getCtx(), "C_Order_ID"));
            return false;
        }
        if (this.isSOTrx() && this.getM_RMA_ID() != 0) {
            MRMA rma = new MRMA(this.getCtx(), this.getM_RMA_ID(), this.get_TrxName());
            MDocType docType = MDocType.get(this.getCtx(), rma.getC_DocType_ID());
            this.setC_DocType_ID(docType.getC_DocTypeShipment_ID());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("AD_Org_ID")) {
            String sql = "UPDATE M_InOutLine ol SET AD_Org_ID =(SELECT AD_Org_ID FROM M_InOut o WHERE ol.M_InOut_ID=o.M_InOut_ID) WHERE M_InOut_ID=" + this.getC_Order_ID();
            int no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.fine("Lines -> #" + no);
        }
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        MInOutLine line;
        MInOutLine[] lines;
        I_C_Order order;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (this.getC_Order_ID() != 0 && this.getM_RMA_ID() != 0) {
            this.m_processMsg = "@OrderOrRMA@";
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (this.isSOTrx() && !this.isReversal() && ((order = this.getC_Order()) == null || !"PR".equals(order.getC_DocType().getDocSubTypeSO()) || MSysConfig.getBooleanValue("CHECK_CREDIT_ON_PREPAY_ORDER", true, this.getAD_Client_ID(), this.getAD_Org_ID()))) {
            MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
            if ("S".equals(bp.getSOCreditStatus())) {
                this.m_processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
            if ("H".equals(bp.getSOCreditStatus())) {
                this.m_processMsg = "@BPartnerCreditHold@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
            BigDecimal notInvoicedAmt = MBPartner.getNotInvoicedAmt(this.getC_BPartner_ID());
            if ("H".equals(bp.getSOCreditStatus(notInvoicedAmt))) {
                this.m_processMsg = "@BPartnerOverSCreditHold@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @NotInvoicedAmt@=" + notInvoicedAmt + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
        }
        if ((lines = this.getLines(true)) == null || lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal Volume = Env.ZERO;
        BigDecimal Weight = Env.ZERO;
        int i = 0;
        while (i < lines.length) {
            line = lines[i];
            MProduct product = line.getProduct();
            if (product != null) {
                Volume = Volume.add(product.getVolume().multiply(line.getMovementQty()));
                Weight = Weight.add(product.getWeight().multiply(line.getMovementQty()));
            }
            if (line.getM_AttributeSetInstance_ID() == 0 && product != null && product.isASIMandatory(this.isSOTrx(), line.getAD_Org_ID())) {
                this.m_processMsg = "@M_AttributeSet_ID@ @IsMandatory@ (@Line@ #" + lines[i].getLine() + ", @M_Product_ID@=" + product.getValue() + ")";
                return "IN";
            }
            ++i;
        }
        if (OFBForward.UseValidationStockLote()) {
            if (!this.getDocStatus().equals("IP")) {
                i = 0;
                while (i < lines.length) {
                    line = lines[i];
                    if (line.getM_Product() != null && line.getM_Product().isStocked() && !this.isReversal()) {
                        this.checkMaterialPolicy(line);
                    }
                    ++i;
                }
            }
            this.m_processMsg = this.checkStock();
            if (this.m_processMsg != null) {
                return "IN";
            }
        }
        this.setVolume(Volume);
        this.setWeight(Weight);
        if (!this.isReversal()) {
            this.createConfirmation();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String valid;
        MInOut dropShipment;
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MInOutConfirm[] confirmations = this.getConfirmations(true);
        int i = 0;
        while (i < confirmations.length) {
            MInOutConfirm confirm = confirmations[i];
            if (!confirm.isProcessed() && !"XC".equals(confirm.getConfirmType())) {
                this.m_processMsg = "Open @M_InOutConfirm_ID@: " + confirm.getConfirmTypeName() + " - " + confirm.getDocumentNo();
                return "IP";
            }
            ++i;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        StringBuffer info = new StringBuffer();
        TreeSet<Integer> inOutOrders = new TreeSet<Integer>();
        MInOutLine[] lines = this.getLines(true);
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            I_M_InOutLine ioLine;
            MInOutLine sLine = lines[lineIndex];
            MProduct product = sLine.getProduct();
            String MovementType = this.getMovementType();
            BigDecimal Qty = sLine.getMovementQty();
            if (MovementType.charAt(1) == '-') {
                Qty = Qty.negate();
            }
            BigDecimal QtySO = Env.ZERO;
            BigDecimal QtyPO = Env.ZERO;
            MRMALine rmaLine = null;
            if (sLine.getM_RMALine_ID() > 0 && (rmaLine = new MRMALine(this.getCtx(), sLine.getM_RMALine_ID(), this.get_TrxName())).getM_InOutLine_ID() > 0 && (ioLine = rmaLine.getM_InOutLine()).getC_OrderLine_ID() > 0) {
                sLine.setC_OrderLine_ID(ioLine.getC_OrderLine_ID());
                sLine.saveEx();
            }
            MOrderLine oLine = null;
            if (sLine.getC_OrderLine_ID() != 0) {
                oLine = new MOrderLine(this.getCtx(), sLine.getC_OrderLine_ID(), this.get_TrxName());
                inOutOrders.add(oLine.getC_Order_ID());
                this.log.fine("OrderLine - Reserved=" + oLine.getQtyReserved() + ", Delivered=" + oLine.getQtyDelivered());
                if (this.isSOTrx() && "C-".equals(MovementType) && sLine.getMovementQty().signum() > 0 || this.isSOTrx() && "C+".equals(MovementType) && sLine.getMovementQty().signum() < 0) {
                    QtySO = sLine.getMovementQty().abs().negate();
                } else if (this.isSOTrx() && "C-".equals(MovementType) && sLine.getMovementQty().signum() < 0 || this.isSOTrx() && "C+".equals(MovementType) && sLine.getMovementQty().signum() > 0) {
                    QtySO = sLine.getMovementQty().abs();
                } else if (!this.isSOTrx() && "V+".equals(MovementType) && sLine.getMovementQty().signum() > 0 || !this.isSOTrx() && "V-".equals(MovementType) && sLine.getMovementQty().signum() < 0) {
                    QtyPO = sLine.getMovementQty().abs().negate();
                } else if (!this.isSOTrx() && "V+".equals(MovementType) && sLine.getMovementQty().signum() < 0 || !this.isSOTrx() && "V-".equals(MovementType) && sLine.getMovementQty().signum() > 0) {
                    QtyPO = sLine.getMovementQty().abs();
                }
            }
            this.log.info("Line=" + sLine.getLine() + " - Qty=" + sLine.getMovementQty());
            if (product != null && product.isStocked()) {
                if (!this.isReversal()) {
                    this.checkMaterialPolicy(sLine);
                }
                this.log.fine("Material Transaction");
                MTransaction mtrx = null;
                boolean sameWarehouse = true;
                int reservationAttributeSetInstance_ID = 0;
                if (oLine != null) {
                    reservationAttributeSetInstance_ID = oLine.getM_AttributeSetInstance_ID();
                    boolean bl = sameWarehouse = oLine.getM_Warehouse_ID() == this.getM_Warehouse_ID();
                }
                if (sLine.getM_AttributeSetInstance_ID() == 0) {
                    List<MInOutLineMA> mas = MInOutLineMA.get(this.getCtx(), sLine.getM_InOutLine_ID(), this.get_TrxName());
                    for (MInOutLineMA ma : mas) {
                        BigDecimal QtyMA = ma.getMovementQty();
                        if (MovementType.charAt(1) == '-') {
                            QtyMA = QtyMA.negate();
                        }
                        BigDecimal reservedDiff = Env.ZERO;
                        BigDecimal orderedDiff = Env.ZERO;
                        if (sLine.getC_OrderLine_ID() != 0) {
                            if (this.isSOTrx() && "C-".equals(MovementType) && ma.getMovementQty().signum() > 0 || this.isSOTrx() && "C+".equals(MovementType) && ma.getMovementQty().signum() < 0) {
                                reservedDiff = ma.getMovementQty().abs().negate();
                            } else if (this.isSOTrx() && "C-".equals(MovementType) && ma.getMovementQty().signum() < 0 || this.isSOTrx() && "C+".equals(MovementType) && ma.getMovementQty().signum() > 0) {
                                if (!"C+".equals(MovementType)) {
                                    reservedDiff = ma.getMovementQty().abs();
                                }
                            } else if (!this.isSOTrx() && "V+".equals(MovementType) && ma.getMovementQty().signum() > 0 || !this.isSOTrx() && "V-".equals(MovementType) && ma.getMovementQty().signum() < 0) {
                                orderedDiff = ma.getMovementQty().abs().negate();
                            } else if (!this.isSOTrx() && "V+".equals(MovementType) && ma.getMovementQty().signum() < 0 || !this.isSOTrx() && "V-".equals(MovementType) && ma.getMovementQty().signum() > 0) {
                                orderedDiff = ma.getMovementQty().abs();
                            }
                        }
                        if (!MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), sLine.getM_Locator_ID(), sLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), reservationAttributeSetInstance_ID, QtyMA, sameWarehouse ? reservedDiff : Env.ZERO, sameWarehouse ? orderedDiff : Env.ZERO, this.get_TrxName())) {
                            this.m_processMsg = "Cannot correct Inventory (MA)";
                            return "IN";
                        }
                        if (!sameWarehouse) {
                            MWarehouse wh = MWarehouse.get(this.getCtx(), oLine.getM_Warehouse_ID());
                            if (!MStorage.add(this.getCtx(), oLine.getM_Warehouse_ID(), wh.getDefaultLocator().getM_Locator_ID(), sLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), reservationAttributeSetInstance_ID, Env.ZERO, reservedDiff, orderedDiff, this.get_TrxName())) {
                                this.m_processMsg = "Cannot correct Inventory (MA) in order warehouse";
                                return "IN";
                            }
                        }
                        mtrx = new MTransaction(this.getCtx(), sLine.getAD_Org_ID(), MovementType, sLine.getM_Locator_ID(), sLine.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), QtyMA, this.getMovementDate(), this.get_TrxName());
                        mtrx.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
                        if (mtrx.save()) continue;
                        this.m_processMsg = "Could not create Material Transaction (MA)";
                        return "IN";
                    }
                }
                if (mtrx == null) {
                    BigDecimal reservedDiff = Env.ZERO;
                    BigDecimal orderedDiff = Env.ZERO;
                    if (sLine.getC_OrderLine_ID() != 0 && sameWarehouse) {
                        if (this.isSOTrx()) {
                            if (!"C+".equals(MovementType)) {
                                reservedDiff = QtySO;
                            }
                        } else {
                            orderedDiff = QtyPO;
                        }
                    }
                    if (!MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), sLine.getM_Locator_ID(), sLine.getM_Product_ID(), sLine.getM_AttributeSetInstance_ID(), reservationAttributeSetInstance_ID, Qty, reservedDiff, orderedDiff, this.get_TrxName())) {
                        this.m_processMsg = "Cannot correct Inventory";
                        return "IN";
                    }
                    if (!sameWarehouse) {
                        MWarehouse wh = MWarehouse.get(this.getCtx(), oLine.getM_Warehouse_ID());
                        if (!MStorage.add(this.getCtx(), oLine.getM_Warehouse_ID(), wh.getDefaultLocator().getM_Locator_ID(), sLine.getM_Product_ID(), sLine.getM_AttributeSetInstance_ID(), reservationAttributeSetInstance_ID, Env.ZERO, QtySO.negate(), QtyPO.negate(), this.get_TrxName())) {
                            this.m_processMsg = "Cannot correct Inventory";
                            return "IN";
                        }
                    }
                    mtrx = new MTransaction(this.getCtx(), sLine.getAD_Org_ID(), MovementType, sLine.getM_Locator_ID(), sLine.getM_Product_ID(), sLine.getM_AttributeSetInstance_ID(), Qty, this.getMovementDate(), this.get_TrxName());
                    mtrx.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
                    if (!mtrx.save()) {
                        this.m_processMsg = CLogger.retrieveErrorString("Could not create Material Transaction");
                        return "IN";
                    }
                }
            }
            if (product != null && oLine != null && this.isSOTrx()) {
                if (this.getC_DocType().getDocBaseType().compareTo("MMR") != 0) {
                    oLine.setQtyReserved(oLine.getQtyReserved().add(QtySO));
                }
            } else if (product != null && oLine != null && !this.isSOTrx()) {
                oLine.setQtyReserved(oLine.getQtyReserved().add(QtyPO));
            }
            if (oLine != null) {
                if ((this.isSOTrx() || sLine.getM_Product_ID() == 0) && this.getC_DocType().getDocBaseType().compareTo("MMR") != 0) {
                    oLine.setQtyDelivered(oLine.getQtyDelivered().subtract(Qty));
                }
                oLine.setDateDelivered(this.getMovementDate());
                if (!oLine.save()) {
                    this.m_processMsg = "Could not update Order Line";
                    return "IN";
                }
                this.log.fine("OrderLine -> Reserved=" + oLine.getQtyReserved() + ", Delivered=" + oLine.getQtyDelivered());
            } else if (rmaLine != null) {
                if (this.isSOTrx()) {
                    rmaLine.setQtyDelivered(rmaLine.getQtyDelivered().add(Qty));
                } else {
                    rmaLine.setQtyDelivered(rmaLine.getQtyDelivered().subtract(Qty));
                }
                if (!rmaLine.save()) {
                    this.m_processMsg = "Could not update RMA Line";
                    return "IN";
                }
            }
            if (!this.isSOTrx() && sLine.getM_Product_ID() != 0 && !this.isReversal()) {
                MInvoiceLine iLine;
                BigDecimal matchQty = sLine.getMovementQty();
                if (MovementType.charAt(1) == '-') {
                    matchQty = matchQty.negate();
                }
                if ((iLine = MInvoiceLine.getOfInOutLine(sLine)) != null && iLine.getM_Product_ID() != 0) {
                    MMatchInv[] matches;
                    if (matchQty.compareTo(iLine.getQtyInvoiced()) > 0) {
                        matchQty = iLine.getQtyInvoiced();
                    }
                    if ((matches = MMatchInv.get(this.getCtx(), sLine.getM_InOutLine_ID(), iLine.getC_InvoiceLine_ID(), this.get_TrxName())) == null || matches.length == 0) {
                        MMatchInv inv = new MMatchInv(iLine, this.getMovementDate(), matchQty);
                        if (sLine.getM_AttributeSetInstance_ID() != iLine.getM_AttributeSetInstance_ID()) {
                            iLine.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
                            iLine.saveEx();
                            inv.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
                        }
                        boolean isNewMatchInv = false;
                        if (inv.get_ID() == 0) {
                            isNewMatchInv = true;
                        }
                        if (!inv.save(this.get_TrxName())) {
                            this.m_processMsg = CLogger.retrieveErrorString("Could not create Inv Matching");
                            return "IN";
                        }
                        if (isNewMatchInv) {
                            this.addDocsPostProcess(inv);
                        }
                    }
                }
                if (sLine.getC_OrderLine_ID() != 0) {
                    this.log.fine("PO Matching");
                    MMatchPO po = MMatchPO.create(null, sLine, this.getMovementDate(), matchQty);
                    boolean isNewMatchPO = false;
                    if (po.get_ID() == 0) {
                        isNewMatchPO = true;
                    }
                    if (!po.save()) {
                        this.m_processMsg = "Could not create PO Matching";
                        return "IN";
                    }
                    if (isNewMatchPO) {
                        this.addDocsPostProcess(po);
                    }
                    if (oLine != null && oLine.getM_AttributeSetInstance_ID() == 0 && sLine.getMovementQty().compareTo(oLine.getQtyOrdered()) == 0) {
                        oLine.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
                        oLine.save(this.get_TrxName());
                    }
                } else if (iLine != null && iLine.getC_OrderLine_ID() != 0) {
                    this.log.fine("PO(Inv) Matching");
                    MMatchPO po = MMatchPO.create(iLine, sLine, this.getMovementDate(), matchQty);
                    boolean isNewMatchPO = false;
                    if (po.get_ID() == 0) {
                        isNewMatchPO = true;
                    }
                    if (!po.save(this.get_TrxName())) {
                        this.m_processMsg = "Could not create PO(Inv) Matching";
                        return "IN";
                    }
                    if (isNewMatchPO) {
                        this.addDocsPostProcess(po);
                    }
                    if ((oLine = new MOrderLine(this.getCtx(), po.getC_OrderLine_ID(), this.get_TrxName())) != null && oLine.getM_AttributeSetInstance_ID() == 0 && sLine.getMovementQty().compareTo(oLine.getQtyOrdered()) == 0) {
                        oLine.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
                        oLine.save(this.get_TrxName());
                    }
                }
            }
            ++lineIndex;
        }
        MInOut counter = this.createCounterDoc();
        if (counter != null) {
            info.append(" - @CounterDoc@: @M_InOut_ID@=").append(counter.getDocumentNo());
        }
        if ((dropShipment = this.createDropShipment()) != null) {
            info.append(" - @DropShipment@: @M_InOut_ID@=").append(dropShipment.getDocumentNo());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        if (inOutOrders.size() > 0) {
            Iterator it = inOutOrders.iterator();
            while (it.hasNext()) {
                MOrder order = new MOrder(this.getCtx(), (Integer)it.next(), this.get_TrxName());
                try {
                    order.updateIsDelivered();
                }
                catch (SQLException ee) {
                    this.log.warning("Could not update isDelivered flag on order " + order.getDocumentNo() + " : " + ee.getMessage());
                }
                order.saveEx(this.get_TrxName());
            }
        }
        this.m_processMsg = info.toString();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void addDocsPostProcess(PO doc) {
        this.docsPostProcess.add(doc);
    }

    public ArrayList<PO> getDocsPostProcess() {
        return this.docsPostProcess;
    }

    private MInOut createDropShipment() {
        if (this.isSOTrx() || !this.isDropShip() || this.getC_Order_ID() == 0) {
            return null;
        }
        int C_DocTypeTarget_ID = 0;
        MDocType[] shipmentTypes = MDocType.getOfDocBaseType(this.getCtx(), "MMS");
        int i = 0;
        while (i < shipmentTypes.length) {
            if (shipmentTypes[i].isSOTrx() && (C_DocTypeTarget_ID == 0 || shipmentTypes[i].isDefault())) {
                C_DocTypeTarget_ID = shipmentTypes[i].getC_DocType_ID();
            }
            ++i;
        }
        MInOut dropShipment = MInOut.copyFrom(this, this.getMovementDate(), this.getDateAcct(), C_DocTypeTarget_ID, !this.isSOTrx(), false, this.get_TrxName(), true);
        int linkedOrderID = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName()).getLink_Order_ID();
        if (linkedOrderID != 0) {
            dropShipment.setC_Order_ID(linkedOrderID);
            int invID = new MOrder(this.getCtx(), linkedOrderID, this.get_TrxName()).getC_Invoice_ID();
            if (invID != 0) {
                dropShipment.setC_Invoice_ID(invID);
            }
        } else {
            return null;
        }
        dropShipment.setC_BPartner_ID(this.getDropShip_BPartner_ID());
        dropShipment.setC_BPartner_Location_ID(this.getDropShip_Location_ID());
        dropShipment.setAD_User_ID(this.getDropShip_User_ID());
        dropShipment.setIsDropShip(false);
        dropShipment.setDropShip_BPartner_ID(0);
        dropShipment.setDropShip_Location_ID(0);
        dropShipment.setDropShip_User_ID(0);
        dropShipment.setMovementType("C-");
        dropShipment.setSalesRep_ID(this.getSalesRep_ID());
        dropShipment.save(this.get_TrxName());
        MInOutLine[] lines = dropShipment.getLines(true);
        int i2 = 0;
        while (i2 < lines.length) {
            MInOutLine dropLine = lines[i2];
            MOrderLine ol = new MOrderLine(this.getCtx(), dropLine.getC_OrderLine_ID(), null);
            if (ol.getC_OrderLine_ID() != 0) {
                dropLine.setC_OrderLine_ID(ol.getLink_OrderLine_ID());
                dropLine.saveEx();
            }
            ++i2;
        }
        this.log.fine(dropShipment.toString());
        dropShipment.setDocAction("CO");
        dropShipment.processIt("CO");
        dropShipment.saveEx();
        return dropShipment;
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    private void checkMaterialPolicy(MInOutLine line) {
        String MovementType;
        BigDecimal qtyFound = DB.getSQLValueBD(this.get_TrxName(), "Select SUM(MovementQty) from M_InOutLineMA where M_InOutLine_ID=?", line.getM_InOutLine_ID());
        if (qtyFound != null && qtyFound.compareTo(line.getMovementQty()) == 0) {
            return;
        }
        int no = MInOutLineMA.deleteInOutLineMA(line.getM_InOutLine_ID(), this.get_TrxName());
        if (no > 0) {
            this.log.config("Delete old #" + no);
        }
        boolean inTrx = (MovementType = this.getMovementType()).charAt(1) == '+';
        boolean needSave = false;
        MProduct product = line.getProduct();
        if (product != null && line.getM_Locator_ID() == 0) {
            line.setM_Warehouse_ID(this.getM_Warehouse_ID());
            line.setM_Locator_ID(inTrx ? Env.ZERO : line.getMovementQty());
            needSave = true;
        }
        if (product != null && line.getM_AttributeSetInstance_ID() == 0) {
            if (this.getMovementType().compareTo("C+") == 0 || this.getMovementType().compareTo("V+") == 0) {
                MStorage[] storages;
                X_M_AttributeSetInstance asi = null;
                MStorage[] mStorageArray = storages = MStorage.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), 0, null, "F".equals(product.getMMPolicy()), false, line.getM_Locator_ID(), this.get_TrxName());
                int n = storages.length;
                int n2 = 0;
                while (n2 < n) {
                    MStorage storage = mStorageArray[n2];
                    if (storage.getQtyOnHand().signum() < 0) {
                        asi = new MAttributeSetInstance(this.getCtx(), storage.getM_AttributeSetInstance_ID(), this.get_TrxName());
                        break;
                    }
                    ++n2;
                }
                if (asi == null) {
                    asi = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
                }
                line.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
                this.log.config("New ASI=" + line);
                needSave = true;
            } else if (this.getMovementType().compareTo("V-") == 0 || this.getMovementType().compareTo("C-") == 0) {
                String MMPolicy = product.getMMPolicy();
                Timestamp minGuaranteeDate = this.getMovementDate();
                MStorage[] storages = MStorage.getWarehouse(this.getCtx(), this.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy), true, line.getM_Locator_ID(), this.get_TrxName());
                BigDecimal qtyToDeliver = line.getMovementQty();
                MStorage[] mStorageArray = storages;
                int n = storages.length;
                int n3 = 0;
                while (n3 < n) {
                    MInOutLineMA ma;
                    MStorage storage = mStorageArray[n3];
                    if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                        ma = new MInOutLineMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver);
                        ma.saveEx();
                        qtyToDeliver = Env.ZERO;
                    } else {
                        ma = new MInOutLineMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
                        ma.saveEx();
                        qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                        this.log.fine(ma + ", QtyToDeliver=" + qtyToDeliver);
                    }
                    if (qtyToDeliver.signum() == 0) break;
                    ++n3;
                }
                if (qtyToDeliver.signum() != 0) {
                    MAttributeSetInstance asi = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
                    int M_AttributeSetInstance_ID = asi.getM_AttributeSetInstance_ID();
                    MInOutLineMA ma = new MInOutLineMA(line, M_AttributeSetInstance_ID, qtyToDeliver);
                    ma.saveEx();
                    this.log.fine("##: " + ma);
                }
            }
        }
        if (needSave) {
            line.saveEx();
        }
    }

    private MInOut createCounterDoc() {
        if (this.getRef_InOut_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get(this.getCtx(), this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, this.get_TrxName());
        MOrgInfo counterOrgInfo = MOrgInfo.get(this.getCtx(), counterAD_Org_ID, this.get_TrxName());
        this.log.info("Counter BP=" + counterBP.getName());
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType(this.getCtx(), this.getC_DocType_ID());
        if (counterDT != null) {
            this.log.fine(counterDT.toString());
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID(this.getCtx(), this.getC_DocType_ID());
            this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MInOut counter = MInOut.copyFrom(this, this.getMovementDate(), this.getDateAcct(), C_DocTypeTarget_ID, !this.isSOTrx(), true, this.get_TrxName(), true);
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setM_Warehouse_ID(counterOrgInfo.getM_Warehouse_ID());
        counter.setBPartner(counterBP);
        if (this.isDropShip()) {
            counter.setIsDropShip(true);
            counter.setDropShip_BPartner_ID(this.getDropShip_BPartner_ID());
            counter.setDropShip_Location_ID(this.getDropShip_Location_ID());
            counter.setDropShip_User_ID(this.getDropShip_User_ID());
        }
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.save(this.get_TrxName());
        String MovementType = counter.getMovementType();
        boolean inTrx = MovementType.charAt(1) == '+';
        MInOutLine[] counterLines = counter.getLines(true);
        int i = 0;
        while (i < counterLines.length) {
            MInOutLine counterLine = counterLines[i];
            counterLine.setClientOrg(counter);
            counterLine.setM_Warehouse_ID(counter.getM_Warehouse_ID());
            counterLine.setM_Locator_ID(0);
            counterLine.setM_Locator_ID(inTrx ? Env.ZERO : counterLine.getMovementQty());
            counterLine.save(this.get_TrxName());
            ++i;
        }
        this.log.fine(counter.toString());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            counter.processIt(counterDT.getDocAction());
            counter.save(this.get_TrxName());
        }
        return counter;
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            MInOutLine[] lines = this.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInOutLine line = lines[i];
                BigDecimal old = line.getMovementQty();
                if (old.signum() != 0) {
                    line.setQty(Env.ZERO);
                    line.addDescription("Void (" + old + ")");
                    line.save(this.get_TrxName());
                }
                ++i;
            }
        } else {
            return this.reverseCorrectIt();
        }
        this.setDocStatus("VO");
        this.saveEx();
        this.voidConfirmations();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        MInOut reversal;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return false;
        }
        if (!this.isSOTrx()) {
            MMatchInv[] mInv = MMatchInv.getInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
            int i = 0;
            while (i < mInv.length) {
                mInv[i].deleteEx(true);
                ++i;
            }
            MMatchPO[] mPO = MMatchPO.getInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
            int i2 = 0;
            while (i2 < mPO.length) {
                if (mPO[i2].getC_InvoiceLine_ID() == 0) {
                    mPO[i2].deleteEx(true);
                } else {
                    mPO[i2].setM_InOutLine_ID(0);
                    mPO[i2].saveEx();
                }
                ++i2;
            }
        }
        if ((reversal = MInOut.copyFrom(this, this.getMovementDate(), this.getDateAcct(), this.getC_DocType_ID(), this.isSOTrx(), false, this.get_TrxName(), true)) == null) {
            this.m_processMsg = "Could not create Ship Reversal";
            return false;
        }
        reversal.setReversal(true);
        MInOutLine[] sLines = this.getLines(true);
        MInOutLine[] rLines = reversal.getLines(true);
        int i = 0;
        while (i < rLines.length) {
            MInOutLine rLine = rLines[i];
            rLine.setQtyEntered(rLine.getQtyEntered().negate());
            rLine.setMovementQty(rLine.getMovementQty().negate());
            rLine.setM_AttributeSetInstance_ID(sLines[i].getM_AttributeSetInstance_ID());
            rLine.setReversalLine_ID(sLines[i].getM_InOutLine_ID());
            if (!rLine.save(this.get_TrxName())) {
                this.m_processMsg = "Could not correct Ship Reversal Line";
                return false;
            }
            if (rLine.getM_AttributeSetInstance_ID() == 0) {
                List<MInOutLineMA> mas = MInOutLineMA.get(this.getCtx(), sLines[i].getM_InOutLine_ID(), this.get_TrxName());
                for (MInOutLineMA ma : mas) {
                    MInOutLineMA reverseLine = new MInOutLineMA(rLine, ma.getM_AttributeSetInstance_ID(), ma.getMovementQty().negate());
                    reverseLine.saveEx();
                }
            }
            ++i;
        }
        reversal.setC_Order_ID(this.getC_Order_ID());
        reversal.setM_RMA_ID(this.getM_RMA_ID());
        reversal.addDescription("{->" + this.getDocumentNo() + ")");
        reversal.setReversal_ID(this.getM_InOut_ID());
        reversal.saveEx(this.get_TrxName());
        if (!reversal.processIt("CO") || !reversal.getDocStatus().equals("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return false;
        }
        reversal.closeIt();
        reversal.setProcessing(false);
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx(this.get_TrxName());
        this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        this.setDocStatus("RE");
        this.saveEx();
        this.voidConfirmations();
        TreeSet<Integer> inOutOrders = new TreeSet<Integer>();
        MInOutLine[] lines = this.getLines(false);
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            MInOutLine sLine = lines[lineIndex];
            MOrderLine oLine = null;
            if (sLine.getC_OrderLine_ID() != 0) {
                oLine = new MOrderLine(this.getCtx(), sLine.getC_OrderLine_ID(), this.get_TrxName());
                inOutOrders.add(oLine.getC_Order_ID());
            }
            ++lineIndex;
        }
        if (inOutOrders.size() > 0) {
            Iterator it = inOutOrders.iterator();
            while (it.hasNext()) {
                MOrder order = new MOrder(this.getCtx(), (Integer)it.next(), this.get_TrxName());
                try {
                    order.updateIsDelivered();
                }
                catch (SQLException ee) {
                    this.log.warning("Could not update isDelivered flag on order " + order.getDocumentNo() + " : " + ee.getMessage());
                }
                order.saveEx(this.get_TrxName());
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        this.setReversal_ID(reversal.getM_InOut_ID());
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(":").append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return Env.getContextAsInt(this.getCtx(), "$C_Currency_ID");
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    private String checkStock() {
        MInOutLine[] lines;
        if (this.getC_Order_ID() > 0 && this.getC_Order().getDeliveryRule().equals("F")) {
            return null;
        }
        MInOutLine[] mInOutLineArray = lines = this.getLines(true);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MInOutLine line = mInOutLineArray[n2];
            if (line.getReversalLine_ID() <= 0 && line.getM_Product_ID() > 0 && line.getM_Product().isStocked()) {
                if (line.getM_AttributeSetInstance_ID() != 0 && (this.getMovementType().equals("C-") || this.getMovementType().equals("V-"))) {
                    BigDecimal qtyHand = DB.getSQLValueBD(this.get_TrxName(), "Select SUM(QtyonHand) from M_Storage where M_Product_ID=?and M_Locator_ID=? and M_AttributeSetInstance_ID=?", line.getM_Product_ID(), line.getM_Locator_ID(), line.getM_AttributeSetInstance_ID());
                    if (qtyHand == null || qtyHand.compareTo(line.getMovementQty()) < 0) {
                        return "Stock Insuficiente :" + (qtyHand == null ? Env.ZERO : qtyHand) + " linea " + line.getLine();
                    }
                } else if (line.getM_AttributeSetInstance_ID() == 0 && (this.getMovementType().equals("C-") || this.getMovementType().equals("V-"))) {
                    MInOutLineMA[] mas = MInOutLineMA.get2(this.getCtx(), line.getM_InOutLine_ID(), this.get_TrxName());
                    int j = 0;
                    while (j < mas.length) {
                        MInOutLineMA ma = mas[j];
                        BigDecimal qtyHand = DB.getSQLValueBD(this.get_TrxName(), "Select SUM(QtyonHand) from M_Storage where M_Product_ID=?and M_Locator_ID=? and M_AttributeSetInstance_ID=?", line.getM_Product_ID(), line.getM_Locator_ID(), ma.getM_AttributeSetInstance_ID());
                        if (qtyHand == null || qtyHand.compareTo(ma.getMovementQty()) < 0) {
                            return "Stock Insuficiente :" + (qtyHand == null ? Env.ZERO : qtyHand) + " linea " + line.getLine();
                        }
                        ++j;
                    }
                }
                if (this.getMovementType().equals("C-")) {
                    int abastLoc_ID = this.getLocatorTo(line.getM_Warehouse_ID());
                    if (line.getM_Locator_ID() == abastLoc_ID) {
                        return "No Valid Locator line " + line.getLine();
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    private int getLocatorTo(int Warehouse_ID) {
        String sql = "select M_locator_ID from M_Locator where upper(value) = 'ABASTECIMIENTO' and M_Warehouse_ID=" + Warehouse_ID;
        int LocatorTO_ID = DB.getSQLValue(this.get_TrxName(), sql);
        if (LocatorTO_ID < 0) {
            LocatorTO_ID = 0;
        }
        return LocatorTO_ID;
    }

    public String CreateXML() {
        MDocType doc = new MDocType(this.getCtx(), this.getC_DocType_ID(), this.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            Element Documento2 = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento2);
            Documento2.setAttribute("ID", "DTE-" + this.getDocumentNo());
            Element Encabezado2 = document.createElement("Encabezado");
            Documento2.appendChild(Encabezado2);
            Element IdDoc2 = document.createElement("IdDoc");
            Encabezado2.appendChild(IdDoc2);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc2.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(this.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc2.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(this.getMovementDate().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc2.appendChild(FchEmis);
            Element TipoDespacho = document.createElement("TipoDespacho");
            Text TDespacho = document.createTextNode("2");
            TipoDespacho.appendChild(TDespacho);
            IdDoc2.appendChild(TipoDespacho);
            String IndTrl = null;
            try {
                IndTrl = this.get_ValueAsString("IndTraslado");
            }
            catch (Exception e) {
                IndTrl = null;
            }
            if (IndTrl != null && IndTrl.length() > 0) {
                Element IndTraslado = document.createElement("IndTraslado");
                Text iTraslado = document.createTextNode(IndTrl);
                IndTraslado.appendChild(iTraslado);
                IdDoc2.appendChild(IndTraslado);
            }
            if (this.getC_Order_ID() > 0) {
                MOrder order = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
                MPaymentTerm pterm = new MPaymentTerm(this.getCtx(), order.getC_PaymentTerm_ID(), this.get_TrxName());
                Element PayTerm = document.createElement("TermPagoGlosa");
                Text term = document.createTextNode(pterm.getName());
                PayTerm.appendChild(term);
                IdDoc2.appendChild(PayTerm);
            }
            Element Emisor2 = document.createElement("Emisor");
            Encabezado2.appendChild(Emisor2);
            mylog = "Emisor";
            MOrg company = MOrg.get(this.getCtx(), this.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor2.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor2.appendChild(RznSoc);
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode((String)company.get_Value("Giro"));
            GiroEmis.appendChild(gi);
            Emisor2.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor2.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor2.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor2.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor2.appendChild(CiudadOrigen);
            mylog = "receptor";
            MBPartner BP = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(this.getCtx(), this.getC_BPartner_Location_ID(), this.get_TrxName());
            Element Receptor2 = document.createElement("Receptor");
            Encabezado2.appendChild(Receptor2);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor2.appendChild(RUTRecep);
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(BP.getName());
            RznSocRecep.appendChild(RznSocR);
            Receptor2.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor2.appendChild(GiroRecep);
            Element ContactoRecep = document.createElement("Contacto");
            Text contacto = document.createTextNode(this.getAD_User_ID() > 0 ? this.getAD_User().getName() : " ");
            ContactoRecep.appendChild(contacto);
            Receptor2.appendChild(ContactoRecep);
            Element CorreoRecep = document.createElement("CorreoRecep");
            Text corrRecep = document.createTextNode(this.getAD_User().getEMail() == null ? " " : this.getAD_User().getEMail());
            CorreoRecep.appendChild(corrRecep);
            Receptor2.appendChild(CorreoRecep);
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirRecep.appendChild(dirr);
            Receptor2.appendChild(DirRecep);
            Element CmnaRecep = document.createElement("CmnaRecep");
            Text Cmna = document.createTextNode(bloc.getLocation(true).getAddress3() == null ? " " : bloc.getLocation(true).getAddress3());
            CmnaRecep.appendChild(Cmna);
            Receptor2.appendChild(CmnaRecep);
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(this.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor2.appendChild(CiudadRecep);
            Element transporte = document.createElement("Transporte");
            Encabezado2.appendChild(transporte);
            Element DirDest = document.createElement("DirDest");
            Text dirdest = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirDest.appendChild(dirdest);
            transporte.appendChild(DirDest);
            Element CmnaDest = document.createElement("CmnaDest");
            Text CmnaDestTxt = document.createTextNode(bloc.getLocation(true).getAddress3() == null ? " " : bloc.getLocation(true).getAddress3());
            CmnaDest.appendChild(CmnaDestTxt);
            transporte.appendChild(CmnaDest);
            Element CiudadDest = document.createElement("CiudadDest");
            Text regDest = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(this.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadDest.appendChild(regDest);
            transporte.appendChild(CiudadDest);
            mylog = "Totales";
            Element Totales2 = document.createElement("Totales");
            Encabezado2.appendChild(Totales2);
            BigDecimal amountGrandT = Env.ZERO;
            BigDecimal priceT = Env.ZERO;
            BigDecimal taxAmt = Env.ZERO;
            if (this.getC_Order_ID() > 0) {
                MInOutLine[] iLines2 = this.getLines();
                int a = 0;
                while (a < iLines2.length) {
                    priceT = Env.ZERO;
                    taxAmt = Env.ZERO;
                    MInOutLine iLine = iLines2[a];
                    if (iLine.getC_OrderLine_ID() > 0) {
                        priceT = iLine.getC_OrderLine().getPriceEntered();
                    }
                    priceT = priceT.multiply(iLine.getQtyEntered());
                    if (iLine.getC_OrderLine().getC_Tax_ID() > 0 && iLine.getC_OrderLine().getC_Tax().getRate().compareTo(Env.ZERO) > 0) {
                        taxAmt = priceT.multiply(iLine.getC_OrderLine().getC_Tax().getRate());
                        taxAmt = taxAmt.divide(Env.ONEHUNDRED);
                    }
                    priceT = priceT.add(taxAmt);
                    amountGrandT = amountGrandT.add(priceT);
                    ++a;
                }
            }
            Element TasaIVA = document.createElement("TasaIVA");
            Text tiva = document.createTextNode("19");
            TasaIVA.appendChild(tiva);
            Totales2.appendChild(TasaIVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(amountGrandT.setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales2.appendChild(MntTotal);
            mylog = "detalle";
            MInOutLine[] iLines = this.getLines();
            int i = 0;
            while (i < iLines.length) {
                MInOutLine iLine = iLines[i];
                if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                    Element Detalle2 = document.createElement("Detalle");
                    Documento2.appendChild(Detalle2);
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(iLine.getLine() / 10));
                    NroLinDet.appendChild(line);
                    Detalle2.appendChild(NroLinDet);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = iLine.getProduct() != null ? iLine.getProduct().getName() : iLine.getC_Charge().getName();
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle2.appendChild(NmbItem);
                    BigDecimal mtoItem = Env.ZERO;
                    BigDecimal prcRefMnt = Env.ZERO;
                    if (iLine.getC_OrderLine_ID() > 0) {
                        prcRefMnt = iLine.getC_OrderLine().getPriceEntered();
                        mtoItem = prcRefMnt.multiply(iLine.getQtyEntered());
                    }
                    Element PrcRef = document.createElement("PrcRef");
                    Text PrcRefTxt = document.createTextNode(prcRefMnt.setScale(0, 4).toString());
                    PrcRef.appendChild(PrcRefTxt);
                    Detalle2.appendChild(PrcRef);
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(iLine.getQtyEntered().toString());
                    QtyItem.appendChild(qt);
                    Detalle2.appendChild(QtyItem);
                    Element MtoItem = document.createElement("MontoItem");
                    Text MtoTxt = document.createTextNode(mtoItem.setScale(0, 4).toString());
                    MtoItem.appendChild(MtoTxt);
                    Detalle2.appendChild(MtoItem);
                }
                ++i;
            }
            mylog = "referencia";
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            if (this.getPOReference() != null && this.getPOReference().length() > 0) {
                mylog = "referencia:order";
                tiporeferencia = "801";
                folioreferencia = this.getPOReference();
                fechareferencia = this.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 2;
            }
            if (tipo_Ref > 0) {
                Element Referencia2 = document.createElement("Referencia");
                Documento2.appendChild(Referencia2);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("1");
                NroLinRef.appendChild(Nro);
                Referencia2.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(tiporeferencia);
                TpoDocRef.appendChild(tpo);
                Referencia2.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(folioreferencia);
                FolioRef.appendChild(ref);
                Referencia2.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(fechareferencia);
                FchRef.appendChild(fchref);
                Referencia2.appendChild(FchRef);
                String CodRefTxt = null;
                try {
                    CodRefTxt = this.get_ValueAsString("CodRef");
                }
                catch (Exception e) {
                    CodRefTxt = null;
                }
                if (CodRefTxt != null && CodRefTxt.length() > 0) {
                    Element CodRef = document.createElement("CodRef");
                    Text codref = document.createTextNode(this.get_ValueAsString("CodRef") == null ? "0" : this.get_ValueAsString("CodRef"));
                    CodRef.appendChild(codref);
                    Referencia2.appendChild(CodRef);
                }
            }
            mylog = "firma";
            Element Firma = document.createElement("TmstFirma");
            Timestamp today = new Timestamp(TimeUtil.getToday().getTimeInMillis());
            Text Ftext = document.createTextNode(today.toString().substring(0, 10) + "T" + today.toString().substring(11, 19));
            Firma.appendChild(Ftext);
            Documento2.appendChild(Firma);
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, this.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML Generated";
    }
}

