/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDistributionListLine;
import org.compiere.model.X_M_DistributionList;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MDistributionList
extends X_M_DistributionList {
    private static final long serialVersionUID = -1570304450929416071L;

    public MDistributionList(Properties ctx, int M_DistributionList_ID, String trxName) {
        super(ctx, M_DistributionList_ID, trxName);
    }

    public MDistributionList(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDistributionListLine[] getLines() {
        ArrayList<MDistributionListLine> list = new ArrayList<MDistributionListLine>();
        BigDecimal ratioTotal = Env.ZERO;
        String sql = "SELECT * FROM M_DistributionListLine WHERE M_DistributionList_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getM_DistributionList_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MDistributionListLine line = new MDistributionListLine(this.getCtx(), rs, this.get_TrxName());
                list.add(line);
                BigDecimal ratio = line.getRatio();
                if (ratio == null) continue;
                ratioTotal = ratioTotal.add(ratio);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getLines", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (ratioTotal.compareTo(this.getRatioTotal()) != 0) {
            this.log.info("getLines - Set RatioTotal from " + this.getRatioTotal() + " to " + ratioTotal);
            this.setRatioTotal(ratioTotal);
            this.save();
        }
        MDistributionListLine[] retValue = new MDistributionListLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

