/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDiscountSchemaBreak;
import org.compiere.model.MDiscountSchemaLine;
import org.compiere.model.X_M_DiscountSchema;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MDiscountSchema
extends X_M_DiscountSchema {
    private static final long serialVersionUID = -3314884382853756019L;
    private static CCache<Integer, MDiscountSchema> s_cache = new CCache("M_DiscountSchema", 20);
    private MDiscountSchemaBreak[] m_breaks = null;
    private MDiscountSchemaLine[] m_lines = null;

    public static MDiscountSchema get(Properties ctx, int M_DiscountSchema_ID) {
        Integer key = new Integer(M_DiscountSchema_ID);
        MDiscountSchema retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MDiscountSchema(ctx, M_DiscountSchema_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MDiscountSchema(Properties ctx, int M_DiscountSchema_ID, String trxName) {
        super(ctx, M_DiscountSchema_ID, trxName);
        if (M_DiscountSchema_ID == 0) {
            this.setDiscountType("F");
            this.setFlatDiscount(Env.ZERO);
            this.setIsBPartnerFlatDiscount(false);
            this.setIsQuantityBased(true);
            this.setCumulativeLevel("L");
        }
    }

    public MDiscountSchema(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDiscountSchemaBreak[] getBreaks(boolean reload) {
        if (this.m_breaks != null && !reload) {
            return this.m_breaks;
        }
        String sql = "SELECT * FROM M_DiscountSchemaBreak WHERE M_DiscountSchema_ID=? ORDER BY SeqNo";
        ArrayList<MDiscountSchemaBreak> list = new ArrayList<MDiscountSchemaBreak>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getM_DiscountSchema_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MDiscountSchemaBreak(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_breaks = new MDiscountSchemaBreak[list.size()];
        list.toArray(this.m_breaks);
        return this.m_breaks;
    }

    public MDiscountSchemaLine[] getLines(boolean reload) {
        if (this.m_lines != null && !reload) {
            MDiscountSchema.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String sql = "SELECT * FROM M_DiscountSchemaLine WHERE M_DiscountSchema_ID=? ORDER BY SeqNo";
        ArrayList<MDiscountSchemaLine> list = new ArrayList<MDiscountSchemaLine>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getM_DiscountSchema_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MDiscountSchemaLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MDiscountSchemaLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public BigDecimal calculatePrice(BigDecimal Qty, BigDecimal Price, int M_Product_ID, int M_Product_Category_ID, BigDecimal BPartnerFlatDiscount) {
        this.log.fine("Price=" + Price + ",Qty=" + Qty + ",M_Product_ID=" + M_Product_ID + ",M_Product_Category_ID=" + M_Product_Category_ID + ",BPartnerFlatDiscount=" + BPartnerFlatDiscount.doubleValue());
        if (Price == null || Env.ZERO.compareTo(Price) == 0) {
            return Price;
        }
        BigDecimal discount = this.calculateDiscount(Qty, Price, M_Product_ID, M_Product_Category_ID, BPartnerFlatDiscount);
        this.log.fine("Discount=" + discount.doubleValue());
        if (discount == null || discount.signum() == 0) {
            return Price;
        }
        BigDecimal onehundred = new BigDecimal(100);
        BigDecimal multiplier = onehundred.subtract(discount);
        multiplier = multiplier.divide(onehundred, 6, 4);
        BigDecimal newPrice = Price.multiply(multiplier);
        this.log.fine("=>" + newPrice);
        return newPrice;
    }

    public BigDecimal calculateDiscount(BigDecimal Qty, BigDecimal Price, int M_Product_ID, int M_Product_Category_ID, BigDecimal BPartnerFlatDiscount) {
        if (BPartnerFlatDiscount == null) {
            BPartnerFlatDiscount = Env.ZERO;
        }
        if ("F".equals(this.getDiscountType())) {
            if (this.isBPartnerFlatDiscount()) {
                return BPartnerFlatDiscount;
            }
            return this.getFlatDiscount();
        }
        if ("S".equals(this.getDiscountType()) || "P".equals(this.getDiscountType())) {
            this.log.info("Not supported (yet) DiscountType=" + this.getDiscountType());
            return Env.ZERO;
        }
        this.getBreaks(false);
        boolean found = false;
        BigDecimal Amt = Price.multiply(Qty);
        if (this.isQuantityBased()) {
            this.log.finer("Qty=" + Qty + ",M_Product_ID=" + M_Product_ID + ",M_Product_Category_ID=" + M_Product_Category_ID);
        } else {
            this.log.finer("Amt=" + Amt + ",M_Product_ID=" + M_Product_ID + ",M_Product_Category_ID=" + M_Product_Category_ID);
        }
        for (int i2 = 0; i2 < this.m_breaks.length; ++i2) {
            MDiscountSchemaBreak br = this.m_breaks[i2];
            if (!br.isActive()) continue;
            if (this.isQuantityBased()) {
                if (!br.applies(Qty, M_Product_ID, M_Product_Category_ID)) {
                    this.log.finer("No: " + br);
                    continue;
                }
                this.log.finer("Yes: " + br);
            } else {
                if (!br.applies(Amt, M_Product_ID, M_Product_Category_ID)) {
                    this.log.finer("No: " + br);
                    continue;
                }
                this.log.finer("Yes: " + br);
            }
            BigDecimal discount = null;
            discount = br.isBPartnerFlatDiscount() ? BPartnerFlatDiscount : br.getBreakDiscount();
            this.log.fine("Discount=>" + discount);
            return discount;
        }
        return Env.ZERO;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getValidFrom() == null) {
            this.setValidFrom(TimeUtil.getDay(null));
        }
        return true;
    }

    public int reSeq() {
        int count = 0;
        MDiscountSchemaLine[] lines = this.getLines(true);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            int line = (i2 + 1) * 10;
            if (line == lines[i2].getSeqNo()) continue;
            lines[i2].setSeqNo(line);
            if (!lines[i2].save()) continue;
            ++count;
        }
        this.m_lines = null;
        MDiscountSchemaBreak[] breaks = this.getBreaks(true);
        for (int i3 = 0; i3 < breaks.length; ++i3) {
            int line = (i3 + 1) * 10;
            if (line == breaks[i3].getSeqNo()) continue;
            breaks[i3].setSeqNo(line);
            if (!breaks[i3].save()) continue;
            ++count;
        }
        this.m_breaks = null;
        return count;
    }
}

