/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.compiere.FA.exceptions.AssetException;
import org.compiere.FA.exceptions.AssetNotActiveException;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MDepreciationEntry;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.Query;
import org.compiere.model.X_A_Depreciation_Exp;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MDepreciationExp
extends X_A_Depreciation_Exp {
    private static final long serialVersionUID = 1L;
    private static CLogger s_log = CLogger.getCLogger(MDepreciationExp.class);
    private CLogger log = CLogger.getCLogger(this.getClass());

    public MDepreciationExp(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MDepreciationExp(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public static MDepreciationExp get(Properties properties, int n) {
        if (n <= 0) {
            return null;
        }
        MDepreciationExp mDepreciationExp = new MDepreciationExp(properties, n, null);
        if (mDepreciationExp.get_ID() != n) {
            mDepreciationExp = null;
        }
        return mDepreciationExp;
    }

    public static MDepreciationExp createEntry(Properties properties, String string, int n, int n2, Timestamp timestamp, String string2, int n3, int n4, BigDecimal bigDecimal, String string3, MDepreciationWorkfile mDepreciationWorkfile) {
        MDepreciationExp mDepreciationExp = new MDepreciationExp(properties, 0, null);
        mDepreciationExp.setA_Entry_Type(string);
        mDepreciationExp.setA_Asset_ID(n);
        mDepreciationExp.setDR_Account_ID(n3);
        mDepreciationExp.setCR_Account_ID(n4);
        mDepreciationExp.setA_Account_Number_Acct(n3);
        mDepreciationExp.setPostingType(string2);
        mDepreciationExp.setExpense(bigDecimal);
        mDepreciationExp.setDescription(Msg.parseTranslation(properties, string3));
        mDepreciationExp.setA_Period(n2);
        mDepreciationExp.setIsDepreciated(true);
        mDepreciationExp.setDateAcct(timestamp);
        mDepreciationExp.updateFrom(mDepreciationWorkfile);
        s_log.fine("depexp=" + mDepreciationExp);
        return mDepreciationExp;
    }

    public void updateFrom(MDepreciationWorkfile mDepreciationWorkfile) {
        this.setA_Asset_Cost(mDepreciationWorkfile.getA_Asset_Cost());
        this.setA_Accumulated_Depr(mDepreciationWorkfile.getA_Accumulated_Depr());
        this.setA_Accumulated_Depr_F(mDepreciationWorkfile.getA_Accumulated_Depr_F());
        this.setUseLifeMonths(mDepreciationWorkfile.getUseLifeMonths());
        this.setUseLifeMonths_F(mDepreciationWorkfile.getUseLifeMonths_F());
        this.setA_Asset_Remaining(mDepreciationWorkfile.getA_Asset_Remaining());
        this.setA_Asset_Remaining_F(mDepreciationWorkfile.getA_Asset_Remaining_F());
    }

    private MDepreciationWorkfile getA_Depreciation_Workfile() {
        return MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
    }

    public static Collection<MDepreciationExp> createDepreciation(MDepreciationWorkfile mDepreciationWorkfile, int n, Timestamp timestamp, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4, String string, String string2) {
        ArrayList<MDepreciationExp> arrayList = new ArrayList<MDepreciationExp>();
        Properties properties = mDepreciationWorkfile.getCtx();
        MAssetAcct mAssetAcct = mDepreciationWorkfile.getA_AssetAcct(timestamp, string2);
        MDepreciationExp mDepreciationExp = null;
        mDepreciationExp = MDepreciationExp.createEntry(properties, "DEP", mDepreciationWorkfile.getA_Asset_ID(), n, timestamp, mDepreciationWorkfile.getPostingType(), mAssetAcct.getA_Depreciation_Acct(), mAssetAcct.getA_Accumdepreciation_Acct(), bigDecimal, "@AssetDepreciationAmt@", mDepreciationWorkfile);
        if (mDepreciationExp != null) {
            mDepreciationExp.setAD_Org_ID(mDepreciationWorkfile.getA_Asset().getAD_Org_ID());
            if (bigDecimal3 != null) {
                mDepreciationExp.setA_Accumulated_Depr(bigDecimal3);
            }
            if (bigDecimal4 != null) {
                mDepreciationExp.setA_Accumulated_Depr_F(bigDecimal4);
            }
            if (string != null && string.length() > 0) {
                mDepreciationExp.setHelp(string);
            }
            mDepreciationExp.setExpense_F(bigDecimal2);
            mDepreciationExp.setA_Accumulated_Depr_Delta(bigDecimal);
            mDepreciationExp.setA_Accumulated_Depr_F_Delta(bigDecimal2);
            mDepreciationExp.saveEx(mDepreciationWorkfile.get_TrxName());
            arrayList.add(mDepreciationExp);
        }
        return arrayList;
    }

    public void process() {
        if (this.isProcessed()) {
            this.log.fine("@AlreadyProcessed@");
            return;
        }
        MDepreciationWorkfile mDepreciationWorkfile = this.getA_Depreciation_Workfile();
        if (mDepreciationWorkfile == null) {
            throw new AssetException("@NotFound@ @A_Depreciation_Workfile_ID@");
        }
        String string = this.getA_Entry_Type();
        if ("DEP".equals(string)) {
            MDepreciationExp.checkExistsNotProcessedEntries(this.getCtx(), this.getA_Asset_ID(), this.getDateAcct(), this.getPostingType(), this.get_TrxName());
            if (!mDepreciationWorkfile.getAsset().getA_Asset_Status().equals("AC")) {
                throw new AssetNotActiveException(mDepreciationWorkfile.getAsset().get_ID());
            }
            this.setDateAcct(mDepreciationWorkfile.getDateAcct());
            mDepreciationWorkfile.adjustAccumulatedDepr(this.getExpense(), this.getExpense_F(), false);
        }
        this.setProcessed(true);
        this.updateFrom(mDepreciationWorkfile);
        this.saveEx();
        mDepreciationWorkfile.setA_Current_Period();
        mDepreciationWorkfile.saveEx();
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            MDepreciationWorkfile mDepreciationWorkfile = this.getA_Depreciation_Workfile();
            mDepreciationWorkfile.adjustAccumulatedDepr(this.getA_Accumulated_Depr().negate(), this.getA_Accumulated_Depr_F().negate(), false);
            mDepreciationWorkfile.saveEx();
        }
        if (this.isPosted()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "GLD", this.getAD_Org_ID());
            MDepreciationEntry.deleteFacts(this);
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean bl) {
        if (!bl) {
            return false;
        }
        if (this.isProcessed()) {
            MDepreciationWorkfile mDepreciationWorkfile = this.getA_Depreciation_Workfile();
            mDepreciationWorkfile.setA_Current_Period();
            mDepreciationWorkfile.saveEx();
        }
        return true;
    }

    protected boolean isPosted() {
        return this.isProcessed() && this.getA_Depreciation_Entry_ID() > 0;
    }

    public static void checkExistsNotProcessedEntries(Properties properties, int n, Timestamp timestamp, String string, String string2) {
        boolean bl = new Query(properties, "A_Depreciation_Exp", "A_Asset_ID=? AND TRUNC(DateAcct,'MONTH')<? AND PostingType=? AND Processed=?", string2).setParameters(n, TimeUtil.getMonthFirstDay(timestamp), string, false).match();
        if (bl) {
            throw new AssetException("There are unprocessed records to date");
        }
    }

    public static List<MDepreciationExp> getNotProcessedEntries(Properties properties, int n, String string, String string2) {
        List<MDepreciationExp> list = new Query(properties, "A_Depreciation_Exp", "A_Asset_ID=? AND PostingType=? AND Processed=?", string2).setParameters(n, string, false).list();
        return list;
    }

    @Override
    public void setProcessed(boolean bl) {
        super.setProcessed(bl);
        if (this.get_ID() > 0) {
            DB.executeUpdateEx("UPDATE A_Depreciation_Exp SET Processed=? WHERE A_Depreciation_Exp_ID=?", new Object[]{bl, this.get_ID()}, this.get_TrxName());
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.get_ID() + ",A_Asset_ID=" + this.getA_Asset_ID() + ",A_Period=" + this.getA_Period() + ",DateAcct=" + this.getDateAcct() + ",Expense=" + this.getExpense() + ",Entry_ID=" + this.getA_Depreciation_Entry_ID() + "]";
    }
}

