/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.Adempiere;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MClient;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Attachment;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.MimeType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MAttachment
extends X_AD_Attachment {
    private static final long serialVersionUID = -1948066627503677516L;
    private static CLogger s_log = CLogger.getCLogger(MAttachment.class);
    public static final String NONE = ".";
    public static final String ZIP = "zip";
    public static final String XML = "xml";
    private ArrayList<MAttachmentEntry> m_items = null;
    private boolean isStoreAttachmentsOnFileSystem = false;
    private String m_attachmentPathRoot = "";
    private final String ATTACHMENT_FOLDER_PLACEHOLDER = "%ATTACHMENT_FOLDER%";

    public static MAttachment get(Properties ctx, int AD_Table_ID, int Record_ID) {
        String whereClause = "AD_Table_ID=? AND Record_ID=?";
        MAttachment retValue = (MAttachment)new Query(ctx, "AD_Attachment", "AD_Table_ID=? AND Record_ID=?", null).setParameters(AD_Table_ID, Record_ID).first();
        return retValue;
    }

    public MAttachment(Properties ctx, int AD_Attachment_ID, String trxName) {
        super(ctx, AD_Attachment_ID, trxName);
        this.initAttachmentStoreDetails(ctx, trxName);
    }

    public MAttachment(Properties ctx, int AD_Table_ID, int Record_ID, String trxName) {
        this(ctx, MAttachment.get(ctx, AD_Table_ID, Record_ID) == null ? 0 : MAttachment.get(ctx, AD_Table_ID, Record_ID).get_ID(), trxName);
        if (this.get_ID() == 0) {
            this.setAD_Table_ID(AD_Table_ID);
            this.setRecord_ID(Record_ID);
        }
    }

    public MAttachment(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.initAttachmentStoreDetails(ctx, trxName);
    }

    private void initAttachmentStoreDetails(Properties ctx, String trxName) {
        MClient client = new MClient(ctx, this.getAD_Client_ID(), trxName);
        this.isStoreAttachmentsOnFileSystem = client.isStoreAttachmentsOnFileSystem();
        if (this.isStoreAttachmentsOnFileSystem) {
            this.m_attachmentPathRoot = File.separatorChar == '\\' ? client.getWindowsAttachmentPath() : client.getUnixAttachmentPath();
            if (this.m_attachmentPathRoot == null || "".equals(this.m_attachmentPathRoot)) {
                this.log.severe("no attachmentPath defined");
            } else if (!this.m_attachmentPathRoot.endsWith(File.separator)) {
                this.log.warning("attachment path doesn't end with " + File.separator);
                this.m_attachmentPathRoot = String.valueOf(this.m_attachmentPathRoot) + File.separator;
                this.log.fine(this.m_attachmentPathRoot);
            }
        }
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void addTextMsg(String added) {
        String oldTextMsg = this.getTextMsg();
        if (oldTextMsg == null) {
            this.setTextMsg(added);
        } else if (added != null) {
            this.setTextMsg(String.valueOf(oldTextMsg) + added);
        }
    }

    @Override
    public String getTextMsg() {
        String msg = super.getTextMsg();
        if (msg == null) {
            return null;
        }
        return msg.trim();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MAttachment[");
        sb.append(this.getAD_Attachment_ID()).append(",Title=").append(this.getTitle()).append(",Entries=").append(this.getEntryCount());
        int i = 0;
        while (i < this.getEntryCount()) {
            if (i == 0) {
                sb.append(":");
            } else {
                sb.append(",");
            }
            sb.append(this.getEntryName(i));
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean addEntry(File file) {
        byte[] data;
        String name;
        block26: {
            if (file == null) {
                this.log.warning("No File");
                return false;
            }
            if (!file.exists() || file.isDirectory() || !file.canRead()) {
                this.log.warning("not added - " + file + ", Exists=" + file.exists() + ", Directory=" + file.isDirectory());
                return false;
            }
            this.log.fine("addEntry - " + file);
            name = file.getName();
            data = null;
            FileInputStream fis = null;
            ByteArrayOutputStream os = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    os = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    int length = -1;
                    while ((length = fis.read(buffer)) != -1) {
                        os.write(buffer, 0, length);
                    }
                    data = os.toByteArray();
                }
                catch (IOException ioe) {
                    this.log.log(Level.SEVERE, "(file)", ioe);
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ex) {
                            this.log.log(Level.SEVERE, "(file)", ex);
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException ex) {
                            this.log.log(Level.SEVERE, "(file)", ex);
                        }
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {
                        this.log.log(Level.SEVERE, "(file)", ex);
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException ex) {
                        this.log.log(Level.SEVERE, "(file)", ex);
                    }
                }
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    this.log.log(Level.SEVERE, "(file)", ex);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    this.log.log(Level.SEVERE, "(file)", ex);
                }
            }
        }
        return this.addEntry(name, data);
    }

    public boolean addEntry(String name, byte[] data) {
        if (name == null || data == null) {
            return false;
        }
        return this.addEntry(new MAttachmentEntry(name, data));
    }

    public boolean addEntry(MAttachmentEntry item) {
        boolean replaced = false;
        boolean retValue = false;
        if (item == null) {
            return false;
        }
        if (this.m_items == null) {
            this.loadLOBData();
        }
        int i = 0;
        while (i < this.m_items.size()) {
            if (this.m_items.get(i).getName().equals(item.getName())) {
                this.m_items.set(i, item);
                replaced = true;
            }
            ++i;
        }
        if (!replaced) {
            retValue = this.m_items.add(item);
        }
        this.log.fine(item.toStringX());
        this.setBinaryData(new byte[0]);
        return retValue || replaced;
    }

    public MAttachmentEntry getEntry(int index) {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        if (index < 0 || index >= this.m_items.size()) {
            return null;
        }
        return this.m_items.get(index);
    }

    public MAttachmentEntry[] getEntries() {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        MAttachmentEntry[] retValue = new MAttachmentEntry[this.m_items.size()];
        this.m_items.toArray(retValue);
        return retValue;
    }

    public boolean deleteEntry(int index) {
        if (index >= 0 && index < this.m_items.size()) {
            if (this.isStoreAttachmentsOnFileSystem) {
                MAttachmentEntry entry = this.m_items.get(index);
                File file = entry.getFile();
                this.log.fine("delete: " + file.getAbsolutePath());
                if (file != null && file.exists() && !file.delete()) {
                    this.log.warning("unable to delete " + file.getAbsolutePath());
                }
            }
            this.m_items.remove(index);
            this.log.config("Index=" + index + " - NewSize=" + this.m_items.size());
            return true;
        }
        this.log.warning("Not deleted Index=" + index + " - Size=" + this.m_items.size());
        return false;
    }

    public int getEntryCount() {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        return this.m_items.size();
    }

    public String getEntryName(int index) {
        MAttachmentEntry item = this.getEntry(index);
        if (item != null) {
            String name = item.getName();
            if (name != null && this.isStoreAttachmentsOnFileSystem) {
                name = name.substring(name.lastIndexOf(File.separator) + 1);
            }
            return name;
        }
        return null;
    }

    public void dumpEntryNames() {
        if (this.m_items == null) {
            this.loadLOBData();
        }
        if (this.m_items == null || this.m_items.size() == 0) {
            System.out.println("- no entries -");
            return;
        }
        System.out.println("- entries: " + this.m_items.size());
        int i = 0;
        while (i < this.m_items.size()) {
            System.out.println("  - " + this.getEntryName(i));
            ++i;
        }
    }

    public byte[] getEntryData(int index) {
        MAttachmentEntry item = this.getEntry(index);
        if (item != null) {
            return item.getData();
        }
        return null;
    }

    public File getEntryFile(int index, String fileName) {
        MAttachmentEntry item = this.getEntry(index);
        if (item != null) {
            return item.getFile(fileName);
        }
        return null;
    }

    public File getEntryFile(int index, File file) {
        MAttachmentEntry item = this.getEntry(index);
        if (item != null) {
            return item.getFile(file);
        }
        return null;
    }

    private boolean saveLOBData() {
        if (this.isStoreAttachmentsOnFileSystem) {
            return this.saveLOBDataToFileSystem();
        }
        return this.saveLOBDataToDB();
    }

    private boolean saveLOBDataToDB() {
        if (this.m_items == null || this.m_items.size() == 0) {
            this.setBinaryData(null);
            return true;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(out);
        zip.setMethod(8);
        zip.setLevel(9);
        zip.setComment("adempiere");
        try {
            int i = 0;
            while (i < this.m_items.size()) {
                MAttachmentEntry item = this.getEntry(i);
                ZipEntry entry = new ZipEntry(item.getName());
                entry.setTime(System.currentTimeMillis());
                entry.setMethod(8);
                zip.putNextEntry(entry);
                byte[] data = item.getData();
                zip.write(data, 0, data.length);
                zip.closeEntry();
                this.log.fine(String.valueOf(entry.getName()) + " - " + entry.getCompressedSize() + " (" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
                ++i;
            }
            zip.close();
            byte[] zipData = out.toByteArray();
            this.log.fine("Length=" + zipData.length);
            this.setBinaryData(zipData);
            return true;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "saveLOBData", e);
            this.setBinaryData(null);
            return false;
        }
    }

    private boolean saveLOBDataToFileSystem() {
        if (this.m_attachmentPathRoot == null || "".equals(this.m_attachmentPathRoot)) {
            this.log.severe("no attachmentPath defined");
            return false;
        }
        if (this.m_items == null || this.m_items.size() == 0) {
            this.setBinaryData(null);
            return true;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("attachments");
            document.appendChild(root);
            document.setXmlStandalone(true);
            int i = 0;
            while (i < this.m_items.size()) {
                File entryFile;
                block19: {
                    this.log.fine(this.m_items.get(i).toString());
                    entryFile = this.m_items.get(i).getFile();
                    String path = entryFile.getAbsolutePath();
                    this.log.fine(String.valueOf(path) + " - " + this.m_attachmentPathRoot);
                    if (!path.startsWith(this.m_attachmentPathRoot)) {
                        this.log.fine("move file: " + path);
                        AbstractInterruptibleChannel in = null;
                        AbstractInterruptibleChannel out = null;
                        try {
                            try {
                                File destFolder = new File(String.valueOf(this.m_attachmentPathRoot) + File.separator + this.getAttachmentPathSnippet());
                                if (!destFolder.exists() && !destFolder.mkdirs()) {
                                    this.log.warning("unable to create folder: " + destFolder.getPath());
                                }
                                File destFile = new File(String.valueOf(this.m_attachmentPathRoot) + File.separator + this.getAttachmentPathSnippet() + File.separator + entryFile.getName());
                                in = new FileInputStream(entryFile).getChannel();
                                out = new FileOutputStream(destFile).getChannel();
                                ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
                                in.close();
                                out.close();
                                if (entryFile.exists() && !entryFile.delete()) {
                                    entryFile.deleteOnExit();
                                }
                                entryFile = destFile;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                this.log.severe("unable to copy file " + entryFile.getAbsolutePath() + " to " + this.m_attachmentPathRoot + File.separator + this.getAttachmentPathSnippet() + File.separator + entryFile.getName());
                                if (in != null && in.isOpen()) {
                                    in.close();
                                }
                                if (out != null && out.isOpen()) {
                                    out.close();
                                }
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            if (in != null && in.isOpen()) {
                                in.close();
                            }
                            if (out != null && out.isOpen()) {
                                out.close();
                            }
                            throw throwable;
                        }
                        if (in != null && in.isOpen()) {
                            in.close();
                        }
                        if (out != null && out.isOpen()) {
                            out.close();
                        }
                    }
                }
                Element entry = document.createElement("entry");
                entry.setAttribute("name", this.getEntryName(i));
                String filePathToStore = entryFile.getAbsolutePath();
                filePathToStore = filePathToStore.replaceFirst(this.m_attachmentPathRoot.replaceAll("\\\\", "\\\\\\\\"), "%ATTACHMENT_FOLDER%");
                this.log.fine(filePathToStore);
                entry.setAttribute("file", filePathToStore);
                root.appendChild(entry);
                ++i;
            }
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            byte[] xmlData = bos.toByteArray();
            this.log.fine(bos.toString());
            this.setBinaryData(xmlData);
            return true;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "saveLOBData", e);
            this.setBinaryData(null);
            return false;
        }
    }

    private boolean loadLOBData() {
        if (this.isStoreAttachmentsOnFileSystem) {
            return this.loadLOBDataFromFileSystem();
        }
        return this.loadLOBDataFromDB();
    }

    private boolean loadLOBDataFromDB() {
        this.m_items = new ArrayList();
        byte[] data = this.getBinaryData();
        if (data == null) {
            return true;
        }
        this.log.fine("ZipSize=" + data.length);
        if (data.length == 0) {
            return true;
        }
        if (!ZIP.equals(this.getTitle())) {
            this.m_items.add(new MAttachmentEntry(this.getTitle(), data, 1));
            return true;
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ZipInputStream zip = new ZipInputStream(in);
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[2048];
                int length = zip.read(buffer);
                while (length != -1) {
                    out.write(buffer, 0, length);
                    length = zip.read(buffer);
                }
                byte[] dataEntry = out.toByteArray();
                this.log.fine(String.valueOf(name) + " - size=" + dataEntry.length + " - zip=" + entry.getCompressedSize() + "(" + entry.getSize() + ") " + entry.getCompressedSize() * 100L / entry.getSize() + "%");
                this.m_items.add(new MAttachmentEntry(name, dataEntry, this.m_items.size() + 1));
                entry = zip.getNextEntry();
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "loadLOBData", e);
            this.m_items = null;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadLOBDataFromFileSystem() {
        if ("".equals(this.m_attachmentPathRoot)) {
            this.log.severe("no attachmentPath defined");
            return false;
        }
        this.m_items = new ArrayList();
        byte[] data = this.getBinaryData();
        if (data == null) {
            return true;
        }
        this.log.fine("TextFileSize=" + data.length);
        if (data.length == 0) {
            return true;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(data));
            NodeList entries = document.getElementsByTagName("entry");
            int i = 0;
            while (true) {
                if (i >= entries.getLength()) {
                    return true;
                }
                Node entryNode = entries.item(i);
                NamedNodeMap attributes = entryNode.getAttributes();
                Node fileNode = attributes.getNamedItem("file");
                Node nameNode = attributes.getNamedItem("name");
                if (fileNode == null || nameNode == null) {
                    this.log.severe("no filename for entry " + i);
                    this.m_items = null;
                    return false;
                }
                this.log.fine("name: " + nameNode.getNodeValue());
                String filePath = fileNode.getNodeValue();
                this.log.fine("filePath: " + filePath);
                if (filePath != null) {
                    filePath = filePath.replaceFirst("%ATTACHMENT_FOLDER%", this.m_attachmentPathRoot.replaceAll("\\\\", "\\\\\\\\"));
                    String replaceSeparator = File.separator;
                    if (!replaceSeparator.equals("/")) {
                        replaceSeparator = "\\\\";
                    }
                    filePath = filePath.replaceAll("/", replaceSeparator);
                    filePath = filePath.replaceAll("\\\\", replaceSeparator);
                }
                this.log.fine("filePath: " + filePath);
                File file = new File(filePath);
                if (file.exists()) {
                    byte[] dataEntry = new byte[(int)file.length()];
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        fileInputStream.read(dataEntry);
                        fileInputStream.close();
                    }
                    catch (FileNotFoundException e) {
                        this.log.severe("File Not Found.");
                        e.printStackTrace();
                    }
                    catch (IOException e1) {
                        this.log.severe("Error Reading The File.");
                        e1.printStackTrace();
                    }
                    MAttachmentEntry entry = new MAttachmentEntry(filePath, dataEntry, this.m_items.size() + 1);
                    this.m_items.add(entry);
                } else {
                    this.log.severe("file not found: " + file.getAbsolutePath());
                }
                ++i;
            }
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
            this.log.severe(x.getMessage());
            return true;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            this.log.severe(pce.getMessage());
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.log.severe(ioe.getMessage());
        }
        return true;
    }

    public String getAttachmentPathSnippet() {
        return String.valueOf(this.getAD_Client_ID()) + File.separator + this.getAD_Org_ID() + File.separator + this.getAD_Table_ID() + File.separator + this.getRecord_ID();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isStoreAttachmentsOnFileSystem) {
            if (this.getTitle() == null || !this.getTitle().equals(XML)) {
                this.setTitle(XML);
            }
        } else if (this.getTitle() == null || !this.getTitle().equals(ZIP)) {
            this.setTitle(ZIP);
        }
        return this.saveLOBData();
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isStoreAttachmentsOnFileSystem) {
            int i = 0;
            while (i < this.m_items.size()) {
                MAttachmentEntry entry = this.m_items.get(i);
                File file = entry.getFile();
                if (file != null && file.exists() && !file.delete()) {
                    this.log.warning("unable to delete " + file.getAbsolutePath());
                }
                ++i;
            }
            File folder = new File(String.valueOf(this.m_attachmentPathRoot) + this.getAttachmentPathSnippet());
            if (folder.exists() && !folder.delete()) {
                this.log.warning("unable to delete " + folder.getAbsolutePath());
            }
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(MimeType.getMimeType("data.xls"));
        System.out.println(MimeType.getMimeType("data.cvs"));
        System.out.println(MimeType.getMimeType("data.txt"));
        System.out.println(MimeType.getMimeType("data.log"));
        System.out.println(MimeType.getMimeType("data.html"));
        System.out.println(MimeType.getMimeType("data.htm"));
        System.out.println(MimeType.getMimeType("data.png"));
        System.out.println(MimeType.getMimeType("data.gif"));
        System.out.println(MimeType.getMimeType("data.jpg"));
        System.out.println(MimeType.getMimeType("data.xml"));
        System.out.println(MimeType.getMimeType("data.rtf"));
        System.exit(0);
        Adempiere.startupEnvironment(true);
        MAttachment att = new MAttachment(Env.getCtx(), 100, 0, null);
        att.addEntry(new File("C:\\Adempiere\\Dev.properties"));
        att.addEntry(new File("C:\\Adempiere\\index.html"));
        att.saveEx();
        System.out.println(att);
        att.dumpEntryNames();
        int AD_Attachment_ID = att.getAD_Attachment_ID();
        System.out.println("===========================================");
        att = new MAttachment(Env.getCtx(), AD_Attachment_ID, null);
        System.out.println(att);
        att.dumpEntryNames();
        System.out.println("===========================================");
        MAttachmentEntry[] entries = att.getEntries();
        int i = 0;
        while (i < entries.length) {
            MAttachmentEntry entry = entries[i];
            entry.dump();
            ++i;
        }
        System.out.println("===========================================");
        att.delete(true);
    }

    public boolean updateEntry(int i, File file) {
        if (file == null) {
            this.log.warning("No File");
            return false;
        }
        if (!file.exists() || file.isDirectory() || !file.canRead()) {
            this.log.warning("not added - " + file + ", Exists=" + file.exists() + ", Directory=" + file.isDirectory());
            return false;
        }
        this.log.fine("updateEntry - " + file);
        String name = file.getName();
        byte[] data = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int length = -1;
            while ((length = fis.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            fis.close();
            data = os.toByteArray();
            os.close();
        }
        catch (IOException ioe) {
            this.log.log(Level.SEVERE, "(file)", ioe);
        }
        return this.updateEntry(i, data);
    }

    public boolean updateEntry(int i, byte[] data) {
        MAttachmentEntry entry = this.getEntry(i);
        if (entry == null) {
            return false;
        }
        entry.setData(data);
        return true;
    }
}

