/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.util.POCacheLocal;
import org.compiere.FA.exceptions.AssetAlreadyDepreciatedException;
import org.compiere.FA.exceptions.AssetCheckDocumentException;
import org.compiere.FA.exceptions.AssetException;
import org.compiere.FA.exceptions.AssetNotImplementedException;
import org.compiere.FA.exceptions.AssetNotSupportedException;
import org.compiere.FA.feature.UseLifeImpl;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetChange;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.MAssetProduct;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRateUtil;
import org.compiere.model.MConversionType;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MFactAcct;
import org.compiere.model.MIFixedAsset;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_A_Asset_Addition;
import org.compiere.model.X_A_Asset_Group_Acct;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_M_AttributeSetInstance;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProjectClose;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class MAssetAddition
extends X_A_Asset_Addition
implements DocAction {
    private static final long serialVersionUID = 5977180589101094202L;
    private static CLogger s_log = CLogger.getCLogger(MAssetAddition.class);
    private final POCacheLocal<MProject> m_cacheCProject = POCacheLocal.newInstance(this, MProject.class);
    private final POCacheLocal<MMatchInv> m_cacheMatchInv = POCacheLocal.newInstance(this, MMatchInv.class);
    private final POCacheLocal<MIFixedAsset> m_cacheIFixedAsset = POCacheLocal.newInstance(this, MIFixedAsset.class);
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private final POCacheLocal<MAsset> m_cacheAsset = POCacheLocal.newInstance(this, MAsset.class);

    public MAssetAddition(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setProcessed(false);
        }
    }

    public MAssetAddition(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        this.setA_CreateAsset();
        MAssetGroupAcct mAssetGroupAcct = MAssetGroupAcct.forA_Asset_Group_ID(this.getCtx(), this.getA_Asset().getA_Asset_Group_ID(), "A");
        if (this.isA_CreateAsset()) {
            this.setDeltaUseLifeYears(mAssetGroupAcct.getUseLifeYears());
            this.setDeltaUseLifeYears_F(mAssetGroupAcct.getUseLifeYears_F());
        }
        if ("INV".equals(this.getA_SourceType())) {
            MInvoiceLine mInvoiceLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
            if ("Cap".equals(mInvoiceLine.getA_CapvsExp()) && mInvoiceLine.getA_Asset_ID() == 0) {
                if (!mInvoiceLine.get_ValueAsBoolean("IsCollectiveAsset")) {
                    this.setA_QTY_Current(Env.ONE);
                } else {
                    this.setA_QTY_Current(mInvoiceLine.getQtyEntered());
                }
            }
            if ("Cap".equals(mInvoiceLine.getA_CapvsExp()) && mInvoiceLine.getA_Asset_ID() > 0) {
                this.setA_QTY_Current(Env.ZERO);
                this.setA_CreateAsset(false);
            }
            this.setA_CapvsExp(mInvoiceLine.getA_CapvsExp());
        }
        if (this.isA_CreateAsset() && this.getA_QTY_Current().signum() == 0 && !"INV".equals(this.getA_SourceType())) {
            this.setA_QTY_Current(Env.ONE);
        }
        if (this.getC_Currency_ID() <= 0) {
            this.setC_Currency_ID(MClient.get(this.getCtx()).getAcctSchema().getC_Currency_ID());
        }
        if (this.getC_ConversionType_ID() <= 0) {
            this.setC_ConversionType_ID(MConversionType.getDefault(this.getAD_Client_ID()));
        }
        this.getDateAcct();
        this.setAssetValueAmt();
        if (this.isA_CreateAsset()) {
            this.setA_CapvsExp("Cap");
        }
        this.setIsApproved();
        return true;
    }

    public static MAssetAddition createAsset(MMatchInv mMatchInv) {
        MAssetAddition mAssetAddition = new MAssetAddition(mMatchInv);
        mAssetAddition.dump();
        if ("Cap".equals(mAssetAddition.getA_CapvsExp()) && mMatchInv.getC_InvoiceLine().getA_Asset_ID() == 0 && mAssetAddition.isA_CreateAsset()) {
            MAsset mAsset = mAssetAddition.createAsset();
            mAsset.dump();
            MAssetGroupAcct mAssetGroupAcct = MAssetGroupAcct.forA_Asset_Group_ID(mAsset.getCtx(), mAsset.getA_Asset_Group_ID(), mAssetAddition.getPostingType());
            mAssetAddition.setDeltaUseLifeYears(mAssetGroupAcct.getUseLifeYears());
            mAssetAddition.setDeltaUseLifeYears_F(mAssetGroupAcct.getUseLifeYears_F());
        } else {
            mAssetAddition.setA_Asset_ID(mMatchInv.getC_InvoiceLine().getA_Asset_ID());
            mAssetAddition.setA_CreateAsset(false);
        }
        mAssetAddition.saveEx();
        return mAssetAddition;
    }

    public static MAssetAddition createAsset(MIFixedAsset mIFixedAsset) {
        MAssetAddition mAssetAddition = new MAssetAddition(mIFixedAsset);
        mAssetAddition.dump();
        if ("Cap".equals(mAssetAddition.getA_CapvsExp()) && mIFixedAsset.getA_Asset_ID() == 0) {
            MAsset mAsset = mAssetAddition.createAsset();
            mAsset.dump();
        }
        mAssetAddition.saveEx();
        return mAssetAddition;
    }

    public static MAssetAddition createAsset(MProject mProject, MProduct mProduct) {
        PO pO;
        MAssetAddition mAssetAddition = new MAssetAddition(mProject);
        mAssetAddition.dump();
        MAsset mAsset = mAssetAddition.createAsset();
        if (mProduct != null) {
            mAsset.setM_Product_ID(mProduct.getM_Product_ID());
            mAsset.setA_Asset_Group_ID(mProduct.getA_Asset_Group_ID());
            pO = MAttributeSetInstance.create(Env.getCtx(), mProduct, null);
            mAsset.setM_AttributeSetInstance_ID(((X_M_AttributeSetInstance)pO).getM_AttributeSetInstance_ID());
        }
        mAsset.setName(mProduct.getName().concat(mProject.getName()));
        mAsset.setValue(mProduct.getName().concat(mProject.getName()));
        mAsset.saveEx();
        mAsset.dump();
        pO = MAssetGroupAcct.forA_Asset_Group_ID(mAsset.getCtx(), mAsset.getA_Asset_Group_ID(), mAssetAddition.getPostingType());
        mAssetAddition.setDeltaUseLifeYears(((X_A_Asset_Group_Acct)pO).getUseLifeYears());
        mAssetAddition.setDeltaUseLifeYears_F(((X_A_Asset_Group_Acct)pO).getUseLifeYears_F());
        mAssetAddition.setA_Asset(mAsset);
        mAssetAddition.saveEx();
        return mAssetAddition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MAsset createAsset() {
        MAsset mAsset = null;
        if (this.getA_Asset_ID() > 0) return this.getA_Asset(false);
        String string = this.getA_SourceType();
        if ("INV".equals(string)) {
            mAsset = new MAsset(this.getMatchInv(false));
            mAsset.saveEx();
            mAsset.setName(mAsset.getName() + "-" + mAsset.getInventoryNo());
            mAsset.saveEx();
            this.setA_Asset(mAsset);
            return mAsset;
        } else if ("IMP".equals(string)) {
            mAsset = new MAsset(this.getI_FixedAsset(false));
            mAsset.saveEx();
            this.setA_Asset(mAsset);
            return mAsset;
        } else {
            if (!"PRJ".equals(string)) throw new AssetNotSupportedException("A_SourceType", string);
            return new MAsset(this.getC_Project(false));
        }
    }

    private MAssetAddition(MMatchInv mMatchInv) {
        this(mMatchInv.getCtx(), 0, mMatchInv.get_TrxName());
        this.setM_MatchInv(mMatchInv);
        this.setC_DocType_ID();
    }

    private MAssetAddition(MProject mProject) {
        this(mProject.getCtx(), 0, mProject.get_TrxName());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Entering: Project=" + mProject);
        }
        this.setAD_Org_ID(mProject.getAD_Org_ID());
        this.setPostingType("A");
        this.setA_SourceType("PRJ");
        this.setC_Currency_ID(mProject.getC_Currency_ID());
        if (mProject.get_ValueAsInt("C_ConversionType_ID") > 0) {
            this.setC_ConversionType_ID(mProject.get_ValueAsInt("C_ConversionType_ID"));
        }
        this.setSourceAmt(mProject.getProjectBalanceAmt());
        this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        this.setA_CreateAsset(true);
        this.setDeltaUseLifeYears(I_ZERO);
        this.setDeltaUseLifeYears_F(I_ZERO);
        this.setC_DocType_ID();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        if (timestamp != null) {
            timestamp = UseLifeImpl.getDateAcct(timestamp, 1);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DateAcct=" + timestamp);
            }
            this.setDateAcct(timestamp);
        }
        this.setC_Project(mProject);
    }

    public MProject getC_Project(boolean bl) {
        return this.m_cacheCProject.get(bl);
    }

    private void setC_Project(MProject mProject) {
        this.set_Value("C_Project_ID", (Object)mProject.get_ID());
        this.m_cacheCProject.set(mProject);
    }

    private MAssetAddition(MIFixedAsset mIFixedAsset) {
        this(mIFixedAsset.getCtx(), 0, mIFixedAsset.get_TrxName());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Entering: ifa=" + mIFixedAsset);
        }
        this.setAD_Org_ID(mIFixedAsset.getAD_Org_ID());
        this.setPostingType("A");
        this.setA_SourceType("IMP");
        this.setM_Product_ID(mIFixedAsset.getM_Product_ID());
        this.setSourceAmt(mIFixedAsset.getA_Asset_Cost());
        this.setDateDoc(mIFixedAsset.getAssetServiceDate());
        this.setM_Locator_ID(mIFixedAsset.getM_Locator_ID());
        boolean bl = mIFixedAsset.getA_Accumulated_Depr().compareTo(Env.ZERO) > 0;
        this.setA_Accumulated_Depr_Adjust(bl);
        if (mIFixedAsset.getA_Current_Period() == 0) {
            this.setA_Period_Start(mIFixedAsset.getUseLifeMonths() + 1);
            mIFixedAsset.setA_Accumulated_Depr_F(mIFixedAsset.getA_Accumulated_Depr());
            mIFixedAsset.setUseLifeMonths_F(mIFixedAsset.getUseLifeMonths());
        } else {
            this.setA_Period_Start(mIFixedAsset.getA_Current_Period());
        }
        this.setA_Accumulated_Depr(mIFixedAsset.getA_Accumulated_Depr());
        this.setA_Accumulated_Depr_F(mIFixedAsset.getA_Accumulated_Depr_F());
        this.setDeltaUseLifeYears(mIFixedAsset.getUseLifeMonths() / 12);
        this.setDeltaUseLifeYears_F(mIFixedAsset.getUseLifeMonths_F() / 12);
        this.setA_CapvsExp("Cap");
        this.setA_CreateAsset(true);
        this.setA_Salvage_Value(mIFixedAsset.getA_Salvage_Value());
        this.setC_DocType_ID();
        Timestamp timestamp = mIFixedAsset.getDateAcct();
        if (timestamp != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DateAcct=" + timestamp);
            }
            this.setDateAcct(timestamp);
        }
        this.setI_FixedAsset(mIFixedAsset);
    }

    private MMatchInv getMatchInv(boolean bl) {
        return this.m_cacheMatchInv.get(bl);
    }

    private void setM_MatchInv(MMatchInv mMatchInv) {
        MInvoiceLine mInvoiceLine = new MInvoiceLine(this.getCtx(), mMatchInv.getC_InvoiceLine_ID(), this.get_TrxName());
        mMatchInv.load(this.get_TrxName());
        this.setAD_Org_ID(mMatchInv.getAD_Org_ID());
        this.setPostingType("A");
        this.setA_SourceType("INV");
        this.setM_MatchInv_ID(mMatchInv.get_ID());
        if ("Cap".equals(mMatchInv.getC_InvoiceLine().getA_CapvsExp())) {
            if (mMatchInv.getC_InvoiceLine().getA_Asset_ID() == 0) {
                this.setA_CreateAsset(true);
            }
            if (mMatchInv.getC_InvoiceLine().getA_Asset_ID() > 0) {
                this.setA_CreateAsset(false);
            }
        } else {
            this.setA_CreateAsset(false);
        }
        this.setC_Invoice_ID(mMatchInv.getC_InvoiceLine().getC_Invoice_ID());
        this.setC_InvoiceLine_ID(mMatchInv.getC_InvoiceLine_ID());
        this.setM_InOutLine_ID(mMatchInv.getM_InOutLine_ID());
        this.setM_Product_ID(mMatchInv.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(mMatchInv.getM_AttributeSetInstance_ID());
        this.setLine(mMatchInv.getC_InvoiceLine().getLine());
        this.setM_Locator_ID(mMatchInv.getM_InOutLine().getM_Locator_ID());
        this.setA_CapvsExp(mMatchInv.getC_InvoiceLine().getA_CapvsExp());
        this.setC_Currency_ID(mMatchInv.getC_InvoiceLine().getC_Invoice().getC_Currency_ID());
        this.setC_ConversionType_ID(mMatchInv.getC_InvoiceLine().getC_Invoice().getC_ConversionType_ID());
        this.setDateDoc(mMatchInv.getM_InOutLine().getM_InOut().getMovementDate());
        this.setDateAcct(mMatchInv.getM_InOutLine().getM_InOut().getMovementDate());
        if ("Cap".equals(mInvoiceLine.getA_CapvsExp()) && mInvoiceLine.get_ValueAsBoolean("IsCollectiveAsset")) {
            this.setA_QTY_Current(mMatchInv.getQty());
            this.setAssetAmtEntered(mMatchInv.getC_InvoiceLine().getLineNetAmt());
            this.setAssetSourceAmt(mMatchInv.getC_InvoiceLine().getLineNetAmt());
        }
        if ("Cap".equals(mInvoiceLine.getA_CapvsExp()) && !mInvoiceLine.get_ValueAsBoolean("IsCollectiveAsset") && mInvoiceLine.getA_Asset_ID() <= 0) {
            this.setA_QTY_Current(Env.ONE);
            this.setAssetAmtEntered(mMatchInv.getC_InvoiceLine().getLineNetAmt().divide(mMatchInv.getQty()));
            this.setAssetSourceAmt(mMatchInv.getC_InvoiceLine().getLineNetAmt().divide(mMatchInv.getQty()));
        }
        if ("Cap".equals(mInvoiceLine.getA_CapvsExp()) && mInvoiceLine.getA_Asset_ID() > 0 || "Exp".equals(mInvoiceLine.getA_CapvsExp())) {
            this.setA_QTY_Current(Env.ZERO);
            this.setAssetAmtEntered(mMatchInv.getC_InvoiceLine().getLineNetAmt());
            this.setAssetSourceAmt(mMatchInv.getC_InvoiceLine().getLineNetAmt());
        }
        this.m_cacheMatchInv.set(mMatchInv);
    }

    public static boolean setM_MatchInv(SetGetModel setGetModel, int n) {
        boolean bl = false;
        String string = null;
        if (setGetModel instanceof PO) {
            PO pO = (PO)((Object)setGetModel);
            bl = pO.is_new();
            string = pO.get_TrxName();
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("Entering: model=" + setGetModel + ", M_MatchInv_ID=" + n + ", newRecord=" + bl + ", trxName=" + string);
        }
        String string2 = "SELECT  C_Invoice_ID, C_InvoiceLine_ID, M_InOutLine_ID, M_Product_ID, M_AttributeSetInstance_ID, Qty AS A_QTY_Current, InvoiceLine AS Line, M_Locator_ID, A_CapVsExp, MatchNetAmt AS AssetAmtEntered, MatchNetAmt AS AssetSourceAmt, C_Currency_ID, C_ConversionType_ID, MovementDate AS DateDoc";
        if (bl) {
            string2 = string2 + ", A_Asset_ID, A_CreateAsset";
        }
        string2 = string2 + " FROM mb_matchinv WHERE M_MatchInv_ID=" + n;
        SetGetUtil.updateColumns(setGetModel, null, string2, string);
        s_log.fine("Leaving: RETURN TRUE");
        return true;
    }

    public MIFixedAsset getI_FixedAsset(boolean bl) {
        return this.m_cacheIFixedAsset.get(bl);
    }

    private void setI_FixedAsset(MIFixedAsset mIFixedAsset) {
        this.setI_FixedAsset_ID(mIFixedAsset.get_ID());
        this.m_cacheIFixedAsset.set(mIFixedAsset);
    }

    private void setAssetValueAmt() {
        this.getDateAcct();
        MConversionRateUtil.convertBase(SetGetUtil.wrap(this), "DateAcct", "AssetSourceAmt", "AssetValueAmt", null);
    }

    public void setSourceAmt(BigDecimal bigDecimal) {
        this.setAssetAmtEntered(bigDecimal);
        this.setAssetSourceAmt(bigDecimal);
    }

    public void setIsApproved() {
        if (!this.isProcessed()) {
            String string = Env.getContext(this.getCtx(), "#IsCanApproveOwnDoc");
            boolean bl = "Y".equals(string);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#IsCanApproveOwnDoc=" + string + "=" + bl);
            }
            this.setIsApproved(bl);
        }
    }

    @Override
    public Timestamp getDateAcct() {
        Timestamp timestamp = super.getDateAcct();
        if (timestamp == null) {
            timestamp = this.getDateDoc();
            this.setDateAcct(timestamp);
        }
        return timestamp;
    }

    @Override
    public boolean processIt(String string) {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        return false;
    }

    @Override
    public String prepareIt() {
        List list;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "FAA", this.getAD_Org_ID());
        this.setA_CreateAsset();
        if (this.getAssetValueAmt().signum() == 0) {
            this.m_processMsg = "@Invalid@ @AssetValueAmt@=0";
            return "IN";
        }
        MAsset mAsset = this.getA_Asset(true);
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if ("DI".equals(mAsset.getA_Asset_Status())) {
            this.m_processMsg = "Asset aldready disposed";
            return "IN";
        }
        if (!"NW".equals(mAsset.getA_Asset_Status()) && mDepreciationWorkfile != null && mDepreciationWorkfile.getDateAcct() != null && mDepreciationWorkfile.isDepreciated(this.getDateAcct())) {
            this.m_processMsg = "Asset already depreciated for this period";
            return "IN";
        }
        if (this.getDateDoc().before(mAsset.getA_Asset_CreateDate())) {
            throw new AssetCheckDocumentException("Document is date older than Asset Create Date");
        }
        if (mAsset.getAssetServiceDate() != null && this.getDateDoc().before(mAsset.getAssetServiceDate())) {
            throw new AssetCheckDocumentException("Document is date older than Asset Service Date");
        }
        if (this.isA_CreateAsset() && this.hasZeroValues()) {
            throw new AssetException("New document must have non-zero values");
        }
        if (!this.isA_CreateAsset() && this.getDeltaUseLifeYears() < 0) {
            throw new AssetException("Delta Use Life Years cannot be negative values");
        }
        if ("DP".equals(mAsset.getA_Asset_Status())) {
            throw new AssetException("Asset is fully depreciated");
        }
        if (this.isA_CreateAsset() && !"NW".equals(mAsset.getA_Asset_Status())) {
            throw new AssetException("Only new assets can be activated");
        }
        if ("INV".equals(this.getA_SourceType())) {
            int n = this.getC_Invoice_ID();
            list = new MInvoice(this.getCtx(), n, this.get_TrxName());
            if ("VO".equals(((X_C_Invoice)((Object)list)).getDocStatus())) {
                throw new AssetException("You cannot add asset from voided document(s)");
            }
        }
        if ("PRJ".equals(this.getA_SourceType())) {
            if (this.getC_Project_ID() <= 0) {
                throw new FillMandatoryException(new String[]{"C_Project_ID"});
            }
            list = new Query(this.getCtx(), "A_Asset_Addition", "C_Project_ID=? AND DocStatus IN ('IP','CO','CL') AND A_Asset_Addition_ID<>?", this.get_TrxName()).setParameters(this.getC_Project_ID(), this.get_ID()).list();
            if (list.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder("You can not create project for this asset, Project already has assets. View: ");
                for (MAssetAddition mAssetAddition : list) {
                    stringBuilder.append(mAssetAddition.getDocumentInfo()).append("; ");
                }
                throw new AssetException(stringBuilder.toString());
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        Object object;
        if (!this.m_justPrepared && !"IP".equals(object = this.prepareIt())) {
            return object;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.checkCreateASI();
        object = this.getA_Asset(!this.m_justPrepared);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("asset=" + object);
        }
        if (object == null) {
            this.m_processMsg = "Asset not created/selected";
            return "IN";
        }
        ((X_A_Asset)object).setM_AttributeSetInstance_ID(this.getM_AttributeSetInstance_ID());
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (mDepreciationWorkfile == null) {
            mDepreciationWorkfile = new MDepreciationWorkfile((MAsset)object, this.getPostingType(), null);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("workfile: " + mDepreciationWorkfile);
        }
        if (this.getA_CapvsExp().equals("Cap")) {
            MDepreciationExp.checkExistsNotProcessedEntries(mDepreciationWorkfile.getCtx(), mDepreciationWorkfile.getA_Asset_ID(), this.getDateAcct(), mDepreciationWorkfile.getPostingType(), mDepreciationWorkfile.get_TrxName());
            if (this.getA_Salvage_Value().signum() > 0) {
                mDepreciationWorkfile.setA_Salvage_Value(this.getA_Salvage_Value());
            }
            mDepreciationWorkfile.adjustCost(this.getAssetValueAmt(), this.getA_QTY_Current(), this.isA_CreateAsset());
            mDepreciationWorkfile.adjustUseLife(this.getDeltaUseLifeYears(), this.getDeltaUseLifeYears_F(), this.isA_CreateAsset());
            mDepreciationWorkfile.setDateAcct(this.getDateAcct());
            mDepreciationWorkfile.setProcessed(true);
            mDepreciationWorkfile.saveEx();
        }
        MAssetChange.createAddition(this, mDepreciationWorkfile);
        if (this.isA_CreateAsset() && this.getM_Locator_ID() > 0) {
            ((X_A_Asset)object).setM_Locator_ID(this.getM_Locator_ID());
        }
        this.updateA_Asset_Product(false);
        if (this.isA_CreateAsset()) {
            ((X_A_Asset)object).setAssetServiceDate(this.getDateDoc());
            ((MAsset)object).changeStatus("AC", this.getDateAcct());
            ((X_A_Asset)object).setA_QTY_Original(this.getA_QTY_Current());
        }
        ((PO)object).saveEx();
        if (this.isA_CreateAsset() && !this.isA_Accumulated_Depr_Adjust()) {
            mDepreciationWorkfile.setA_Current_Period(1);
            mDepreciationWorkfile.saveEx();
        }
        if (this.isA_CreateAsset() && this.isA_Accumulated_Depr_Adjust()) {
            mDepreciationWorkfile.setA_Current_Period(this.getA_Period_Start());
            mDepreciationWorkfile.setA_Accumulated_Depr(this.getA_Accumulated_Depr());
            mDepreciationWorkfile.setA_Accumulated_Depr_F(this.getA_Accumulated_Depr_F());
            mDepreciationWorkfile.saveEx();
        }
        mDepreciationWorkfile.buildDepreciation();
        this.updateSourceDocument(false);
        this.setProcessed(true);
        this.setDocAction("CL");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (this.m_processMsg != null) {
            return "IN";
        }
        return "CO";
    }

    @Override
    public boolean voidIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.setA_CreateAsset(false);
        } else {
            this.reverseIt(false);
        }
        String string = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (string != null) {
            this.m_processMsg = string;
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    private void reverseIt(boolean bl) {
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.setDocAction("--");
            throw new AssetException("Document Closed: " + this.getDocStatus());
        }
        MAsset mAsset = this.getA_Asset(true);
        if ("DI".equals(mAsset.getA_Asset_Status())) {
            this.setDocAction("--");
            throw new AssetException("Asset already disposed");
        }
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (mDepreciationWorkfile == null) {
            throw new AssetException("@NotFound@ @A_DepreciationWorkfile_ID");
        }
        List list = new Query(this.getCtx(), "A_Asset_Addition", "A_Asset_Addition_ID>? AND A_Asset_ID=? AND A_CapvsExp=? AND M_AttributeSetInstance_ID>? AND AssetAmtEntered>? AND DateAcct>=? AND Processed=?", this.get_TrxName()).setParameters(this.getA_Asset_Addition_ID(), this.getA_Asset_ID(), "Cap", this.getM_AttributeSetInstance_ID(), BigDecimal.ZERO, this.getDateAcct(), "Y").setOrderBy("DateAcct ASC ,A_Asset_Addition_ID ASC ,M_AttributeSetInstance_ID ASC ").list();
        if (mDepreciationWorkfile.isFullyDepreciated()) {
            throw new AssetNotImplementedException("Unable to verify if it is fully depreciated");
        }
        if (mDepreciationWorkfile.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        mDepreciationWorkfile.adjustCost(this.getAssetValueAmt().negate(), this.getA_QTY_Current().negate(), false);
        mDepreciationWorkfile.adjustUseLife(0 - this.getDeltaUseLifeYears(), 0 - this.getDeltaUseLifeYears_F(), false);
        mDepreciationWorkfile.saveEx();
        if (list.size() == 0) {
            if (this.isA_CreateAsset()) {
                mDepreciationWorkfile.buildDepreciation();
                mDepreciationWorkfile.deleteEx(true);
            } else {
                mDepreciationWorkfile.buildDepreciation();
            }
        } else {
            mDepreciationWorkfile.setA_Current_Period();
            mDepreciationWorkfile.saveEx();
            mDepreciationWorkfile.buildDepreciation();
        }
        this.updateA_Asset_Product(true);
        if (this.isA_CreateAsset() && list.size() == 0) {
            mAsset.changeStatus("NW", this.getDateAcct());
            mAsset.saveEx();
            if (!bl) {
                this.setA_CreateAsset(false);
            }
        }
        MFactAcct.deleteEx(this.get_Table_ID(), this.get_ID(), this.get_TrxName());
        this.updateSourceDocument(true);
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        throw new AssetNotImplementedException("reverseCorrectIt");
    }

    @Override
    public boolean reverseAccrualIt() {
        throw new AssetNotImplementedException("reverseAccrualIt");
    }

    @Override
    public boolean reActivateIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.reverseIt(true);
        String string = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (string != null) {
            this.m_processMsg = string;
            return false;
        }
        this.setProcessed(false);
        this.setDocAction("CO");
        return true;
    }

    @Override
    public String getSummary() {
        MAsset mAsset = this.getA_Asset(false);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@DocumentNo@ #").append(this.getDocumentNo()).append(": @A_CreateAsset@=@").append(this.isA_CreateAsset() ? "Y" : "N").append("@");
        if (mAsset != null) {
            stringBuilder.append(", @A_Asset_ID@=").append(mAsset.getName());
        }
        return Msg.parseTranslation(this.getCtx(), stringBuilder.toString());
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getAssetValueAmt();
    }

    public MAsset getA_Asset(boolean bl) {
        return this.m_cacheAsset.get(bl);
    }

    private void setA_Asset(MAsset mAsset) {
        this.setA_Asset_ID(mAsset.getA_Asset_ID());
        this.m_cacheAsset.set(mAsset);
    }

    @Override
    protected boolean afterSave(boolean bl, boolean bl2) {
        if (!bl2) {
            return false;
        }
        this.updateSourceDocument(false);
        return true;
    }

    private void updateSourceDocument(boolean bl) {
        String string;
        boolean bl2 = bl;
        String string2 = this.getDocStatus();
        if (!bl2 && ("RE".equals(string2) || "VO".equals(string2))) {
            bl2 = true;
        }
        if ("INV".equals(string = this.getA_SourceType()) && this.isProcessed()) {
            int n = this.getC_InvoiceLine_ID();
            MInvoiceLine mInvoiceLine = new MInvoiceLine(this.getCtx(), n, this.get_TrxName());
            mInvoiceLine.setA_Processed(!bl2);
            mInvoiceLine.setA_Asset_ID(bl2 ? 0 : this.getA_Asset_ID());
            mInvoiceLine.saveEx();
        } else if ("PRJ".equals(string) && this.isProcessed()) {
            if (!bl2) {
                int n = this.getC_Project_ID();
                ProcessInfo processInfo = new ProcessInfo("", 0, MProject.Table_ID, n);
                processInfo.setAD_Client_ID(this.getAD_Client_ID());
                processInfo.setAD_User_ID(Env.getAD_User_ID(this.getCtx()));
                ProjectClose projectClose = new ProjectClose();
                projectClose.startProcess(this.getCtx(), processInfo, Trx.get(this.get_TrxName(), false));
                if (processInfo.isError()) {
                    throw new AssetException(processInfo.getSummary());
                }
            }
        } else if ("IMP".equals(string) && !this.isProcessed()) {
            MIFixedAsset mIFixedAsset;
            if (this.is_new() && this.getI_FixedAsset_ID() > 0 && (mIFixedAsset = this.getI_FixedAsset(false)) != null) {
                mIFixedAsset.setI_IsImported(true);
                mIFixedAsset.setA_Asset_ID(this.getA_Asset_ID());
                mIFixedAsset.saveEx(this.get_TrxName());
            }
        } else if ("MAN".equals(string) && this.isProcessed()) {
            this.log.fine("Nothing to do");
        }
    }

    private void checkCreateASI() {
        MProduct mProduct = MProduct.get(this.getCtx(), this.getM_Product_ID());
        MAttributeSetInstance mAttributeSetInstance = null;
        if (mProduct != null && this.getM_AttributeSetInstance_ID() == 0) {
            mAttributeSetInstance = new MAttributeSetInstance(this.getCtx(), 0, this.get_TrxName());
            mAttributeSetInstance.setAD_Org_ID(0);
            mAttributeSetInstance.setM_AttributeSet_ID(mProduct.getM_AttributeSet_ID());
            mAttributeSetInstance.saveEx();
            this.setM_AttributeSetInstance_ID(mAttributeSetInstance.getM_AttributeSetInstance_ID());
        }
    }

    private void updateA_Asset_Product(boolean bl) {
        if (this.getM_Product_ID() <= 0) {
            return;
        }
        MAssetProduct mAssetProduct = MAssetProduct.getCreate(this.getCtx(), this.getA_Asset_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
        if (mAssetProduct.get_ID() <= 0 && bl) {
            this.log.warning("No Product found " + this + " [IGNORE]");
            return;
        }
        BigDecimal bigDecimal = this.getA_QTY_Current();
        if (bl) {
            bigDecimal = bigDecimal.negate();
        }
        mAssetProduct.addA_Qty_Current(bigDecimal);
        MAsset mAsset = this.getA_Asset(false);
        mAssetProduct.addA_Qty_Current(mAsset.getA_QTY_Current());
        mAssetProduct.setM_Locator_ID(this.getM_Locator_ID());
        if (mAsset.getA_Asset_Status().equals("AC") && mAssetProduct.getA_QTY_Current().compareTo(BigDecimal.ZERO) <= 0 && !bl) {
            mAssetProduct.addA_Qty_Current(BigDecimal.ONE);
        }
        mAssetProduct.setAD_Org_ID(this.getA_Asset().getAD_Org_ID());
        mAssetProduct.saveEx();
        if (this.isA_CreateAsset()) {
            mAssetProduct.updateAsset(mAsset);
            mAsset.setA_QTY_Current(this.getA_QTY_Current());
            mAsset.setA_QTY_Original(this.getA_QTY_Current());
            mAsset.setQty(this.getA_QTY_Current());
            mAsset.saveEx();
        } else {
            mAsset.setA_QTY_Current(mAssetProduct.getA_QTY_Current());
            mAsset.setQty(mAssetProduct.getA_QTY_Current());
            mAsset.saveEx();
        }
    }

    public boolean hasZeroValues() {
        return this.getDeltaUseLifeYears() <= 0 || this.getAssetValueAmt().signum() <= 0;
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo() + " / " + this.getDateDoc();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("@DocumentNo@: " + this.getDocumentNo());
        MAsset mAsset = this.getA_Asset(false);
        if (mAsset != null && mAsset.get_ID() > 0) {
            stringBuilder.append(", @A_Asset_ID@: ").append(mAsset.getName());
        }
        return stringBuilder.toString();
    }

    private void setA_CreateAsset() {
        if ("VO".equals(this.getDocStatus())) {
            this.setA_CreateAsset(false);
        } else {
            int n = DB.getSQLValueEx(null, "SELECT COUNT(*) FROM A_Asset_Addition WHERE A_Asset_ID=? AND A_CreateAsset='Y' AND DocStatus IN ('CO','CL') AND IsActive='Y' AND A_Asset_Addition_ID<>?", this.getA_Asset_ID(), this.getA_Asset_Addition_ID());
            MAsset mAsset = new MAsset(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName());
            if ("Cap".equals(this.getA_CapvsExp())) {
                this.setA_CreateAsset(true);
            }
            if ("Cap".equals(this.getA_CapvsExp()) && this.getA_Asset_ID() > 0) {
                this.setA_CreateAsset(false);
            }
            if ("Exp".equals(this.getA_CapvsExp())) {
                this.setA_CreateAsset(false);
            }
            if (this.isA_CreateAsset()) {
                if (n >= 1) {
                    this.setA_CreateAsset(false);
                } else if (n == 0) {
                    this.setA_CreateAsset(true);
                    if (mAsset.getA_Asset_Status().equals("AC") && !mAsset.getAssetActivationDate().equals(this.getDateDoc())) {
                        this.setA_CreateAsset(false);
                    }
                }
            } else if (n == 0) {
                if (mAsset.getA_Asset_Status().equals("AC") && !mAsset.getAssetActivationDate().equals(this.getDateDoc())) {
                    this.setA_CreateAsset(false);
                } else {
                    this.setA_CreateAsset(true);
                }
            }
        }
    }

    private void setC_DocType_ID() {
        StringBuilder stringBuilder = new StringBuilder("SELECT C_DocType_ID FROM C_DocType ").append("WHERE AD_Client_ID=? AND AD_Org_ID IN (0,").append(this.getAD_Org_ID()).append(") AND DocBaseType='FAA' ").append("ORDER BY AD_Org_ID DESC, IsDefault DESC");
        int n = DB.getSQLValue(null, stringBuilder.toString(), this.getAD_Client_ID());
        if (n <= 0) {
            this.log.severe("No FAA found for AD_Client_ID=" + this.getAD_Client_ID());
        } else {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("(PO) - " + n);
            }
            this.set_ValueOfColumn("C_DocType_ID", (Object)n);
        }
    }
}

