/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.compiere.model.MAlertRecipient;
import org.compiere.model.MAlertRule;
import org.compiere.model.MUserRoles;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Alert;

public class MAlert
extends X_AD_Alert {
    private static final long serialVersionUID = -5684705878618526801L;
    private MAlertRule[] m_rules = null;
    private MAlertRecipient[] m_recipients = null;

    public MAlert(Properties ctx, int AD_Alert_ID, String trxName) {
        super(ctx, AD_Alert_ID, trxName);
        if (AD_Alert_ID == 0) {
            this.setEnforceClientSecurity(true);
            this.setEnforceRoleSecurity(true);
            this.setIsValid(true);
        }
    }

    public MAlert(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAlertRule[] getRules(boolean reload) {
        if (this.m_rules != null && !reload) {
            return this.m_rules;
        }
        String whereClause = "AD_Alert_ID=?";
        List<MAlertRule> list = new Query(this.getCtx(), "AD_AlertRule", "AD_Alert_ID=?", null).setParameters(this.getAD_Alert_ID()).setOrderBy("Name, AD_AlertRule_ID").setOnlyActiveRecords(true).list();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MAlertRule rule = (MAlertRule)list.get(i2);
            rule.setParent(this);
        }
        this.m_rules = new MAlertRule[list.size()];
        this.m_rules = list.toArray(this.m_rules);
        return this.m_rules;
    }

    public MAlertRecipient[] getRecipients(boolean reload) {
        if (this.m_recipients != null && !reload) {
            return this.m_recipients;
        }
        String whereClause = "AD_Alert_ID=?";
        List<MAlertRecipient> list = new Query(this.getCtx(), "AD_AlertRecipient", "AD_Alert_ID=?", null).setParameters(this.getAD_Alert_ID()).setOnlyActiveRecords(true).list();
        this.m_recipients = new MAlertRecipient[list.size()];
        this.m_recipients = list.toArray(this.m_recipients);
        return this.m_recipients;
    }

    public int getFirstAD_Role_ID() {
        this.getRecipients(false);
        for (int i2 = 0; i2 < this.m_recipients.length; ++i2) {
            if (this.m_recipients[i2].getAD_Role_ID() == -1) continue;
            return this.m_recipients[i2].getAD_Role_ID();
        }
        return -1;
    }

    public int getFirstUserAD_Role_ID() {
        this.getRecipients(false);
        int AD_User_ID = this.getFirstAD_User_ID();
        if (AD_User_ID != -1) {
            MUserRoles[] urs = MUserRoles.getOfUser(this.getCtx(), AD_User_ID);
            for (int i2 = 0; i2 < urs.length; ++i2) {
                if (!urs[i2].isActive()) continue;
                return urs[i2].getAD_Role_ID();
            }
        }
        return -1;
    }

    public int getFirstAD_User_ID() {
        this.getRecipients(false);
        for (int i2 = 0; i2 < this.m_recipients.length; ++i2) {
            if (this.m_recipients[i2].getAD_User_ID() == -1) continue;
            return this.m_recipients[i2].getAD_User_ID();
        }
        return -1;
    }

    public Collection<Integer> getRecipientUsers() {
        MAlertRecipient[] recipients = this.getRecipients(false);
        TreeSet<Integer> users = new TreeSet<Integer>();
        for (int i2 = 0; i2 < recipients.length; ++i2) {
            MAlertRecipient recipient = recipients[i2];
            if (recipient.getAD_User_ID() >= 0) {
                users.add(recipient.getAD_User_ID());
            }
            if (recipient.getAD_Role_ID() < 0) continue;
            MUserRoles[] urs = MUserRoles.getOfRole(this.getCtx(), recipient.getAD_Role_ID());
            for (int j = 0; j < urs.length; ++j) {
                MUserRoles ur = urs[j];
                if (!ur.isActive()) continue;
                users.add(ur.getAD_User_ID());
            }
        }
        return users;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MAlert[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Valid=").append(this.isValid());
        if (this.m_rules != null) {
            sb.append(",Rules=").append(this.m_rules.length);
        }
        if (this.m_recipients != null) {
            sb.append(",Recipients=").append(this.m_recipients.length);
        }
        sb.append("]");
        return sb.toString();
    }
}

