/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.minigrid;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.compiere.minigrid.IDColumn;

public class IDColumnRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -7513837304119751313L;
    private boolean m_multiSelection;
    private JButton m_button;
    private JCheckBox m_check;

    public IDColumnRenderer(boolean multiSelection) {
        this.m_multiSelection = multiSelection;
        if (this.m_multiSelection) {
            this.m_check = new JCheckBox();
            this.m_check.setMargin(new Insets(0, 0, 0, 0));
            this.m_check.setHorizontalAlignment(0);
            this.putClientProperty("SortColumn", Boolean.FALSE);
        } else {
            this.m_button = new JButton();
            this.m_button.setMargin(new Insets(0, 0, 0, 0));
            this.m_button.setSize(new Dimension(5, 5));
        }
    }

    @Override
    protected void setValue(Object value) {
        if (this.m_multiSelection) {
            boolean sel = false;
            if (value != null) {
                sel = value instanceof IDColumn ? ((IDColumn)value).isSelected() : (value instanceof Boolean ? ((Boolean)value).booleanValue() : value.toString().equals("Y"));
            }
            if (this.m_check.isSelected() != sel) {
                this.m_check.setSelected(sel);
            }
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setValue(value);
        if (this.m_multiSelection) {
            return this.m_check;
        }
        return this.m_button;
    }

    public void addChangeListener(ChangeListener listener) {
        this.m_check.addChangeListener(listener);
    }
}

