/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.tree;

import java.util.logging.Level;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.compiere.model.MTable;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class AdempiereTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 8503954687681402088L;
    private static CLogger log = CLogger.getCLogger(AdempiereTreeModel.class);
    private MTree m_MTree;

    public AdempiereTreeModel(TreeNode root) {
        super(root);
    }

    public AdempiereTreeModel(MTreeNode root, boolean b2) {
        super(root, b2);
    }

    public void setMTree(MTree tree) {
        this.m_MTree = tree;
    }

    public void saveChangedNodes(MTreeNode from, MTreeNode to) {
        int AD_Tree_ID = this.m_MTree.getAD_Tree_ID();
        Trx trx = Trx.get(Trx.createTrxName("AdempiereTreeModel"), true);
        try {
            for (int i = 0; i < from.getChildCount(); ++i) {
                MTreeNode nd = (MTreeNode)from.getChildAt(i);
                String whereClause = "AD_Tree_ID=" + AD_Tree_ID + " AND Node_ID=" + nd.getNode_ID();
                PO tree = MTable.get(Env.getCtx(), this.m_MTree.getNodeTableName()).getPO(whereClause, trx.getTrxName());
                if (tree.get_ValueAsInt("Parent_ID") == from.getNode_ID() && tree.get_ValueAsInt("SeqNo") == i) continue;
                tree.set_CustomColumn("Parent_ID", from.getNode_ID());
                tree.set_CustomColumn("SeqNo", i);
                tree.saveEx();
            }
            if (from != to) {
                int nextSeqNo = 0;
                for (int i = 0; i < to.getChildCount(); ++i) {
                    if (i == Integer.parseInt(from.getSeqNo())) continue;
                    MTreeNode nd = (MTreeNode)to.getChildAt(i);
                    String whereClause = "AD_Tree_ID=" + AD_Tree_ID + " AND Node_ID=" + nd.getNode_ID();
                    PO tree = MTable.get(Env.getCtx(), this.m_MTree.getNodeTableName()).getPO(whereClause, trx.getTrxName());
                    if (tree.get_ValueAsInt("Parent_ID") != to.getNode_ID() || tree.get_ValueAsInt("SeqNo") < nextSeqNo) {
                        tree.set_CustomColumn("Parent_ID", to.getNode_ID());
                        tree.set_CustomColumn("SeqNo", nextSeqNo++);
                        tree.saveEx();
                        continue;
                    }
                    nextSeqNo = tree.get_ValueAsInt("SeqNo") + 1;
                }
            }
            trx.commit(true);
        }
        catch (Exception e) {
            trx.rollback();
            log.log(Level.SEVERE, "move", e);
        }
        trx.close();
        trx = null;
        log.config("complete");
    }
}

