/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ScriptEditor;
import org.compiere.grid.ed.Editor;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CTextArea;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VMemo
extends CTextArea
implements VEditor,
KeyListener,
FocusListener,
ActionListener {
    private static final long serialVersionUID = -1589654941310687511L;
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem menuEditor;
    private int m_fieldLength;
    private String m_columnName;
    private String m_oldText = "";
    private boolean m_firstChange;
    private static CLogger log = CLogger.getCLogger(VMemo.class);
    private GridField m_mField = null;

    public VMemo() {
        this("", false, false, true, 60, 4000);
    }

    public VMemo(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int displayLength, int fieldLength) {
        super(fieldLength / 80, 50);
        super.setName(columnName);
        LookAndFeel.installBorder(this, "TextField.border");
        this.addFocusListener(this);
        this.setColumns(displayLength > 60 ? 60 : displayLength);
        this.setForeground(AdempierePLAF.getTextColor_Normal());
        this.setBackground(AdempierePLAF.getFieldBackground_Normal());
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.addFocusListener(this);
        this.setInputVerifier(new CInputVerifier());
        this.setMandatory(mandatory);
        this.m_columnName = columnName;
        this.m_fieldLength = fieldLength;
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        }
        this.addKeyListener(this);
        this.addMouseListener(new VMemo_mouseAdapter(this));
        this.menuEditor = columnName.equals("Script") ? new CMenuItem(Msg.getMsg(Env.getCtx(), "Script"), Env.getImageIcon("Script16.gif")) : new CMenuItem(Msg.getMsg(Env.getCtx(), "Editor"), Env.getImageIcon("Editor16.gif"));
        this.menuEditor.addActionListener(this);
        this.popupMenu.add(this.menuEditor);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.m_firstChange = true;
        this.setCaretPosition(0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuEditor) {
            this.menuEditor.setEnabled(false);
            String s = null;
            s = this.m_columnName.equals("Script") || this.m_columnName.endsWith("_Script") ? ScriptEditor.start(Env.getFrame(this.getParent()), Msg.translate(Env.getCtx(), this.m_columnName), this.getText(), this.isEditable(), this.findWindowNo()) : Editor.startEditor(this, Msg.translate(Env.getCtx(), this.m_columnName), this.getText(), this.isEditable(), this.m_fieldLength);
            this.menuEditor.setEnabled(true);
            this.setValue(s);
            try {
                this.fireVetoableChange(this.m_columnName, null, this.getText());
                this.m_oldText = this.getText();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private int findWindowNo() {
        Container c = this.getParent();
        return c != null ? Env.getWindowNo(c) : 0;
    }

    @Override
    public void addActionListener(ActionListener listener) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27 && !this.getText().equals(this.m_oldText)) {
            log.fine("VMemo.keyReleased - ESC");
            this.setText(this.m_oldText);
            return;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        log.config(e.paramString());
        if (e.getSource() instanceof VMemo) {
            this.requestFocus();
        } else {
            this.m_oldText = this.getText();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        log.fine("focusLost");
        try {
            String text = this.getText();
            this.fireVetoableChange(this.m_columnName, text, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }

    private class CInputVerifier
    extends InputVerifier {
        private CInputVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            if (VMemo.this.getText() == null && VMemo.this.m_oldText == null) {
                return true;
            }
            if (VMemo.this.getText().equals(VMemo.this.m_oldText)) {
                return true;
            }
            try {
                String text = VMemo.this.getText();
                VMemo.this.fireVetoableChange(VMemo.this.m_columnName, null, text);
                VMemo.this.m_oldText = text;
                return true;
            }
            catch (PropertyVetoException propertyVetoException) {
                return true;
            }
        }
    }

    final class VMemo_mouseAdapter
    extends MouseAdapter {
        private VMemo adaptee;

        VMemo_mouseAdapter(VMemo adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

