/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.grid.GridController;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MAccount;
import org.compiere.model.MAccountLookup;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MQuery;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public final class VAccountDialog
extends CDialog
implements ActionListener,
DataStatusListener,
VetoableChangeListener {
    private static final long serialVersionUID = -1980622319541357651L;
    private int m_WindowNo;
    protected boolean m_changed = false;
    private static MAcctSchema s_AcctSchema = null;
    private GridWindow m_mWindow = null;
    private GridTab m_mTab = null;
    private GridController m_gridController = null;
    private MAccountLookup m_mAccount = null;
    private int m_C_ValidCombination_ID;
    private int m_C_AcctSchema_ID = 0;
    private int m_AD_Client_ID;
    private MQuery m_query;
    private static CLogger log = CLogger.getCLogger(VAccountDialog.class);
    private VEditor f_Alias;
    private VEditor f_Combination;
    private VEditor f_AD_Org_ID;
    private VEditor f_Account_ID;
    private VEditor f_SubAcct_ID;
    private VEditor f_M_Product_ID;
    private VEditor f_C_BPartner_ID;
    private VEditor f_C_Campaign_ID;
    private VEditor f_C_LocFrom_ID;
    private VEditor f_C_LocTo_ID;
    private VEditor f_C_Project_ID;
    private VEditor f_C_SalesRegion_ID;
    private VEditor f_AD_OrgTrx_ID;
    private VEditor f_C_Activity_ID;
    private VEditor f_User1_ID;
    private VEditor f_User2_ID;
    private JLabel f_Description = new JLabel("", 0);
    private GridBagConstraints m_gbc = new GridBagConstraints();
    private Insets m_labelInsets = new Insets(2, 15, 2, 0);
    private Insets m_fieldInsets = new Insets(2, 5, 2, 10);
    private int m_line = 0;
    private boolean m_newRow = true;
    private CPanel panel = new CPanel();
    private BorderLayout panelLayout = new BorderLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private TitledBorder titledBorder;
    private StatusBar statusBar = new StatusBar();
    private CPanel northPanel = new CPanel();
    private CPanel parameterPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private BorderLayout northLayout = new BorderLayout();
    private JToolBar toolBar = new JToolBar();
    private CButton bRefresh = new CButton();
    private CButton bSave = new CButton();
    private CButton bIgnore = new CButton();

    public VAccountDialog(Frame frame, String title, MAccountLookup mAccount, int C_AcctSchema_ID) {
        super(frame, title, true);
        log.config("C_AcctSchema_ID=" + C_AcctSchema_ID + ", C_ValidCombination_ID=" + mAccount.C_ValidCombination_ID);
        this.m_mAccount = mAccount;
        this.m_C_AcctSchema_ID = C_AcctSchema_ID;
        this.m_WindowNo = Env.createWindowNo(this);
        this.setDefaultCloseOperation(2);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.toString());
        }
        if (this.initAccount()) {
            AEnv.showCenterWindow(frame, this);
        } else {
            this.dispose();
        }
    }

    void jbInit() throws Exception {
        this.titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), Msg.getMsg(Env.getCtx(), "Parameter"));
        this.panelLayout.setHgap(5);
        this.panelLayout.setVgap(5);
        this.northLayout.setHgap(5);
        this.northLayout.setVgap(5);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.parameterPanel.setBorder(this.titledBorder);
        this.northPanel.setLayout(this.northLayout);
        this.toolBar.setOrientation(1);
        this.toolBar.setBorder(null);
        this.toolBar.setRequestFocusEnabled(false);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setMargin(new Insets(5, 5, 5, 5));
        this.bSave.setIcon(new ImageIcon(Adempiere.class.getResource("images/Save24.gif")));
        this.bSave.setMargin(new Insets(2, 2, 2, 2));
        this.bSave.setToolTipText(Msg.getMsg(Env.getCtx(), "AccountNewUpdate"));
        this.bSave.addActionListener(this);
        this.bRefresh.setIcon(new ImageIcon(Adempiere.class.getResource("images/Refresh24.gif")));
        this.bRefresh.setMargin(new Insets(2, 2, 2, 2));
        this.bRefresh.setToolTipText(Msg.getMsg(Env.getCtx(), "Refresh"));
        this.bRefresh.addActionListener(this);
        this.bIgnore.setIcon(new ImageIcon(Adempiere.class.getResource("images/Ignore24.gif")));
        this.bIgnore.setMargin(new Insets(2, 2, 2, 2));
        this.bIgnore.setToolTipText(Msg.getMsg(Env.getCtx(), "Ignore"));
        this.bIgnore.addActionListener(this);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.bRefresh, null);
        this.toolBar.add((Component)this.bIgnore, null);
        this.toolBar.add((Component)this.bSave, null);
        this.getContentPane().add(this.panel);
        this.panel.setLayout(this.panelLayout);
        this.panel.add((Component)this.confirmPanel, "South");
        this.panel.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.parameterPanel, "Center");
        this.northPanel.add((Component)this.toolBar, "East");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.confirmPanel.addActionListener(this);
    }

    private boolean initAccount() {
        this.m_AD_Client_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "AD_Client_ID");
        if (s_AcctSchema == null || s_AcctSchema.getC_AcctSchema_ID() != this.m_C_AcctSchema_ID) {
            s_AcctSchema = new MAcctSchema(Env.getCtx(), this.m_C_AcctSchema_ID, null);
        }
        log.config(s_AcctSchema.toString() + ", #" + s_AcctSchema.getAcctSchemaElements().length);
        Env.setContext(Env.getCtx(), this.m_WindowNo, "C_AcctSchema_ID", this.m_C_AcctSchema_ID);
        int AD_Window_ID = 153;
        GridWindowVO wVO = AEnv.getMWindowVO(this.m_WindowNo, AD_Window_ID, 0);
        if (wVO == null) {
            return false;
        }
        this.m_mWindow = new GridWindow(wVO);
        this.m_mTab = this.m_mWindow.getTab(0);
        if (!this.m_mTab.isLoadComplete()) {
            this.m_mWindow.initTab(0);
        }
        this.m_mTab.getField("Alias").setDisplayLength(15);
        this.m_mTab.getField("Combination").setDisplayLength(15);
        this.m_mTab.getField("AD_Client_ID").setDisplayed(false);
        this.m_mTab.getField("C_AcctSchema_ID").setDisplayed(false);
        this.m_mTab.getField("IsActive").setDisplayed(false);
        this.m_mTab.getField("IsFullyQualified").setDisplayed(false);
        for (int i = 0; i < this.m_mTab.getFieldCount(); ++i) {
            GridField field = this.m_mTab.getField(i);
            if (field.isDisplayed(true)) continue;
            field.setDisplayed(false);
        }
        this.m_gridController = new GridController();
        this.m_gridController.initGrid(this.m_mTab, true, this.m_WindowNo, null, null);
        this.m_gridController.setPreferredSize(new Dimension(300, 100));
        this.panel.add((Component)this.m_gridController, "Center");
        this.m_gbc.anchor = 18;
        this.m_gbc.gridy = 0;
        this.m_gbc.gridx = 0;
        this.m_gbc.gridwidth = 1;
        this.m_gbc.insets = this.m_fieldInsets;
        this.m_gbc.fill = 2;
        this.m_gbc.weightx = 0.0;
        this.m_gbc.weighty = 0.0;
        boolean TabNo = false;
        if (s_AcctSchema.isHasAlias()) {
            GridField alias = this.m_mTab.getField("Alias");
            this.f_Alias = VEditorFactory.getEditor(this.m_mTab, alias, false);
            this.addLine(alias, this.f_Alias, false);
        }
        GridField combination = this.m_mTab.getField("Combination");
        this.f_Combination = VEditorFactory.getEditor(this.m_mTab, combination, false);
        this.addLine(combination, this.f_Combination, false);
        this.m_newRow = true;
        MAcctSchemaElement[] elements = s_AcctSchema.getAcctSchemaElements();
        for (int i = 0; i < elements.length; ++i) {
            GridFieldVO newFieldVO;
            GridField field;
            MAcctSchemaElement ase = elements[i];
            String type = ase.getElementType();
            boolean isMandatory = ase.isMandatory();
            if (type.equals("OO")) {
                field = this.m_mTab.getField("AD_Org_ID");
                this.f_AD_Org_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                this.addLine(field, this.f_AD_Org_ID, isMandatory);
                continue;
            }
            if (type.equals("AC")) {
                field = this.m_mTab.getField("Account_ID");
                this.f_Account_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                this.addLine(field, this.f_Account_ID, isMandatory);
                this.f_Account_ID.addVetoableChangeListener(this);
                continue;
            }
            if (type.equals("SA")) {
                field = this.m_mTab.getField("C_SubAcct_ID");
                this.f_SubAcct_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                this.addLine(field, this.f_SubAcct_ID, isMandatory);
                continue;
            }
            if (type.equals("PR")) {
                field = this.m_mTab.getField("M_Product_ID");
                this.f_M_Product_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                this.addLine(field, this.f_M_Product_ID, isMandatory);
                continue;
            }
            if (type.equals("BP")) {
                field = this.m_mTab.getField("C_BPartner_ID");
                this.f_C_BPartner_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                this.addLine(field, this.f_C_BPartner_ID, isMandatory);
                continue;
            }
            if (type.equals("MC")) {
                field = this.m_mTab.getField("C_Campaign_ID");
                this.f_C_Campaign_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                this.addLine(field, this.f_C_Campaign_ID, isMandatory);
                continue;
            }
            if (type.equals("LF")) {
                field = this.m_mTab.getField("C_LocFrom_ID");
                this.f_C_LocFrom_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                this.addLine(field, this.f_C_LocFrom_ID, isMandatory);
                continue;
            }
            if (type.equals("LT")) {
                field = this.m_mTab.getField("C_LocTo_ID");
                this.f_C_LocTo_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                this.addLine(field, this.f_C_LocTo_ID, isMandatory);
                continue;
            }
            if (type.equals("PJ")) {
                field = this.m_mTab.getField("C_Project_ID");
                this.f_C_Project_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                this.addLine(field, this.f_C_Project_ID, isMandatory);
                continue;
            }
            if (type.equals("SR")) {
                field = this.m_mTab.getField("C_SalesRegion_ID");
                this.f_C_SalesRegion_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                this.addLine(field, this.f_C_SalesRegion_ID, isMandatory);
                continue;
            }
            if (type.equals("OT")) {
                field = this.m_mTab.getField("AD_OrgTrx_ID");
                this.f_AD_OrgTrx_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                this.addLine(field, this.f_AD_OrgTrx_ID, isMandatory);
                continue;
            }
            if (type.equals("AY")) {
                field = this.m_mTab.getField("C_Activity_ID");
                this.f_C_Activity_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                this.addLine(field, this.f_C_Activity_ID, isMandatory);
                continue;
            }
            if (type.equals("U1")) {
                field = this.m_mTab.getField("User1_ID");
                this.f_User1_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
                newFieldVO = this.f_User1_ID.getField().getVO();
                newFieldVO.Header = this.f_User1_ID.getName();
                field = new GridField(newFieldVO);
                this.addLine(field, this.f_User1_ID, isMandatory);
                continue;
            }
            if (!type.equals("U2")) continue;
            field = this.m_mTab.getField("User2_ID");
            this.f_User2_ID = VEditorFactory.getEditor(this.m_mTab, field, false);
            newFieldVO = this.f_User2_ID.getField().getVO();
            newFieldVO.Header = this.f_User2_ID.getName();
            field = new GridField(newFieldVO);
            this.addLine(field, this.f_User2_ID, isMandatory);
        }
        this.m_newRow = true;
        this.m_gbc.gridy = this.m_line++;
        this.m_gbc.gridx = 0;
        this.m_gbc.gridwidth = 4;
        this.m_gbc.insets = new Insets(5, 15, 2, 0);
        this.m_gbc.fill = 2;
        this.f_Description.setFont(this.f_Description.getFont().deriveFont(2));
        this.parameterPanel.add((Component)this.f_Description, this.m_gbc);
        this.m_query = new MQuery();
        this.m_query.addRestriction("C_AcctSchema_ID", "=", this.m_C_AcctSchema_ID);
        this.m_query.addRestriction("IsFullyQualified", "=", "Y");
        if (this.m_mAccount.C_ValidCombination_ID == 0) {
            this.m_mTab.setQuery(MQuery.getEqualQuery("1", "2"));
        } else {
            MQuery query = new MQuery();
            query.addRestriction("C_AcctSchema_ID", "=", this.m_C_AcctSchema_ID);
            query.addRestriction("C_ValidCombination_ID", "=", this.m_mAccount.C_ValidCombination_ID);
            this.m_mTab.setQuery(query);
        }
        this.m_mTab.query(false);
        this.m_gridController.getTable().addMouseListener(new VAccountDialog_mouseAdapter(this));
        this.m_gridController.addDataStatusListener(this);
        this.statusBar.setStatusLine(s_AcctSchema.toString());
        this.statusBar.setStatusDB("?");
        if (this.m_mAccount.C_ValidCombination_ID != 0) {
            this.m_mTab.navigate(0);
        }
        log.config("fini");
        return true;
    }

    private void addLine(GridField field, VEditor editor, boolean mandatory) {
        log.fine("Field=" + field);
        CLabel label = VEditorFactory.getLabel(field);
        ((JLabel)label).setLabelFor((Component)((Object)editor));
        editor.setReadWrite(true);
        editor.setMandatory(mandatory);
        field.addPropertyChangeListener(editor);
        if (this.m_newRow) {
            this.m_gbc.gridy = this.m_line++;
            this.m_gbc.gridx = 0;
        } else {
            this.m_gbc.gridx = 2;
        }
        this.m_gbc.insets = this.m_labelInsets;
        this.m_gbc.fill = 2;
        this.m_gbc.weightx = 0.0;
        this.parameterPanel.add((Component)label, this.m_gbc);
        this.m_gbc.gridx = this.m_newRow ? 1 : 3;
        this.m_gbc.insets = this.m_fieldInsets;
        this.m_gbc.fill = 2;
        this.m_gbc.weightx = 1.0;
        this.parameterPanel.add((Component)((Object)editor), this.m_gbc);
        this.m_newRow = !this.m_newRow;
    }

    private void loadInfo(int C_ValidCombination_ID, int C_AcctSchema_ID) {
        log.fine("C_ValidCombination_ID=" + C_ValidCombination_ID);
        String sql = "SELECT * FROM C_ValidCombination WHERE C_ValidCombination_ID=? AND C_AcctSchema_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_ValidCombination_ID);
            pstmt.setInt(2, C_AcctSchema_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                if (this.f_Alias != null) {
                    this.f_Alias.setValue(rs.getString("Alias"));
                }
                this.f_Combination.setValue(rs.getString("Combination"));
                this.loadInfoOf(rs, this.f_AD_Org_ID, "AD_Org_ID");
                this.loadInfoOf(rs, this.f_Account_ID, "Account_ID");
                this.loadInfoOf(rs, this.f_SubAcct_ID, "C_SubAcct_ID");
                this.loadInfoOf(rs, this.f_M_Product_ID, "M_Product_ID");
                this.loadInfoOf(rs, this.f_C_BPartner_ID, "C_BPartner_ID");
                this.loadInfoOf(rs, this.f_C_Campaign_ID, "C_Campaign_ID");
                this.loadInfoOf(rs, this.f_C_LocFrom_ID, "C_LocFrom_ID");
                this.loadInfoOf(rs, this.f_C_LocTo_ID, "C_LocTo_ID");
                this.loadInfoOf(rs, this.f_C_Project_ID, "C_Project_ID");
                this.loadInfoOf(rs, this.f_C_SalesRegion_ID, "C_SalesRegion_ID");
                this.loadInfoOf(rs, this.f_AD_OrgTrx_ID, "AD_OrgTrx_ID");
                this.loadInfoOf(rs, this.f_C_Activity_ID, "C_Activity_ID");
                this.loadInfoOf(rs, this.f_User1_ID, "User1_ID");
                this.loadInfoOf(rs, this.f_User2_ID, "User2_ID");
                this.f_Description.setText(rs.getString("Description"));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    private void loadInfoOf(ResultSet rs, VEditor editor, String name) throws SQLException {
        if (editor == null) {
            return;
        }
        int intValue = rs.getInt(name);
        if (rs.wasNull()) {
            editor.setValue(null);
        } else {
            editor.setValue(new Integer(intValue));
        }
    }

    @Override
    public void dispose() {
        this.saveSelection();
        if (this.m_gridController != null) {
            this.m_gridController.dispose();
        }
        this.m_gridController = null;
        this.m_mTab = null;
        if (this.m_mWindow != null) {
            this.m_mWindow.dispose();
        }
        this.m_mWindow = null;
        this.removeAll();
        Env.clearWinContext(this.m_WindowNo);
        super.dispose();
    }

    private void saveSelection() {
        if (this.m_changed && this.m_gridController != null) {
            int row = this.m_gridController.getTable().getSelectedRow();
            if (row >= 0) {
                this.m_C_ValidCombination_ID = (Integer)this.m_mTab.getValue(row, "C_ValidCombination_ID");
            }
            log.config("(" + row + ") - " + this.m_C_ValidCombination_ID);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.m_changed = true;
            this.dispose();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.m_changed = false;
            this.dispose();
        } else if (e.getSource() == this.bSave) {
            this.action_Save();
        } else if (e.getSource() == this.bIgnore) {
            this.action_Ignore();
        } else {
            this.action_Find(true);
        }
    }

    @Override
    public void dataStatusChanged(DataStatusEvent e) {
        log.config(e.toString());
        String info = (String)this.m_mTab.getValue("Description");
        this.f_Description.setText(info);
    }

    private void action_Find(boolean includeAliasCombination) {
        String value;
        log.info("");
        this.setCursor(Cursor.getPredefinedCursor(3));
        MQuery query = null;
        query = this.m_query != null ? this.m_query.deepCopy() : new MQuery();
        if (includeAliasCombination && this.f_Alias != null && this.f_Alias.getValue().toString().length() > 0) {
            value = this.f_Alias.getValue().toString().toUpperCase();
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            query.addRestriction("UPPER(Alias)", " LIKE ", value);
        }
        if (includeAliasCombination && this.f_Combination.getValue().toString().length() > 0) {
            value = this.f_Combination.getValue().toString().toUpperCase();
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            query.addRestriction("UPPER(Combination)", " LIKE ", value);
        }
        if (this.f_AD_Org_ID != null && this.f_AD_Org_ID.getValue() != null) {
            query.addRestriction("AD_Org_ID", "=", this.f_AD_Org_ID.getValue());
        }
        if (this.f_Account_ID != null && this.f_Account_ID.getValue() != null) {
            query.addRestriction("Account_ID", "=", this.f_Account_ID.getValue());
        }
        if (this.f_SubAcct_ID != null && this.f_SubAcct_ID.getValue() != null) {
            query.addRestriction("C_SubAcct_ID", "=", this.f_SubAcct_ID.getValue());
        }
        if (this.f_M_Product_ID != null && this.f_M_Product_ID.getValue() != null) {
            query.addRestriction("M_Product_ID", "=", this.f_M_Product_ID.getValue());
        }
        if (this.f_C_BPartner_ID != null && this.f_C_BPartner_ID.getValue() != null) {
            query.addRestriction("C_BPartner_ID", "=", this.f_C_BPartner_ID.getValue());
        }
        if (this.f_C_Campaign_ID != null && this.f_C_Campaign_ID.getValue() != null) {
            query.addRestriction("C_Campaign_ID", "=", this.f_C_Campaign_ID.getValue());
        }
        if (this.f_C_LocFrom_ID != null && this.f_C_LocFrom_ID.getValue() != null) {
            query.addRestriction("C_LocFrom_ID", "=", this.f_C_LocFrom_ID.getValue());
        }
        if (this.f_C_LocTo_ID != null && this.f_C_LocTo_ID.getValue() != null) {
            query.addRestriction("C_LocTo_ID", "=", this.f_C_LocTo_ID.getValue());
        }
        if (this.f_C_Project_ID != null && this.f_C_Project_ID.getValue() != null) {
            query.addRestriction("C_Project_ID", "=", this.f_C_Project_ID.getValue());
        }
        if (this.f_C_SalesRegion_ID != null && this.f_C_SalesRegion_ID.getValue() != null) {
            query.addRestriction("C_SalesRegion_ID", "=", this.f_C_SalesRegion_ID.getValue());
        }
        if (this.f_AD_OrgTrx_ID != null && this.f_AD_OrgTrx_ID.getValue() != null) {
            query.addRestriction("AD_OrgTrx_ID", "=", this.f_AD_OrgTrx_ID.getValue());
        }
        if (this.f_C_Activity_ID != null && this.f_C_Activity_ID.getValue() != null) {
            query.addRestriction("C_Activity_ID", "=", this.f_C_Activity_ID.getValue());
        }
        if (this.f_User1_ID != null && this.f_User1_ID.getValue() != null) {
            query.addRestriction("User1_ID", "=", this.f_User1_ID.getValue());
        }
        if (this.f_User2_ID != null && this.f_User2_ID.getValue() != null) {
            query.addRestriction("User2_ID", "=", this.f_User2_ID.getValue());
        }
        this.m_mTab.setQuery(query);
        this.m_mTab.query(false);
        this.statusBar.setStatusDB(String.valueOf(this.m_mTab.getRowCount()));
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void action_Save() {
        MAccount acct;
        log.info("");
        StringBuffer sb = new StringBuffer();
        StringBuffer sql = new StringBuffer("SELECT C_ValidCombination_ID, Alias FROM C_ValidCombination WHERE ");
        Object value = null;
        if (s_AcctSchema.isHasAlias() && (value = this.f_Alias.getValue().toString()) == null) {
            sb.append(Msg.translate(Env.getCtx(), "Alias")).append(", ");
        }
        MAcctSchemaElement[] elements = s_AcctSchema.getAcctSchemaElements();
        for (int i = 0; i < elements.length; ++i) {
            MAcctSchemaElement ase = elements[i];
            String type = ase.getElementType();
            if (type.equals("OO")) {
                value = this.f_AD_Org_ID.getValue();
                sql.append("AD_Org_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("AC")) {
                value = this.f_Account_ID.getValue();
                sql.append("Account_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("SA")) {
                value = this.f_SubAcct_ID.getValue();
                sql.append("C_SubAcct_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("PR")) {
                value = this.f_M_Product_ID.getValue();
                sql.append("M_Product_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("BP")) {
                value = this.f_C_BPartner_ID.getValue();
                sql.append("C_BPartner_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("MC")) {
                value = this.f_C_Campaign_ID.getValue();
                sql.append("C_Campaign_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("LF")) {
                value = this.f_C_LocFrom_ID.getValue();
                sql.append("C_LocFrom_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("LT")) {
                value = this.f_C_LocTo_ID.getValue();
                sql.append("C_LocTo_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("PJ")) {
                value = this.f_C_Project_ID.getValue();
                sql.append("C_Project_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("SR")) {
                value = this.f_C_SalesRegion_ID.getValue();
                sql.append("C_SalesRegion_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("OT")) {
                value = this.f_AD_OrgTrx_ID.getValue();
                sql.append("AD_OrgTrx_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("AY")) {
                value = this.f_C_Activity_ID.getValue();
                sql.append("C_Activity_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("U1")) {
                value = this.f_User1_ID.getValue();
                sql.append("User1_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            } else if (type.equals("U2")) {
                value = this.f_User2_ID.getValue();
                sql.append("User2_ID");
                if (value == null) {
                    sql.append(" IS NULL AND ");
                } else {
                    sql.append("=").append(value).append(" AND ");
                }
            }
            if (!ase.isMandatory() || value != null) continue;
            sb.append(ase.getName()).append(", ");
        }
        if (sb.length() != 0) {
            ADialog.error(this.m_WindowNo, this, "FillMandatory", sb.substring(0, sb.length() - 2));
            return;
        }
        if (this.f_AD_Org_ID == null || this.f_AD_Org_ID.getValue() == null) {
            ADialog.error(this.m_WindowNo, this, "FillMandatory", Msg.getElement(Env.getCtx(), "AD_Org_ID"));
            return;
        }
        if (this.f_Account_ID == null || this.f_Account_ID.getValue() == null) {
            ADialog.error(this.m_WindowNo, this, "FillMandatory", Msg.getElement(Env.getCtx(), "Account_ID"));
            return;
        }
        sql.append("AD_Client_ID=? AND C_AcctSchema_ID=?");
        log.fine("Check = " + sql.toString());
        int IDvalue = 0;
        String Alias = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, this.m_AD_Client_ID);
            pstmt.setInt(2, s_AcctSchema.getC_AcctSchema_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                IDvalue = rs.getInt(1);
                Alias = rs.getString(2);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
            IDvalue = 0;
        }
        log.fine("ID=" + IDvalue + ", Alias=" + Alias);
        if (Alias == null) {
            Alias = "";
        }
        if (IDvalue != 0 && s_AcctSchema.isHasAlias() && !this.f_Alias.getValue().toString().equals(Alias)) {
            sql = new StringBuffer("UPDATE C_ValidCombination SET Alias=");
            if (this.f_Alias.getValue().toString().length() == 0) {
                sql.append("NULL");
            } else {
                sql.append("'").append(this.f_Alias.getValue()).append("'");
            }
            sql.append(" WHERE C_ValidCombination_ID=").append(IDvalue);
            int i = 0;
            try {
                CPreparedStatement stmt = DB.prepareStatement(sql.toString(), 1003, 1008, null);
                i = stmt.executeUpdate();
                stmt.close();
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql.toString(), e);
            }
            if (i == 0) {
                ADialog.error(this.m_WindowNo, this, "AccountNotUpdated");
            }
        }
        if (IDvalue != 0) {
            this.loadInfo(IDvalue, s_AcctSchema.getC_AcctSchema_ID());
            this.action_Find(false);
            return;
        }
        log.config("New");
        Alias = null;
        if (this.f_Alias != null) {
            Alias = this.f_Alias.getValue().toString();
        }
        int C_SubAcct_ID = 0;
        if (this.f_SubAcct_ID != null && this.f_SubAcct_ID.getValue() != null) {
            C_SubAcct_ID = (Integer)this.f_SubAcct_ID.getValue();
        }
        int M_Product_ID = 0;
        if (this.f_M_Product_ID != null && this.f_M_Product_ID.getValue() != null) {
            M_Product_ID = (Integer)this.f_M_Product_ID.getValue();
        }
        int C_BPartner_ID = 0;
        if (this.f_C_BPartner_ID != null && this.f_C_BPartner_ID.getValue() != null) {
            C_BPartner_ID = (Integer)this.f_C_BPartner_ID.getValue();
        }
        int AD_OrgTrx_ID = 0;
        if (this.f_AD_OrgTrx_ID != null && this.f_AD_OrgTrx_ID.getValue() != null) {
            AD_OrgTrx_ID = (Integer)this.f_AD_OrgTrx_ID.getValue();
        }
        int C_LocFrom_ID = 0;
        if (this.f_C_LocFrom_ID != null && this.f_C_LocFrom_ID.getValue() != null) {
            C_LocFrom_ID = (Integer)this.f_C_LocFrom_ID.getValue();
        }
        int C_LocTo_ID = 0;
        if (this.f_C_LocTo_ID != null && this.f_C_LocTo_ID.getValue() != null) {
            C_LocTo_ID = (Integer)this.f_C_LocTo_ID.getValue();
        }
        int C_SRegion_ID = 0;
        if (this.f_C_SalesRegion_ID != null && this.f_C_SalesRegion_ID.getValue() != null) {
            C_SRegion_ID = (Integer)this.f_C_SalesRegion_ID.getValue();
        }
        int C_Project_ID = 0;
        if (this.f_C_Project_ID != null && this.f_C_Project_ID.getValue() != null) {
            C_Project_ID = (Integer)this.f_C_Project_ID.getValue();
        }
        int C_Campaign_ID = 0;
        if (this.f_C_Campaign_ID != null && this.f_C_Campaign_ID.getValue() != null) {
            C_Campaign_ID = (Integer)this.f_C_Campaign_ID.getValue();
        }
        int C_Activity_ID = 0;
        if (this.f_C_Activity_ID != null && this.f_C_Activity_ID.getValue() != null) {
            C_Activity_ID = (Integer)this.f_C_Activity_ID.getValue();
        }
        int User1_ID = 0;
        if (this.f_User1_ID != null && this.f_User1_ID.getValue() != null) {
            User1_ID = (Integer)this.f_User1_ID.getValue();
        }
        int User2_ID = 0;
        if (this.f_User2_ID != null && this.f_User2_ID.getValue() != null) {
            User2_ID = (Integer)this.f_User2_ID.getValue();
        }
        if ((acct = MAccount.get(Env.getCtx(), this.m_AD_Client_ID, (Integer)this.f_AD_Org_ID.getValue(), s_AcctSchema.getC_AcctSchema_ID(), (Integer)this.f_Account_ID.getValue(), C_SubAcct_ID, M_Product_ID, C_BPartner_ID, AD_OrgTrx_ID, C_LocFrom_ID, C_LocTo_ID, C_SRegion_ID, C_Project_ID, C_Campaign_ID, C_Activity_ID, User1_ID, User2_ID, 0, 0, null)) != null && acct.get_ID() == 0) {
            acct.saveEx();
        }
        if (acct == null || acct.get_ID() == 0) {
            this.loadInfo(0, 0);
        } else {
            if (Alias != null && Alias.length() > 0) {
                acct.setAlias(Alias);
                acct.saveEx();
            }
            this.loadInfo(acct.get_ID(), s_AcctSchema.getC_AcctSchema_ID());
        }
        this.action_Find(false);
    }

    private void action_Ignore() {
        if (this.f_Alias != null) {
            this.f_Alias.setValue("");
        }
        this.f_Combination.setValue("");
        this.f_Description.setText("");
        this.f_AD_Org_ID.setValue(null);
        this.f_Account_ID.setValue(null);
        if (this.f_SubAcct_ID != null) {
            this.f_SubAcct_ID.setValue(null);
        }
        if (this.f_M_Product_ID != null) {
            this.f_M_Product_ID.setValue(null);
        }
        if (this.f_C_BPartner_ID != null) {
            this.f_C_BPartner_ID.setValue(null);
        }
        if (this.f_C_Campaign_ID != null) {
            this.f_C_Campaign_ID.setValue(null);
        }
        if (this.f_C_LocFrom_ID != null) {
            this.f_C_LocFrom_ID.setValue(null);
        }
        if (this.f_C_LocTo_ID != null) {
            this.f_C_LocTo_ID.setValue(null);
        }
        if (this.f_C_Project_ID != null) {
            this.f_C_Project_ID.setValue(null);
        }
        if (this.f_C_SalesRegion_ID != null) {
            this.f_C_SalesRegion_ID.setValue(null);
        }
        if (this.f_AD_OrgTrx_ID != null) {
            this.f_AD_OrgTrx_ID.setValue(null);
        }
        if (this.f_C_Activity_ID != null) {
            this.f_C_Activity_ID.setValue(null);
        }
        if (this.f_User1_ID != null) {
            this.f_User1_ID.setValue(null);
        }
        if (this.f_User2_ID != null) {
            this.f_User2_ID.setValue(null);
        }
    }

    public Integer getValue() {
        log.config("C_ValidCombination_ID=" + this.m_C_ValidCombination_ID + ", Changed=" + this.m_changed);
        if (!this.m_changed || this.m_C_ValidCombination_ID == 0) {
            return null;
        }
        return new Integer(this.m_C_ValidCombination_ID);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Object newValue = evt.getNewValue();
        if (newValue instanceof Integer) {
            Env.setContext(Env.getCtx(), this.m_WindowNo, "Account_ID", (Integer)newValue);
        }
    }

    class VAccountDialog_mouseAdapter
    extends MouseAdapter {
        VAccountDialog adaptee;

        VAccountDialog_mouseAdapter(VAccountDialog adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getSource() instanceof JTable && e.getClickCount() > 1) {
                this.adaptee.m_changed = true;
                this.adaptee.dispose();
            }
        }
    }
}

