/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.model.MConversionRate;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public final class Calculator
extends CDialog
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 467225451773238663L;
    private BigDecimal m_number;
    private String m_display = "";
    private int m_DisplayType;
    private DecimalFormat m_format;
    private int m_WindowNo;
    private boolean m_abort = true;
    private boolean m_currencyOK = false;
    private boolean p_disposeOnEqual = true;
    private static final String OPERANDS = "/*-+%";
    private char m_decimal = (char)46;
    private static CLogger log = CLogger.getCLogger(Calculator.class);
    private CPanel mainPanel = new CPanel();
    private CPanel displayPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel keyPanel = new CPanel();
    private JLabel display = new JLabel();
    private BorderLayout displayLayout = new BorderLayout();
    private JButton b7 = new JButton();
    private JButton b8 = new JButton();
    private JButton b9 = new JButton();
    private JButton b4 = new JButton();
    private JButton b5 = new JButton();
    private JButton b6 = new JButton();
    private JButton b1 = new JButton();
    private JButton b2 = new JButton();
    private JButton b3 = new JButton();
    private GridLayout keyLayout = new GridLayout();
    private JButton bCur = new JButton();
    private JButton bC = new JButton();
    private JButton bDiv = new JButton();
    private JButton bM = new JButton();
    private JButton bMin = new JButton();
    private JButton bProc = new JButton();
    private JButton bAC = new JButton();
    private JButton bResult = new JButton();
    private JButton bDec = new JButton();
    private JButton b0 = new JButton();
    private JButton bPlus = new JButton();
    private CPanel bordPanel = new CPanel();
    private CPanel currencyPanel = new CPanel();
    private BorderLayout bordLayout = new BorderLayout();
    private JComboBox curFrom = new JComboBox();
    private JComboBox curTo = new JComboBox();
    private JLabel curLabel = new JLabel();
    private FlowLayout currencyLayout = new FlowLayout();

    public Calculator(Frame frame, String title, int displayType, DecimalFormat format, BigDecimal number) {
        super(frame, title, true);
        this.setDefaultCloseOperation(2);
        this.m_WindowNo = Env.getWindowNo(frame);
        this.m_DisplayType = displayType;
        if (!DisplayType.isNumeric(this.m_DisplayType)) {
            this.m_DisplayType = 22;
        }
        this.m_format = format;
        if (this.m_format == null) {
            this.m_format = DisplayType.getNumberFormat(this.m_DisplayType);
        }
        this.m_number = number;
        if (this.m_number == null) {
            this.m_number = new BigDecimal(0.0);
        }
        try {
            this.jbInit();
            this.finishSetup();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Calculator" + ex);
        }
    }

    public Calculator(Frame frame) {
        this(frame, Msg.getMsg(Env.getCtx(), "Calculator"), 22, null, null);
    }

    public Calculator(Frame frame, BigDecimal number) {
        this(frame, Msg.getMsg(Env.getCtx(), "Calculator"), 22, null, number);
    }

    void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.displayPanel.setLayout(this.displayLayout);
        this.keyPanel.setLayout(this.keyLayout);
        this.mainLayout.setHgap(2);
        this.mainLayout.setVgap(2);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.mainPanel.addKeyListener(this);
        this.display.setBackground(Color.white);
        this.display.setFont(new Font("SansSerif", 0, 14));
        this.display.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 1), BorderFactory.createLineBorder(AdempierePLAF.getPrimary1())));
        this.display.setText("0");
        this.display.setHorizontalAlignment(4);
        this.b7.setText("7");
        this.b8.setText("8");
        this.b9.setText("9");
        this.b4.setText("4");
        this.b5.setText("5");
        this.b6.setText("6");
        this.b1.setText("1");
        this.b2.setText("2");
        this.b3.setText("3");
        this.keyLayout.setColumns(5);
        this.keyLayout.setHgap(3);
        this.keyLayout.setRows(4);
        this.keyLayout.setVgap(3);
        this.bCur.setForeground(Color.yellow);
        this.bCur.setToolTipText(Msg.getMsg(Env.getCtx(), "CurrencyConversion"));
        this.bCur.setText("$");
        this.bC.setForeground(Color.red);
        this.bC.setText("C");
        this.bDiv.setForeground(Color.blue);
        this.bDiv.setText("/");
        this.bM.setForeground(Color.blue);
        this.bM.setText("*");
        this.bMin.setForeground(Color.blue);
        this.bMin.setText("-");
        this.bProc.setForeground(Color.blue);
        this.bProc.setText("%");
        this.bAC.setForeground(Color.red);
        this.bAC.setText("AC");
        this.bResult.setForeground(Color.green);
        this.bResult.setText("=");
        this.bDec.setText(".");
        this.b0.setText("0");
        this.bPlus.setForeground(Color.blue);
        this.bPlus.setText("+");
        this.bordPanel.setLayout(this.bordLayout);
        this.curLabel.setHorizontalAlignment(0);
        this.curLabel.setHorizontalTextPosition(0);
        this.curLabel.setText(" >> ");
        this.currencyPanel.setLayout(this.currencyLayout);
        this.bordLayout.setHgap(2);
        this.bordLayout.setVgap(2);
        this.displayLayout.setHgap(2);
        this.displayLayout.setVgap(2);
        this.currencyLayout.setHgap(3);
        this.currencyLayout.setVgap(2);
        this.displayPanel.setBackground(Color.white);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.displayPanel, "North");
        this.displayPanel.add((Component)this.display, "Center");
        this.mainPanel.add((Component)this.bordPanel, "Center");
        this.bordPanel.add((Component)this.currencyPanel, "North");
        this.currencyPanel.add((Component)this.curFrom, null);
        this.currencyPanel.add((Component)this.curLabel, null);
        this.currencyPanel.add((Component)this.curTo, null);
        this.bordPanel.add((Component)this.keyPanel, "Center");
        this.keyPanel.add((Component)this.bAC, null);
        this.keyPanel.add((Component)this.b7, null);
        this.keyPanel.add((Component)this.b8, null);
        this.keyPanel.add((Component)this.b9, null);
        this.keyPanel.add((Component)this.bM, null);
        this.keyPanel.add((Component)this.bC, null);
        this.keyPanel.add((Component)this.b4, null);
        this.keyPanel.add((Component)this.b5, null);
        this.keyPanel.add((Component)this.b6, null);
        this.keyPanel.add((Component)this.bDiv, null);
        this.keyPanel.add((Component)this.bProc, null);
        this.keyPanel.add((Component)this.b1, null);
        this.keyPanel.add((Component)this.b2, null);
        this.keyPanel.add((Component)this.b3, null);
        this.keyPanel.add((Component)this.bMin, null);
        this.keyPanel.add((Component)this.bCur, null);
        this.keyPanel.add((Component)this.b0, null);
        this.keyPanel.add((Component)this.bDec, null);
        this.keyPanel.add((Component)this.bResult, null);
        this.keyPanel.add((Component)this.bPlus, null);
    }

    private void finishSetup() {
        Insets in = new Insets(2, 2, 2, 2);
        Component[] comp = this.keyPanel.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof JButton)) continue;
            JButton b2 = (JButton)comp[i];
            b2.setMargin(in);
            b2.addActionListener(this);
            b2.addKeyListener(this);
        }
        this.toggleCurrency();
        this.m_decimal = this.m_format.getDecimalFormatSymbols().getDecimalSeparator();
        if (this.m_number.doubleValue() != 0.0) {
            this.m_display = this.m_format.format(this.m_number);
            this.display.setText(this.m_display);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            String cmd = e.getActionCommand();
            if (cmd != null && cmd.length() > 0) {
                this.handleInput(cmd.charAt(0));
            }
        } else if (e.getSource() == this.curTo) {
            KeyNamePair p2 = (KeyNamePair)this.curFrom.getSelectedItem();
            int curFromID = p2.getKey();
            p2 = (KeyNamePair)this.curTo.getSelectedItem();
            int curToID = p2.getKey();
            int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
            int AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
            this.m_number = MConversionRate.convert(Env.getCtx(), this.evaluate(), curFromID, curToID, AD_Client_ID, AD_Org_ID);
            this.m_display = this.m_format.format(this.m_number);
            this.display.setText(this.m_display);
            this.curFrom.setSelectedItem(p2);
        }
    }

    public void handleInput(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.m_display = this.m_display + c;
                break;
            }
            case ',': 
            case '.': {
                this.m_display = this.m_display + this.m_decimal;
                break;
            }
            case '%': 
            case '*': 
            case '+': 
            case '-': 
            case '/': {
                if (this.m_display.length() > 0) {
                    char last = this.m_display.charAt(this.m_display.length() - 1);
                    this.m_display = OPERANDS.indexOf(last) == -1 ? this.m_display + c : this.m_display.substring(0, this.m_display.length() - 1) + c;
                }
                this.m_display = this.m_format.format(this.evaluate());
                if (c == '%') break;
                this.m_display = this.m_display + c;
                break;
            }
            case 'C': {
                if (this.m_display.length() <= 0) break;
                this.m_display = this.m_display.substring(0, this.m_display.length() - 1);
                break;
            }
            case 'A': {
                this.m_display = "";
                break;
            }
            case '$': {
                this.m_display = this.m_format.format(this.evaluate());
                this.toggleCurrency();
                break;
            }
            case '=': {
                this.m_display = this.m_format.format(this.evaluate());
                this.m_abort = false;
                if (!this.isDisposeOnEqual()) break;
                this.dispose();
                break;
            }
            default: {
                ADialog.beep();
            }
        }
        if (this.m_display.equals("")) {
            this.m_display = "0";
        }
        if (this.m_display.length() > 1 && this.m_display.startsWith("0") && this.m_display.charAt(1) != ',' && this.m_display.charAt(1) != '.') {
            this.m_display = this.m_display.substring(1);
        }
        this.display.setText(this.m_display);
    }

    private BigDecimal evaluate() {
        Number secondNumber;
        BigDecimal firstNo;
        Number firstNumber;
        if (this.m_display == null || this.m_display.equals("") || this.m_display.equals("0")) {
            this.m_number = new BigDecimal(0.0);
            return this.m_number;
        }
        StringTokenizer st = new StringTokenizer(this.m_display, OPERANDS, true);
        String token = st.nextToken();
        if (token.equals("-")) {
            if (st.hasMoreTokens()) {
                token = token + st.nextToken();
            } else {
                this.m_number = new BigDecimal(0.0);
                return this.m_number;
            }
        }
        try {
            firstNumber = this.m_format.parse(token);
        }
        catch (ParseException pe1) {
            log.log(Level.SEVERE, "Calculator.evaluate - token: " + token, pe1);
            this.m_number = new BigDecimal(0.0);
            return this.m_number;
        }
        this.m_number = firstNo = new BigDecimal(firstNumber.toString());
        if (!st.hasMoreTokens()) {
            return this.m_number;
        }
        token = st.nextToken();
        if (OPERANDS.indexOf(token) == -1) {
            log.log(Level.SEVERE, "Calculator.evaluate - Unknown token: " + token);
            return this.m_number;
        }
        char op = token.charAt(0);
        if (op == '%') {
            this.m_number = firstNo = firstNo.divide(new BigDecimal(100.0), this.m_format.getMaximumFractionDigits(), 4);
        }
        if (!st.hasMoreTokens()) {
            return this.m_number;
        }
        token = st.nextToken();
        try {
            secondNumber = this.m_format.parse(token);
        }
        catch (ParseException pe2) {
            log.log(Level.SEVERE, "Calculator.evaluate - token: " + token, pe2);
            this.m_number = new BigDecimal(0.0);
            return this.m_number;
        }
        BigDecimal secondNo = new BigDecimal(secondNumber.toString());
        int op2 = 0;
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            if (OPERANDS.indexOf(token) == -1) {
                log.log(Level.SEVERE, "Calculator.evaluate - Unknown token: " + token);
                return this.m_number;
            }
            op2 = token.charAt(0);
        }
        if (op2 == 37) {
            secondNo = secondNo.divide(new BigDecimal(100.0), this.m_format.getMaximumFractionDigits(), 4);
        }
        switch (op) {
            case '/': {
                this.m_number = firstNo.divide(secondNo, this.m_format.getMaximumFractionDigits(), 4);
                break;
            }
            case '*': {
                this.m_number = firstNo.multiply(secondNo);
                break;
            }
            case '-': {
                this.m_number = firstNo.subtract(secondNo);
                break;
            }
            case '+': {
                this.m_number = firstNo.add(secondNo);
                break;
            }
        }
        return this.m_number.setScale(this.m_format.getMaximumFractionDigits(), 4);
    }

    private void toggleCurrency() {
        if (this.currencyPanel.isVisible()) {
            this.currencyPanel.setVisible(false);
        } else {
            if (!this.m_currencyOK) {
                this.loadCurrency();
            }
            this.currencyPanel.setVisible(true);
        }
        this.pack();
    }

    private void loadCurrency() {
        int C_Currency_ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "C_Currency_ID");
        if (C_Currency_ID == 0) {
            C_Currency_ID = Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID");
        }
        String sql = "SELECT C_Currency_ID, ISO_Code FROM C_Currency WHERE IsActive='Y' ORDER BY 2";
        KeyNamePair defaultValue = null;
        try {
            Statement stmt = DB.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int id = rs.getInt("C_Currency_ID");
                String s = rs.getString("ISO_Code");
                KeyNamePair p2 = new KeyNamePair(id, s);
                this.curFrom.addItem(p2);
                this.curTo.addItem(p2);
                if (id != C_Currency_ID) continue;
                defaultValue = p2;
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "Calculator.loadCurrency", e);
        }
        if (defaultValue != null) {
            this.curFrom.setSelectedItem(defaultValue);
            this.curTo.setSelectedItem(defaultValue);
        }
        this.curTo.addActionListener(this);
        this.m_currencyOK = true;
    }

    public BigDecimal getNumber() {
        if (this.m_abort) {
            return null;
        }
        return this.m_number;
    }

    public boolean isDisposeOnEqual() {
        return this.p_disposeOnEqual;
    }

    public void setDisposeOnEqual(boolean b2) {
        this.p_disposeOnEqual = b2;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int input = e.getKeyChar();
        int code = e.getKeyCode();
        e.consume();
        if (code == 127) {
            input = 65;
        } else if (code == 8) {
            input = 67;
        } else if (code == 10) {
            input = 61;
        } else {
            if (code == 16) {
                return;
            }
            if (code == 3 || code == 27) {
                this.m_abort = true;
                this.dispose();
                return;
            }
        }
        this.handleInput((char)input);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

