/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.compiere.apps.ADialog;
import org.compiere.apps.AppsAction;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.MiniTable;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;

public class VCreateFromDialog
extends CDialog
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private CreateFrom createFrom;
    private int windowNo;
    private CPanel parameterPanel = new CPanel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private StatusBar statusBar = new StatusBar();
    private MiniTable dataTable = new MiniTable();
    private static final String SELECT_ALL = "SelectAll";

    public VCreateFromDialog(CreateFrom createFrom, int windowNo, boolean modal) {
        super((Frame)Env.getWindow(windowNo), modal);
        this.createFrom = createFrom;
        this.windowNo = windowNo;
        try {
            this.jbInit();
            this.confirmPanel.addActionListener(this);
            this.statusBar.setStatusDB("");
            this.tableChanged(null);
            createFrom.setInitOK(true);
        }
        catch (Exception e) {
            createFrom.setInitOK(false);
        }
    }

    protected void jbInit() throws Exception {
        this.getContentPane().add((Component)this.parameterPanel, "North");
        JScrollPane dataPane = new JScrollPane();
        this.getContentPane().add((Component)dataPane, "Center");
        dataPane.getViewport().add((Component)this.dataTable, null);
        AppsAction selectAllAction = new AppsAction(SELECT_ALL, KeyStroke.getKeyStroke(65, 8), null);
        CButton selectAllButton = (CButton)selectAllAction.getButton();
        selectAllButton.setMargin(new Insets(0, 10, 0, 10));
        selectAllButton.setDefaultCapable(true);
        selectAllButton.addActionListener(this);
        this.confirmPanel.addButton(selectAllButton);
        CPanel southPanel = new CPanel();
        this.getContentPane().add((Component)southPanel, "South");
        BorderLayout southLayout = new BorderLayout();
        southPanel.setLayout(southLayout);
        southPanel.add((Component)this.confirmPanel, "Center");
        southPanel.add((Component)this.statusBar, "South");
        this.dataTable.setMultiSelection(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            try {
                Trx.run(new TrxRunnable(){

                    @Override
                    public void run(String trxName) {
                        if (VCreateFromDialog.this.save(trxName)) {
                            VCreateFromDialog.this.dispose();
                        }
                    }
                });
            }
            catch (Exception ex) {
                ADialog.error(this.windowNo, this, "Error", ex.getLocalizedMessage());
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals(SELECT_ALL)) {
            this.dataTable.selectAll();
            this.dataTable.matchCheckWithSelectedRows();
            this.info();
        }
    }

    public boolean save(String trxName) {
        this.dataTable.stopEditor(true);
        TableModel model = this.dataTable.getModel();
        int rows = model.getRowCount();
        if (rows == 0) {
            return false;
        }
        return this.createFrom.save(this.dataTable, trxName);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int type = -1;
        if (e != null && (type = e.getType()) != 0) {
            return;
        }
        this.info();
        this.dataTable.repaint();
    }

    public void info() {
        this.createFrom.info();
    }

    public void setStatusLine(int selectedRowCount, String text) {
        StringBuffer sb = new StringBuffer(String.valueOf(selectedRowCount));
        if (text != null && text.trim().length() > 0) {
            sb.append(" - ").append(text);
        }
        this.statusBar.setStatusLine(sb.toString());
        this.confirmPanel.getOKButton().setEnabled(selectedRowCount > 0);
    }

    public MiniTable getMiniTable() {
        return this.dataTable;
    }

    public CPanel getParameterPanel() {
        return this.parameterPanel;
    }

    public ConfirmPanel getConfirmPanel() {
        return this.confirmPanel;
    }
}

