/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class CreateFromRMA
extends CreateFrom {
    public CreateFromRMA(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle("Customer RMA - Create Lines From");
        return true;
    }

    protected Vector<Vector<Object>> getRMAData() {
        int M_InOut_ID = Env.getContextAsInt(Env.getCtx(), this.getGridTab().getWindowNo(), "InOut_ID");
        int M_RMA_ID = Env.getContextAsInt(Env.getCtx(), this.getGridTab().getWindowNo(), "M_RMA_ID");
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sqlStmt = new StringBuffer();
        sqlStmt.append("SELECT iol.M_InOutLine_ID, iol.Line, ");
        sqlStmt.append("CASE WHEN iol.M_Product_ID IS NOT NULL THEN (Select p.Name from M_Product p where p.M_Product_ID = iol.M_Product_ID) END as ProductName, ");
        sqlStmt.append("iol.QtyEntered, ");
        sqlStmt.append("iol.movementQty, ");
        sqlStmt.append("CASE WHEN iol.M_AttributeSetInstance_ID IS NOT NULL THEN (SELECT SerNo FROM M_AttributeSetInstance asi where asi.M_AttributeSetInstance_ID=iol.M_AttributeSetInstance_ID) END as ASI ");
        sqlStmt.append("from M_InOutLine iol where M_InOut_ID=? ");
        sqlStmt.append("and iol.M_InOutLine_ID not in (select rmal.M_InOutLine_ID from M_RMALine rmal where rmal.M_RMA_ID=?)");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sqlStmt.toString(), null);
            pstmt.setInt(1, M_InOut_ID);
            pstmt.setInt(2, M_RMA_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>(7);
                line.add(new Boolean(false));
                KeyNamePair lineKNPair = new KeyNamePair(rs.getInt(1), rs.getString(2));
                line.add(lineKNPair);
                line.add(rs.getString(3));
                line.add(rs.getString(6));
                BigDecimal qtyEntered = rs.getBigDecimal(4);
                BigDecimal movementQty = rs.getBigDecimal(5);
                line.add(qtyEntered);
                line.add(movementQty);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sqlStmt.toString(), e);
        }
        return data;
    }

    @Override
    public void info() {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, String.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, BigDecimal.class, true);
        miniTable.setColumnClass(5, BigDecimal.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        this.log.config("");
        int M_RMA_ID = Env.getContextAsInt(Env.getCtx(), this.getGridTab().getWindowNo(), "M_RMA_ID");
        MRMA rma = new MRMA(Env.getCtx(), M_RMA_ID, trxName);
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                BigDecimal d = (BigDecimal)miniTable.getValueAt(i, 5);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 1);
                int inOutLineId = pp.getKey();
                MRMALine rmaLine = new MRMALine(rma.getCtx(), 0, rma.get_TrxName());
                rmaLine.setM_RMA_ID(M_RMA_ID);
                rmaLine.setM_InOutLine_ID(inOutLineId);
                rmaLine.setQty(d);
                rmaLine.setAD_Org_ID(rma.getAD_Org_ID());
                if (!rmaLine.save()) {
                    throw new IllegalStateException("Could not create RMA Line");
                }
            }
            ++i;
        }
        rma.saveEx();
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add("Line");
        columnNames.add(Msg.translate(Env.getCtx(), "M_Product_ID"));
        columnNames.add("ASI");
        columnNames.add(Msg.translate(Env.getCtx(), "Quantity"));
        columnNames.add(Msg.getElement(Env.getCtx(), "QtyDelivered", false));
        return columnNames;
    }
}

