/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Vector;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.X_C_PaymentRequestLine;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class CreateFromPaymentRequest
extends CreateFrom {
    public CreateFromPaymentRequest(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement(Env.getCtx(), "C_Invoice_ID", false)) + " .. " + Msg.translate(Env.getCtx(), "CreateFrom"));
        return true;
    }

    @Override
    public void info() {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        String type2 = this.getGridTab().get_ValueAsString("RequestType");
        type2 = Character.toString(type2.charAt(0));
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, BigDecimal.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.setColumnClass(8, String.class, true);
        miniTable.setColumnClass(9, Integer.TYPE, true);
        if (type2.equals("I")) {
            miniTable.setColumnClass(10, String.class, true);
        }
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        int header_ID = (Integer)this.getGridTab().getValue("C_PaymentRequest_ID");
        String type = this.getGridTab().get_ValueAsString("RequestType");
        type = Character.toString(type.charAt(0));
        BigDecimal total = new BigDecimal(0);
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                X_C_PaymentRequestLine line = new X_C_PaymentRequestLine(Env.getCtx(), 0, trxName);
                KeyNamePair document = (KeyNamePair)miniTable.getValueAt(i, 3);
                BigDecimal amt = (BigDecimal)miniTable.getValueAt(i, 4);
                String desc = (String)miniTable.getValueAt(i, 5);
                int Schedule_ID = (Integer)miniTable.getValueAt(i, 9);
                line.setC_PaymentRequest_ID(header_ID);
                line.setAmt(amt);
                line.setDescription(desc);
                if (type.equals("I")) {
                    line.setC_Invoice_ID(document.getKey());
                }
                if (type.equals("J") || type.equals("P")) {
                    line.setGL_JournalLine_ID(document.getKey());
                }
                if (type.equals("I") && Schedule_ID > 0) {
                    line.set_CustomColumn("C_InvoicePaySchedule_ID", Schedule_ID);
                }
                if (type.equals("R")) {
                    line.set_CustomColumn("DM_Document_ID", document.getKey());
                }
                line.save();
                total = total.add(amt);
            }
            ++i;
        }
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        String type2 = this.getGridTab().get_ValueAsString("RequestType");
        type2 = Character.toString(type2.charAt(0));
        Vector<String> columnNames = new Vector<String>(10);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.getElement(Env.getCtx(), "DateTrx"));
        columnNames.add(Msg.getElement(Env.getCtx(), "C_BPartner_ID"));
        columnNames.add(Msg.getElement(Env.getCtx(), "DocumentNo"));
        columnNames.add(Msg.getElement(Env.getCtx(), "Amt"));
        columnNames.add(Msg.translate(Env.getCtx(), "Description"));
        columnNames.add(Msg.translate(Env.getCtx(), "Organizaci\u00f3n"));
        columnNames.add(Msg.translate(Env.getCtx(), "Proyecto"));
        columnNames.add(Msg.translate(Env.getCtx(), "Combinaci\u00f3n"));
        columnNames.add(Msg.translate(Env.getCtx(), "Cuota"));
        if (type2.equals("I")) {
            columnNames.add("Termino de pago");
        }
        return columnNames;
    }
}

