/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.ofb.model.OFBForward;

public class CreateFromInvoice
extends CreateFrom {
    String IsSOTrx;
    int wType = 0;
    boolean getPay = false;
    boolean extinguir = false;

    public CreateFromInvoice(GridTab mTab) {
        super(mTab);
        this.IsSOTrx = mTab.get_ValueAsString("IsSOTrx");
        this.log.info(mTab.toString());
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement(Env.getCtx(), "C_Invoice_ID", false)) + " .. " + Msg.translate(Env.getCtx(), "CreateFrom"));
        return true;
    }

    protected ArrayList<KeyNamePair> loadShipmentData(int C_BPartner_ID) {
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        StringBuffer display = new StringBuffer("s.DocumentNo||' - '||").append(DB.TO_CHAR("s.MovementDate", 15, Env.getAD_Language(Env.getCtx())));
        if (OFBForward.UseMinjuDisplayFromInvoice()) {
            display = new StringBuffer("s.DocumentNo||' - '||").append(DB.TO_CHAR("s.MovementDate", 15, Env.getAD_Language(Env.getCtx()))).append("||' - '||").append("(SELECT DocumentNo FROM C_Order WHERE C_Order_ID = s.C_Order_ID) ");
        }
        StringBuffer sql = new StringBuffer("SELECT s.M_InOut_ID,").append(display).append(" FROM M_InOut s inner join C_DocType doc on (s.c_doctype_id=doc.c_doctype_id) WHERE s.C_BPartner_ID=? AND (s.IsSOTrx='" + this.IsSOTrx + "' or doc.name like 'AD%') AND s.DocStatus IN ('CL','CO')" + " AND s.AD_Org_ID=" + this.getAD_Org_ID() + "\tAND Exists (select il.m_inoutline_id,sum(il.movementqty),sum(invl.qtyinvoiced) from m_inoutline il" + " Left outer join c_invoiceline invl on (il.m_inoutline_id=invl.m_inoutline_id)" + " where il.M_InOut_ID=s.M_InOut_ID group by il.m_inoutline_id" + " having sum(il.movementqty)> coalesce(sum(invl.qtyinvoiced),0) )");
        if (OFBForward.createFromInvSinceTwoMonth()) {
            sql = sql.append(" and s.MovementDate >= now() - interval '2 month' ");
        }
        sql = sql.append(" ORDER BY s.MovementDate");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        return list;
    }

    protected ArrayList<KeyNamePair> loadRMAData(int C_BPartner_ID) {
        ArrayList<KeyNamePair> list;
        block13: {
            list = new ArrayList<KeyNamePair>();
            String sqlStmt = "SELECT r.M_RMA_ID, r.DocumentNo || '-' || r.Amt from M_RMA r WHERE ISSOTRX='N' AND r.DocStatus in ('CO', 'CL') AND r.C_BPartner_ID=? AND NOT EXISTS (SELECT * FROM C_Invoice inv WHERE inv.M_RMA_ID=r.M_RMA_ID AND inv.DocStatus IN ('CO', 'CL'))";
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlStmt, null);
                    pstmt.setInt(1, C_BPartner_ID);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), e);
                    if (pstmt == null) break block13;
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
        }
        return list;
    }

    protected Vector<Vector<Object>> getShipmentData(int M_InOut_ID) {
        this.log.config("M_InOut_ID=" + M_InOut_ID);
        MInOut inout = new MInOut(Env.getCtx(), M_InOut_ID, null);
        this.p_order = null;
        if (inout.getC_Order_ID() != 0) {
            this.p_order = new MOrder(Env.getCtx(), inout.getC_Order_ID(), null);
        }
        this.m_rma = null;
        if (inout.getM_RMA_ID() != 0) {
            this.m_rma = new MRMA(Env.getCtx(), inout.getM_RMA_ID(), null);
        }
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT  l.MovementQty-SUM(NVL(invl.QtyInvoiced, 0)), l.QtyEntered/l.MovementQty, l.C_UOM_ID, COALESCE(uom.UOMSymbol, uom.Name), l.M_Product_ID, p.Name, po.VendorProductNo, l.M_InOutLine_ID, l.Line, l.C_OrderLine_ID  FROM M_InOutLine l ");
        if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
            sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
        } else {
            sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("')");
        }
        sql.append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID)").append(" INNER JOIN M_InOut io ON (l.M_InOut_ID=io.M_InOut_ID)").append(" LEFT OUTER JOIN M_Product_PO po ON (l.M_Product_ID = po.M_Product_ID AND io.C_BPartner_ID = po.C_BPartner_ID)").append(" LEFT OUTER JOIN M_MatchInv mi ON (l.M_InOutLine_ID=mi.M_InOutLine_ID)").append(" LEFT OUTER JOIN C_InvoiceLine invl ON (invl.M_InOutLine_ID=l.M_InOutLine_ID)").append(" WHERE l.M_InOut_ID=? AND l.MovementQty<>0 ").append("GROUP BY l.MovementQty, l.QtyEntered/l.MovementQty, l.C_UOM_ID, COALESCE(uom.UOMSymbol, uom.Name), l.M_Product_ID, p.Name, po.VendorProductNo, l.M_InOutLine_ID, l.Line, l.C_OrderLine_ID ").append("ORDER BY l.Line");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, M_InOut_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>(7);
                line.add(new Boolean(false));
                BigDecimal qtyMovement = rs.getBigDecimal(1);
                BigDecimal multiplier = rs.getBigDecimal(2);
                BigDecimal qtyEntered = qtyMovement.multiply(multiplier);
                line.add(qtyEntered);
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                if (!OFBForward.ArtilecCreateShipment()) {
                    line.add(pp);
                } else {
                    String sqlcode = "SELECT '   ' || value || ' - ' || coalesce(UPC,name) from m_product where m_product_id = " + rs.getInt(5);
                    String namecode = DB.getSQLValueString(null, sqlcode, new Object[0]);
                    line.add(namecode);
                }
                pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                if (!OFBForward.ArtilecCreateShipment()) {
                    line.add(pp);
                } else {
                    String sqlprice = "SELECT round(priceentered,2) from c_orderline where c_orderline_id = " + rs.getInt(10);
                    BigDecimal price = DB.getSQLValueBD(null, sqlprice, new Object[0]);
                    line.add(price);
                }
                if (!OFBForward.ArtilecCreateShipment()) {
                    line.add(rs.getString(7));
                } else {
                    String sqlname = "SELECT coalesce(name,'-') from m_product where m_product_id = " + rs.getInt(5);
                    String name = DB.getSQLValueString(null, sqlname, new Object[0]);
                    line.add(name);
                }
                int C_OrderLine_ID = rs.getInt(10);
                if (rs.wasNull()) {
                    line.add(null);
                } else {
                    line.add(new KeyNamePair(C_OrderLine_ID, "."));
                }
                pp = new KeyNamePair(rs.getInt(8), rs.getString(9));
                line.add(pp);
                line.add(null);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        return data;
    }

    protected Vector<Vector<Object>> getRMAData(int M_RMA_ID) {
        Vector<Vector<Object>> data;
        block10: {
            this.p_order = null;
            data = new Vector<Vector<Object>>();
            StringBuffer sqlStmt = new StringBuffer();
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - COALESCE(rl.QtyInvoiced, 0), iol.M_Product_ID, p.Name, uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name) ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN M_InOutLine iol ON rl.M_InOutLine_ID=iol.M_InOutLine_ID ");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=iol.C_UOM_ID) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=iol.C_UOM_ID AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language(Env.getCtx())).append("') ");
            }
            sqlStmt.append("LEFT OUTER JOIN M_Product p ON p.M_Product_ID=iol.M_Product_ID ");
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.M_INOUTLINE_ID IS NOT NULL");
            sqlStmt.append(" UNION ");
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - rl.QtyDelivered, 0, c.Name, uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name) ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN C_Charge c ON c.C_Charge_ID = rl.C_Charge_ID ");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=100) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=100 AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language(Env.getCtx())).append("') ");
            }
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.C_Charge_ID IS NOT NULL");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlStmt.toString(), null);
                    pstmt.setInt(1, M_RMA_ID);
                    pstmt.setInt(2, M_RMA_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>(7);
                        line.add(new Boolean(false));
                        line.add(rs.getBigDecimal(3));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(6), rs.getString(7));
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                        line.add(pp);
                        line.add(null);
                        line.add(null);
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add(null);
                        line.add(pp);
                        data.add(line);
                    }
                    rs.close();
                }
                catch (Exception ex) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    @Override
    public void info() {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, BigDecimal.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        if (this.wType != 0) {
            return this.saveOFB(miniTable, trxName);
        }
        int C_Invoice_ID = (Integer)this.getGridTab().getValue("C_Invoice_ID");
        MInvoice invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, trxName);
        this.log.config(invoice.toString());
        if (this.p_order != null) {
            invoice.setOrder(this.p_order);
            if (OFBForward.createFromInvCopySalesRep()) {
                if (this.p_order != null && this.p_order.getSalesRep_ID() > 0) {
                    invoice.setSalesRep_ID(this.p_order.getSalesRep_ID());
                }
                invoice.setC_BPartner_Location_ID(this.p_order.getBill_Location_ID());
            }
            if (OFBForward.CopyOrgFromOrderInv()) {
                invoice.setAD_Org_ID(this.p_order.getAD_Org_ID());
            }
            invoice.saveEx();
        }
        if (this.m_rma != null) {
            invoice.setM_RMA_ID(this.m_rma.getM_RMA_ID());
            invoice.saveEx();
        }
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                MInOutLine line;
                int j;
                MInOutLine[] lines;
                String whereClause;
                MProduct product = null;
                BigDecimal QtyEntered = (BigDecimal)miniTable.getValueAt(i, 1);
                KeyNamePair pp = null;
                int C_UOM_ID = 0;
                if (!OFBForward.ArtilecCreateShipment()) {
                    pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                    C_UOM_ID = pp.getKey();
                } else {
                    this.log.config("ART uom");
                }
                int M_Product_ID = 0;
                if (!OFBForward.ArtilecCreateShipment()) {
                    pp = (KeyNamePair)miniTable.getValueAt(i, 3);
                    if (pp != null) {
                        M_Product_ID = pp.getKey();
                    }
                } else {
                    this.log.config("ART prod");
                }
                int C_OrderLine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i, 5);
                if (pp != null) {
                    C_OrderLine_ID = pp.getKey();
                }
                int M_InOutLine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i, 6);
                if (pp != null) {
                    M_InOutLine_ID = pp.getKey();
                }
                int M_RMALine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i, 7);
                if (pp != null) {
                    M_RMALine_ID = pp.getKey();
                }
                int precision = 2;
                if (M_Product_ID != 0) {
                    product = MProduct.get(Env.getCtx(), M_Product_ID);
                    precision = product.getUOMPrecision();
                }
                QtyEntered = QtyEntered.setScale(precision, 5);
                this.log.fine("Line QtyEntered=" + QtyEntered + ", Product_ID=" + M_Product_ID + ", OrderLine_ID=" + C_OrderLine_ID + ", InOutLine_ID=" + M_InOutLine_ID);
                MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
                invoiceLine.setM_Product_ID(M_Product_ID, C_UOM_ID);
                invoiceLine.setQty(QtyEntered);
                BigDecimal QtyInvoiced = null;
                if (M_Product_ID > 0 && product.getC_UOM_ID() != C_UOM_ID) {
                    QtyInvoiced = MUOMConversion.convertProductFrom(Env.getCtx(), M_Product_ID, C_UOM_ID, QtyEntered);
                }
                if (QtyInvoiced == null) {
                    QtyInvoiced = QtyEntered;
                }
                invoiceLine.setQtyInvoiced(QtyInvoiced);
                MOrderLine orderLine = null;
                if (C_OrderLine_ID != 0) {
                    orderLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                }
                MRMALine rmaLine = null;
                if (M_RMALine_ID > 0) {
                    rmaLine = new MRMALine(Env.getCtx(), M_RMALine_ID, null);
                }
                MInOutLine inoutLine = null;
                if (M_InOutLine_ID != 0) {
                    inoutLine = new MInOutLine(Env.getCtx(), M_InOutLine_ID, trxName);
                    if (orderLine == null && inoutLine.getC_OrderLine_ID() != 0) {
                        C_OrderLine_ID = inoutLine.getC_OrderLine_ID();
                        orderLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                    }
                } else if (C_OrderLine_ID > 0) {
                    whereClause = "EXISTS (SELECT 1 FROM M_InOut io WHERE io.M_InOut_ID=M_InOutLine.M_InOut_ID AND io.DocStatus IN ('CO','CL'))";
                    lines = MInOutLine.getOfOrderLine(Env.getCtx(), C_OrderLine_ID, whereClause, trxName);
                    this.log.fine("Receipt Lines with OrderLine = #" + lines.length);
                    if (lines.length > 0) {
                        j = 0;
                        while (j < lines.length) {
                            line = lines[j];
                            if (line.getQtyEntered().compareTo(QtyEntered) == 0) {
                                inoutLine = line;
                                M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                                break;
                            }
                            ++j;
                        }
                        if (inoutLine == null) {
                            inoutLine = lines[0];
                            M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                        }
                    }
                } else if (M_RMALine_ID != 0) {
                    whereClause = "EXISTS (SELECT 1 FROM M_InOut io WHERE io.M_InOut_ID=M_InOutLine.M_InOut_ID AND io.DocStatus IN ('CO','CL'))";
                    lines = MInOutLine.getOfRMALine(Env.getCtx(), M_RMALine_ID, whereClause, null);
                    this.log.fine("Receipt Lines with RMALine = #" + lines.length);
                    if (lines.length > 0) {
                        j = 0;
                        while (j < lines.length) {
                            line = lines[j];
                            if (rmaLine.getQty().compareTo(QtyEntered) == 0) {
                                inoutLine = line;
                                M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                                break;
                            }
                            ++j;
                        }
                        if (rmaLine == null) {
                            inoutLine = lines[0];
                            M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                        }
                    }
                }
                if (inoutLine != null) {
                    invoiceLine.setShipLine(inoutLine);
                } else {
                    this.log.fine("No Receipt Line");
                    if (orderLine != null) {
                        invoiceLine.setOrderLine(orderLine);
                    } else {
                        this.log.fine("No Order Line");
                        invoiceLine.setPrice();
                        invoiceLine.setTax();
                    }
                    if (rmaLine != null) {
                        invoiceLine.setRMALine(rmaLine);
                    } else {
                        this.log.fine("No RMA Line");
                    }
                }
                if (OFBForward.CopyOrgFromOrderInvoice() && orderLine != null) {
                    invoiceLine.setAD_Org_ID(orderLine.getAD_Org_ID());
                }
                invoiceLine.saveEx();
            }
            ++i;
        }
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Quantity"));
        if (!OFBForward.ArtilecCreateShipment()) {
            columnNames.add(Msg.translate(Env.getCtx(), "C_UOM_ID"));
        } else {
            columnNames.add("Codigo + Nombre");
        }
        if (!OFBForward.ArtilecCreateShipment()) {
            columnNames.add(Msg.translate(Env.getCtx(), "M_Product_ID"));
        } else {
            columnNames.add("Precio");
        }
        if (!OFBForward.ArtilecCreateShipment()) {
            columnNames.add(Msg.getElement(Env.getCtx(), "VendorProductNo", false));
        } else {
            columnNames.add("Producto");
        }
        columnNames.add(Msg.getElement(Env.getCtx(), "C_Order_ID", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "M_InOut_ID", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "M_RMA_ID", false));
        return columnNames;
    }

    public boolean saveOFB(IMiniTable miniTable, String trxName) {
        int C_Invoice_ID = (Integer)this.getGridTab().getValue("C_Invoice_ID");
        MInvoice invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, trxName);
        Integer docTypeId = (Integer)this.getGridTab().getValue("C_DocTypeTarget_ID");
        MDocType docType = MDocType.get(Env.getCtx(), docTypeId);
        this.wType = docType.getDocBaseType().equals("FAT") ? 1 : (docType.getDocBaseType().equals("PTK") ? 2 : (docType.getDocBaseType().equals("CDC") ? 3 : (docType.getDocBaseType().equals("VDC") ? 4 : (docType.getDocBaseType().equals("PRV") && docType.getName().toLowerCase().contains("nota") ? 6 : (docType.getDocBaseType().equals("PRV") ? 5 : 0)))));
        this.log.config(invoice.toString());
        int C_ChargeCheck_ID = 0;
        int C_ChargeLetra_ID = 0;
        int C_Factoring_ID = 0;
        int C_FactoringPay_ID = 0;
        int C_Extinguir_ID = 0;
        int C_FactoringPayL_ID = 0;
        int C_ChargeChange_ID = 0;
        if (this.wType == 2) {
            String sql1 = "SELECT C_Charge_ID FROM C_Charge WHERE upper(TipoCargo)='TC03' and isactive='Y' and AD_client_ID=" + invoice.getAD_Client_ID();
            C_ChargeCheck_ID = DB.getSQLValue("C_Charge", sql1);
            String sql2 = "SELECT C_Charge_ID FROM C_Charge WHERE upper(TipoCargo)='TC04'  and isactive='Y' and AD_client_ID=" + invoice.getAD_Client_ID();
            C_ChargeLetra_ID = DB.getSQLValue("C_Charge", sql2);
        }
        if (this.wType == 3 || this.wType == 4) {
            String sql3 = "SELECT C_Charge_ID FROM C_Charge WHERE upper(TipoCargo)='TC05'  and isactive='Y' and AD_client_ID=" + invoice.getAD_Client_ID();
            C_ChargeChange_ID = DB.getSQLValue("C_Charge", sql3);
        }
        if (this.wType == 1) {
            String sql4 = "SELECT C_Charge_ID FROM C_Charge WHERE upper(TipoCargo)='TC06'  and isactive='Y' and AD_client_ID=" + invoice.getAD_Client_ID();
            C_Factoring_ID = DB.getSQLValue("C_Charge", sql4);
            String sql5 = "SELECT C_Charge_ID FROM C_Charge WHERE upper(TipoCargo)='TC07'  and isactive='Y' and AD_client_ID=" + invoice.getAD_Client_ID();
            C_FactoringPay_ID = DB.getSQLValue("C_Charge", sql5);
            String sql6 = "SELECT C_Charge_ID FROM C_Charge WHERE upper(TipoCargo)='TC08'  and isactive='Y' and AD_client_ID=" + invoice.getAD_Client_ID();
            C_Extinguir_ID = DB.getSQLValue("C_Charge", sql6);
            String sql7 = "SELECT C_Charge_ID FROM C_Charge WHERE upper(TipoCargo)='TC09'  and isactive='Y' and AD_client_ID=" + invoice.getAD_Client_ID();
            C_FactoringPayL_ID = DB.getSQLValue("C_Charge", sql7);
        }
        int Tax_ID = DB.getSQLValue("C_Tax", "SELECT C_Tax_ID FROM C_Tax WHERE IsTaxExempt='Y' and AD_client_ID=" + invoice.getAD_Client_ID());
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                if (this.wType != 6 && this.wType != 5) {
                    BigDecimal TrxAmt;
                    KeyNamePair pp;
                    Timestamp trxDate;
                    int C_InvoiceFac_ID = 0;
                    int C_Payment_ID = 0;
                    String Tender = new String();
                    if (this.getPay) {
                        trxDate = (Timestamp)miniTable.getValueAt(i, 1);
                        pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                        C_Payment_ID = pp.getKey();
                        pp = (KeyNamePair)miniTable.getValueAt(i, 4);
                        int C_Currency_ID = pp.getKey();
                        TrxAmt = (BigDecimal)miniTable.getValueAt(i, 5);
                        Tender = (String)miniTable.getValueAt(i, 8);
                        this.log.fine("Line Date=" + trxDate + ", Payment=" + C_Payment_ID + ", Currency=" + C_Currency_ID + ", Amt=" + TrxAmt);
                    } else {
                        trxDate = (Timestamp)miniTable.getValueAt(i, 4);
                        pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                        C_InvoiceFac_ID = pp.getKey();
                        TrxAmt = (BigDecimal)miniTable.getValueAt(i, 3);
                    }
                    MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
                    if (this.wType == 2 && Tender.equals("Letra")) {
                        invoiceLine.setDescription("Letra Protestada");
                        invoiceLine.setC_Charge_ID(C_ChargeLetra_ID);
                        this.log.config("C_ChargeLetra_ID:" + C_ChargeLetra_ID);
                    } else if (this.wType == 2 && (Tender.indexOf("Cheque") >= 0 || Tender.indexOf("Check") >= 0)) {
                        invoiceLine.setDescription("Cheque Protestado");
                        invoiceLine.setC_Charge_ID(C_ChargeCheck_ID);
                        this.log.config("C_ChargeCheck_ID:" + C_ChargeCheck_ID);
                    } else if (this.wType == 3 || this.wType == 4) {
                        invoiceLine.setDescription("Cambio de documento");
                        invoiceLine.setC_Charge_ID(C_ChargeChange_ID);
                        this.log.config("C_ChargeReturn_ID:" + C_ChargeChange_ID);
                    } else if (this.wType == 1) {
                        invoiceLine.setDescription("Factoring");
                        if (!this.getPay && !this.extinguir) {
                            invoiceLine.setC_Charge_ID(C_Factoring_ID);
                        } else if (this.getPay && !this.extinguir) {
                            if (Tender.equals("Cheque") || Tender.equals("Check")) {
                                invoiceLine.setC_Charge_ID(C_FactoringPay_ID);
                            } else {
                                invoiceLine.setC_Charge_ID(C_FactoringPayL_ID);
                            }
                        } else {
                            invoiceLine.setC_Charge_ID(C_Extinguir_ID);
                        }
                        this.log.config("C_Factoring_ID:" + C_Factoring_ID + "-" + C_FactoringPay_ID);
                    }
                    this.log.config("C_Payment_ID:" + C_Payment_ID);
                    if (this.getPay) {
                        invoiceLine.set_ValueOfColumn("C_Payment_ID", (Object)C_Payment_ID);
                    } else {
                        invoiceLine.set_ValueOfColumn("C_InvoiceFac_ID", (Object)C_InvoiceFac_ID);
                    }
                    invoiceLine.setPriceActual(TrxAmt.abs());
                    invoiceLine.setPriceEntered(TrxAmt.abs());
                    invoiceLine.setQtyEntered(Env.ONE);
                    invoiceLine.setQtyInvoiced(Env.ONE);
                    invoiceLine.setC_Tax_ID(Tax_ID);
                    invoiceLine.saveEx();
                } else {
                    int C_InvoiceLine_ID = 0;
                    KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 6);
                    C_InvoiceLine_ID = pp.getKey();
                    if (C_InvoiceLine_ID > 0) {
                        MInvoiceLine invoiceLineFrom = new MInvoiceLine(Env.getCtx(), C_InvoiceLine_ID, trxName);
                        MInvoiceLine invoiceLineTo = new MInvoiceLine(invoice);
                        invoiceLineTo.setAD_Org_ID(invoiceLineFrom.getAD_Org_ID());
                        if (this.wType == 5) {
                            invoiceLineTo.set_CustomColumn("Ref_InvoiceLine_ID", invoiceLineFrom.get_ID());
                        } else if (this.wType == 6) {
                            invoiceLineTo.set_CustomColumn("Ref_InvoiceReqLine_ID", invoiceLineFrom.get_ID());
                        }
                        invoiceLineTo.setM_Product_ID(invoiceLineFrom.getM_Product_ID());
                        if (invoiceLineFrom.getC_Charge_ID() > 0) {
                            invoiceLineTo.setC_Charge_ID(invoiceLineFrom.getC_Charge_ID());
                        }
                        invoiceLineTo.setM_AttributeSetInstance_ID(invoiceLineFrom.getM_AttributeSetInstance_ID());
                        invoiceLineTo.setQtyEntered(invoiceLineFrom.getQtyEntered());
                        invoiceLineTo.setQtyInvoiced(invoiceLineFrom.getQtyEntered());
                        invoiceLineTo.setDescription(invoiceLineFrom.getDescription());
                        invoiceLineTo.setC_UOM_ID(invoiceLineFrom.getC_UOM_ID());
                        invoiceLineTo.setC_Tax_ID(invoiceLineFrom.getC_Tax_ID());
                        invoiceLineTo.setPrice(invoiceLineFrom.getPriceEntered());
                        invoiceLineTo.setLineNetAmt();
                        invoiceLineTo.saveEx();
                    }
                }
            }
            ++i;
        }
        return true;
    }
}

