/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleDriver;

public class TestConnection {
    private String m_jdbcURL;
    private String m_uid = "adempiere";
    private String m_pwd = "adempiere";
    private String m_sql = "SELECT * FROM AD_Element";
    private Connection m_conn;

    public TestConnection(String jdbcURL, String uid, String pwd) {
        System.out.println("Test Connection for " + jdbcURL);
        this.m_jdbcURL = jdbcURL;
        this.m_uid = uid;
        this.m_pwd = pwd;
        this.init();
        if (this.m_conn != null) {
            long time = this.test();
            time += this.test();
            time += this.test();
            System.out.println("");
            System.out.println("Total Average (" + this.m_jdbcURL + ")= " + (time += this.test()) / 4L + "ms");
        }
    }

    private void init() {
        long start = System.currentTimeMillis();
        Driver driver = null;
        try {
            driver = DriverManager.getDriver(this.m_jdbcURL);
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (driver == null) {
            try {
                DriverManager.registerDriver((Driver)new OracleDriver());
            }
            catch (SQLException ex) {
                System.err.println("Init = register Driver: " + ex);
            }
        }
        long end = System.currentTimeMillis();
        System.out.println("(1) Driver = " + (end - start) + "ms");
        start = System.currentTimeMillis();
        try {
            this.m_conn = DriverManager.getConnection(this.m_jdbcURL, this.m_uid, this.m_pwd);
        }
        catch (SQLException ex) {
            System.err.println("Init = get Connection: " + ex);
        }
        end = System.currentTimeMillis();
        System.out.println("(2) Get Connection = " + (end - start) + "ms");
        start = System.currentTimeMillis();
        try {
            if (this.m_conn != null) {
                this.m_conn.close();
            }
        }
        catch (SQLException ex) {
            System.err.println("Init = close Connection: " + ex);
        }
        end = System.currentTimeMillis();
        System.out.println("(3) Close Connection = " + (end - start) + "ms");
    }

    private long test() {
        System.out.println("");
        long totalStart = System.currentTimeMillis();
        long start = System.currentTimeMillis();
        try {
            this.m_conn = DriverManager.getConnection(this.m_jdbcURL, this.m_uid, this.m_pwd);
        }
        catch (SQLException ex) {
            System.err.println("Test get Connection: " + ex);
            return -1L;
        }
        long end = System.currentTimeMillis();
        System.out.println("(A) Get Connection = " + (end - start) + "ms");
        try {
            start = System.currentTimeMillis();
            Statement stmt = this.m_conn.createStatement();
            end = System.currentTimeMillis();
            System.out.println("(B) Create Statement = " + (end - start) + "ms");
            start = System.currentTimeMillis();
            ResultSet rs = stmt.executeQuery(this.m_sql);
            end = System.currentTimeMillis();
            System.out.println("(C) Execute Query = " + (end - start) + "ms");
            int no = 0;
            start = System.currentTimeMillis();
            while (rs.next()) {
                int i = rs.getInt("AD_Client_ID");
                String s = rs.getString("Name");
                i += s.length();
                ++no;
            }
            end = System.currentTimeMillis();
            System.out.println("(D) Read ResultSet = " + (end - start) + "ms - per 10 rows " + (end - start) / (long)(no / 10) + "ms");
            start = System.currentTimeMillis();
            rs.close();
            end = System.currentTimeMillis();
            System.out.println("(E) Close ResultSet = " + (end - start) + "ms");
            start = System.currentTimeMillis();
            stmt.close();
            end = System.currentTimeMillis();
            System.out.println("(F) Close Statement = " + (end - start) + "ms");
        }
        catch (SQLException e) {
            System.err.println("Test: " + e);
        }
        start = System.currentTimeMillis();
        try {
            if (this.m_conn != null) {
                this.m_conn.close();
            }
        }
        catch (SQLException ex) {
            System.err.println("Test close Connection: " + ex);
        }
        end = System.currentTimeMillis();
        System.out.println("(G) Close Connection = " + (end - start) + "ms");
        long totalEnd = System.currentTimeMillis();
        System.out.println("Total Test = " + (totalEnd - totalStart) + "ms");
        return totalEnd - totalStart;
    }

    public static void main(String[] args) {
        String url = "jdbc:oracle:thin:@//24.151.26.64:1521/lap11";
        String uid = "adempiere";
        String pwd = "adempiere";
        if (args.length == 0) {
            System.out.println("TestConnection <jdbcUrl> <uid> <pwd>");
            System.out.println("Example: jdbc:oracle:thin:@//dev:1521/dev adempiere adempiere");
            System.out.println("Example: jdbc:oracle:oci8:@dev adempiere adempiere");
        } else if (args.length > 0) {
            url = args[0];
        } else if (args.length > 1) {
            url = args[1];
        } else if (args.length > 2) {
            url = args[2];
        }
        System.out.println("");
        TestConnection test = new TestConnection(url, uid, pwd);
    }
}

