/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class InfoOrder
extends Info {
    private static final long serialVersionUID = 2246871771555208114L;
    private int fieldID = 0;
    private CLabel lDocumentNo = new CLabel(Msg.translate(Env.getCtx(), "DocumentNo"));
    private CTextField fDocumentNo = new CTextField(10);
    private CLabel lDescription = new CLabel(Msg.translate(Env.getCtx(), "Description"));
    private CTextField fDescription = new CTextField(10);
    private CLabel lPOReference = new CLabel(Msg.translate(Env.getCtx(), "POReference"));
    private CTextField fPOReference = new CTextField(10);
    private CLabel lBPartner_ID = new CLabel(Msg.translate(Env.getCtx(), "BPartner"));
    private VLookup fBPartner_ID;
    private CLabel lDateFrom = new CLabel(Msg.translate(Env.getCtx(), "DateOrdered"));
    private VDate fDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private CLabel lDateTo = new CLabel("- ");
    private VDate fDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private CLabel lAmtFrom = new CLabel(Msg.translate(Env.getCtx(), "GrandTotal"));
    private VNumber fAmtFrom = new VNumber("AmtFrom", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtFrom"));
    private CLabel lAmtTo = new CLabel("- ");
    private VNumber fAmtTo = new VNumber("AmtTo", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtTo"));
    private VCheckBox fIsSOTrx = new VCheckBox("IsSOTrx", false, false, true, Msg.translate(Env.getCtx(), "IsSOTrx"), "", false);
    private VCheckBox fIsDelivered = new VCheckBox("IsDelivered", false, false, true, Msg.translate(Env.getCtx(), "IsDelivered"), "", false);
    private static String s_From = " C_Order o";
    private static String s_Order = "2,3,4";
    private static Info_Column[] s_Layout = null;

    @Deprecated
    protected InfoOrder(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause) {
        this(frame, modal, WindowNo, 0, value, multiSelection, true, whereClause);
    }

    protected InfoOrder(Frame frame, boolean modal, int WindowNo, int record_id, String value, boolean multiSelection, boolean saveResults, String whereClause) {
        super(frame, modal, WindowNo, "o", "C_Order_ID", multiSelection, saveResults, whereClause);
        this.log.info("InfoOrder");
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoOrder"));
        StringBuffer where = new StringBuffer("o.IsActive='Y'");
        if (whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(whereClause, "C_Order.", "o."));
        }
        this.setWhereClause(where.toString());
        this.setTableLayout(s_Layout);
        this.setFromClause(s_From);
        this.setOrderClause(s_Order);
        this.setShowTotals(true);
        this.statInit();
        this.initInfo(record_id, value);
        this.m_heldLastFocus = this.fDocumentNo;
        if (this.autoQuery() || record_id != 0 || value != null && value.length() > 0 && value != "%") {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        this.lDocumentNo.setLabelFor(this.fDocumentNo);
        this.fDocumentNo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDocumentNo.addActionListener(this);
        this.lDescription.setLabelFor(this.fDescription);
        this.fDescription.setBackground(AdempierePLAF.getInfoBackground());
        this.fDescription.addActionListener(this);
        this.lPOReference.setLabelFor(this.fPOReference);
        this.fPOReference.setBackground(AdempierePLAF.getInfoBackground());
        this.fPOReference.addActionListener(this);
        this.fIsSOTrx.setSelected(!"N".equals(Env.getContext(Env.getCtx(), this.p_WindowNo, "IsSOTrx")));
        this.fIsSOTrx.addActionListener(this);
        this.fIsDelivered.setSelected(false);
        this.fIsDelivered.addActionListener(this);
        this.fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("C_Order", "C_BPartner_ID"), 30));
        this.lBPartner_ID.setLabelFor(this.fBPartner_ID);
        this.fBPartner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fBPartner_ID.addActionListener(this);
        this.lDateFrom.setLabelFor(this.fDateFrom);
        this.fDateFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateFrom.setToolTipText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.fDateFrom.addActionListener(this);
        this.lDateTo.setLabelFor(this.fDateTo);
        this.fDateTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateTo.setToolTipText(Msg.translate(Env.getCtx(), "DateTo"));
        this.fDateTo.addActionListener(this);
        this.lAmtFrom.setLabelFor(this.fAmtFrom);
        this.fAmtFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtFrom.setToolTipText(Msg.translate(Env.getCtx(), "AmtFrom"));
        this.fAmtFrom.addActionListener(this);
        this.fAmtFrom.setBorder(this.fDateFrom.getBorder());
        this.lAmtTo.setLabelFor(this.fAmtTo);
        this.fAmtTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtTo.setToolTipText(Msg.translate(Env.getCtx(), "AmtTo"));
        this.fAmtTo.addActionListener(this);
        this.fAmtTo.setBorder(this.fDateFrom.getBorder());
        CPanel amtPanel = new CPanel();
        CPanel datePanel = new CPanel();
        amtPanel.setLayout(new ALayout(0, 0, true));
        amtPanel.add((Component)this.fAmtFrom, new ALayoutConstraint(0, 0));
        amtPanel.add((Component)this.lAmtTo, null);
        amtPanel.add((Component)this.fAmtTo, null);
        datePanel.setLayout(new ALayout(0, 0, true));
        datePanel.add((Component)this.fDateFrom, new ALayoutConstraint(0, 0));
        datePanel.add((Component)this.lDateTo, null);
        datePanel.add((Component)this.fDateTo, null);
        this.p_criteriaGrid.add((Component)this.lDocumentNo, new ALayoutConstraint(0, 0));
        this.p_criteriaGrid.add((Component)this.fDocumentNo, null);
        this.p_criteriaGrid.add((Component)this.lDescription, null);
        this.p_criteriaGrid.add((Component)this.fDescription, null);
        this.p_criteriaGrid.add((Component)this.fIsSOTrx, new ALayoutConstraint(0, 4));
        this.p_criteriaGrid.add((Component)this.lBPartner_ID, new ALayoutConstraint(1, 0));
        this.p_criteriaGrid.add((Component)this.fBPartner_ID, null);
        this.p_criteriaGrid.add((Component)this.lDateFrom, null);
        this.p_criteriaGrid.add((Component)datePanel, null);
        this.p_criteriaGrid.add((Component)this.fIsDelivered, new ALayoutConstraint(1, 4));
        this.p_criteriaGrid.add((Component)this.lPOReference, new ALayoutConstraint(2, 0));
        this.p_criteriaGrid.add((Component)this.fPOReference, null);
        this.p_criteriaGrid.add((Component)this.lAmtFrom, null);
        this.p_criteriaGrid.add((Component)amtPanel, null);
    }

    @Override
    protected void initInfo(int record_id, String value) {
        if (record_id != 0 && value != null && value.length() > 0) {
            this.log.severe("Received both a record_id and a value: " + record_id + " - " + value);
        }
        if (record_id != 0) {
            this.fieldID = record_id;
            String trxName = Trx.createTrxName();
            MOrder o = new MOrder(Env.getCtx(), record_id, trxName);
            this.fIsSOTrx.setValue(o.isSOTrx());
            this.fIsDelivered.setValue(o.isDelivered());
            o = null;
            Trx.get(trxName, false).close();
        } else {
            String id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_BPartner_ID", true);
            if (id != null && id.length() != 0 && new Integer(id) > 0) {
                this.fBPartner_ID.setValue(new Integer(id));
            }
            if (value != null && value.length() > 0) {
                this.fDocumentNo.setValue(value);
            } else {
                id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_Order_ID", true);
                if (id != null && id.length() != 0 && new Integer(id) > 0) {
                    this.fieldID = new Integer(id);
                    String trxName = Trx.createTrxName();
                    MOrder o = new MOrder(Env.getCtx(), record_id, trxName);
                    this.fIsSOTrx.setValue(o.isSOTrx());
                    this.fIsDelivered.setValue(o.isDelivered());
                    o = null;
                    Trx.get(trxName, false).close();
                }
            }
        }
    }

    @Override
    protected Info_Column[] getTableLayout() {
        ArrayList<Info_Column> list = new ArrayList<Info_Column>();
        list.add(new Info_Column(" ", "o.C_Order_ID", IDColumn.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=o.C_BPartner_ID)", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "DateOrdered"), "o.DateOrdered", Timestamp.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "DocumentNo"), "o.DocumentNo", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "C_Currency_ID"), "(SELECT ISO_Code FROM C_Currency c WHERE c.C_Currency_ID=o.C_Currency_ID)", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "GrandTotal"), "o.GrandTotal", BigDecimal.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "ConvertedAmount"), "currencyBase(o.GrandTotal,o.C_Currency_ID,o.DateAcct, o.AD_Client_ID,o.AD_Org_ID)", BigDecimal.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "IsSOTrx"), "o.IsSOTrx", Boolean.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "Description"), "o.Description", String.class));
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "POReference"), "o.POReference", String.class));
        if (this.fIsSOTrx.isSelected()) {
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "IsDelivered"), "o.IsDelivered", Boolean.class));
        } else {
            list.add(new Info_Column(Msg.translate(Env.getCtx(), "Received"), "o.IsDelivered", Boolean.class));
        }
        list.add(new Info_Column(Msg.translate(Env.getCtx(), "DocStatus"), "o.docstatus", String.class));
        s_Layout = new Info_Column[list.size()];
        list.toArray(s_Layout);
        return s_Layout;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        VCheckBox cb;
        if (!this.p_loadedOK) {
            return;
        }
        if (e.getSource() != null && e.getSource() instanceof VCheckBox && (cb = (VCheckBox)e.getSource()).getName().equals("IsSOTrx")) {
            if (cb.isSelected()) {
                this.fIsDelivered.setText(Msg.translate(Env.getCtx(), "IsDelivered"));
            } else {
                this.fIsDelivered.setText(Msg.translate(Env.getCtx(), "Received"));
            }
        }
        super.actionPerformed(e);
    }

    @Override
    protected String getSQLWhere() {
        Comparable<Date> to;
        Comparable<Date> from;
        StringBuffer sql = new StringBuffer();
        if (this.isResetRecordID()) {
            this.fieldID = 0;
        }
        if (this.fieldID != 0) {
            sql.append(" AND o.C_Order_ID = ?");
        }
        if (InfoOrder.isValidSQLText(this.fDocumentNo)) {
            sql.append(" AND UPPER(o.DocumentNo) LIKE ?");
        }
        if (InfoOrder.isValidSQLText(this.fDescription)) {
            sql.append(" AND UPPER(o.Description) LIKE ?");
        }
        if (InfoOrder.isValidSQLText(this.fPOReference)) {
            sql.append(" AND UPPER(o.POReference) LIKE ?");
        }
        if (this.fBPartner_ID.getValue() != null) {
            sql.append(" AND o.C_BPartner_ID=?");
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(o.DateOrdered, 'DD') <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(o.DateOrdered, 'DD') >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(o.DateOrdered, 'DD') BETWEEN ? AND ?");
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND o.GrandTotal <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND o.GrandTotal >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND o.GrandTotal BETWEEN ? AND ?");
            }
        }
        sql.append(" AND o.IsSOTrx=?");
        sql.append(" AND o.IsDelivered=?");
        this.log.finer(sql.toString());
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        Comparable<Date> to;
        Comparable<Date> from;
        int index = 1;
        if (this.fieldID != 0) {
            pstmt.setInt(index++, this.fieldID);
        }
        if (InfoOrder.isValidSQLText(this.fDocumentNo)) {
            pstmt.setString(index++, InfoOrder.getSQLText(this.fDocumentNo));
        }
        if (InfoOrder.isValidSQLText(this.fDescription)) {
            pstmt.setString(index++, InfoOrder.getSQLText(this.fDescription));
        }
        if (InfoOrder.isValidSQLText(this.fPOReference)) {
            pstmt.setString(index++, InfoOrder.getSQLText(this.fPOReference));
        }
        if (this.fBPartner_ID.getValue() != null) {
            Integer bp = (Integer)this.fBPartner_ID.getValue();
            pstmt.setInt(index++, bp);
            this.log.fine("BPartner=" + bp);
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            this.log.fine("Date From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
                pstmt.setTimestamp(index++, (Timestamp)to);
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            this.log.fine("Amt From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            } else if (from != null && to == null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
            } else if (from != null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            }
        }
        pstmt.setString(index++, this.fIsSOTrx.isSelected() ? "Y" : "N");
        pstmt.setString(index++, this.fIsDelivered.isSelected() ? "Y" : "N");
    }

    @Override
    protected void zoom(int record_ID) {
        this.log.info("");
        Integer C_Order_ID = record_ID;
        if (C_Order_ID == null) {
            return;
        }
        MQuery query = new MQuery("C_Order");
        query.addRestriction("C_Order_ID", "=", C_Order_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("C_Order", this.fIsSOTrx.isSelected());
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    @Override
    protected boolean columnIsDynamic(Object o) {
        return o.equals(this.fIsSOTrx);
    }

    @Override
    protected boolean hasOutstandingChanges() {
        return this.fAmtFrom.hasChanged() || this.fAmtTo.hasChanged() || this.fBPartner_ID.hasChanged() || this.fDescription.hasChanged() || this.fDocumentNo.hasChanged() || this.fDateFrom.hasChanged() || this.fDateTo.hasChanged() || this.fIsDelivered.hasChanged() || this.fIsSOTrx.hasChanged() || this.fPOReference.hasChanged();
    }

    @Override
    protected void setFieldOldValues() {
        this.fAmtFrom.set_oldValue();
        this.fAmtTo.set_oldValue();
        this.fBPartner_ID.set_oldValue();
        this.fDescription.set_oldValue();
        this.fDocumentNo.set_oldValue();
        this.fDateFrom.set_oldValue();
        this.fDateTo.set_oldValue();
        this.fIsDelivered.set_oldValue();
        this.fIsSOTrx.set_oldValue();
        this.fPOReference.set_oldValue();
    }
}

