/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.compiere.apps.search.Find;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.grid.ed.VNumber;
import org.compiere.grid.ed.VString;
import org.compiere.model.GridField;
import org.compiere.model.MQuery;
import org.compiere.util.CLogger;
import org.compiere.util.ValueNamePair;

public final class FindValueEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = -4819832280924881253L;
    private Find m_find;
    private boolean m_valueToColumn;
    private boolean m_between = false;
    private VEditor m_editor = null;
    private static CLogger log = CLogger.getCLogger(FindValueEditor.class);

    public FindValueEditor(Find find, boolean valueTo) {
        this.m_find = find;
        this.m_valueToColumn = valueTo;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.m_editor == null) {
            return null;
        }
        Object obj = this.m_editor.getValue();
        log.config("Obj=" + obj);
        return obj;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table2, Object value, boolean isSelected, int row, int col) {
        this.m_between = false;
        Object betweenValue = table2.getModel().getValueAt(row, 3);
        if (this.m_valueToColumn && betweenValue != null && betweenValue.equals(MQuery.OPERATORS[8])) {
            this.m_between = true;
        }
        boolean enabled = !this.m_valueToColumn || this.m_valueToColumn && this.m_between;
        log.config("(" + value + ") - Enabled=" + enabled);
        if (enabled) {
            GridField field;
            String columnName = null;
            Object column = table2.getModel().getValueAt(row, 2);
            if (column != null) {
                columnName = ((ValueNamePair)column).getValue();
            }
            this.m_editor = (field = this.m_find.getTargetMField(columnName)).isKey() ? new VNumber(columnName, false, false, true, 11, columnName) : VEditorFactory.getEditor(field, true);
            if (this.m_editor == null) {
                this.m_editor = new VString();
            }
            this.m_editor.setValue(value);
            this.m_editor.setReadWrite(enabled);
            this.m_editor.setBorder(null);
        } else {
            this.m_editor = null;
        }
        return (Component)((Object)this.m_editor);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject e) {
        boolean retValue = !this.m_valueToColumn || this.m_valueToColumn && this.m_between;
        return retValue;
    }
}

