/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.PayPrint;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaymentBatch;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.ReportCtl;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.PaymentExport;
import org.compiere.util.ValueNamePair;

public class VPayPrint
extends PayPrint
implements FormPanel,
ActionListener,
VetoableChangeListener {
    private CPanel panel = new CPanel();
    private FormFrame m_frame;
    private CPanel centerPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private FlowLayout southLayout = new FlowLayout();
    private GridBagLayout centerLayout = new GridBagLayout();
    private JButton bPrint = ConfirmPanel.createPrintButton(true);
    private JButton bExport = ConfirmPanel.createExportButton(true);
    private JButton bCancel = ConfirmPanel.createCancelButton(true);
    private JButton bProcess = ConfirmPanel.createProcessButton(Msg.getMsg(Env.getCtx(), "VPayPrintProcess"));
    private CLabel lPaySelect = new CLabel();
    private VLookup paySelectSearch = null;
    private CLabel lBank = new CLabel();
    private CLabel fBank = new CLabel();
    private CLabel lPaymentRule = new CLabel();
    private CComboBox fPaymentRule = new CComboBox();
    private CLabel lDocumentNo = new CLabel();
    private VNumber fDocumentNo = new VNumber();
    private CLabel lNoPayments = new CLabel();
    private CLabel fNoPayments = new CLabel();
    private CLabel lBalance = new CLabel();
    private VNumber fBalance = new VNumber();
    private CLabel lCurrency = new CLabel();
    private CLabel fCurrency = new CLabel();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.centerPanel, "Center");
            frame.getContentPane().add((Component)this.southPanel, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this.panel);
        this.southPanel.setLayout(this.southLayout);
        this.southLayout.setAlignment(2);
        this.centerPanel.setLayout(this.centerLayout);
        this.bPrint.addActionListener(this);
        this.bExport.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bProcess.setText(Msg.getMsg(Env.getCtx(), "EFT"));
        this.bProcess.setEnabled(false);
        this.bProcess.addActionListener(this);
        this.lPaySelect.setText(Msg.translate(Env.getCtx(), "C_PaySelection_ID"));
        this.lBank.setText(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
        this.lPaymentRule.setText(Msg.translate(Env.getCtx(), "PaymentRule"));
        this.fPaymentRule.addActionListener(this);
        this.lDocumentNo.setText(Msg.translate(Env.getCtx(), "DocumentNo"));
        this.fDocumentNo.setDisplayType(11);
        this.lNoPayments.setText(Msg.getMsg(Env.getCtx(), "NoOfPayments"));
        this.fNoPayments.setText("0");
        this.lBalance.setText(Msg.translate(Env.getCtx(), "CurrentBalance"));
        this.fBalance.setReadWrite(false);
        this.fBalance.setDisplayType(12);
        this.lCurrency.setText(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        this.southPanel.add((Component)this.bCancel, null);
        this.southPanel.add((Component)this.bExport, null);
        this.southPanel.add((Component)this.bPrint, null);
        this.southPanel.add((Component)this.bProcess, null);
        this.centerPanel.add((Component)this.lPaySelect, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.paySelectSearch, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(12, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lBank, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fBank, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lPaymentRule, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fPaymentRule, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lDocumentNo, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fDocumentNo, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lNoPayments, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fNoPayments, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lBalance, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fBalance, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 12), 0, 0));
        this.centerPanel.add((Component)this.lCurrency, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 12, 5), 0, 0));
        this.centerPanel.add((Component)this.fCurrency, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 12, 12), 0, 0));
    }

    private void dynInit() {
        int AD_Column_ID = 7670;
        MLookup lookupPS = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.paySelectSearch = new VLookup("C_PaySelection_ID", true, false, true, lookupPS);
        this.paySelectSearch.addVetoableChangeListener(this);
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void setPaySelection(int C_PaySelection_ID) {
        if (C_PaySelection_ID == 0) {
            return;
        }
        this.m_C_PaySelection_ID = C_PaySelection_ID;
        this.paySelectSearch.setValue(new Integer(this.m_C_PaySelection_ID));
        this.loadPaySelectInfo();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bCancel) {
            this.dispose();
        } else {
            if (this.m_C_PaySelection_ID <= 0) {
                return;
            }
            if (e.getSource() == this.fPaymentRule) {
                this.loadPaymentRuleInfo();
            } else if (e.getSource() == this.bExport) {
                this.cmd_export();
            } else if (e.getSource() == this.bProcess) {
                this.cmd_EFT();
            } else if (e.getSource() == this.bPrint) {
                this.cmd_print();
            }
        }
    }

    private void loadPaySelectInfo() {
        log.info("VPayPrint.loadPaySelectInfo");
        if (this.m_C_PaySelection_ID <= 0) {
            return;
        }
        this.loadPaySelectInfo(this.m_C_PaySelection_ID);
        this.fBank.setText(this.bank);
        this.fCurrency.setText(this.currency);
        this.fBalance.setValue(this.balance);
        this.m_frame.pack();
        this.loadPaymentRule();
    }

    private void loadPaymentRule() {
        log.info("");
        if (this.m_C_BankAccount_ID == -1) {
            return;
        }
        this.fPaymentRule.removeAllItems();
        ArrayList<ValueNamePair> data = this.loadPaymentRule(this.m_C_PaySelection_ID);
        for (ValueNamePair pp : data) {
            this.fPaymentRule.addItem(pp);
        }
        if (this.fPaymentRule.getItemCount() > 0) {
            this.fPaymentRule.setSelectedIndex(0);
        }
        this.loadPaymentRuleInfo();
    }

    private void loadPaymentRuleInfo() {
        ValueNamePair pp = (ValueNamePair)this.fPaymentRule.getSelectedItem();
        if (pp == null) {
            return;
        }
        String PaymentRule = pp.getValue();
        log.info("PaymentRule=" + PaymentRule);
        this.fNoPayments.setText(" ");
        String msg = this.loadPaymentRuleInfo(this.m_C_PaySelection_ID, PaymentRule);
        if (this.noPayments != null) {
            this.fNoPayments.setText(this.noPayments);
        }
        this.bProcess.setEnabled(PaymentRule.equals("T"));
        if (this.documentNo != null) {
            this.fDocumentNo.setValue(this.documentNo);
        }
        if (msg != null && msg.length() > 0) {
            ADialog.error(this.m_WindowNo, this.panel, msg);
        }
    }

    private void cmd_export() {
        ValueNamePair pp = (ValueNamePair)this.fPaymentRule.getSelectedItem();
        if (pp == null) {
            return;
        }
        String PaymentRule = pp.getValue();
        log.info(PaymentRule);
        if (!this.getChecks(PaymentRule)) {
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(Msg.getMsg(Env.getCtx(), "Export"));
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setSelectedFile(new File("paymentExport.txt"));
        if (fc.showSaveDialog(this.panel) != 0) {
            return;
        }
        int no = 0;
        StringBuffer err = new StringBuffer("");
        if (this.m_PaymentExportClass == null || this.m_PaymentExportClass.trim().length() == 0) {
            this.m_PaymentExportClass = "org.compiere.util.GenericPaymentExport";
        }
        PaymentExport custom = null;
        try {
            Class<?> clazz = Class.forName(this.m_PaymentExportClass);
            custom = (PaymentExport)clazz.newInstance();
            no = custom.exportToFile(this.m_checks, fc.getSelectedFile(), err);
        }
        catch (ClassNotFoundException e) {
            no = -1;
            err.append("No custom PaymentExport class " + this.m_PaymentExportClass + " - " + e.toString());
            log.log(Level.SEVERE, err.toString(), e);
        }
        catch (Exception e) {
            no = -1;
            err.append("Error in " + this.m_PaymentExportClass + " check log, " + e.toString());
            log.log(Level.SEVERE, err.toString(), e);
        }
        if (no >= 0) {
            ADialog.info(this.m_WindowNo, this.panel, "Saved", fc.getSelectedFile().getAbsolutePath() + "\n" + Msg.getMsg(Env.getCtx(), "NoOfLines") + "=" + no);
            if (ADialog.ask(this.m_WindowNo, this.panel, "VPayPrintSuccess?")) {
                MPaySelectionCheck.confirmPrint(this.m_checks, this.m_batch);
            }
        } else {
            ADialog.error(this.m_WindowNo, this.panel, "Error", err.toString());
        }
        this.dispose();
    }

    private void cmd_EFT() {
        ValueNamePair pp = (ValueNamePair)this.fPaymentRule.getSelectedItem();
        if (pp == null) {
            return;
        }
        String PaymentRule = pp.getValue();
        log.info(PaymentRule);
        if (!this.getChecks(PaymentRule)) {
            return;
        }
        this.dispose();
    }

    private void cmd_print() {
        int lastDocumentNo;
        MPaySelectionCheck check;
        int i;
        ValueNamePair pp = (ValueNamePair)this.fPaymentRule.getSelectedItem();
        if (pp == null) {
            return;
        }
        String PaymentRule = pp.getValue();
        log.info(PaymentRule);
        if (!this.getChecks(PaymentRule)) {
            return;
        }
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
        boolean somethingPrinted = false;
        boolean directPrint = !Ini.isPropertyBool("PrintPreview");
        for (i = 0; i < this.m_checks.length; ++i) {
            check = this.m_checks[i];
            boolean ok = ReportCtl.startDocumentPrint(6, check.get_ID(), null, Env.getWindowNo(this.panel), directPrint);
            if (somethingPrinted || !ok) continue;
            somethingPrinted = true;
        }
        if (somethingPrinted && ADialog.ask(this.m_WindowNo, this.panel, "VPayPrintSuccess?") && (lastDocumentNo = MPaySelectionCheck.confirmPrint(this.m_checks, this.m_batch)) != 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE C_BankAccountDoc SET CurrentNext=").append(++lastDocumentNo).append(" WHERE C_BankAccount_ID=").append(this.m_C_BankAccount_ID).append(" AND PaymentRule='").append(PaymentRule).append("'");
            DB.executeUpdate(sb.toString(), null);
        }
        if (ADialog.ask(this.m_WindowNo, this.panel, "VPayPrintPrintRemittance")) {
            for (i = 0; i < this.m_checks.length; ++i) {
                check = this.m_checks[i];
                ReportCtl.startDocumentPrint(5, check.get_ID(), null, Env.getWindowNo(this.panel), directPrint);
            }
        }
        this.panel.setCursor(Cursor.getDefaultCursor());
        this.dispose();
    }

    private boolean getChecks(String PaymentRule) {
        if (this.m_C_PaySelection_ID <= 0 || this.m_C_BankAccount_ID == -1 || this.fPaymentRule.getSelectedIndex() == -1 || this.fDocumentNo.getValue() == null) {
            ADialog.error(this.m_WindowNo, this.panel, "VPayPrintNoRecords", "(" + Msg.translate(Env.getCtx(), "C_PaySelectionLine_ID") + "=0)");
            return false;
        }
        int startDocumentNo = ((Number)this.fDocumentNo.getValue()).intValue();
        log.config("C_PaySelection_ID=" + this.m_C_PaySelection_ID + ", PaymentRule=" + PaymentRule + ", DocumentNo=" + startDocumentNo);
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
        this.m_checks = MPaySelectionCheck.get(this.m_C_PaySelection_ID, PaymentRule, startDocumentNo, null);
        this.panel.setCursor(Cursor.getDefaultCursor());
        if (this.m_checks == null || this.m_checks.length == 0) {
            ADialog.error(this.m_WindowNo, this.panel, "VPayPrintNoRecords", "(" + Msg.translate(Env.getCtx(), "C_PaySelectionLine_ID") + " #0");
            return false;
        }
        this.m_batch = MPaymentBatch.getForPaySelection(Env.getCtx(), this.m_C_PaySelection_ID, null);
        return true;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(name + "=" + value);
        if (value == null) {
            return;
        }
        if (name.equals("C_PaySelection_ID")) {
            this.paySelectSearch.setValue(value);
            this.m_C_PaySelection_ID = (Integer)value;
            this.loadPaySelectInfo();
        }
    }
}

