/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Stack;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.DeleteEntitiesModel;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MTable;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class VDelete
extends CPanel
implements FormPanel,
ActionListener {
    private static final long serialVersionUID = 149783846292562740L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VDelete.class);
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel CenterPanel = new CPanel();
    private GridLayout centerLayout = new GridLayout(0, 2);
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private JScrollPane treePane;
    private CheckboxTree tree;
    private CLabel clientLabel;
    private CComboBox clientPick;
    private VLookup tablePick;
    private CLabel tableLabel;
    private CCheckBox dryRun;
    private Integer clientId;
    private DefaultMutableTreeNode rootNode;
    private Trx m_trx;
    private int m_totalCount;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.info("VMerge.init - WinNo=" + this.m_WindowNo);
        try {
            this.preInit();
            this.jbInit();
            frame.getContentPane().add((Component)this, "Center");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    private void createNodes(DefaultMutableTreeNode root) {
        DeleteEntitiesModel currentNode = (DeleteEntitiesModel)root.getUserObject();
        HashSet<String> tablesIgnored = new HashSet<String>(Arrays.asList("T_Report", "T_ReportStatement", "AD_Attribute_Value", "AD_PInstance_Log", "A_Valid_Asset_Combinations"));
        if (tablesIgnored.contains(currentNode.tableName)) {
            return;
        }
        String sql = "SELECT t.TableName, c.ColumnName, c.IsMandatory FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE t.IsView='N' AND c.ColumnName NOT IN ('CreatedBy', 'UpdatedBy')  AND t.TableName NOT IN ('C_TaxDeclarationAcct',?) AND ((c.ColumnName=? AND c.IsKey='N' AND c.ColumnSQL IS NULL) OR c.AD_Reference_Value_ID IN (SELECT rt.AD_Reference_ID FROM AD_Ref_Table rt INNER JOIN AD_Table tt ON (rt.AD_Table_ID=tt.AD_Table_ID) WHERE tt.TableName = ? ) ) ORDER BY t.LoadSeq DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String keyCol = currentNode.tableName + "_ID";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, currentNode.tableName);
            pstmt.setString(2, keyCol);
            pstmt.setString(3, currentNode.tableName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                DeleteEntitiesModel data = new DeleteEntitiesModel();
                data.mandatoryLink = "Y".equals(rs.getString(3));
                data.tableName = rs.getString(1);
                data.joinColumn = rs.getString(2);
                data.whereClause = " EXISTS (SELECT 1 FROM " + currentNode.tableName + " WHERE " + currentNode.tableName + "." + currentNode.tableName + "_ID" + " = " + data.tableName + "." + data.joinColumn + " AND " + currentNode.whereClause + ") ";
                int count = data.getCount();
                if (count > 0) {
                    DefaultMutableTreeNode node = new DefaultMutableTreeNode(data.tableName);
                    node.setUserObject(data);
                    log.log(Level.FINE, "Adding node: " + data.tableName + "." + data.joinColumn);
                    root.add(node);
                    continue;
                }
                log.log(Level.FINE, "No records:" + data.tableName);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.INFO, sql);
                throw new AdempiereException("Couldn't load child tables", e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        Enumeration<TreeNode> kids = root.children();
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)kids.nextElement();
            if (root.isNodeAncestor(node)) {
                log.log(Level.WARNING, "Loop detected, escaping.");
                break;
            }
            if (!((DeleteEntitiesModel)node.getUserObject()).mandatoryLink) continue;
            this.createNodes(node);
        }
    }

    private void preInit() {
        this.dryRun = new CCheckBox("Dry Run", true);
        this.clientLabel = new CLabel(Msg.getMsg(Env.getCtx(), "AD_Client_ID"));
        String sql = "SELECT AD_Client_ID, Name FROM AD_Client WHERE AD_Client_ID <> 0";
        Object[] clients = DB.getKeyNamePairs(sql, false);
        this.clientPick = new CComboBox(clients);
        this.clientPick.insertItemAt(null, 0);
        this.clientPick.setSelectedItem(null);
        this.clientPick.setMandatory(true);
        this.clientPick.setBackground(false);
        this.tableLabel = new CLabel(Msg.getMsg(Env.getCtx(), "AD_Table_ID"));
        this.tablePick = new VLookup("AD_Table_ID", true, false, true, MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, 114, 19));
        this.tablePick.setValue(new Integer(Env.getContextAsInt(Env.getCtx(), "$AD_Table_ID")));
        this.tablePick.setMandatory(true);
        this.tablePick.addActionListener(this);
        DeleteEntitiesModel root = new DeleteEntitiesModel();
        root.tableName = "Tables";
        this.rootNode = new DefaultMutableTreeNode(null);
        this.tree = new CheckboxTree(this.rootNode);
        this.treePane = new JScrollPane(this.tree);
        JViewport viewPort = this.treePane.getViewport();
        viewPort.add(this.tree);
    }

    void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.mainLayout.setHgap(5);
        this.mainLayout.setVgap(5);
        this.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this);
        this.centerLayout.setHgap(5);
        this.centerLayout.setVgap(5);
        this.centerLayout.setColumns(5);
        this.centerLayout.setRows(0);
        this.CenterPanel.setLayout(this.centerLayout);
        this.add((Component)this.CenterPanel, "North");
        this.CenterPanel.add(this.clientLabel);
        this.CenterPanel.add(this.clientPick);
        this.CenterPanel.add(this.tableLabel);
        this.CenterPanel.add(this.tablePick);
        this.CenterPanel.add(this.dryRun);
        this.add((Component)this.treePane, "Center");
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        log.log(Level.FINE, "from: " + e.getSource() + " action: " + e.getActionCommand());
        boolean commit = !this.dryRun.isSelected();
        Object o = this.tablePick.getValue();
        int tableId = 0;
        if (o != null) {
            tableId = (Integer)o;
        }
        if ((o = this.clientPick.getValue()) != null) {
            this.clientId = ((KeyNamePair)o).getKey();
        }
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        if (e.getActionCommand().equals("Ok")) {
            if (tableId == 0 || this.clientId == 0) {
                ADialog.error(this.m_WindowNo, this, "Error", "Select client and base table for cascade delete.");
            } else {
                this.m_totalCount = 0;
                this.m_trx = Trx.get(Trx.createTrxName("delete"), true);
                String errorMsg = "";
                try {
                    Enumeration<TreeNode> nodes = this.rootNode.breadthFirstEnumeration();
                    Stack<DeleteEntitiesModel> stack = new Stack<DeleteEntitiesModel>();
                    while (nodes.hasMoreElements()) {
                        stack.push((DeleteEntitiesModel)((DefaultMutableTreeNode)nodes.nextElement()).getUserObject());
                    }
                    while (!stack.empty()) {
                        DeleteEntitiesModel tableData = (DeleteEntitiesModel)stack.pop();
                        this.m_totalCount += tableData.delete(this.m_trx);
                    }
                    if (commit) {
                        this.m_trx.commit(true);
                    } else {
                        this.m_trx.rollback(true);
                    }
                }
                catch (Exception ex) {
                    errorMsg = ex.getLocalizedMessage();
                    log.log(Level.WARNING, "Cascade delete failed.", ex);
                    this.m_totalCount = 0;
                    this.m_trx.rollback();
                    ADialog.error(this.m_WindowNo, this, "DeleteError", errorMsg);
                    return;
                }
                finally {
                    this.m_trx.close();
                }
                ADialog.info(this.m_WindowNo, this, "DeleteSuccess", "Records deleted: #" + this.m_totalCount);
                this.dispose();
            }
        } else if (e.getActionCommand().equals("comboBoxChanged")) {
            if (this.clientId == 0) {
                ADialog.error(this.m_WindowNo, this, "Error", "Select client and base table for cascade delete.");
                return;
            }
            MTable table2 = null;
            if (tableId <= 0) {
                return;
            }
            table2 = MTable.get(Env.getCtx(), tableId);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.confirmPanel.getOKButton().setEnabled(false);
            DeleteEntitiesModel data = new DeleteEntitiesModel();
            data.mandatoryLink = true;
            data.tableName = table2.getTableName();
            data.joinColumn = table2.getKeyColumns()[0];
            data.whereClause = " " + data.tableName + ".AD_Client_ID = " + this.clientId;
            if (table2.getTableName().equals("AD_User")) {
                data.whereClause = data.whereClause + " AND NOT EXISTS (SELECT * FROM C_BPartner bp " + "WHERE AD_User.Link_BPartner_ID=bp.C_BPartner_ID " + "AND (bp.IsEmployee='Y' OR bp.IsSalesRep='Y'))";
            }
            this.rootNode = new DefaultMutableTreeNode(data);
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            model.setRoot(this.rootNode);
            this.createNodes(this.rootNode);
            this.tree.expandRow(0);
            this.confirmPanel.getOKButton().setEnabled(true);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

