/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.Adempiere;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.model.MTask;
import org.compiere.swing.CFrame;
import org.compiere.util.CLogger;
import org.compiere.util.Task;

public class ATask
extends CFrame
implements ActionListener {
    private static final long serialVersionUID = -8998998120736876682L;
    private Task m_task = null;
    private static CLogger log = CLogger.getCLogger(ATask.class);
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private JScrollPane infoScrollPane = new JScrollPane();
    private JTextArea info = new JTextArea();

    public static void start(final String title, final MTask task) {
        new Thread(){

            @Override
            public void run() {
                new ATask(title, task);
            }
        }.start();
    }

    public ATask(String title, MTask task) {
        super(title);
        this.setIconImage(Adempiere.getImage16());
        try {
            this.jbInit();
            AEnv.showCenterScreen(this);
            if (task.isServerProcess()) {
                this.info.setText("Executing on Server ...");
            } else {
                this.info.setText("Executing locally ...");
            }
            String result = task.execute();
            this.info.setText(result);
            this.confirmPanel.getCancelButton().setEnabled(false);
            this.confirmPanel.getOKButton().setEnabled(true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, task.toString(), e);
        }
    }

    private void jbInit() throws Exception {
        this.info.setEditable(false);
        this.info.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.infoScrollPane.getViewport().add((Component)this.info, null);
        this.infoScrollPane.setPreferredSize(new Dimension(500, 300));
        this.getContentPane().add((Component)this.infoScrollPane, "Center");
        this.getContentPane().add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this);
        this.confirmPanel.getOKButton().setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_task != null && this.m_task.isAlive()) {
            this.m_task.interrupt();
        }
        this.dispose();
    }
}

