/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JPopupMenu;
import org.adempiere.apps.toolbar.AProcessModel;
import org.adempiere.model.POWrapper;
import org.compiere.apps.APanel;
import org.compiere.apps.AppsAction;
import org.compiere.grid.ed.VButton;
import org.compiere.model.I_AD_Process;
import org.compiere.swing.CMenuItem;
import org.compiere.util.Env;

public class AProcess {
    private final AProcessModel model = new AProcessModel();
    private final APanel parent;
    private AppsAction action;

    public static AppsAction createAppsAction(APanel parent) {
        AProcess app = new AProcess(parent);
        return app.action;
    }

    public AProcess(APanel parent) {
        this.parent = parent;
        this.initAction();
    }

    private void initAction() {
        this.action = new AppsAction(this.model.getActionName(), null, false);
        this.action.setDelegate(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AProcess.this.showPopup();
            }
        });
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu popup = new JPopupMenu("ProcessMenu");
        List<I_AD_Process> processes = this.model.fetchProcesses(Env.getCtx(), this.parent.getCurrentTab());
        if (processes.size() == 0) {
            return null;
        }
        for (I_AD_Process process : processes) {
            CMenuItem mi = this.createProcessMenuItem(process);
            popup.add(mi);
        }
        return popup;
    }

    public void showPopup() {
        JPopupMenu popup = this.getPopupMenu();
        if (popup == null) {
            return;
        }
        AbstractButton button = this.action.getButton();
        if (button.isShowing()) {
            popup.show(button, 0, button.getHeight());
        }
    }

    private CMenuItem createProcessMenuItem(final I_AD_Process process) {
        CMenuItem mi = new CMenuItem(this.model.getDisplayName(process));
        mi.setToolTipText(this.model.getDescription(process));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AProcess.this.startProcess(process);
            }
        });
        return mi;
    }

    private void startProcess(I_AD_Process process) {
        I_AD_Process processTrl = POWrapper.translate(process, I_AD_Process.class);
        VButton button = new VButton("StartProcess", false, false, true, processTrl.getName(), processTrl.getDescription(), processTrl.getHelp(), process.getAD_Process_ID());
        this.parent.actionButton(button);
    }
}

