/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import org.adempiere.impexp.GridTabExcelExporter;
import org.compiere.apps.ADialog;
import org.compiere.apps.APanel;
import org.compiere.model.GridTab;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.ExtensionFileFilter;
import org.compiere.util.Msg;

public class AExport {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Properties m_ctx = Env.getCtx();
    private int m_WindowNo = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AExport(APanel parent) {
        this.m_WindowNo = parent.getWindowNo();
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(new ExtensionFileFilter("xls", Msg.getMsg(this.m_ctx, "FileXLS")));
        if (chooser.showSaveDialog(parent) != 0) {
            return;
        }
        File outFile = ExtensionFileFilter.getFile(chooser.getSelectedFile(), chooser.getFileFilter());
        try {
            outFile.createNewFile();
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "", e);
            ADialog.error(this.m_WindowNo, parent, "FileCannotCreate", e.getLocalizedMessage());
            return;
        }
        String ext = outFile.getPath();
        if (ext.lastIndexOf(46) == -1) {
            ADialog.error(this.m_WindowNo, parent, "FileInvalidExtension");
            return;
        }
        ext = ext.substring(ext.lastIndexOf(46) + 1).toLowerCase();
        this.log.config("File=" + outFile.getPath() + "; Type=" + ext);
        parent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (ext.equals("xls")) {
                this.createXLS(outFile, parent.getCurrentTab());
            } else {
                ADialog.error(this.m_WindowNo, parent, "FileInvalidExtension");
            }
        }
        catch (Exception e) {
            ADialog.error(this.m_WindowNo, parent, "Error", e.getLocalizedMessage());
            if (CLogMgt.isLevelFinest()) {
                e.printStackTrace();
            }
        }
        finally {
            parent.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void createXLS(File outFile, GridTab tab) throws Exception {
        GridTabExcelExporter exporter = new GridTabExcelExporter(this.m_ctx, tab);
        exporter.export(outFile, null);
    }
}

