/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.compiere.Adempiere;
import org.compiere.acct.AcctViewer;
import org.compiere.apps.ADialog;
import org.compiere.apps.AMenu;
import org.compiere.apps.AMenuStartItem;
import org.compiere.apps.AWindow;
import org.compiere.apps.AboutBox;
import org.compiere.apps.BeanShellEditor;
import org.compiere.apps.Preference;
import org.compiere.apps.PrintScreenPainter;
import org.compiere.apps.ScreenShot;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.InfoSchedule;
import org.compiere.db.CConnection;
import org.compiere.grid.ed.Calculator;
import org.compiere.grid.ed.Calendar;
import org.compiere.grid.ed.Editor;
import org.compiere.interfaces.Server;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MMenu;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.process.DocumentEngine;
import org.compiere.swing.CButton;
import org.compiere.swing.CFrame;
import org.compiere.swing.CMenuItem;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Splash;

public final class AEnv {
    private static Boolean s_workflow = null;
    private static int s_workflow_Window_ID = 0;
    private static int s_serverTries = 0;
    private static Server s_server = null;
    private static CLogger log = CLogger.getCLogger(AEnv.class);
    private static CCache<Integer, GridWindowVO> s_windows = new CCache("AD_Window", 10);

    public static void showWindow(Window window) {
        Frame f;
        int state;
        window.setVisible(true);
        if (window instanceof Frame && ((state = (f = (Frame)window).getExtendedState()) & 1) > 0) {
            f.setExtendedState(state & 0xFFFFFFFE);
        }
        window.toFront();
    }

    public static void showCenterScreen(Window window) {
        AEnv.positionCenterScreen(window);
        AEnv.showWindow(window);
    }

    public static void showMaximized(Frame frame) {
        frame.pack();
        frame.setExtendedState(6);
        frame.setVisible(true);
        frame.toFront();
    }

    public static void positionCenterScreen(Window window) {
        AEnv.positionScreen(window, 0);
    }

    public static void showScreen(Window window, int position) {
        AEnv.positionScreen(window, position);
        AEnv.showWindow(window);
    }

    public static void positionScreen(Window window, int position) {
        window.pack();
        GraphicsConfiguration config = window.getGraphicsConfiguration();
        Rectangle bounds = config.getBounds();
        Dimension sSize = bounds.getSize();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config);
        sSize.width -= insets.left + insets.right;
        sSize.height -= insets.top + insets.bottom;
        Dimension wSize = window.getSize();
        if (wSize.height > sSize.height) {
            wSize.height = sSize.height;
        }
        if (wSize.width > sSize.width) {
            wSize.width = sSize.width;
        }
        window.setSize(wSize);
        int x = (sSize.width - wSize.width) / 2;
        int y = (sSize.height - wSize.height) / 2;
        if (position != 0) {
            if (position == 8) {
                x = 0;
                y = 0;
            } else if (position == 1) {
                y = 0;
            } else if (position == 2) {
                x = sSize.width - wSize.width;
                y = 0;
            } else if (position == 7) {
                x = 0;
            } else if (position == 3) {
                x = sSize.width - wSize.width;
            } else if (position == 5) {
                y = sSize.height - wSize.height;
            } else if (position == 6) {
                x = 0;
                y = sSize.height - wSize.height;
            } else if (position == 4) {
                x = sSize.width - wSize.width;
                y = sSize.height - wSize.height;
            }
        }
        window.setLocation(bounds.x + x + insets.left, bounds.y + y + insets.top);
    }

    public static void showCenterWindow(Window parent, Window window) {
        AEnv.positionCenterWindow(parent, window);
        AEnv.showWindow(window);
    }

    public static void positionCenterWindow(Window parent, Window window) {
        int y;
        if (parent == null) {
            AEnv.positionCenterScreen(window);
            return;
        }
        window.pack();
        Dimension sSize = Toolkit.getDefaultToolkit().getScreenSize();
        GraphicsConfiguration config = window.getGraphicsConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config);
        sSize.width -= insets.left + insets.right;
        sSize.height -= insets.top + insets.bottom;
        Dimension wSize = window.getSize();
        if (wSize.height > sSize.height) {
            wSize.height = sSize.height;
        }
        if (wSize.width > sSize.width) {
            wSize.width = sSize.width;
        }
        window.setSize(wSize);
        Rectangle pBounds = parent.getBounds();
        if (pBounds.x == pBounds.y && pBounds.x == 0) {
            AEnv.positionCenterScreen(window);
            return;
        }
        int x = pBounds.x + (pBounds.width - wSize.width) / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = pBounds.y + (pBounds.height - wSize.height) / 2) < 0) {
            y = 0;
        }
        if (x + wSize.width > sSize.width) {
            x = sSize.width - wSize.width;
        }
        if (y + wSize.height > sSize.height) {
            y = sSize.height - wSize.height;
        }
        window.setLocation(x + insets.left, y + insets.top);
    }

    public static CButton getButton(String iconName) {
        CButton button = new CButton(Env.getImageIcon(iconName + "16.gif"));
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setToolTipText(Msg.getMsg(Env.getCtx(), iconName));
        button.setDefaultCapable(false);
        return button;
    }

    public static JMenu getMenu(String AD_Message) {
        char ch;
        JMenu menu = new JMenu();
        String text = Msg.getMsg(Env.getCtx(), AD_Message);
        int pos = text.indexOf(38);
        if (pos != -1 && text.length() > pos && (ch = text.toUpperCase().charAt(pos + 1)) != ' ') {
            text = text.substring(0, pos) + text.substring(pos + 1);
            menu.setMnemonic(ch);
        }
        menu.setText(text);
        return menu;
    }

    public static JMenuItem addMenuItem(String actionName, String iconName, KeyStroke ks, JMenu menu, ActionListener al) {
        if (iconName == null) {
            iconName = actionName;
        }
        String text = Msg.getMsg(Env.getCtx(), actionName);
        ImageIcon icon = Env.getImageIcon2(iconName + "16");
        CMenuItem mi = new CMenuItem(text, icon);
        mi.setActionCommand(actionName);
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        if (menu != null) {
            menu.add(mi);
        }
        if (al != null) {
            mi.addActionListener(al);
        }
        return mi;
    }

    public static boolean actionPerformed(String actionCommand, int WindowNo, Container c) {
        MRole role = MRole.getDefault();
        if (actionCommand.equals("PrintScreen")) {
            PrintScreenPainter.printScreen(Env.getFrame(c));
        } else if (actionCommand.equals("ScreenShot")) {
            ScreenShot.createJPEG(Env.getFrame(c), null);
        } else if (actionCommand.equals("Exit")) {
            if (ADialog.ask(WindowNo, c, "ExitApplication?")) {
                AMenu aMenu = (AMenu)Env.getWindow(0);
                aMenu.dispose();
            }
        } else if (actionCommand.equals("Logout")) {
            AMenu aMenu = (AMenu)Env.getWindow(0);
            aMenu.logout();
        } else if (actionCommand.equals("InfoProduct") && AEnv.canAccessInfo("PRODUCT")) {
            Info.showProduct(Env.getFrame(c), WindowNo);
        } else if (actionCommand.equals("InfoBPartner") && AEnv.canAccessInfo("BPARTNER")) {
            Info.showBPartner(Env.getFrame(c), WindowNo);
        } else if (actionCommand.equals("InfoAsset") && AEnv.canAccessInfo("ASSET")) {
            Info.showAsset(Env.getFrame(c), WindowNo);
        } else if (actionCommand.equals("InfoAccount") && MRole.getDefault().isShowAcct() && AEnv.canAccessInfo("ACCOUNT")) {
            new AcctViewer();
        } else if (actionCommand.equals("InfoSchedule") && AEnv.canAccessInfo("SCHEDULE")) {
            new InfoSchedule((Frame)Env.getFrame(c), null, false);
        } else if (actionCommand.equals("InfoMRP") && AEnv.canAccessInfo("MRP")) {
            CFrame frame = (CFrame)Env.getFrame(c);
            int m_menu_id = MMenu.getMenu_ID("MRP Info");
            AMenu menu = AEnv.getAMenu(frame);
            AMenuStartItem form = new AMenuStartItem(m_menu_id, true, Msg.translate(Env.getCtx(), "MRP Info"), menu);
            form.start();
        } else if (actionCommand.equals("InfoCRP") && AEnv.canAccessInfo("CRP")) {
            CFrame frame = (CFrame)Env.getFrame(c);
            int m_menu_id = MMenu.getMenu_ID("CRP Info");
            AMenu menu = AEnv.getAMenu(frame);
            AMenuStartItem form = new AMenuStartItem(m_menu_id, true, Msg.translate(Env.getCtx(), "CRP Info"), menu);
            form.start();
        } else if (actionCommand.equals("InfoOrder") && AEnv.canAccessInfo("ORDER")) {
            Info.showOrder(Env.getFrame(c), WindowNo, "");
        } else if (actionCommand.equals("InfoInvoice") && AEnv.canAccessInfo("INVOICE")) {
            Info.showInvoice(Env.getFrame(c), WindowNo, "");
        } else if (actionCommand.equals("InfoInOut") && AEnv.canAccessInfo("INOUT")) {
            Info.showInOut(Env.getFrame(c), WindowNo, "");
        } else if (actionCommand.equals("InfoPayment") && AEnv.canAccessInfo("PAYMENT")) {
            Info.showPayment(Env.getFrame(c), WindowNo, "");
        } else if (actionCommand.equals("InfoCashLine") && AEnv.canAccessInfo("CASHJOURNAL")) {
            Info.showCashLine(Env.getFrame(c), WindowNo, "");
        } else if (actionCommand.equals("InfoAssignment") && AEnv.canAccessInfo("RESOURCE")) {
            Info.showAssignment(Env.getFrame(c), WindowNo, "");
        } else if (actionCommand.equals("WorkFlow")) {
            AEnv.startWorkflowProcess(0, 0);
        } else if (actionCommand.equals("Home")) {
            AEnv.showWindow(Env.getWindow(0));
        } else if (actionCommand.equals("Calculator")) {
            Calculator calc = new Calculator(Env.getFrame(c));
            calc.setDisposeOnEqual(false);
            AEnv.showCenterScreen(calc);
        } else if (actionCommand.equals("Calendar")) {
            AEnv.showCenterScreen(new Calendar(Env.getFrame(c)));
        } else if (actionCommand.equals("Editor")) {
            AEnv.showCenterScreen(new Editor(Env.getFrame(c)));
        } else if (actionCommand.equals("Script")) {
            new BeanShellEditor(Env.getFrame(c));
        } else if (actionCommand.equals("Preference")) {
            if (role.isShowPreference()) {
                AEnv.showCenterScreen(new Preference((Frame)Env.getFrame(c), WindowNo));
            }
        } else if (actionCommand.equals("Online")) {
            Env.startBrowser(Adempiere.getOnlineHelpURL());
        } else if (actionCommand.equals("EMailSupport")) {
            ADialog.createSupportEMail(Env.getFrame(c), Env.getFrame(c).getTitle(), "\n\n");
        } else if (actionCommand.equals("About")) {
            AEnv.showCenterScreen(new AboutBox(Env.getFrame(c)));
        } else {
            return false;
        }
        return true;
    }

    public static void setTextMnemonic(JButton b2, String text) {
        if (text == null || b2 == null) {
            return;
        }
        int pos = text.indexOf(38);
        if (pos != -1) {
            char ch = text.charAt(pos + 1);
            b2.setMnemonic(ch);
            b2.setText(text.substring(0, pos) + text.substring(pos + 1));
        }
        b2.setText(text);
    }

    public static char getMnemonic(String text) {
        int pos = text.indexOf(38);
        if (pos != -1) {
            return text.charAt(pos + 1);
        }
        return '\u0000';
    }

    public static void zoom(int AD_Table_ID, int Record_ID) {
        String whereClause;
        String TableName = null;
        int AD_Window_ID = 0;
        int PO_Window_ID = 0;
        String sql = "SELECT TableName, AD_Window_ID, PO_Window_ID FROM AD_Table WHERE AD_Table_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                TableName = rs.getString(1);
                AD_Window_ID = rs.getInt(2);
                PO_Window_ID = rs.getInt(3);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (TableName == null || AD_Window_ID == 0) {
            return;
        }
        boolean isSOTrx = true;
        if (PO_Window_ID != 0 && !(isSOTrx = DB.isSOTrx(TableName, whereClause = TableName + "_ID=" + Record_ID))) {
            AD_Window_ID = PO_Window_ID;
        }
        log.config(TableName + " - Record_ID=" + Record_ID + " (IsSOTrx=" + isSOTrx + ")");
        AWindow frame = new AWindow();
        if (!frame.initWindow(AD_Window_ID, MQuery.getEqualQuery(TableName + "_ID", Record_ID))) {
            return;
        }
        AEnv.addToWindowManager(frame);
        if (Ini.isPropertyBool("OpenWindowMaximized")) {
            AEnv.showMaximized(frame);
        } else {
            AEnv.showCenterScreen(frame);
        }
        frame = null;
    }

    public static void zoom(MQuery query) {
        if (query == null || query.getTableName() == null || query.getTableName().length() == 0) {
            return;
        }
        String TableName = query.getTableName();
        int AD_Window_ID = 0;
        int PO_Window_ID = 0;
        String sql = "SELECT AD_Window_ID, PO_Window_ID FROM AD_Table WHERE TableName=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, TableName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                AD_Window_ID = rs.getInt(1);
                PO_Window_ID = rs.getInt(2);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        if (AD_Window_ID == 0) {
            return;
        }
        boolean isSOTrx = true;
        if (PO_Window_ID != 0 && !(isSOTrx = DB.isSOTrx(TableName, query.getWhereClause(false)))) {
            AD_Window_ID = PO_Window_ID;
        }
        log.config(query + " (IsSOTrx=" + isSOTrx + ")");
        AWindow frame = new AWindow();
        if (!frame.initWindow(AD_Window_ID, query)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        if (Ini.isPropertyBool("OpenWindowMaximized")) {
            AEnv.showMaximized(frame);
        } else {
            AEnv.showCenterScreen(frame);
        }
        frame = null;
    }

    public static void zoom(Component invoker, int AD_Window_ID, MQuery query) {
        if (query == null || query.getTableName() == null || query.getTableName().length() == 0) {
            return;
        }
        AWindow frame = new AWindow(invoker.getGraphicsConfiguration());
        if (!frame.initWindow(AD_Window_ID, query)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        if (Ini.isPropertyBool("OpenWindowMaximized")) {
            AEnv.showMaximized(frame);
        } else {
            AEnv.showCenterScreen(frame);
        }
        frame = null;
    }

    public static void addToWindowManager(CFrame frame) {
        JFrame top = Env.getWindow(0);
        if (top instanceof AMenu) {
            ((AMenu)top).getWindowManager().add(frame);
        }
    }

    public static AMenu getAMenu(CFrame frame) {
        JFrame top = Env.getWindow(0);
        if (top instanceof AMenu) {
            return (AMenu)top;
        }
        return null;
    }

    public static void exit(int status) {
        Env.exitEnv(status);
    }

    public static void logout() {
        Env.logout();
        Splash.getSplash().setVisible(true);
        new AMenu();
    }

    public static boolean isWorkflowProcess() {
        if (s_workflow == null) {
            s_workflow = Boolean.FALSE;
            int AD_Table_ID = 645;
            if (MRole.getDefault().isTableAccess(AD_Table_ID, true)) {
                s_workflow = Boolean.TRUE;
            } else {
                AD_Table_ID = 644;
                if (MRole.getDefault().isTableAccess(AD_Table_ID, true)) {
                    s_workflow = Boolean.TRUE;
                } else {
                    log.config(s_workflow.toString());
                }
            }
            if (s_workflow.booleanValue()) {
                s_workflow_Window_ID = DB.getSQLValue(null, "SELECT AD_Window_ID FROM AD_Table WHERE AD_Table_ID=?", AD_Table_ID);
                if (s_workflow_Window_ID == 0) {
                    s_workflow_Window_ID = 297;
                }
                log.config(s_workflow + ", Window=" + s_workflow_Window_ID);
            }
        }
        return s_workflow;
    }

    public static void startWorkflowProcess(int AD_Table_ID, int Record_ID) {
        AWindow frame;
        if (s_workflow_Window_ID == 0) {
            return;
        }
        MQuery query = null;
        if (AD_Table_ID != 0 && Record_ID != 0) {
            query = new MQuery("AD_WF_Process");
            query.addRestriction("AD_Table_ID", "=", AD_Table_ID);
            query.addRestriction("Record_ID", "=", Record_ID);
        }
        if (!(frame = new AWindow()).initWindow(s_workflow_Window_ID, query)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        if (Ini.isPropertyBool("OpenWindowMaximized")) {
            frame.pack();
            frame.setExtendedState(6);
            frame.setVisible(true);
            frame.toFront();
        } else {
            AEnv.showCenterScreen(frame);
        }
        frame = null;
    }

    public static boolean isServerActive() {
        boolean contactAgain = s_server == null && s_serverTries == 0;
        boolean ok = CConnection.get().isAppsServerOK(contactAgain);
        if (ok) {
            s_serverTries = 0;
            return true;
        }
        if (s_serverTries > 1) {
            return false;
        }
        CLogMgt.enable(false);
        try {
            log.config("try #" + ++s_serverTries);
            ok = CConnection.get().isAppsServerOK(true);
            if (ok) {
                s_serverTries = 0;
            }
        }
        catch (Exception ex) {
            ok = false;
            s_server = null;
        }
        CLogMgt.enable(true);
        return ok;
    }

    public static String getServerVersion() {
        return CConnection.get().getServerVersion();
    }

    public static GridWindowVO getMWindowVO(int WindowNo, int AD_Window_ID, int AD_Menu_ID) {
        log.config("Window=" + WindowNo + ", AD_Window_ID=" + AD_Window_ID);
        GridWindowVO mWindowVO = null;
        if (AD_Window_ID != 0 && Ini.isCacheWindow() && (mWindowVO = s_windows.get(AD_Window_ID)) != null) {
            mWindowVO = mWindowVO.clone(WindowNo);
            log.info("Cached=" + mWindowVO);
        }
        if (mWindowVO == null) {
            log.config("create local");
            mWindowVO = GridWindowVO.create(Env.getCtx(), WindowNo, AD_Window_ID, AD_Menu_ID);
            if (mWindowVO != null) {
                s_windows.put(AD_Window_ID, mWindowVO);
            }
        }
        if (mWindowVO == null) {
            return null;
        }
        if (!mWindowVO.ctx.equals(Env.getCtx())) {
            Enumeration<Object> keyEnum = mWindowVO.ctx.keys();
            while (keyEnum.hasMoreElements()) {
                String key = (String)keyEnum.nextElement();
                if (!key.startsWith(WindowNo + "|")) continue;
                String value = mWindowVO.ctx.getProperty(key);
                Env.setContext(Env.getCtx(), key, value);
            }
            mWindowVO.setCtx(Env.getCtx());
        }
        return mWindowVO;
    }

    public static String postImmediate(int WindowNo, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force) {
        log.config("Window=" + WindowNo + ", AD_Table_ID=" + AD_Table_ID + "/" + Record_ID + ", Force=" + force);
        String error = DocumentEngine.postImmediate(Env.getCtx(), AD_Client_ID, AD_Table_ID, Record_ID, force, null);
        return error;
    }

    public static void cacheReset(String tableName, int Record_ID) {
        log.config("TableName=" + tableName + ", Record_ID=" + Record_ID);
        if (AEnv.isServerActive()) {
            log.config("trying server");
            try {
                Server server = CConnection.get().getServer();
                if (server != null) {
                    server.cacheReset(tableName, Record_ID);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "ex", e);
                s_server = null;
            }
        }
    }

    public static void updateUI() {
        Set<Window> updated = Env.updateUI();
        JFrame top = Env.getWindow(0);
        if (top instanceof AMenu) {
            CFrame[] frames;
            for (CFrame f : frames = ((AMenu)top).getWindowManager().getWindows()) {
                Component[] childs;
                if (updated.contains(f)) continue;
                SwingUtilities.updateComponentTreeUI(f);
                f.validate();
                RepaintManager mgr = RepaintManager.currentManager(f);
                for (Component c : childs = f.getComponents()) {
                    if (!(c instanceof JComponent)) continue;
                    mgr.markCompletelyDirty((JComponent)c);
                }
                f.repaint();
                updated.add(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canAccessInfo(String infoWindowName) {
        ResultSet rs;
        CPreparedStatement prolestmt;
        boolean result;
        block5: {
            boolean bl;
            result = false;
            int roleid = Env.getAD_Role_ID(Env.getCtx());
            String sqlRolePermission = "Select COUNT(AD_ROLE_ID) AS ROWCOUNT FROM AD_ROLE WHERE AD_ROLE_ID=" + roleid + " AND ALLOW_INFO_" + infoWindowName + "='Y'";
            log.config(sqlRolePermission);
            prolestmt = null;
            rs = null;
            try {
                prolestmt = DB.prepareStatement(sqlRolePermission, null);
                rs = prolestmt.executeQuery();
                rs.next();
                if (rs.getInt("ROWCOUNT") > 0) {
                    result = true;
                    break block5;
                }
                bl = false;
            }
            catch (Exception e) {
                try {
                    System.out.println(e);
                    log.log(Level.SEVERE, "(1)", e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, prolestmt);
                    rs = null;
                    prolestmt = null;
                    throw throwable;
                }
                DB.close(rs, prolestmt);
                rs = null;
                prolestmt = null;
            }
            DB.close(rs, prolestmt);
            rs = null;
            prolestmt = null;
            return bl;
        }
        DB.close(rs, prolestmt);
        rs = null;
        prolestmt = null;
        return result;
    }
}

