/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.JSplitPane;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.model.MChat;
import org.compiere.model.MChatEntry;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextArea;
import org.compiere.swing.CTextPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class AChat
extends CDialog {
    private static final long serialVersionUID = -8555071848521981730L;
    private int m_WindowNo;
    private MChat m_chat;
    private boolean m_change = false;
    private static CLogger log = CLogger.getCLogger(AChat.class);
    private CPanel mainPanel = new CPanel(new BorderLayout(5, 5));
    private CTextPane historyText = new CTextPane();
    private CTextArea newText = new CTextArea();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);

    public AChat(Frame frame, int WindowNo, int CM_Chat_ID, int AD_Table_ID, int Record_ID, String Description, String trxName) {
        super(frame, Msg.getMsg(Env.getCtx(), "Chat") + " " + Description, true);
        log.config("ID=" + CM_Chat_ID + ", Table=" + AD_Table_ID + ", Record=" + Record_ID);
        this.m_WindowNo = WindowNo;
        try {
            this.staticInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
        this.m_chat = CM_Chat_ID == 0 ? new MChat(Env.getCtx(), AD_Table_ID, Record_ID, Description, trxName) : new MChat(Env.getCtx(), CM_Chat_ID, trxName);
        this.loadChat();
        try {
            AEnv.showCenterWindow(frame, this);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.newText.requestFocus();
    }

    private void staticInit() throws Exception {
        this.getContentPane().add(this.mainPanel);
        this.historyText.setPreferredSize(new Dimension(350, 300));
        this.historyText.setReadWrite(false);
        this.historyText.setMargin(new Insets(2, 2, 2, 2));
        this.newText.setPreferredSize(new Dimension(350, 200));
        this.newText.setMargin(new Insets(2, 2, 2, 2));
        JSplitPane textPane = new JSplitPane(0, true, this.historyText, this.newText);
        this.mainPanel.add((Component)textPane, "Center");
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this);
    }

    private void loadChat() {
        String text = this.m_chat.getHistory("I").toString();
        this.historyText.setText(text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String data;
        if (e.getActionCommand().equals("Ok") && (data = this.newText.getText()) != null && data.length() > 0) {
            log.config(data);
            if (this.m_chat.get_ID() == 0) {
                this.m_chat.saveEx();
            }
            MChatEntry entry = new MChatEntry(this.m_chat, data);
            entry.saveEx();
        }
        this.dispose();
    }
}

