/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MDocType;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.OFBProductCost;
import org.compiere.util.Env;

public class Doc_Movement
extends Doc {
    private int m_Reversal_ID = 0;
    private String m_DocStatus = "";

    public Doc_Movement(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MMovement.class, rs, "MMM", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MMovement move = (MMovement)this.getPO();
        this.setDateDoc(move.getMovementDate());
        this.setDateAcct(move.getMovementDate());
        this.m_Reversal_ID = move.getReversal_ID();
        this.m_DocStatus = move.getDocStatus();
        this.p_lines = this.loadLines(move);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MMovement move) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MMovementLine[] lines = move.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MMovementLine line = lines[i];
            DocLine docLine = new DocLine(line, this);
            docLine.setQty(line.getMovementQty(), false);
            docLine.setReversalLine_ID(line.getReversalLine_ID());
            this.log.fine(docLine.toString());
            list.add(docLine);
            ++i;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, "A");
        MMovement doc = (MMovement)this.getPO();
        MDocType type = MDocType.get(this.getCtx(), doc.getC_DocType_ID());
        if (!type.get_ValueAsBoolean("Posted")) {
            return facts;
        }
        this.setC_Currency_ID(as.getC_Currency_ID());
        FactLine dr = null;
        FactLine cr = null;
        int i = 0;
        while (i < this.p_lines.length) {
            DocLine line = this.p_lines[i];
            BigDecimal costs = line.getProductCosts(as, line.getAD_Org_ID(), true, "M_MovementLine_ID=? AND IsSOTrx='N'");
            dr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs.negate());
            if (dr != null) {
                dr.setM_Locator_ID(line.getM_Locator_ID());
                dr.setQty(line.getQty().negate());
                if (this.m_DocStatus.equals("RE") && this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && !dr.updateReverseLine(MMovement.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                    this.p_Error = "Original Inventory Move not posted yet";
                    return null;
                }
                cr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs);
                if (cr != null) {
                    String costingLevel;
                    cr.setM_Locator_ID(line.getM_LocatorTo_ID());
                    cr.setQty(line.getQty());
                    if (this.m_DocStatus.equals("RE") && this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0) {
                        if (!cr.updateReverseLine(MMovement.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                            this.p_Error = "Original Inventory Move not posted yet";
                            return null;
                        }
                        costs = cr.getAcctBalance();
                    }
                    if (dr.getAD_Org_ID() != cr.getAD_Org_ID() && "O".equals(costingLevel = line.getProduct().getCostingLevel(as)) && !OFBProductCost.sameOrg(dr.getAD_Org_ID(), cr.getAD_Org_ID(), as.getCtx())) {
                        String description = line.getDescription();
                        if (description == null) {
                            description = "";
                        }
                        OFBProductCost.createMovement(as, dr.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs.negate(), line.getQty().negate(), true, String.valueOf(description) + "(|->)", this.getTrxName());
                        OFBProductCost.createMovement(as, cr.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), false, String.valueOf(description) + "(|<-)", this.getTrxName());
                    }
                }
            }
            ++i;
        }
        facts.add(fact);
        return facts;
    }
}

