/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MDocType;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.OFBProductCost;
import org.compiere.util.Env;

public class Doc_Inventory
extends Doc {
    private int m_Reversal_ID = 0;
    private String m_DocStatus = "";

    public Doc_Inventory(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MInventory.class, rs, "MMI", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MInventory inventory = (MInventory)this.getPO();
        this.setDateDoc(inventory.getMovementDate());
        this.setDateAcct(inventory.getMovementDate());
        this.m_Reversal_ID = inventory.getReversal_ID();
        this.m_DocStatus = inventory.getDocStatus();
        this.p_lines = this.loadLines(inventory);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MInventory inventory) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MInventoryLine[] lines = inventory.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MInventoryLine line = lines[i];
            if (line.getQtyBook().compareTo(line.getQtyCount()) != 0 || line.getQtyInternalUse().signum() != 0) {
                DocLine docLine = new DocLine(line, this);
                BigDecimal Qty = line.getQtyInternalUse();
                if (Qty.signum() != 0) {
                    Qty = Qty.negate();
                } else {
                    BigDecimal QtyBook = line.getQtyBook();
                    BigDecimal QtyCount = line.getQtyCount();
                    Qty = QtyCount.subtract(QtyBook);
                }
                docLine.setQty(Qty, false);
                docLine.setReversalLine_ID(line.getReversalLine_ID());
                this.log.fine(docLine.toString());
                list.add(docLine);
            }
            ++i;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        ArrayList<Fact> facts = new ArrayList<Fact>();
        MInventory doc = (MInventory)this.getPO();
        MDocType type = MDocType.get(this.getCtx(), doc.getC_DocType_ID());
        if (!type.get_ValueAsBoolean("Posted")) {
            return facts;
        }
        FactLine dr = null;
        FactLine cr = null;
        int i = 0;
        while (i < this.p_lines.length) {
            DocLine line = this.p_lines[i];
            BigDecimal costs = OFBProductCost.getProductCosts(as, "M_InventoryLine_ID=? ", line, as.getC_AcctSchema_ID(), this.getTrxName(), this.getCtx());
            if (costs == null || costs.signum() == 0) {
                this.p_Error = "No Costs for " + line.getProduct().getName();
                return null;
            }
            dr = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs);
            if (dr != null) {
                dr.setM_Locator_ID(line.getM_Locator_ID());
                dr.setAD_Org_ID(line.getAD_Org_ID());
                if (this.m_DocStatus.equals("RE") && this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && !dr.updateReverseLine(MInventory.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                    this.p_Error = "Original Physical Inventory not posted yet";
                    return null;
                }
                MAccount invDiff = null;
                invDiff = this.m_DocStatus.equals("RE") && this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0 && line.getC_Charge_ID() != 0 ? line.getChargeAccount(as, costs) : line.getChargeAccount(as, costs.negate());
                if (invDiff == null) {
                    invDiff = this.getAccount(50, as);
                }
                if ((cr = fact.createLine(line, invDiff, as.getC_Currency_ID(), costs.negate())) != null) {
                    cr.setM_Locator_ID(line.getM_Locator_ID());
                    cr.setQty(line.getQty().negate());
                    if (line.getC_Charge_ID() != 0) {
                        cr.setAD_Org_ID(line.getAD_Org_ID());
                    }
                    this.log.config("costs antes del if por reverso " + costs);
                    if (this.m_DocStatus.equals("RE") && this.m_Reversal_ID != 0 && line.getReversalLine_ID() != 0) {
                        this.log.config("costs antes de pregunta validacion:" + costs);
                        if (!cr.updateReverseLine(MInventory.Table_ID, this.m_Reversal_ID, line.getReversalLine_ID(), Env.ONE)) {
                            this.p_Error = "Original Physical Inventory not posted yet";
                            return null;
                        }
                        this.log.config("costs despues de pregunta validacion:" + costs);
                        costs = cr.getAcctBalance();
                        if (line.getQty().signum() < 0 && costs.signum() > 0) {
                            costs = costs.negate();
                        }
                    }
                    this.log.config("costs antes del abs " + costs);
                    this.log.config("cantidad antes del abs " + line.getQty());
                    if (line.getQty().signum() > 0) {
                        costs = costs.abs();
                    }
                    this.log.config("costs despues del abs " + costs);
                    OFBProductCost.createInventory(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), line.getDescription(), this.getTrxName());
                }
            }
            ++i;
        }
        facts.add(fact);
        return facts;
    }
}

