/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.process;

import java.io.StringWriter;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.MBPartner;
import org.compiere.model.MCity;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MUser;
import org.compiere.model.X_CC_Hospitalization;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.ofb.process.CXFConnector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSBionetFromReq
extends SvrProcess {
    public String urlPdf = "";
    private int p_Requisition_ID = 0;
    private String p_value2 = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String value2 = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (value2.equals("value2")) {
                    this.p_value2 = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + value2);
                }
            }
            ++i;
        }
        this.p_Requisition_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("value2=" + this.p_value2);
        String ret = "";
        if (this.p_Requisition_ID > 0) {
            MRequisition req = new MRequisition(this.getCtx(), this.p_Requisition_ID, this.get_TrxName());
            ret = this.llamarWSAcceptMessage(req);
        }
        return ret;
    }

    private String llamarWSAcceptMessage(MRequisition req) throws Exception {
        String msg = "";
        MBPartner bp = new MBPartner(this.getCtx(), req.get_ValueAsInt("C_BPartner_ID"), this.get_TrxName());
        Timestamp birthday = (Timestamp)bp.get_Value("Birthday");
        String bDay = new SimpleDateFormat("yyyyMMdd").format(birthday);
        String gender = "M";
        if (bp.get_ValueAsString("gender").compareTo("02") == 0) {
            gender = "F";
        } else if (bp.get_ValueAsString("gender").compareTo("03") == 0) {
            gender = "U";
        } else if (bp.get_ValueAsString("gender").compareTo("99") == 0) {
            gender = "U";
        }
        String comuna = "Santiago";
        String pais = "Chile";
        int C_City = bp.get_ValueAsInt("C_City_ID");
        if (C_City > 0) {
            MCity city = new MCity(this.getCtx(), C_City, this.get_TrxName());
            comuna = city.getName();
            pais = city.getC_Country().getName();
        }
        X_CC_Hospitalization hosp = new X_CC_Hospitalization(this.getCtx(), req.get_ValueAsInt("CC_Hospitalization_ID"), this.get_TrxName());
        String dateReq = Integer.toString(req.getCreated().getYear() + 1900);
        dateReq = req.getCreated().getMonth() + 1 >= 10 ? String.valueOf(dateReq) + (req.getCreated().getMonth() + 1) : String.valueOf(dateReq) + "0" + (req.getCreated().getMonth() + 1);
        dateReq = req.getCreated().getDate() >= 10 ? String.valueOf(dateReq) + req.getCreated().getDate() : String.valueOf(dateReq) + "0" + req.getCreated().getDate();
        dateReq = req.getCreated().getHours() >= 10 ? String.valueOf(dateReq) + req.getCreated().getHours() : String.valueOf(dateReq) + "0" + req.getCreated().getHours();
        dateReq = req.getCreated().getMinutes() >= 10 ? String.valueOf(dateReq) + req.getCreated().getMinutes() : String.valueOf(dateReq) + "0" + req.getCreated().getMinutes();
        dateReq = req.getCreated().getSeconds() >= 10 ? String.valueOf(dateReq) + req.getCreated().getSeconds() : String.valueOf(dateReq) + "0" + req.getCreated().getSeconds();
        MUser docUser = new MUser(this.getCtx(), Env.getAD_User_ID(this.getCtx()), this.get_TrxName());
        MBPartner doctor = new MBPartner(this.getCtx(), docUser.getC_BPartner_ID(), this.get_TrxName());
        String request = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ws=\"http://ws.connectors.connect.mirth.com/\"><soapenv:Header/><soapenv:Body><ws:acceptMessage><!-- Optional: --><arg0><![CDATA[<OrdenDeLaboratorio><IdentificacionDePaciente><Nombres>" + bp.get_ValueAsString("Name1") + "</Nombres>" + "<Apellidos>" + bp.getName2() + " " + bp.get_ValueAsString("Name3") + "</Apellidos>" + "<Rut>" + bp.getValue() + "-" + bp.get_ValueAsString("Digito") + "</Rut>" + "<Fnacimiento>" + bDay + "</Fnacimiento>" + "<Genero>" + gender + "</Genero> <!-- M,F,U -->" + "<Direccion>" + bp.get_ValueAsString("Address1") + "</Direccion>" + "<Ciudad>" + comuna + "</Ciudad>" + "<Pais>" + pais + "</Pais>" + "<Telefono>" + bp.get_ValueAsString("PatientPhone") + "</Telefono>" + "<Email>" + bp.get_ValueAsString("Mail") + "</Email>" + "<Nacionalidad>CHL</Nacionalidad>" + "</IdentificacionDePaciente>" + "<Admision>" + "<TipoPaciente>AMB</TipoPaciente>" + "<NroAdmision>" + hosp.getDocumentNo() + "</NroAdmision>" + "<NivelTriage>5</NivelTriage>" + "</Admision>";
        MRequisitionLine[] mRequisitionLineArray = req.getLines();
        int n = mRequisitionLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MRequisitionLine line = mRequisitionLineArray[n2];
            request = String.valueOf(request) + "<Orden>" + "<ControlDeOrden>NW</ControlDeOrden> <!-- NW/CA (Nueva Prestacion/Cancelar Prestacion) -->" + "<NroSolicitud>" + req.get_ID() + "</NroSolicitud>" + "<CodServicioSolicitante>" + req.getAD_Org_ID() + "</CodServicioSolicitante>" + "</Orden>" + "<Solicitud>" + "<CodPrestacion>" + line.getM_Product().getValue() + "</CodPrestacion>" + "<DescPrestacion>" + line.getM_Product().getName() + "</DescPrestacion>" + "<FechaSolicitud>" + dateReq + "</FechaSolicitud>" + "<CodCentroExtraccion>" + req.getAD_Org_ID() + "</CodCentroExtraccion>" + "<RutMedico>7102741-4</RutMedico>" + "<NombreMedico>ROBERTO ANTONIO</NombreMedico>" + "<ApellidoMedico>ASPEE ARAVENA</ApellidoMedico>" + "</Solicitud>" + "<Diagnostico>" + "<TipoDeValor>ST</TipoDeValor>" + "<CodPrueba>18630-4</CodPrueba>" + "<DescPrueba></DescPrueba>" + "<Valor>0</Valor>" + "</Diagnostico>";
            ++n2;
        }
        request = String.valueOf(request) + "</OrdenDeLaboratorio>" + "]]>" + "</arg0>" + "</ws:acceptMessage>" + "</soapenv:Body>" + "</soapenv:Envelope>";
        Source response = null;
        this.log.config("request: " + request);
        try {
            CXFConnector wsc = new CXFConnector();
            wsc.setSoapAction("http://ws.connectors.connect.mirth.com/DefaultAcceptMessage/acceptMessageRequest");
            wsc.setRequest(request);
            wsc.setBinding("http://schemas.xmlsoap.org/wsdl/soap/http");
            wsc.setEndpointAddress("http://172.16.11.114:8081/services/adempiere_bus");
            wsc.setServiceName("DefaultAcceptMessageService");
            wsc.setPortName("DefaultAcceptMessagePort");
            wsc.setTargetNS("http://ws.connectors.connect.mirth.com/");
            wsc.executeConnector();
            response = wsc.getResponse();
        }
        catch (Exception e) {
            throw new Exception("No se ha podido establecer conexion con el Servicio de Facturacion - " + e);
        }
        try {
            StringWriter sw = new StringWriter();
            DocumentBuilderFactory.newInstance().newDocumentBuilder();
            SAXSource output = (SAXSource)response;
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            DOMResult result = new DOMResult();
            tf.transform(output, result);
            Document doc = (Document)result.getNode();
            Node datos = this.findReturn(doc.getChildNodes().item(0));
            Element datospre = doc.getDocumentElement();
            tf.transform(new DOMSource(datospre), new StreamResult(sw));
            this.log.config("result " + sw.toString());
            if (datos != null) {
                NodeList att = datos.getChildNodes();
                int x = 0;
                while (x < att.getLength()) {
                    this.log.config(att.item(x).getLocalName());
                    if (att.item(x).getLocalName().equals("return") || att.item(x).getNodeName().equals("return")) {
                        msg = att.item(x).getFirstChild().getNodeValue();
                    }
                    ++x;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    public Node findReturn(Node node) {
        Node value = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeName().equals("ns2:acceptMessageResponse")) {
                value = childNode;
                break;
            }
            value = this.findReturn(childNode);
            ++i;
        }
        return value;
    }
}

