/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.X_i_ws1appointment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class WS1GenSql
extends SvrProcess {
    private Timestamp p_DateTo_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DateTo")) {
                this.p_DateTo_ID = para[i].getParameterAsTimestamp();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_DateTo_ID != null) {
            String sql = "select sc.ad_client_id,sc.ad_org_id,sc.isactive, sc.created,sc.createdby,sc.updated,sc.updatedby, (bp.value::text || '-'::text) || COALESCE(bp.digito, bp.duns::character varying, ''::character varying)::text AS rut, coalesce(bp.name4,bp.name) AS name,sp.name AS specialty, now() as timerequested from MED_Schedule sc inner join C_BPartner bp ON (sc.C_BPartnerMed_ID = bp.C_BPartner_ID) inner JOIN med_specialty sp ON sc.med_specialty_id = sp.med_specialty_id WHERE ? BETWEEN dateFrom AND dateTo";
            this.log.config("SQL Principal: " + sql);
            CPreparedStatement pstmt = null;
            Object pstmtIn = null;
            ResultSet rs = null;
            String sqlIn = "";
            boolean last_ID = false;
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setTimestamp(1, this.p_DateTo_ID);
            rs = pstmt.executeQuery();
            this.log.config("Parametro antes de ciclo: " + this.p_DateTo_ID);
            while (rs.next()) {
                X_i_ws1appointment ws1 = new X_i_ws1appointment(this.getCtx(), 0, this.get_TrxName());
                ws1.setAD_PInstance_ID(this.getAD_PInstance_ID());
                ws1.setName(rs.getString("name"));
                ws1.setRut(rs.getString("rut"));
                ws1.setspecialty(rs.getString("specialty"));
                ws1.setTimeRequested(rs.getTimestamp("timerequested"));
                ws1.setpInstance(Integer.toString(this.getAD_PInstance_ID()));
                if (ws1.save()) {
                    this.log.config("guardado");
                    continue;
                }
                this.log.config("ERROR no se pudo guardar");
            }
        }
        return Integer.toString(this.getAD_PInstance_ID());
    }
}

