/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.X_MED_Appointment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ProcessBlockSchedule
extends SvrProcess {
    private int p_BPartnerMed_ID = 0;
    private int p_MEDSpecialty_ID = 0;
    private Timestamp p_DateFrom;
    private Timestamp p_DateTo;
    private Timestamp p_TimeFrom;
    private Timestamp p_TimeTo;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_BPartnerMed_ID")) {
                this.p_BPartnerMed_ID = para[i].getParameterAsInt();
            } else if (name.equals("DateFrom")) {
                this.p_DateFrom = para[i].getParameterAsTimestamp();
            } else if (name.equals("DateTo")) {
                this.p_DateTo = para[i].getParameterAsTimestamp();
            } else if (name.equals("TimeFrom")) {
                this.p_TimeFrom = para[i].getParameterAsTimestamp();
            } else if (name.equals("TimeTo")) {
                this.p_TimeTo = para[i].getParameterAsTimestamp();
            } else if (name.equals("MED_Specialty_ID")) {
                this.p_MEDSpecialty_ID = para[i].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int cant;
        block13: {
            if (this.p_BPartnerMed_ID == 0) {
                throw new IllegalArgumentException("No ha seleccionado un medico");
            }
            if (this.p_MEDSpecialty_ID == 0) {
                throw new AdempiereException("No ha seleccionado especialidad");
            }
            if (this.p_DateFrom == null) {
                throw new IllegalArgumentException("No ha seleccionado una fecha/hora desde");
            }
            if (this.p_DateTo == null) {
                throw new IllegalArgumentException("No ha seleccionado una fecha/hora hasta");
            }
            if (this.p_TimeFrom == null) {
                throw new IllegalArgumentException("No ha seleccionado una fecha/hora desde");
            }
            if (this.p_TimeTo == null) {
                throw new IllegalArgumentException("No ha seleccionado una fecha/hora hasta");
            }
            String sqlDet = "SELECT MED_ScheduleTime_ID  FROM MED_ScheduleTime st  INNER JOIN MED_ScheduleDay sd ON (st.MED_ScheduleDay_ID = sd.MED_ScheduleDay_ID) INNER JOIN MED_Schedule s ON (s.MED_Schedule_ID = sd.MED_Schedule_ID) WHERE s.C_BPartnerMed_ID=" + this.p_BPartnerMed_ID + " AND s.MED_Specialty_ID=" + this.p_MEDSpecialty_ID + " AND st.isactive='Y'" + " AND st.timerequested >= ? AND st.timerequested <= ?";
            this.log.config("sql de fecha: " + sqlDet);
            Timestamp timeFrom = new Timestamp(this.p_DateFrom.getTime());
            timeFrom.setHours(this.p_TimeFrom.getHours());
            timeFrom.setMinutes(this.p_TimeFrom.getMinutes());
            timeFrom.setSeconds(this.p_TimeFrom.getSeconds());
            Timestamp timeTo = new Timestamp(this.p_DateTo.getTime());
            timeTo.setHours(this.p_TimeTo.getHours());
            timeTo.setMinutes(this.p_TimeTo.getMinutes());
            timeTo.setSeconds(this.p_TimeTo.getSeconds());
            CPreparedStatement pstmt = DB.prepareStatement(sqlDet, this.get_TrxName());
            pstmt.setTimestamp(1, timeFrom);
            pstmt.setTimestamp(2, timeTo);
            ResultSet rs = pstmt.executeQuery();
            int ID_MEDAppointment = 0;
            cant = 0;
            String ID_anular = "0";
            try {
                try {
                    while (rs.next()) {
                        ++cant;
                        ID_MEDAppointment = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(MED_Appointment_ID) FROM MED_Appointment  WHERE MED_ScheduleTime_ID=" + rs.getInt("MED_ScheduleTime_ID"));
                        if (ID_MEDAppointment > 0) {
                            X_MED_Appointment appoint = new X_MED_Appointment(this.getCtx(), ID_MEDAppointment, this.get_TrxName());
                            MBPartner bp = new MBPartner(this.getCtx(), appoint.getC_BPartner_ID(), this.get_TrxName());
                            DB.executeUpdate("UPDATE MED_ScheduleTime SET State = 'BL', Description='Cita Borrada a paciente " + bp.getValue() + "-" + bp.get_ValueAsString("digito") + " " + bp.get_ValueAsString("name1") + " " + bp.getName2() + " " + bp.get_ValueAsString("name3") + "' WHERE MED_ScheduleTime_ID=" + rs.getInt("MED_ScheduleTime_ID"), this.get_TrxName());
                            DB.executeUpdate("DELETE FROM MED_Appointment WHERE MED_Appointment_ID=" + ID_MEDAppointment, this.get_TrxName());
                            continue;
                        }
                        ID_anular = String.valueOf(ID_anular) + "," + rs.getInt("MED_ScheduleTime_ID");
                    }
                    DB.executeUpdate("UPDATE MED_ScheduleTime SET State = 'BL' WHERE MED_ScheduleTime_ID IN (" + ID_anular + ")", this.get_TrxName());
                }
                catch (Exception e) {
                    this.log.config(e.toString());
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "Actualizados: " + cant + " registros";
    }
}

