/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProductPricing;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class GenerateSalesOrderToday
extends SvrProcess {
    private int p_ID_BPartner;
    private int p_ID_pList;
    private Timestamp p_UseDateFrom;
    private Timestamp p_UseDateTo;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_BPartner_ID")) {
                this.p_ID_BPartner = para[i].getParameterAsInt();
            } else if (name.equals("M_PriceList_ID")) {
                this.p_ID_pList = para[i].getParameterAsInt();
            } else if (name.equals("UseDate")) {
                this.p_UseDateFrom = para[i].getParameterAsTimestamp();
                this.p_UseDateTo = para[i].getParameterToAsTimestamp();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int cant = 0;
        MOrder order = null;
        int ID_lastBPartner = 0;
        String sql = "SELECT M_Product_ID, 1 as qty,A_Locator_Use_ID, dateend, datestart,lu.C_Bpartner_ID FROM A_Locator_Use lu INNER JOIN M_Locator ml ON (lu.M_Locator_ID = ml.M_Locator_ID) WHERE ? BETWEEN datestart::date AND dateend::date;";
        if (this.p_ID_BPartner > 0) {
            sql = String.valueOf(sql) + " AND lu.C_Bpartner_ID = " + this.p_ID_BPartner;
        }
        sql = String.valueOf(sql) + " ORDER BY C_Bpartner_ID DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        this.p_UseDateFrom = DateUtils.today();
        this.p_UseDateTo = DateUtils.today();
        Timestamp dateTrx = new Timestamp(this.p_UseDateFrom.getTime());
        while (dateTrx.compareTo(this.p_UseDateTo) <= 0) {
            pstmt = null;
            rs = null;
            order = null;
            ID_lastBPartner = 0;
            try {
                int ID_Exe;
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                rs = pstmt.executeQuery();
                int ID_Iva = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_Tax_ID) FROM C_Tax WHERE UPPER(Name) like '%IVA%'");
                if (ID_Iva < 0) {
                    ID_Iva = 2000002;
                }
                if ((ID_Exe = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_Tax_ID) FROM C_Tax WHERE UPPER(Name) like '%EXENTO%'")) < 0) {
                    ID_Exe = 2000003;
                }
                while (rs.next()) {
                    if (rs.getInt("M_Product_ID") > 0 && rs.getBigDecimal("qty").compareTo(Env.ZERO) > 0) {
                        if (ID_lastBPartner != rs.getInt("C_Bpartner_ID")) {
                            order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                            order.setAD_Org_ID(Env.getAD_Org_ID(this.getCtx()));
                            order.setC_DocType_ID(2000122);
                            order.setC_BPartner_ID(rs.getInt("C_Bpartner_ID"));
                            order.setDateOrdered(dateTrx);
                            int ID_BPLoc = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location WHERE IsActive = 'Y' AND C_BPartner_ID = " + rs.getInt("C_Bpartner_ID"));
                            if (ID_BPLoc > 0) {
                                order.setC_BPartner_Location_ID(ID_BPLoc);
                            }
                            order.setM_PriceList_ID(this.p_ID_pList);
                            order.save(this.get_TrxName());
                            ++cant;
                        }
                        MOrderLine oLine = new MOrderLine(order);
                        oLine.setM_Product_ID(rs.getInt("M_Product_ID"), true);
                        oLine.setQty(rs.getBigDecimal("qty"));
                        oLine.setPrice();
                        oLine.setC_Tax_ID(ID_Iva);
                        oLine.set_CustomColumn("A_Locator_Use_ID", rs.getInt("A_Locator_Use_ID"));
                        oLine.setLineNetAmt();
                        oLine.save(this.get_TrxName());
                        MProductPricing pp = this.getProductPricing(oLine.getM_Product_ID(), order.getC_BPartner_ID(), oLine.getQtyEntered(), order.isSOTrx(), order.getM_PriceList_ID(), order.getDateOrdered());
                        if (pp.getPriceLimit().compareTo(Env.ZERO) > 0) {
                            MOrderLine oLine2 = new MOrderLine(order);
                            oLine2.setM_Product_ID(rs.getInt("M_Product_ID"), true);
                            oLine2.setQty(rs.getBigDecimal("qty"));
                            oLine2.setPrice();
                            oLine2.setPrice(pp.getPriceLimit());
                            oLine2.setC_Tax_ID(ID_Exe);
                            oLine2.set_CustomColumn("A_Locator_Use_ID", rs.getInt("A_Locator_Use_ID"));
                            oLine2.save(this.get_TrxName());
                            oLine2.setLineNetAmt();
                            ++cant;
                        }
                    }
                    ID_lastBPartner = rs.getInt("C_Bpartner_ID");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            dateTrx = DateUtils.SumarDias(dateTrx, 1);
        }
        return "Se ha generado " + cant + " notas de venta";
    }

    private MProductPricing getProductPricing(int ID_product, int ID_BPartner, BigDecimal qtyOrdered, boolean IssoTrx, int M_PriceList_ID, Timestamp date) {
        MProductPricing m_productPrice = new MProductPricing(ID_product, ID_BPartner, qtyOrdered, IssoTrx);
        m_productPrice.setM_PriceList_ID(M_PriceList_ID);
        m_productPrice.setPriceDate(date);
        m_productPrice.calculatePrice();
        return m_productPrice;
    }
}

