/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.X_C_Order;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateSOrderFromReqAdm
extends SvrProcess {
    private int p_ID_BPartner;
    private int p_ID_pList;
    private Timestamp p_dateFrom;
    private Timestamp p_dateTo;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_BPartner_ID")) {
                this.p_ID_BPartner = para[i].getParameterAsInt();
            } else if (name.equals("M_PriceList_ID")) {
                this.p_ID_pList = para[i].getParameterAsInt();
            } else if (name.equals("DateDoc")) {
                this.p_dateFrom = para[i].getParameterAsTimestamp();
                this.p_dateTo = para[i].getParameterToAsTimestamp();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        X_C_Order order;
        int cant;
        block11: {
            cant = 0;
            order = null;
            String sql = "SELECT rl.M_Product_ID,rl.qty,M_RequisitionLine_ID,0 as A_Locator_Use_ID  FROM M_Requisition r  INNER JOIN M_RequisitionLine rl ON (r.M_Requisition_ID = rl.M_Requisition_ID )  WHERE r.C_Bpartner_ID = " + this.p_ID_BPartner + " AND r.DateDoc BETWEEN ? AND ? " + " UNION " + " SELECT M_Product_ID, " + " CASE WHEN (date_part('day', dateend -datestart) > 1) THEN date_part('day', dateend -datestart)" + " WHEN (date_part('day', dateend -datestart) < 1) AND (date_part('second', dateend -datestart) > 1) THEN 1" + " ELSE 0 END as qty,0,A_Locator_Use_ID " + " FROM A_Locator_Use lu INNER JOIN M_Locator ml ON (lu.M_Locator_ID = ml.M_Locator_ID)" + " WHERE lu.C_Bpartner_ID = " + this.p_ID_BPartner + " AND datestart BETWEEN ? AND ?";
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setTimestamp(1, this.p_dateFrom);
                    pstmt.setTimestamp(2, this.p_dateTo);
                    pstmt.setTimestamp(3, this.p_dateFrom);
                    pstmt.setTimestamp(4, this.p_dateTo);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (rs.getInt("M_Product_ID") <= 0 || rs.getBigDecimal("qty").compareTo(Env.ZERO) <= 0) continue;
                        if (order == null) {
                            order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                            order.setAD_Org_ID(Env.getAD_Org_ID(this.getCtx()));
                            order.setC_DocType_ID(2000122);
                            ((MOrder)order).setC_BPartner_ID(this.p_ID_BPartner);
                            order.setDateOrdered(this.p_dateTo);
                            int ID_BPLoc = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_BPartner_Location_ID) FROM C_BPartner_Location WHERE IsActive = 'Y' AND C_BPartner_ID = " + this.p_ID_BPartner);
                            if (ID_BPLoc > 0) {
                                ((MOrder)order).setC_BPartner_Location_ID(ID_BPLoc);
                            }
                            ((MOrder)order).setM_PriceList_ID(this.p_ID_pList);
                            order.save(this.get_TrxName());
                        }
                        MOrderLine oLine = new MOrderLine((MOrder)order);
                        oLine.setM_Product_ID(rs.getInt("M_Product_ID"), true);
                        oLine.setQty(rs.getBigDecimal("qty"));
                        oLine.setPrice();
                        oLine.setTax();
                        if (rs.getInt("M_RequisitionLine_ID") > 0) {
                            oLine.set_CustomColumn("M_RequisitionLine_ID", rs.getInt("M_RequisitionLine_ID"));
                        } else if (rs.getInt("A_Locator_Use_ID") > 0) {
                            oLine.set_CustomColumn("A_Locator_Use_ID", rs.getInt("A_Locator_Use_ID"));
                        }
                        oLine.save(this.get_TrxName());
                        ++cant;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                    pstmt.close();
                    rs.close();
                    pstmt = null;
                    rs = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
                throw throwable;
            }
            pstmt.close();
            rs.close();
            pstmt = null;
            rs = null;
        }
        return "Se ha generado nota de venta " + order.getDocumentNo() + " con " + cant + " lineas ";
    }
}

