/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class CopyLineRequisition
extends SvrProcess {
    private int p_M_RequisitionFrom_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Requisition_ID")) {
                    this.p_M_RequisitionFrom_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int M_RequisitionTo_ID = this.getRecord_ID();
        if (this.p_M_RequisitionFrom_ID == 0) {
            throw new IllegalArgumentException("Source M_Requisition_ID == 0");
        }
        if (M_RequisitionTo_ID == 0) {
            throw new IllegalArgumentException("Target M_Requisition_ID == 0");
        }
        MRequisition from = new MRequisition(this.getCtx(), this.p_M_RequisitionFrom_ID, this.get_TrxName());
        MRequisition to = new MRequisition(this.getCtx(), M_RequisitionTo_ID, this.get_TrxName());
        int no = this.copyLinesFrom(from, to);
        return "@Copied@=" + no;
    }

    public int copyLinesFrom(MRequisition sourceReq, MRequisition targetReq) {
        if (sourceReq == null || targetReq == null) {
            return 0;
        }
        MRequisitionLine[] fromLines = sourceReq.getLines();
        int count = 0;
        int i = 0;
        while (i < fromLines.length) {
            if (fromLines[i].getM_Product().isActive()) {
                MRequisitionLine newLine = new MRequisitionLine(targetReq);
                newLine.setM_Product_ID(fromLines[i].getM_Product_ID());
                newLine.setC_UOM_ID(fromLines[i].getC_UOM_ID());
                newLine.setQty(fromLines[i].getQty());
                newLine.setPriceActual(fromLines[i].getPriceActual());
                newLine.setDescription(fromLines[i].getDescription());
                newLine.setM_Product_ID(fromLines[i].getM_Product_ID());
                newLine.setC_BPartner_ID(fromLines[i].getC_BPartner_ID());
                newLine.setC_Charge_ID(fromLines[i].getC_Charge_ID());
                newLine.setIsActive(fromLines[i].isActive());
                newLine.set_CustomColumn("Urgent", fromLines[i].get_ValueAsBoolean("Urgent"));
                newLine.set_CustomColumn("Surcharge1", fromLines[i].get_ValueAsBoolean("Surcharge1"));
                if (newLine.save(this.get_TrxName())) {
                    ++count;
                }
                try {
                    newLine.set_CustomColumn("M_RequisitionLineRef_ID", fromLines[i].get_ID());
                }
                catch (Exception e) {
                    this.log.config(e.toString());
                }
            }
            ++i;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }
}

