/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.X_CC_Evaluation;
import org.compiere.model.X_CC_Evaluation_nursing;
import org.compiere.model.X_CC_Evolution_Kine;
import org.compiere.model.X_CC_Hospitalization;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class CloseMedicalRecords
extends SvrProcess {
    private Timestamp p_dateFrom;
    private Timestamp p_dateTo;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DateDoc")) {
                this.p_dateFrom = para[i].getParameterAsTimestamp();
                this.p_dateTo = para[i].getParameterToAsTimestamp();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("fecha inicio " + this.p_dateFrom + ", fecha fin " + this.p_dateTo);
        String msg = "";
        msg = this.p_dateFrom != null && this.p_dateTo != null ? "SE CERRARON " + this.medicalEvaluation(this.p_dateFrom, this.p_dateTo) + ", " + this.nursingEvaluation(this.p_dateFrom, this.p_dateTo) + ", " + this.kineEvaluation(this.p_dateFrom, this.p_dateTo) + ", " + this.protocols(this.p_dateFrom, this.p_dateTo) + ", " + this.income(this.p_dateFrom, this.p_dateTo) : "No se completo el parametro";
        return msg;
    }

    private String medicalEvaluation(Timestamp dateFrom, Timestamp dateTo) throws SQLException {
        int cant;
        block6: {
            String sql = "";
            cant = 0;
            sql = "select cc_evaluation_id, created from cc_evaluation where isreadonly1='N' and created between '" + dateFrom + "' and '" + dateTo + "' order by 2 desc";
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        X_CC_Evaluation eva = new X_CC_Evaluation(this.getCtx(), rs.getInt("cc_evaluation_id"), this.get_TrxName());
                        eva.setIsReadOnly1(true);
                        eva.save();
                        ++cant;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                    pstmt.close();
                    rs.close();
                    pstmt = null;
                    rs = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
                throw throwable;
            }
            pstmt.close();
            rs.close();
            pstmt = null;
            rs = null;
        }
        return "EVOLUCIONES MEDICAS: " + cant;
    }

    private String nursingEvaluation(Timestamp dateFrom, Timestamp dateTo) throws SQLException {
        int cant;
        block6: {
            String sql = "";
            cant = 0;
            sql = "select cc_evaluation_nursing_id, created from cc_evaluation_nursing where isreadonly1='N' and created:: date between '" + dateFrom + "' and '" + dateTo + "' order by 2 desc";
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        X_CC_Evaluation_nursing evan = new X_CC_Evaluation_nursing(this.getCtx(), rs.getInt("cc_evaluation_nursing_id"), this.get_TrxName());
                        evan.setIsReadOnly1(true);
                        evan.save();
                        ++cant;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                    pstmt.close();
                    rs.close();
                    pstmt = null;
                    rs = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
                throw throwable;
            }
            pstmt.close();
            rs.close();
            pstmt = null;
            rs = null;
        }
        return "EVOLUCIONES ENFERMERIA: " + cant;
    }

    private String kineEvaluation(Timestamp dateFrom, Timestamp dateTo) throws SQLException {
        int cant;
        block6: {
            String sql = "";
            cant = 0;
            sql = "select cc_evolution_kine_id, created from cc_evolution_kine where isreadonly1='N' and created:: date between '" + dateFrom + "' and '" + dateTo + "' order by 2 desc";
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        X_CC_Evolution_Kine evak = new X_CC_Evolution_Kine(this.getCtx(), rs.getInt("cc_evolution_kine_id"), this.get_TrxName());
                        evak.set_CustomColumn("isreadonly1", "Y");
                        evak.save();
                        ++cant;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                    pstmt.close();
                    rs.close();
                    pstmt = null;
                    rs = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
                throw throwable;
            }
            pstmt.close();
            rs.close();
            pstmt = null;
            rs = null;
        }
        return "EVOLUCIONES KINE: " + cant;
    }

    private String protocols(Timestamp dateFrom, Timestamp dateTo) throws SQLException {
        int cant;
        block6: {
            String sql = "";
            cant = 0;
            sql = "select cc_postsurgical_protocol_id, created from cc_postsurgical_protocol  where approveprotocol='N' and created:: date between '" + dateFrom + "' and '" + dateTo + "' order by 2 desc";
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        DB.executeUpdate("update cc_postsurgical_protocol set approveprotocol='Y' where cc_postsurgical_protocol_id =" + rs.getInt("cc_postsurgical_protocol_id"), null);
                        ++cant;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                    pstmt.close();
                    rs.close();
                    pstmt = null;
                    rs = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
                throw throwable;
            }
            pstmt.close();
            rs.close();
            pstmt = null;
            rs = null;
        }
        return "PROTOCOLOS: " + cant;
    }

    private String income(Timestamp dateFrom, Timestamp dateTo) throws SQLException {
        int cant;
        block6: {
            String sql = "";
            cant = 0;
            sql = "select cc_hospitalization_id, created from cc_hospitalization  where isreadonly1='N' and isreadonly2='N' and isreadonly3='N'and created:: date between '" + dateFrom + "' and '" + dateTo + "' order by 2 desc";
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        X_CC_Hospitalization hos = new X_CC_Hospitalization(this.getCtx(), rs.getInt("cc_hospitalization_id"), this.get_TrxName());
                        hos.setIsReadOnly1(true);
                        hos.set_CustomColumn("isreadonly2", "Y");
                        hos.set_CustomColumn("isreadonly3", "Y");
                        hos.save();
                        ++cant;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                    pstmt.close();
                    rs.close();
                    pstmt = null;
                    rs = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
                throw throwable;
            }
            pstmt.close();
            rs.close();
            pstmt = null;
            rs = null;
        }
        return "INGRESOS MEDICINA, ENFERMERIA, KINE: " + cant;
    }
}

