/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.model;

import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class ModelCCWarehouseRequest
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelCCWarehouseRequest.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_Requisition", this);
        engine.addModelChange("M_RequisitionLine", this);
        engine.addDocValidate("M_Requisition", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        int ID_BOM;
        MRequisitionLine rLine;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == MRequisition.Table_ID) {
            MRequisition mRequisition = (MRequisition)po;
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == MRequisitionLine.Table_ID && (rLine = (MRequisitionLine)po).getM_Product_ID() > 0 && (ID_BOM = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(PP_Product_BOM_ID) FROM PP_Product_BOM  WHERE IsActive = 'Y' AND M_product_ID = " + rLine.getM_Product_ID())) > 0) {
            if (rLine.getDescription() != null && rLine.getDescription().trim().length() > 0) {
                rLine.setDescription(String.valueOf(rLine.getDescription()) + "*LDM*");
            } else {
                rLine.setDescription("*LDM*");
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MRequisition req;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MRequisition.Table_ID && ((req = (MRequisition)po).getC_DocType_ID() == 2000176 || req.getC_DocType_ID() == 2000149 || req.getC_DocType_ID() == 2000180 || req.getC_DocType_ID() == 2000140 || req.getC_DocType_ID() == 2000174 || req.getC_DocType_ID() == 2000175 || req.getC_DocType_ID() == 2000179 || req.getC_DocType_ID() == 2000155)) {
            MRequisitionLine[] lines = req.getLines();
            MInventory inv = null;
            MWarehouse wh = MWarehouse.get(req.getCtx(), req.getM_Warehouse_ID(), req.get_TrxName());
            int i = 0;
            while (i < lines.length) {
                MRequisitionLine line = lines[i];
                if (line.getM_Product_ID() > 0) {
                    if (inv == null) {
                        try {
                            int id = DB.getNextID(po.getCtx(), "M_Inventory", po.get_TrxName());
                            inv = new MInventory(po.getCtx(), 0, po.get_TrxName());
                            inv.setAD_Org_ID(req.getAD_Org_ID());
                            inv.setM_Warehouse_ID(req.getM_Warehouse_ID());
                            inv.setC_DocType_ID(2000115);
                            inv.setDescription("Generado automaticamente desde solicitud " + req.getDocumentNo());
                            inv.set_CustomColumn("C_BPartner_ID", req.get_ValueAsInt("C_BPartner_ID"));
                            if (req.get_ValueAsInt("C_BPartner_ID") > 0) {
                                MBPartner part = new MBPartner(po.getCtx(), req.get_ValueAsInt("C_BPartner_ID"), po.get_TrxName());
                                inv.set_CustomColumn("DocumentNoBP", part.get_ValueAsString("DocumentNo"));
                                String valueLoc = DB.getSQLValueString(po.get_TrxName(), "select (select max(ml.value) from a_locator_use alu left join m_locator ml on alu.m_locator_id=ml.m_locator_id where mr.datedoc between alu.datestart and coalesce(alu.dateend,current_timestamp+'1 day'::interval) and alu.c_bpartner_id = mr.c_bpartner_id) from M_Requisition mr where M_Requisition_ID=?", req.get_ID());
                                if (valueLoc != null && valueLoc.trim().length() > 0) {
                                    inv.set_CustomColumn("ValueLoc", valueLoc);
                                }
                            }
                            inv.save(po.get_TrxName());
                            try {
                                inv.set_CustomColumn("M_Requisition_ID", req.get_ID());
                                inv.set_CustomColumn("C_DocTypeRef_ID", req.getC_DocType_ID());
                                inv.saveEx(po.get_TrxName());
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, "No se pudo asignar la variable M_Requisition_ID en M_Inventory", e);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "No se pugo guardar la cabezera", e);
                        }
                    }
                    MInventoryLine il = null;
                    int test = line.getM_Product_ID();
                    if (line.getM_Product_ID() > 0) {
                        int ID_BOM = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(PP_Product_BOM_ID) FROM PP_Product_BOM  WHERE IsActive = 'Y' AND M_product_ID = " + line.getM_Product_ID());
                        if (ID_BOM > 0) {
                            MPPProductBOM bom = new MPPProductBOM(po.getCtx(), ID_BOM, po.get_TrxName());
                            if (bom != null) {
                                MPPProductBOMLine[] bomlines = bom.getLines();
                                int j = 0;
                                while (j < bomlines.length) {
                                    MPPProductBOMLine bomline = bomlines[j];
                                    il = new MInventoryLine(req.getCtx(), 0, req.get_TrxName());
                                    il.setM_Inventory_ID(inv.getM_Inventory_ID());
                                    il.setAD_Org_ID(line.getAD_Org_ID());
                                    il.setM_Product_ID(bomline.getM_Product_ID());
                                    il.set_CustomColumn("M_ProductRef_ID", line.getM_Product_ID());
                                    il.setM_Locator_ID(wh.getDefaultLocator().getM_Locator_ID());
                                    if (req.getC_DocType_ID() == 2000174) {
                                        il.setQtyInternalUse(line.getQty().multiply(bomline.getQtyBOM()).negate());
                                    } else {
                                        il.setQtyInternalUse(line.getQty().multiply(bomline.getQtyBOM()));
                                    }
                                    int ID_Charge = -1;
                                    try {
                                        ID_Charge = req.get_ValueAsInt("C_Charge_ID");
                                    }
                                    catch (Exception e) {
                                        log.log(Level.SEVERE, "No se pudo asignar la variable M_Inventory_ID en M_Requisition", e);
                                        ID_Charge = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Charge_ID)  FROM C_Charge WHERE IsActive = 'Y' AND AD_Client_ID = " + Env.getAD_Client_ID(po.getCtx()) + " AND upper(name) like '%CONSUMO%'");
                                    }
                                    if (ID_Charge <= 0) {
                                        ID_Charge = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Charge_ID)  FROM C_Charge WHERE IsActive = 'Y' AND upper(name) like '%CONSUMO%' AND AD_Client_ID = " + Env.getAD_Client_ID(po.getCtx()));
                                    }
                                    if (ID_Charge > 0) {
                                        il.setC_Charge_ID(ID_Charge);
                                    } else {
                                        il.setC_Charge_ID(2000009);
                                    }
                                    il.setDescription(line.getDescription());
                                    il.saveEx(po.get_TrxName());
                                    ++j;
                                }
                            }
                        } else {
                            int dd = DB.getSQLValue(null, "select coalesce(count(m_product_id),0) from m_inventoryline where m_inventory_id = " + inv.getM_Inventory_ID() + " and m_product_id = " + line.getM_Product_ID());
                            if (dd <= 0) {
                                il = new MInventoryLine(req.getCtx(), 0, req.get_TrxName());
                                il.setM_Inventory_ID(inv.getM_Inventory_ID());
                                il.setAD_Org_ID(line.getAD_Org_ID());
                                il.setM_Product_ID(line.getM_Product_ID());
                                il.setM_Locator_ID(wh.getDefaultLocator().getM_Locator_ID());
                                if (req.getC_DocType_ID() == 2000174) {
                                    il.setQtyInternalUse(line.getQty().negate());
                                } else {
                                    il.setQtyInternalUse(line.getQty());
                                }
                                int ID_Charge = -1;
                                try {
                                    ID_Charge = req.get_ValueAsInt("C_Charge_ID");
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, "No se pudo asignar la variable M_Inventory_ID en M_Requisition", e);
                                    ID_Charge = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Charge_ID)  FROM C_Charge WHERE IsActive = 'Y' AND AD_Client_ID = " + Env.getAD_Client_ID(po.getCtx()) + " AND upper(name) like '%CONSUMO%'");
                                }
                                if (ID_Charge <= 0) {
                                    ID_Charge = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Charge_ID)  FROM C_Charge WHERE IsActive = 'Y' AND upper(name) like '%CONSUMO%' AND AD_Client_ID = " + Env.getAD_Client_ID(po.getCtx()));
                                }
                                if (ID_Charge > 0) {
                                    il.setC_Charge_ID(ID_Charge);
                                } else {
                                    il.setC_Charge_ID(2000009);
                                }
                                il.setDescription(line.getDescription());
                                il.saveEx(po.get_TrxName());
                            }
                        }
                    }
                    if ((req.getAD_Org_ID() == 2000025 || req.getAD_Org_ID() == 2000026 || req.getAD_Org_ID() == 2000023) && req.getM_Warehouse_ID() != 2000015) {
                        inv.completeIt();
                        inv.setDocStatus(DOCSTATUS_Completed);
                        inv.save();
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

