/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.model;

import java.sql.Timestamp;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_CC_Evaluation;
import org.compiere.model.X_CC_Evaluation_nursing;
import org.compiere.model.X_CC_Evolution_Kine;
import org.compiere.model.X_CC_MedicalIndications;
import org.compiere.model.X_CC_MedicalOrder;
import org.compiere.model.X_MH_WoundManagement;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModEvaluationReadOnlyV2
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModEvaluationReadOnlyV2.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("CC_Evaluation", this);
        engine.addModelChange("CC_Evaluation_nursing", this);
        engine.addModelChange("CC_Evolution_Kine", this);
        engine.addModelChange("MH_WoundManagement", this);
        engine.addModelChange("CC_MedicalOrder", this);
        engine.addModelChange("CC_MedicalIndications", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        Timestamp dateregistry24t;
        Timestamp datenow24t;
        String dateregistry24;
        String datenow24;
        Timestamp dateregistryd;
        Timestamp datenowd;
        String dateregistry;
        String datenow;
        int iduserofeval;
        int iduser;
        int idrole;
        int idevaluation;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 2 && po.get_Table_ID() == X_CC_Evaluation.Table_ID) {
            idevaluation = po.get_ValueAsInt("CC_Evaluation_ID");
            idrole = Env.getAD_Role_ID(Env.getCtx());
            iduser = Env.getAD_User_ID(Env.getCtx());
            log.config("rol: " + idrole);
            log.config("usuario " + iduser);
            iduserofeval = po.get_ValueAsInt("AD_User_ID");
            log.config("usuario del registro: " + iduserofeval);
            if (iduser != 100) {
                if (iduser != iduserofeval) {
                    return "No puede modificar esta evolucion";
                }
                datenow = "SELECT date_Trunc('day',now()) from ad_system where 1=?";
                dateregistry = "SELECT date_Trunc('day',created) from cc_evaluation where cc_evaluation_id = ?";
                datenowd = DB.getSQLValueTS(po.get_TrxName(), datenow, 1);
                dateregistryd = DB.getSQLValueTS(po.get_TrxName(), dateregistry, idevaluation);
                datenow24 = "SELECT now() from ad_system where 1=?";
                dateregistry24 = "SELECT (created + interval '1 day') from cc_evaluation where cc_evaluation_id = ?";
                datenow24t = DB.getSQLValueTS(po.get_TrxName(), datenow24, 1);
                if (datenow24t.compareTo(dateregistry24t = DB.getSQLValueTS(po.get_TrxName(), dateregistry24, idevaluation)) > 0) {
                    return "No se puede modificar un registro de una fecha distinta a la actual";
                }
            }
        }
        if (type == 2 && po.get_Table_ID() == X_CC_Evaluation_nursing.Table_ID) {
            idevaluation = po.get_ValueAsInt("CC_Evaluation_nursing_ID");
            idrole = Env.getAD_Role_ID(Env.getCtx());
            iduser = Env.getAD_User_ID(Env.getCtx());
            log.config("rol: " + idrole);
            log.config("usuario " + iduser);
            iduserofeval = po.get_ValueAsInt("AD_User_ID");
            log.config("usuario del registro: " + iduserofeval);
            if (iduser != 100) {
                if (iduser != iduserofeval) {
                    return "No puede modificar esta evolucion";
                }
                datenow = "SELECT date_Trunc('day',now()) from ad_system where 1=?";
                dateregistry = "SELECT date_Trunc('day',created) from cc_evaluation_nursing where cc_evaluation_nursing_id = ?";
                datenowd = DB.getSQLValueTS(po.get_TrxName(), datenow, 1);
                dateregistryd = DB.getSQLValueTS(po.get_TrxName(), dateregistry, idevaluation);
                datenow24 = "SELECT now() from ad_system where 1=?";
                dateregistry24 = "SELECT (created + interval '1 day') from cc_evaluation_nursing where cc_evaluation_nursing_id = ?";
                datenow24t = DB.getSQLValueTS(po.get_TrxName(), datenow24, 1);
                if (datenow24t.compareTo(dateregistry24t = DB.getSQLValueTS(po.get_TrxName(), dateregistry24, idevaluation)) > 0) {
                    return "No se puede modificar un registro de una fecha distinta a la actual";
                }
            }
        }
        if (type == 2 && po.get_Table_ID() == X_CC_Evolution_Kine.Table_ID) {
            idevaluation = po.get_ValueAsInt("CC_Evolution_kine_ID");
            idrole = Env.getAD_Role_ID(Env.getCtx());
            iduser = Env.getAD_User_ID(Env.getCtx());
            log.config("rol: " + idrole);
            log.config("usuario " + iduser);
            iduserofeval = po.get_ValueAsInt("AD_User_ID");
            log.config("usuario del registro: " + iduserofeval);
            if (iduser != 100) {
                if (iduser != iduserofeval) {
                    return "No puede modificar esta evolucion";
                }
                datenow = "SELECT date_Trunc('day',now()) from ad_system where 1=?";
                dateregistry = "SELECT date_Trunc('day',created) from cc_evolution_kine where cc_evolution_kine_id = ?";
                datenowd = DB.getSQLValueTS(po.get_TrxName(), datenow, 1);
                dateregistryd = DB.getSQLValueTS(po.get_TrxName(), dateregistry, idevaluation);
                datenow24 = "SELECT now() from ad_system where 1=?";
                dateregistry24 = "SELECT (created + interval '1 day') from cc_evolution_kine where cc_evolution_kine_id = ?";
                datenow24t = DB.getSQLValueTS(po.get_TrxName(), datenow24, 1);
                if (datenow24t.compareTo(dateregistry24t = DB.getSQLValueTS(po.get_TrxName(), dateregistry24, idevaluation)) > 0) {
                    return "No se puede modificar un registro de una fecha distinta a la actual";
                }
            }
        }
        if (type == 2 && po.get_Table_ID() == X_MH_WoundManagement.Table_ID) {
            idevaluation = po.get_ValueAsInt("MH_WoundManagement_ID");
            idrole = Env.getAD_Role_ID(Env.getCtx());
            iduser = Env.getAD_User_ID(Env.getCtx());
            log.config("rol: " + idrole);
            log.config("usuario " + iduser);
            iduserofeval = po.get_ValueAsInt("AD_User_ID");
            log.config("usuario del registro: " + iduserofeval);
            if (iduser != 100) {
                if (iduser != iduserofeval) {
                    return "No puede modificar esta evolucion";
                }
                datenow = "SELECT date_Trunc('day',now()) from ad_system where 1=?";
                dateregistry = "SELECT date_Trunc('day',created) from MH_WoundManagement where MH_WoundManagement_id = ?";
                datenowd = DB.getSQLValueTS(po.get_TrxName(), datenow, 1);
                if (datenowd.compareTo(dateregistryd = DB.getSQLValueTS(po.get_TrxName(), dateregistry, idevaluation)) != 0) {
                    return "No se puede modificar un registro de una fecha distinta a la actual";
                }
            }
        }
        if (type == 2 && po.get_Table_ID() == X_CC_MedicalOrder.Table_ID) {
            idevaluation = po.get_ValueAsInt("CC_MedicalOrder_ID");
            idrole = Env.getAD_Role_ID(Env.getCtx());
            iduser = Env.getAD_User_ID(Env.getCtx());
            log.config("rol: " + idrole);
            log.config("usuario " + iduser);
            iduserofeval = po.get_ValueAsInt("AD_User_ID");
            log.config("usuario del registro: " + iduserofeval);
            if (iduser != 100) {
                if (iduser != iduserofeval) {
                    return "No puede modificar esta evolucion";
                }
                datenow = "SELECT date_Trunc('day',now()) from ad_system where 1=?";
                dateregistry = "SELECT date_Trunc('day',created) from CC_MedicalOrder where cc_medicalorder_id = ?";
                datenowd = DB.getSQLValueTS(po.get_TrxName(), datenow, 1);
                if (datenowd.compareTo(dateregistryd = DB.getSQLValueTS(po.get_TrxName(), dateregistry, idevaluation)) != 0) {
                    return "No se puede modificar un registro de una fecha distinta a la actual";
                }
            }
        }
        if (type == 2 && po.get_Table_ID() == X_CC_MedicalIndications.Table_ID) {
            idevaluation = po.get_ValueAsInt("CC_MedicalIndications_ID");
            idrole = Env.getAD_Role_ID(Env.getCtx());
            iduser = Env.getAD_User_ID(Env.getCtx());
            log.config("rol: " + idrole);
            log.config("usuario " + iduser);
            iduserofeval = po.get_ValueAsInt("CreatedBy");
            log.config("usuario del registro: " + iduserofeval);
            if (iduser != 100) {
                datenow = "SELECT date_Trunc('day',now()) from ad_system where 1=?";
                dateregistry = "SELECT date_Trunc('day',created) from CC_MedicalIndications where CC_MedicalIndications_id = ?";
                datenowd = DB.getSQLValueTS(po.get_TrxName(), datenow, 1);
                if (datenowd.compareTo(dateregistryd = DB.getSQLValueTS(po.get_TrxName(), dateregistry, idevaluation)) != 0) {
                    String datenowyesterday = "SELECT date_Trunc('day',now())-1 from ad_system where 1=?";
                    String dateregistryyesterday = "SELECT date_Trunc('day',created)-1 from CC_MedicalIndications where CC_MedicalIndications_id = ?";
                    Timestamp datenowyesterdayd = DB.getSQLValueTS(po.get_TrxName(), datenowyesterday, 1);
                    Timestamp dateregistryyesterdayd = DB.getSQLValueTS(po.get_TrxName(), dateregistryyesterday, idevaluation);
                    log.config("datenowyesterday " + datenowyesterdayd);
                    log.config("dateregistryyesterday " + dateregistryyesterdayd);
                    if (datenowyesterdayd.compareTo(dateregistryd) != 0) {
                        return "No se puede modificar un registro de una fecha distinta a la actual";
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

