/*
 * Decompiled with CFR 0.152.
 */
package org.clinicacolonial.model;

import org.compiere.model.MClient;
import org.compiere.model.MRequisition;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_WS_InfoPDF;
import org.compiere.util.CLogger;
import org.ofb.model.OFBForward;

public class ModCCSetParhPDFBionet
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModCCSetParhPDFBionet.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("WS_InfoPDF", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 1 && po.get_Table_ID() == X_WS_InfoPDF.Table_ID) {
            X_WS_InfoPDF info = (X_WS_InfoPDF)po;
            log.config("nombre ed archivo:" + info.getDocumentNo());
            String IDDoc = info.getDocumentNo();
            int ID_Req = Integer.parseInt(IDDoc);
            if (ID_Req > 0) {
                MRequisition req = new MRequisition(po.getCtx(), ID_Req, po.get_TrxName());
                req.set_CustomColumn("FileName", String.valueOf(OFBForward.RutaPDFBionet()) + info.getFileName());
                req.saveEx(po.get_TrxName());
            } else {
                log.config("No se ha encontrado ID de documento aociado. ID:" + ID_Req);
            }
            info.setFileName(String.valueOf(OFBForward.RutaPDFBionet()) + info.getFileName());
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

